/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.microprofile.SetSecureMicroprofileConfigurationCommand;
import fish.payara.microprofile.openapi.impl.admin.OpenApiServiceConfiguration;
import jakarta.inject.Inject;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-openapi-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.DEPLOYMENT_GROUP, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=OpenApiServiceConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-openapi-configuration", description="Sets the OpenAPI Configuration")})
public class SetOpenApiConfigurationCommand
extends SetSecureMicroprofileConfigurationCommand {
    private static final Logger LOGGER = Logger.getLogger(SetOpenApiConfigurationCommand.class.getName());
    @Inject
    private Target targetUtil;
    @Param(name="enabled", optional=true)
    private Boolean enabled;
    @Param(name="endpoint", optional=true)
    private String endpoint;
    @Param(name="virtualServers", optional=true)
    private String virtualServers;
    @Param(name="corsHeaders", optional=true, defaultValue="false")
    private Boolean corsHeaders;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Subject subject = context.getSubject();
        if (this.targetUtil.getConfig(this.target) == null) {
            actionReport.setMessage("No such config name: " + this.targetUtil);
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        OpenApiServiceConfiguration config = (OpenApiServiceConfiguration)this.targetUtil.getConfig(this.target).getExtensionByType(OpenApiServiceConfiguration.class);
        if (Boolean.TRUE.equals(this.securityEnabled) || Boolean.parseBoolean(config.getSecurityEnabled())) {
            ActionReport checkUserReport = actionReport.addSubActionsReport();
            ActionReport createUserReport = actionReport.addSubActionsReport();
            if (!this.defaultMicroprofileUserExists(checkUserReport, subject) && !checkUserReport.hasFailures()) {
                this.createDefaultMicroprofileUser(createUserReport, subject);
            }
            if (checkUserReport.hasFailures() || createUserReport.hasFailures()) {
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        try {
            ConfigSupport.apply(configProxy -> {
                if (this.enabled != null) {
                    configProxy.setEnabled(Boolean.toString(this.enabled));
                }
                if (this.endpoint != null) {
                    configProxy.setEndpoint(this.endpoint);
                }
                if (this.virtualServers != null) {
                    configProxy.setVirtualServers(this.virtualServers);
                }
                if (this.corsHeaders != null) {
                    configProxy.setCorsHeaders(Boolean.toString(this.corsHeaders));
                }
                if (this.securityEnabled != null) {
                    configProxy.setSecurityEnabled(this.securityEnabled.toString());
                }
                if (this.roles != null) {
                    configProxy.setRoles(this.roles);
                }
                return configProxy;
            }, (ConfigBeanProxy)config);
            actionReport.setMessage("Restart server for change to take effect");
        }
        catch (TransactionFailure ex) {
            actionReport.failure(LOGGER, "Failed to update OpenAPI configuration", (Throwable)ex);
        }
        if (!actionReport.hasFailures() && !actionReport.hasWarnings()) {
            actionReport.getSubActionsReport().clear();
        }
    }
}

