/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.ws.rs.client.WebTarget;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.microprofile.restclient.MethodModel;

class InterceptorInvocationContext
implements InvocationContext {
    private final MethodModel methodModel;
    private final Method method;
    private final Map<String, Object> contextData = new HashMap<String, Object>();
    private final List<InvocationInterceptor> interceptors;
    private final WebTarget classLevelWebTarget;
    private Object[] args;
    private int currentPosition = 0;

    InterceptorInvocationContext(WebTarget classLevelWebTarget, MethodModel methodModel, Method method, Object[] args) {
        this.methodModel = methodModel;
        this.method = method;
        this.args = args;
        this.classLevelWebTarget = classLevelWebTarget;
        this.interceptors = methodModel.getInvocationInterceptors();
    }

    public Object getTarget() {
        return this.methodModel;
    }

    public Object getTimer() {
        return null;
    }

    public Method getMethod() {
        return this.method;
    }

    public Constructor<?> getConstructor() {
        return null;
    }

    public Object[] getParameters() {
        return this.args;
    }

    public void setParameters(Object[] params) {
        this.args = params;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public Object proceed() {
        if (this.currentPosition < this.interceptors.size()) {
            return this.interceptors.get(this.currentPosition++).intercept(this);
        }
        return this.methodModel.invokeMethod(this.classLevelWebTarget, this.method, this.args);
    }

    static class InvocationInterceptor {
        private final Object interceptorInstance;
        private final Interceptor interceptor;

        InvocationInterceptor(Object interceptorInstance, Interceptor interceptor) {
            this.interceptorInstance = interceptorInstance;
            this.interceptor = interceptor;
        }

        Object intercept(InvocationContext ctx) {
            try {
                return this.interceptor.intercept(InterceptionType.AROUND_INVOKE, this.interceptorInstance, ctx);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }
}

