/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.telemetry.tracing;

import fish.payara.microprofile.telemetry.tracing.OpenTelemetryTracerProducer;
import fish.payara.microprofile.telemetry.tracing.OpenTracingTracerProducer;
import fish.payara.opentracing.OpenTelemetryService;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.glassfish.internal.api.Globals;

public class TelemetryCdiExtension
implements Extension {
    private final OpenTelemetryService openTelemetryService = (OpenTelemetryService)Globals.getDefaultBaseServiceLocator().getService(OpenTelemetryService.class, new Annotation[0]);
    private boolean appManagedOtel;

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        TelemetryCdiExtension.addAnnotatedType(bbd, bm, OpenTracingTracerProducer.class);
        TelemetryCdiExtension.addAnnotatedType(bbd, bm, OpenTelemetryTracerProducer.class);
    }

    static void addAnnotatedType(BeforeBeanDiscovery bbd, BeanManager bm, Class<?> beanClass) {
        AnnotatedType at = bm.createAnnotatedType(beanClass);
        bbd.addAnnotatedType(at, beanClass.getName());
    }

    void initializeOpenTelemetry(@Observes AfterDeploymentValidation adv) {
        try {
            Config config = ConfigProvider.getConfig();
            if (config.getOptionalValue("otel.sdk.disabled", Boolean.class).orElse(true).booleanValue()) {
                return;
            }
            Map<String, String> otelProps = StreamSupport.stream(config.getPropertyNames().spliterator(), false).filter(key -> key.startsWith("otel.")).collect(Collectors.toMap(k -> k, k -> (String)config.getValue(k, String.class)));
            this.appManagedOtel = true;
            this.openTelemetryService.initializeCurrentApplication(otelProps);
        }
        catch (Exception e) {
            adv.addDeploymentProblem((Throwable)e);
        }
    }

    void shutdownAppScopedTelemetry(@Observes BeforeShutdown beforeShutdown) {
        if (this.appManagedOtel) {
            this.openTelemetryService.shutdownCurrentApplication();
        }
    }
}

