/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.telemetry.tracing.jaxrs;

import jakarta.ws.rs.container.ResourceInfo;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

class ResourceCache<T> {
    private final ConcurrentHashMap<ResourceKey, T> tracedCache = new ConcurrentHashMap();

    ResourceCache() {
    }

    T get(ResourceInfo info, Supplier<T> supplier) {
        return (T)this.tracedCache.computeIfAbsent(new ResourceKey(info), k -> supplier.get());
    }

    private static class ResourceKey {
        Class<?> resourceClass;
        Method resourceMethod;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceKey that = (ResourceKey)o;
            return this.resourceClass.equals(that.resourceClass) && this.resourceMethod.equals(that.resourceMethod);
        }

        public int hashCode() {
            return Objects.hash(this.resourceClass, this.resourceMethod);
        }

        ResourceKey(ResourceInfo info) {
            this.resourceClass = info.getResourceClass();
            this.resourceMethod = info.getResourceMethod();
        }
    }
}

