/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.telemetry.tracing.jaxrs.client;

import fish.payara.microprofile.telemetry.tracing.PayaraTracingServices;
import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.opentracing.OpenTelemetryService;
import fish.payara.opentracing.PropagationHelper;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;

public class JaxrsClientRequestTelemetryFilter
implements ClientRequestFilter,
ClientResponseFilter {
    public static final String REQUEST_CONTEXT_TRACING_PREDICATE = "fish.payara.requesttracing.jaxrs.client.TracingPredicate";

    public void filter(ClientRequestContext requestContext) throws IOException {
        ServiceLocator baseServiceLocator = Globals.getStaticBaseServiceLocator();
        OpenTelemetryService openTelemetryService = JaxrsClientRequestTelemetryFilter.getFromServiceHandle(baseServiceLocator, OpenTelemetryService.class);
        PayaraTracingServices payaraTracingServices = new PayaraTracingServices();
        RequestTracingService requestTracing = payaraTracingServices.getRequestTracingService();
        if (requestTracing != null && requestTracing.isRequestTracingEnabled() && requestTracing.isTraceInProgress()) {
            if (!requestContext.getHeaders().containsKey((Object)"Payara-Tracing-TraceId")) {
                requestContext.getHeaders().add((Object)"Payara-Tracing-TraceId", (Object)requestTracing.getConversationID());
            }
            if (!requestContext.getHeaders().containsKey((Object)"Payara-Tracing-ParentId")) {
                requestContext.getHeaders().add((Object)"Payara-Tracing-ParentId", (Object)requestTracing.getStartingTraceID());
            }
            if (!requestContext.getHeaders().containsKey((Object)"Payara-Tracing-RelationshipType")) {
                if (requestContext.getMethod().equals("POST")) {
                    requestContext.getHeaders().add((Object)"Payara-Tracing-RelationshipType", (Object)RequestTraceSpan.SpanContextRelationshipType.FollowsFrom);
                } else {
                    requestContext.getHeaders().add((Object)"Payara-Tracing-RelationshipType", (Object)RequestTraceSpan.SpanContextRelationshipType.ChildOf);
                }
            }
        }
        if (openTelemetryService != null && openTelemetryService.isEnabled() && this.shouldTrace(requestContext)) {
            Context parentSpanContext;
            Tracer tracer = payaraTracingServices.getActiveTracer();
            SpanBuilder spanBuilder = tracer.spanBuilder(requestContext.getMethod()).setAttribute(SemanticAttributes.HTTP_URL, (Object)requestContext.getUri().toString()).setAttribute(SemanticAttributes.HTTP_METHOD, (Object)requestContext.getMethod()).setAttribute(SemanticAttributes.NET_PEER_NAME, (Object)requestContext.getUri().getHost()).setAttribute("component", "jaxrs").setAttribute("span.kind", "client").setSpanKind(SpanKind.CLIENT);
            if (requestContext.getUri().getPort() != -1) {
                spanBuilder.setAttribute(SemanticAttributes.NET_PEER_PORT, (Object)requestContext.getUri().getPort());
            }
            if ((parentSpanContext = (Context)requestContext.getProperty("Payara-Telemetry-Tracing-SpanContext")) != null) {
                spanBuilder.setParent(parentSpanContext);
            } else {
                spanBuilder.setParent(Context.current());
            }
            Span span = spanBuilder.startSpan();
            requestContext.setProperty(PropagationHelper.class.getName(), (Object)PropagationHelper.start((Span)span, (Context)parentSpanContext));
            openTelemetryService.getCurrentSdk().getPropagators().getTextMapPropagator().inject(Context.current(), (Object)requestContext, (clientRequestContext, s, s1) -> clientRequestContext.getHeaders().put((Object)s, Collections.singletonList(s1)));
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (requestContext.hasProperty(PropagationHelper.class.getName())) {
            PropagationHelper helper = (PropagationHelper)requestContext.getProperty(PropagationHelper.class.getName());
            Span activeSpan = helper.span();
            if (!activeSpan.isRecording()) {
                Logger.getLogger(JaxrsClientRequestTelemetryFilter.class.getName()).log(Level.FINEST, "Could not find any active span, nothing to do.");
                return;
            }
            Response.StatusType statusInfo = responseContext.getStatusInfo();
            activeSpan.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, statusInfo.getStatusCode());
            if (statusInfo.getFamily() == Response.Status.Family.CLIENT_ERROR || statusInfo.getFamily() == Response.Status.Family.SERVER_ERROR) {
                activeSpan.setAttribute("error", true);
                activeSpan.setStatus(StatusCode.ERROR);
                activeSpan.addEvent("exception", Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_TYPE, (Object)statusInfo.getFamily().name()));
            }
            helper.end();
            helper.close();
            requestContext.removeProperty(PropagationHelper.class.getName());
        }
    }

    private boolean shouldTrace(ClientRequestContext requestContext) {
        Object traceFilter = requestContext.getConfiguration().getProperty(REQUEST_CONTEXT_TRACING_PREDICATE);
        if (traceFilter instanceof Predicate) {
            return ((Predicate)traceFilter).test(requestContext);
        }
        return true;
    }

    private static final <T> T getFromServiceHandle(ServiceLocator serviceLocator, Class<T> serviceClass) {
        ServiceHandle serviceHandle = serviceLocator.getServiceHandle(serviceClass, new Annotation[0]);
        if (serviceHandle != null && serviceHandle.isActive()) {
            return (T)serviceHandle.getService();
        }
        return null;
    }
}

