/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.glassfish.api.admin.CommandException;

public abstract class DBControl {
    private final String dbHost;
    private final String dbPort;
    private final String dbUser;
    private final String dbPassword;
    private final String dbHome;
    private final String dbCommand;
    private boolean redirect;

    protected DBControl(String dbCommand, String dbHost, String dbPort, String redirect, String dbHome, String dbUser, String dbPassword) {
        this.dbCommand = dbCommand;
        this.dbHost = dbHost;
        this.dbPort = dbPort;
        this.redirect = Boolean.parseBoolean(redirect);
        this.dbHome = dbHome;
        this.dbUser = dbUser;
        this.dbPassword = dbPassword;
        if (this.redirect) {
            try {
                String dbLog = this.dbHome == null ? this.createTempLogFile() : this.createDBLog(this.dbHome);
                try (PrintStream printStream = new PrintStream(new FileOutputStream(dbLog, true), true);){
                    System.setOut(printStream);
                    System.setErr(printStream);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Runtime.getRuntime().exit(2);
            }
        }
    }

    private String createDBLog(String dbHome) throws Exception {
        String dbLogFilePath;
        File fDBHome = new File(dbHome);
        StringManager localManager = StringManager.getManager(this.getClass());
        if (fDBHome.isDirectory() && fDBHome.canWrite()) {
            File fDBLog = new File(dbHome, this.getLogFileName());
            dbLogFilePath = fDBLog.toString();
            if (fDBLog.exists() && !fDBLog.canWrite()) {
                System.out.println(localManager.getString("UnableToAccessDatabaseLog", this.getLogFileName(), dbLogFilePath));
                System.out.println(localManager.getString("ContinueStartingDatabase"));
                dbLogFilePath = this.createTempLogFile();
            } else if (!fDBLog.exists() && !fDBLog.createNewFile()) {
                System.out.println(localManager.getString("UnableToCreateDatabaseLog", this.getLogFileName(), dbLogFilePath));
            }
        } else {
            System.out.println(localManager.getString("InvalidDBDirectory", dbHome));
            System.out.println(localManager.getString("ContinueStartingDatabase"));
            dbLogFilePath = this.createTempLogFile();
        }
        return dbLogFilePath;
    }

    private String createTempLogFile() throws CommandException {
        String tempFileName = "";
        try {
            File fTemp = File.createTempFile("foo", null);
            FileUtils.deleteOnExit(fTemp);
            tempFileName = fTemp.toString();
        }
        catch (IOException ioe) {
            StringManager localManager = StringManager.getManager(this.getClass());
            throw new CommandException(localManager.getString("UnableToAccessDatabaseLog", tempFileName));
        }
        return tempFileName;
    }

    abstract String getLogFileName();

    public String getDbHost() {
        return this.dbHost;
    }

    public String getDbPort() {
        return this.dbPort;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String getDbHome() {
        return this.dbHome;
    }

    public String getDbCommand() {
        return this.dbCommand;
    }

    public boolean isRedirect() {
        return this.redirect;
    }
}

