/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.jaas;

import com.sun.jaspic.config.helper.BaseAuthContextImpl;
import com.sun.jaspic.config.jaas.ExtendedConfigFile;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.security.auth.login.AppConfigurationEntry;

public class JAASAuthContextHelper
extends BaseAuthContextImpl {
    private static final String DEFAULT_ENTRY_NAME = "other";
    private static final Class<?>[] PARAMS = new Class[0];
    private static final Object[] ARGS = new Object[0];
    private ReentrantReadWriteLock instanceReadWriteLock = new ReentrantReadWriteLock();
    private Lock instanceWriteLock = this.instanceReadWriteLock.writeLock();
    private ExtendedConfigFile jaasConfig;
    private final String appContext;
    private AppConfigurationEntry[] entry;
    private Constructor<?>[] constructors;

    public JAASAuthContextHelper(String loggerName, boolean returnNullContexts, ExtendedConfigFile jaasConfig, Map<String, ?> properties, String appContext) throws AuthException {
        super(loggerName, returnNullContexts);
        this.jaasConfig = jaasConfig;
        this.appContext = appContext;
        this.initialize();
    }

    private void initialize() {
        boolean found = false;
        boolean foundDefault = false;
        this.instanceWriteLock.lock();
        try {
            this.entry = this.jaasConfig.getAppConfigurationEntry(this.appContext);
            if (this.entry == null) {
                this.entry = this.jaasConfig.getAppConfigurationEntry(DEFAULT_ENTRY_NAME);
                if (this.entry == null) {
                    this.entry = new AppConfigurationEntry[0];
                } else {
                    foundDefault = true;
                }
            } else {
                found = true;
            }
            this.constructors = null;
        }
        finally {
            this.instanceWriteLock.unlock();
        }
        if (!found) {
            if (!foundDefault) {
                this.logIfLevel(Level.INFO, null, "JAASAuthConfig no entries matched appContext (", this.appContext, ") or (", DEFAULT_ENTRY_NAME, ")");
            } else {
                this.logIfLevel(Level.INFO, null, "JAASAuthConfig appContext (", this.appContext, ") matched (", DEFAULT_ENTRY_NAME, ")");
            }
        }
    }

    private <M> void loadConstructors(M[] template, String authContextID) throws AuthException {
        if (this.constructors == null) {
            try {
                final Class<?> moduleType = template.getClass().getComponentType();
                this.constructors = (Constructor[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
                        Constructor[] ctor = new Constructor[JAASAuthContextHelper.this.entry.length];
                        ClassLoader loader = Thread.currentThread().getContextClassLoader();
                        for (int i = 0; i < JAASAuthContextHelper.this.entry.length; ++i) {
                            ctor[i] = null;
                            String clazz = JAASAuthContextHelper.this.entry[i].getLoginModuleName();
                            try {
                                Class<?> c = Class.forName(clazz, true, loader);
                                if (!moduleType.isAssignableFrom(c)) continue;
                                ctor[i] = c.getConstructor(PARAMS);
                                continue;
                            }
                            catch (Throwable t) {
                                JAASAuthContextHelper.this.logIfLevel(Level.WARNING, null, new String[]{"skipping unloadable class: ", clazz, " of appCOntext: ", JAASAuthContextHelper.this.appContext});
                            }
                        }
                        return ctor;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                AuthException ae = new AuthException();
                ae.initCause(pae.getCause());
                throw ae;
            }
        }
    }

    @Override
    protected final void refresh() {
        this.jaasConfig.refresh();
        this.initialize();
    }

    @Override
    public <M> boolean hasModules(M[] template, String authContextID) throws AuthException {
        this.loadConstructors(template, authContextID);
        for (Constructor<?> constructor : this.constructors) {
            if (constructor == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public <M> M[] getModules(M[] template, String authContextID) throws AuthException {
        this.loadConstructors(template, authContextID);
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.constructors.length; ++i) {
            if (this.constructors[i] == null) {
                list.add(i, null);
                continue;
            }
            final int j = i;
            try {
                list.add(j, AccessController.doPrivileged(new PrivilegedExceptionAction<M>(){

                    @Override
                    public M run() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                        return JAASAuthContextHelper.this.constructors[j].newInstance(ARGS);
                    }
                }));
                continue;
            }
            catch (PrivilegedActionException pae) {
                throw (AuthException)new AuthException().initCause(pae.getCause());
            }
        }
        return list.toArray(template);
    }

    @Override
    public Map<String, Object> getInitProperties(int i, Map<String, Object> properties) {
        HashMap<String, Object> initProperties = new HashMap<String, Object>();
        if (this.entry[i] != null) {
            Map<String, ?> options;
            if (properties != null && !properties.isEmpty()) {
                initProperties.putAll(properties);
            }
            if ((options = this.entry[i].getOptions()) != null && !options.isEmpty()) {
                initProperties.putAll(options);
            }
        }
        return initProperties;
    }

    @Override
    public boolean exitContext(AuthStatus[] successValue, int i, AuthStatus moduleStatus) {
        if (this.entry[i] != null && this.constructors[i] != null) {
            AppConfigurationEntry.LoginModuleControlFlag flag = this.entry[i].getControlFlag();
            if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.equals(flag)) {
                for (AuthStatus authStatus : successValue) {
                    if (moduleStatus != authStatus) continue;
                    return false;
                }
                return true;
            }
            if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.equals(flag)) {
                for (AuthStatus s : successValue) {
                    if (moduleStatus != s) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public AuthStatus getReturnStatus(AuthStatus[] successValue, AuthStatus defaultFailStatus, AuthStatus[] status, int position) {
        AuthStatus returnStatus = null;
        for (int i = 0; i <= position; ++i) {
            if (this.entry[i] == null || this.constructors[i] == null) continue;
            AppConfigurationEntry.LoginModuleControlFlag flag = this.entry[i].getControlFlag();
            if (this.isLoggable(Level.FINE)) {
                this.logIfLevel(Level.FINE, null, "getReturnStatus - flag: ", flag.toString());
            }
            if (flag == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED || flag == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                boolean isSuccessValue = false;
                AuthStatus[] authStatusArray = successValue;
                int n = authStatusArray.length;
                for (int j = 0; j < n; ++j) {
                    AuthStatus authStatus = authStatusArray[j];
                    if (status[i] != authStatus) continue;
                    isSuccessValue = true;
                }
                if (isSuccessValue) {
                    if (returnStatus != null) continue;
                    returnStatus = status[i];
                    continue;
                }
                if (this.isLoggable(Level.FINE)) {
                    this.logIfLevel(Level.FINE, null, "ReturnStatus - REQUIRED or REQUISITE failure: ", status[i].toString());
                }
                return status[i];
            }
            if (flag == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
                if (!this.exitContext(successValue, i, status[i])) continue;
                if (this.isLoggable(Level.FINE)) {
                    this.logIfLevel(Level.FINE, null, "ReturnStatus - Sufficient success: ", status[i].toString());
                }
                return status[i];
            }
            if (flag != AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL || returnStatus != null) continue;
            for (AuthStatus authStatus : successValue) {
                if (status[i] != authStatus) continue;
                returnStatus = status[i];
            }
        }
        if (returnStatus != null) {
            if (this.isLoggable(Level.FINE)) {
                this.logIfLevel(Level.FINE, null, "ReturnStatus - result: ", returnStatus.toString());
            }
            return returnStatus;
        }
        if (this.isLoggable(Level.FINE)) {
            this.logIfLevel(Level.FINE, null, "ReturnStatus - Default faiure status: ", defaultFailStatus.toString());
        }
        return defaultFailStatus;
    }
}

