/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admingui.extras.rest;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;

public class PayaraRestApiHandlers {
    public static void getHazelcastClusterMembers(HandlerContext handlerCtx) {
        String parentEndpoint = (String)handlerCtx.getInputValue("parentEndpoint");
        String type = (String)handlerCtx.getInputValue("type");
        String endpoint = parentEndpoint.endsWith("/") ? parentEndpoint + "list-hazelcast-cluster-members" : parentEndpoint + "/list-hazelcast-cluster-members";
        try {
            Map extraProperties;
            if (type != null) {
                if (type.equals("micro")) {
                    endpoint = endpoint + "?type=micro";
                } else if (type.equals("server")) {
                    endpoint = endpoint + "?type=server";
                }
            }
            Map responseMap = RestUtil.restRequest((String)endpoint, null, (String)"GET", (HandlerContext)handlerCtx, (boolean)false, (boolean)true);
            Map data = (Map)responseMap.get("data");
            List instances = new ArrayList();
            if (data != null && (extraProperties = (Map)data.get("extraProperties")) != null) {
                try {
                    instances = (List)extraProperties.get("members");
                    if (instances == null) {
                        instances = new ArrayList();
                    } else {
                        for (Map instance : instances) {
                            instance.put("selected", false);
                        }
                    }
                }
                catch (ClassCastException ex) {
                    instances = new ArrayList();
                }
            }
            handlerCtx.setOutputValue("result", instances);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void sendAsadminCommandToSelectedInstances(HandlerContext handlerCtx) {
        String parentEndpoint = (String)handlerCtx.getInputValue("parentEndpoint");
        String endpoint = parentEndpoint.endsWith("/") ? parentEndpoint + "send-asadmin-command" : parentEndpoint + "/send-asadmin-command";
        List rows = (List)handlerCtx.getInputValue("rows");
        String command = (String)handlerCtx.getInputValue("command");
        if (command != null) {
            ArrayList<HashMap> selectedRows = new ArrayList<HashMap>();
            for (HashMap row : rows) {
                try {
                    boolean selected = (Boolean)row.get("selected");
                    if (!selected) continue;
                    selectedRows.add(row);
                }
                catch (ClassCastException selected) {}
            }
            String[] splitCommand = command.split(" ");
            command = splitCommand[0];
            Object parameters = "";
            for (int i = 1; i < splitCommand.length; ++i) {
                parameters = (String)parameters + splitCommand[i] + " ";
            }
            parameters = ((String)parameters).trim();
            for (Map map : selectedRows) {
                String instanceName = (String)map.get("instanceName");
                String hazelcastPort = ((BigDecimal)map.get("hazelcastPort")).toString();
                String hostName = (String)map.get("hostName");
                String ipAddress = hostName.split("/")[1];
                HashMap<String, Object> attrsMap = new HashMap<String, Object>();
                attrsMap.put("explicitTarget", ipAddress + ":" + hazelcastPort + ":" + instanceName);
                attrsMap.put("command", command);
                attrsMap.put("id", parameters);
                attrsMap.put("logOutput", "true");
                try {
                    Map response = RestUtil.restRequest((String)endpoint, attrsMap, (String)"POST", (HandlerContext)handlerCtx, (boolean)false, (boolean)false);
                    handlerCtx.setOutputValue("response", (Object)response);
                }
                catch (Exception ex) {
                    GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
                }
            }
        }
    }

    public static void getRestEndpoints(HandlerContext handlerCtx) {
        ArrayList result;
        block3: {
            result = new ArrayList();
            try {
                String appName = (String)handlerCtx.getInputValue("appName");
                String encodedAppName = URLEncoder.encode(appName, "UTF-8");
                String componentName = (String)handlerCtx.getInputValue("componentName");
                String encodedComponentName = URLEncoder.encode(componentName, "UTF-8");
                String prefix = GuiUtil.getSessionValue((String)"REST_URL") + "/applications/application/" + encodedAppName;
                HashMap<String, String> attrMap = new HashMap<String, String>();
                attrMap.put("componentname", encodedComponentName);
                Map payaraEndpointDataMap = RestUtil.restRequest((String)(prefix + "/list-rest-endpoints"), attrMap, (String)"GET", null, (boolean)false, (boolean)false);
                Map payaraEndpointsExtraProps = (Map)((Map)payaraEndpointDataMap.get("data")).get("extraProperties");
                if (payaraEndpointsExtraProps.get("endpoints") != null) {
                    Map output = (Map)payaraEndpointsExtraProps.get("endpoints");
                    output.forEach((path, methods) -> methods.forEach(method -> {
                        TreeMap<String, String> endpointDetails = new TreeMap<String, String>();
                        endpointDetails.put("endpointPath", (String)path);
                        endpointDetails.put("requestMethod", (String)method);
                        result.add(endpointDetails);
                    }));
                }
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage((String)"log.error.getRestEndpoints") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block3;
                ex.printStackTrace();
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void hasRestEndpoints(HandlerContext handlerCtx) {
        HashMap<String, Boolean> result;
        block3: {
            result = new HashMap<String, Boolean>();
            try {
                String appName = (String)handlerCtx.getInputValue("appName");
                String encodedAppName = URLEncoder.encode(appName, "UTF-8");
                List rowList = (List)handlerCtx.getInputValue("rowList");
                for (Object row : rowList) {
                    Map rowMap = (Map)row;
                    String componentName = (String)rowMap.get("name");
                    String encodedComponentName = URLEncoder.encode(componentName, "UTF-8");
                    String prefix = GuiUtil.getSessionValue((String)"REST_URL") + "/applications/application/" + encodedAppName;
                    HashMap<String, String> attrMap = new HashMap<String, String>();
                    attrMap.put("componentname", encodedComponentName);
                    Map payaraEndpointDataMap = RestUtil.restRequest((String)(prefix + "/list-rest-endpoints"), attrMap, (String)"GET", null, (boolean)true, (boolean)false);
                    Map payaraEndpointsExtraProps = (Map)((Map)payaraEndpointDataMap.get("data")).get("extraProperties");
                    result.put(componentName, false);
                    if (payaraEndpointsExtraProps.get("endpoints") == null) continue;
                    result.put(componentName, true);
                    rowMap.put("type", "JAX-RS");
                }
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage((String)"log.error.hasRestEndpoints") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block3;
                ex.printStackTrace();
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void isCDIDevMode(HandlerContext handlerCtx) {
        HashMap<String, Boolean> result;
        block4: {
            result = new HashMap<String, Boolean>();
            try {
                String appName = (String)handlerCtx.getInputValue("appName");
                String encodedAppName = URLEncoder.encode(appName, "UTF-8");
                List rowList = (List)handlerCtx.getInputValue("rowList");
                for (Object row : rowList) {
                    Map rowMap = (Map)row;
                    boolean enabled = false;
                    String componentName = (String)rowMap.get("name");
                    String encodedComponentName = URLEncoder.encode(componentName, "UTF-8");
                    result.put(componentName, false);
                    if (!((String)rowMap.get("sniffers")).contains("cdi")) continue;
                    String endpoint = GuiUtil.getSessionValue((String)"REST_URL") + "/applications/application/" + encodedAppName + "/property";
                    Map<String, String> attrMap = Collections.singletonMap("componentname", encodedComponentName);
                    Map payaraEndpointDataMap = RestUtil.restRequest((String)endpoint, attrMap, (String)"GET", null, (boolean)true, (boolean)false);
                    Map payaraEndpointsExtraProps = (Map)((Map)payaraEndpointDataMap.get("data")).get("extraProperties");
                    List properties = (List)payaraEndpointsExtraProps.get("properties");
                    for (Map property : properties) {
                        if (!"cdiDevModeEnabled".equals(property.get("name")) || !Boolean.parseBoolean((String)property.get("value"))) continue;
                        result.put(componentName, true);
                        enabled = true;
                        break;
                    }
                    if (enabled) continue;
                    result.put(componentName, Boolean.getBoolean("org.jboss.weld.development"));
                }
            }
            catch (Exception ex) {
                GuiUtil.getLogger().log(Level.INFO, "{0}{1}", new Object[]{GuiUtil.getCommonMessage((String)"log.error.isCDIDevMode"), ex.getLocalizedMessage()});
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block4;
                ex.printStackTrace();
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void prepareSuccessfulCommandMsg(HandlerContext handlerCtx) {
        GuiUtil.prepareAlert((String)"success", (String)"Command sent successfully", null);
    }

    public static void sortRequestTracingEnabledNotifierStatus(HandlerContext handlerctx) {
        ArrayList<String> enabled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        List avaliable = (List)handlerctx.getInputValue("availableNotifiers");
        String notifiersString = (String)handlerctx.getInputValue("specifiedNotifiers");
        if (notifiersString == null) {
            notifiersString = "";
        } else {
            String[] notifiers;
            notifiersString = notifiersString.substring(1, notifiersString.length() - 2);
            for (String notifier : notifiers = notifiersString.split("\\}\\,")) {
                String name = notifier.split("notifierName=", 2)[1];
                if (notifier.contains("notifierEnabled=true")) {
                    enabled.add(name);
                } else {
                    disabled.add(name);
                }
                avaliable.remove(name);
            }
        }
        for (String unused : avaliable) {
            disabled.add(unused);
        }
        handlerctx.setOutputValue("disabled", disabled);
        handlerctx.setOutputValue("enabled", enabled);
    }

    public static void sortInstanceSelectedDeploymentGroupStatus(HandlerContext handlerctx) {
        ArrayList enabled = new ArrayList();
        ArrayList<String> disabled = new ArrayList<String>();
        List avaliable = (List)handlerctx.getInputValue("avaliableDeploymentGroups");
        for (String unused : avaliable) {
            disabled.add(unused);
        }
        handlerctx.setOutputValue("disabled", disabled);
        handlerctx.setOutputValue("enabled", enabled);
    }

    public static void updateDeploymentGroups(HandlerContext handlerCtx) {
        String[] deploymentGroups = (String[])handlerCtx.getInputValue("deploymentGroups");
        String[] enabled = (String[])handlerCtx.getInputValue("selected");
        String instance = (String)handlerCtx.getInputValue("instance");
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        Boolean quiet = (Boolean)handlerCtx.getInputValue("quiet");
        Boolean throwException = (Boolean)handlerCtx.getInputValue("throwException");
        List<String> enabledDeploymentGroups = Arrays.asList(enabled);
        if (enabled.length > 0) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("instance", instance);
            for (String deploymentGroup : deploymentGroups) {
                if (!enabledDeploymentGroups.contains(deploymentGroup)) continue;
                attrs.put("deploymentGroup", deploymentGroup);
                RestUtil.restRequest((String)endpoint, attrs, (String)"post", (HandlerContext)handlerCtx, (boolean)quiet, (boolean)throwException);
            }
        }
    }

    public static void sortDeploymentGroupSelectedInstancesStatus(HandlerContext handlerctx) {
        ArrayList enabled = new ArrayList();
        ArrayList<String> disabled = new ArrayList<String>();
        List available = (List)handlerctx.getInputValue("availableInstances");
        for (String unused : available) {
            disabled.add(unused);
        }
        handlerctx.setOutputValue("disabled", disabled);
        handlerctx.setOutputValue("enabled", enabled);
    }

    public static void addSelectedInstancesToDeploymentGroup(HandlerContext handlerCtx) {
        String[] instances = (String[])handlerCtx.getInputValue("instances");
        String[] selected = (String[])handlerCtx.getInputValue("selected");
        String deploymentGroup = (String)handlerCtx.getInputValue("deploymentGroup");
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        Boolean quiet = (Boolean)handlerCtx.getInputValue("quiet");
        Boolean throwException = (Boolean)handlerCtx.getInputValue("throwException");
        List<String> enabledDeploymentGroups = Arrays.asList(selected);
        if (selected.length > 0) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("deploymentGroup", deploymentGroup);
            for (String selectedInstance : instances) {
                if (!enabledDeploymentGroups.contains(selectedInstance)) continue;
                attributes.put("instance", selectedInstance);
                RestUtil.restRequest((String)endpoint, attributes, (String)"post", (HandlerContext)handlerCtx, (boolean)quiet, (boolean)throwException);
            }
        }
    }

    public static void sortHealthcheckEnabledNotifierStatus(HandlerContext handlerctx) {
        ArrayList<String> enabled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        List avaliable = (List)handlerctx.getInputValue("availableNotifiers");
        String notifiersString = (String)handlerctx.getInputValue("specifiedNotifiers");
        notifiersString = notifiersString.substring(1, notifiersString.length() - 2);
        String[] notifiers = notifiersString.split("[\\}\\]]\\,");
        for (String notifier : notifiers) {
            if (!(notifier = notifier.trim()).startsWith("notifierList")) continue;
            String name = notifier.split("notifierName=", 2)[1].toLowerCase();
            if (notifier.contains("notifierEnabled=true")) {
                enabled.add(name);
            } else {
                disabled.add(name);
            }
            avaliable.remove(name);
        }
        for (String unused : avaliable) {
            disabled.add(unused);
        }
        handlerctx.setOutputValue("disabled", disabled);
        handlerctx.setOutputValue("enabled", enabled);
    }

    public static void getHistoricHealthcheckMessages(HandlerContext handlerCtx) {
        Map extraProperties;
        String parentEndpoint = (String)handlerCtx.getInputValue("parentEndpoint");
        String endpoint = parentEndpoint.endsWith("/") ? parentEndpoint + "list-historic-healthchecks" : parentEndpoint + "/list-historic-healthchecks";
        Map responseMap = RestUtil.restRequest((String)endpoint, null, (String)"GET", (HandlerContext)handlerCtx, (boolean)false, (boolean)false);
        Map data = (Map)responseMap.get("data");
        List messages = new ArrayList();
        if (data != null && (extraProperties = (Map)data.get("extraProperties")) != null && (messages = (List)extraProperties.get("historicmessages")) == null) {
            messages = new ArrayList();
        }
        handlerCtx.setOutputValue("result", messages);
    }

    public static void getRequestTracingMessages(HandlerContext handlerCtx) {
        Map extraProperties;
        String parentEndpoint = (String)handlerCtx.getInputValue("parentEndpoint");
        String endpoint = parentEndpoint.endsWith("/") ? parentEndpoint + "list-requesttraces" : parentEndpoint + "/list-requesttraces";
        Map responseMap = RestUtil.restRequest((String)endpoint, null, (String)"GET", (HandlerContext)handlerCtx, (boolean)false, (boolean)false);
        Map data = (Map)responseMap.get("data");
        List messages = new ArrayList();
        if (data != null && (extraProperties = (Map)data.get("extraProperties")) != null && (messages = (List)extraProperties.get("traces")) == null) {
            messages = new ArrayList();
        }
        handlerCtx.setOutputValue("result", messages);
    }

    public static void getVirtualServersAttributes(HandlerContext handlerCtx) {
        String parentEndpoint = (String)handlerCtx.getInputValue("parentEndpoint");
        String childType = (String)handlerCtx.getInputValue("childType");
        String configName = (String)handlerCtx.getInputValue("configName");
        Object sessionScopeRestURL = (String)handlerCtx.getInputValue("sessionScopeRestURL");
        sessionScopeRestURL = ((String)sessionScopeRestURL).endsWith("/") ? sessionScopeRestURL : (String)sessionScopeRestURL + "/";
        String serverName = "";
        try {
            List table = RestUtil.buildChildEntityList((String)((String)handlerCtx.getInputValue("parentEndpoint")), (String)((String)handlerCtx.getInputValue("childType")), (List)((List)handlerCtx.getInputValue("skipList")), (List)((List)handlerCtx.getInputValue("includeList")), (String)((String)handlerCtx.getInputValue("id")));
            if (configName.equals("default-config")) {
                for (Map row : table) {
                    row.put("contextRoot", "");
                }
            } else {
                List instances = RestUtil.getChildList((String)((String)sessionScopeRestURL + "servers/server"));
                for (String instance : instances) {
                    String configRef = (String)RestUtil.getAttributesMap((String)instance).get("configRef");
                    if (!configRef.equals(configName)) continue;
                    serverName = instance.substring(instance.lastIndexOf(47) + 1);
                }
                String deployedApplicationsEndpoint = (String)sessionScopeRestURL + "servers/server/" + serverName + "/application-ref";
                List deployedApplications = RestUtil.getChildList((String)deployedApplicationsEndpoint);
                List virtualServers = RestUtil.getChildList((String)(parentEndpoint + "/" + childType));
                List applications = RestUtil.getChildList((String)((String)sessionScopeRestURL + "applications/application"));
                for (String virtualServer : virtualServers) {
                    String virtualServerName = virtualServer.substring(virtualServer.lastIndexOf(47) + 1);
                    for (int i = 0; i < deployedApplications.size(); ++i) {
                        deployedApplications.set(i, ((String)deployedApplications.get(i)).substring(((String)deployedApplications.get(i)).lastIndexOf("/") + 1));
                    }
                    Object contextRoots = "";
                    for (String application : applications) {
                        String[] deployedVirtualServers;
                        String deployedVirtualServersString;
                        String applicationName = application.substring(application.lastIndexOf(47) + 1);
                        if (!RestUtil.get((String)(deployedApplicationsEndpoint + "/" + applicationName)).isSuccess() || (deployedVirtualServersString = (String)RestUtil.getAttributesMap((String)(deployedApplicationsEndpoint + "/" + applicationName)).get("virtualServers")) == null) continue;
                        for (String deployedVirtualServer : deployedVirtualServers = deployedVirtualServersString.split(",")) {
                            if (deployedVirtualServer.equals("") || !deployedApplications.contains(applicationName) || !virtualServerName.equals(deployedVirtualServer)) continue;
                            contextRoots = !((String)contextRoots).equals("") ? (String)contextRoots + "<br>" + RestUtil.getAttributesMap((String)application).get("contextRoot") : (String)contextRoots + RestUtil.getAttributesMap((String)application).get("contextRoot");
                        }
                    }
                    for (Map row : table) {
                        if (!row.get("name").equals(virtualServerName)) continue;
                        row.put("contextRoot", contextRoots);
                    }
                }
            }
            handlerCtx.setOutputValue("result", (Object)table);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void createDeploymentGroupInstances(HandlerContext handlerCtx) {
        String deploymentGroupName = (String)handlerCtx.getInputValue("deploymentGroupName");
        List instanceRow = (List)handlerCtx.getInputValue("instanceRow");
        HashMap instanceAttributesMap = new HashMap();
        String endpointForCreateInstance = GuiUtil.getSessionValue((String)"REST_URL") + "/create-instance";
        for (Map Instance : instanceRow) {
            instanceAttributesMap.put("name", Instance.get("name"));
            instanceAttributesMap.put("deploymentgroup", deploymentGroupName);
            instanceAttributesMap.put("node", Instance.get("node"));
            try {
                GuiUtil.getLogger().info(endpointForCreateInstance);
                GuiUtil.getLogger().info(((Object)instanceAttributesMap).toString());
                RestUtil.restRequest((String)endpointForCreateInstance, instanceAttributesMap, (String)"post", null, (boolean)false);
                String instanceLoadBalancingWeight = (String)Instance.get("weight");
                if (GuiUtil.isEmpty((String)instanceLoadBalancingWeight)) continue;
                String encodedInstanceName = URLEncoder.encode((String)Instance.get("name"), "UTF-8");
                String endpoint = GuiUtil.getSessionValue((String)"REST_URL") + "/servers/server/" + encodedInstanceName;
                HashMap<String, String> loadBalancingWeightAttribute = new HashMap<String, String>();
                loadBalancingWeightAttribute.put("lbWeight", instanceLoadBalancingWeight);
                RestUtil.restRequest((String)endpoint, loadBalancingWeightAttribute, (String)"post", null, (boolean)false);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().severe(GuiUtil.getCommonMessage((String)"LOG_CREATE_DEPLOYMENT_GROUP_INSTANCE", (Object[])new Object[]{deploymentGroupName, endpointForCreateInstance, instanceAttributesMap}));
                GuiUtil.prepareException((HandlerContext)handlerCtx, (Throwable)ex);
            }
        }
    }
}

