/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.security.store.AsadminTruststore;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.X509TrustManager;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.DumbTerminal;

public class AsadminTrustManager
implements X509TrustManager {
    private final Object alias;
    private boolean alreadyInvoked;
    private boolean interactive = true;
    private CertificateException lastCertException;
    private RuntimeException lastRuntimeException;
    private static final LocalStringsImpl STRING_MANAGER = new LocalStringsImpl(AsadminTrustManager.class);
    private static final Logger logger = Logger.getLogger(AsadminTrustManager.class.getName());

    public AsadminTrustManager(Object alias, Map env) {
        this.alias = alias;
        this.alreadyInvoked = false;
        this.lastCertException = null;
        this.lastRuntimeException = null;
    }

    public AsadminTrustManager() {
        this(null, null);
    }

    public void setInteractive(boolean mode) {
        this.interactive = mode;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificate, String authType) throws CertificateException {
        throw new UnsupportedOperationException("Not Implemented for Client Trust Management");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (!this.alreadyInvoked) {
            this.alreadyInvoked = true;
            try {
                this.checkCertificate(chain);
            }
            catch (RuntimeException ex) {
                this.lastRuntimeException = ex;
                throw ex;
            }
            catch (CertificateException ex) {
                this.lastCertException = ex;
                throw ex;
            }
        } else {
            if (this.lastRuntimeException != null) {
                throw this.lastRuntimeException;
            }
            if (this.lastCertException != null) {
                throw this.lastCertException;
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isItOKToAddCertToTrustStore(X509Certificate c) {
        if (!this.interactive) {
            return true;
        }
        String result = null;
        LineReader lineReader = null;
        try {
            lineReader = LineReaderBuilder.builder().terminal((Terminal)new DumbTerminal(System.in, (OutputStream)System.out)).build();
            result = lineReader.readLine(STRING_MANAGER.get("certificateTrustPrompt"));
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Error instantiating console", ioe);
        }
        finally {
            if (lineReader != null && lineReader.getTerminal() != null) {
                try {
                    lineReader.getTerminal().close();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "Error closing terminal", ioe);
                }
            }
        }
        return result != null && result.equalsIgnoreCase("y");
    }

    private String getAliasName() {
        Object aliasName = this.alias != null ? this.alias.toString() : "";
        DateFormat f = DateFormat.getDateTimeInstance(1, 1);
        aliasName = (String)aliasName + ":" + f.format(new Date());
        return aliasName;
    }

    protected void checkCertificate(X509Certificate[] chain) throws RuntimeException, CertificateException, IllegalArgumentException {
        block6: {
            if (chain == null || chain.length == 0) {
                throw new IllegalArgumentException(STRING_MANAGER.get("emptyServerCertificate"));
            }
            for (int i = 0; i < chain.length; ++i) {
                chain[i].checkValidity();
            }
            try {
                AsadminTruststore truststore = AsadminTruststore.newInstance();
                if (truststore.certificateExists((Certificate)chain[0])) break block6;
                if (this.isItOKToAddCertToTrustStore(chain[0])) {
                    truststore.addCertificate(this.getAliasName(), (Certificate)chain[0]);
                    break block6;
                }
                throw new CertificateException(STRING_MANAGER.get("serverCertificateNotTrusted"));
            }
            catch (CertificateException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

