/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jaspic.config;

import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.RequestPolicy;
import com.sun.enterprise.config.serverbeans.ResponsePolicy;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.jaspic.AuthMessagePolicy;
import com.sun.enterprise.security.jaspic.config.ConfigParser;
import com.sun.enterprise.security.jaspic.config.GFServerConfigProvider;
import com.sun.logging.LogDomains;
import jakarta.security.auth.message.MessagePolicy;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.config.types.Property;

public class ConfigDomainParser
implements ConfigParser {
    private static final Logger _logger = LogDomains.getLogger(ConfigDomainParser.class, (String)"javax.enterprise.system.core.security");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{\\{(.*?)}}|\\$\\{(.*?)}");
    private Map<String, GFServerConfigProvider.InterceptEntry> configMap = new HashMap<String, GFServerConfigProvider.InterceptEntry>();
    private Set<String> layersWithDefault = new HashSet<String>();

    @Override
    public void initialize(Object service) throws IOException {
        if (service == null && Globals.getDefaultHabitat() != null) {
            service = Globals.getDefaultHabitat().getService(SecurityService.class, "default-instance-name", new Annotation[0]);
        }
        if (service instanceof SecurityService) {
            this.processServerConfig((SecurityService)service, this.configMap);
        }
    }

    private void processServerConfig(SecurityService service, Map<String, GFServerConfigProvider.InterceptEntry> newConfig) throws IOException {
        List configList = service.getMessageSecurityConfig();
        if (configList != null) {
            for (MessageSecurityConfig next : configList) {
                String intercept = this.parseInterceptEntry(next, newConfig);
                List provList = next.getProviderConfig();
                if (provList == null) continue;
                for (ProviderConfig provider : provList) {
                    this.parseIDEntry(provider, newConfig, intercept);
                }
            }
        }
    }

    @Override
    public Map<String, GFServerConfigProvider.InterceptEntry> getConfigMap() {
        return this.configMap;
    }

    @Override
    public Set<String> getLayersWithDefault() {
        return this.layersWithDefault;
    }

    private String parseInterceptEntry(MessageSecurityConfig msgConfig, Map<String, GFServerConfigProvider.InterceptEntry> newConfig) throws IOException {
        GFServerConfigProvider.InterceptEntry intEntry;
        String intercept = null;
        String defaultServerID = null;
        String defaultClientID = null;
        intercept = msgConfig.getAuthLayer();
        defaultServerID = msgConfig.getDefaultProvider();
        defaultClientID = msgConfig.getDefaultClientProvider();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Intercept Entry: \n    intercept: " + intercept + "\n    defaultServerID: " + defaultServerID + "\n    defaultClientID:  " + defaultClientID);
        }
        if (defaultServerID != null || defaultClientID != null) {
            this.layersWithDefault.add(intercept);
        }
        if ((intEntry = newConfig.get(intercept)) != null) {
            throw new IOException("found multiple MessageSecurityConfig entries with the same auth-layer");
        }
        intEntry = new GFServerConfigProvider.InterceptEntry(defaultClientID, defaultServerID, null);
        newConfig.put(intercept, intEntry);
        return intercept;
    }

    private void parseIDEntry(ProviderConfig pConfig, Map<String, GFServerConfigProvider.InterceptEntry> newConfig, String intercept) throws IOException {
        String id = pConfig.getProviderId();
        String type = pConfig.getProviderType();
        String moduleClass = pConfig.getClassName();
        MessagePolicy requestPolicy = this.parsePolicy(pConfig.getRequestPolicy());
        MessagePolicy responsePolicy = this.parsePolicy(pConfig.getResponsePolicy());
        HashMap<String, Object> options = new HashMap<String, Object>();
        List pList = pConfig.getProperty();
        if (pList != null) {
            for (Property property : pList) {
                try {
                    options.put(property.getName(), this.expand(property.getValue()));
                }
                catch (IllegalStateException ise) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "jaspic.unexpandedproperty");
                    }
                    options.put(property.getName(), property.getValue());
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ID Entry: \n    module class: " + moduleClass + "\n    id: " + id + "\n    type: " + type + "\n    request policy: " + requestPolicy + "\n    response policy: " + responsePolicy + "\n    options: " + options);
        }
        GFServerConfigProvider.IDEntry idEntry = new GFServerConfigProvider.IDEntry(type, moduleClass, requestPolicy, responsePolicy, options);
        GFServerConfigProvider.InterceptEntry intEntry = newConfig.get(intercept);
        if (intEntry == null) {
            throw new IOException("intercept entry for " + intercept + " must be specified before ID entries");
        }
        if (intEntry.idMap == null) {
            intEntry.idMap = new HashMap<String, GFServerConfigProvider.IDEntry>();
        }
        intEntry.idMap.put(id, idEntry);
    }

    private String expand(String rawProperty) {
        Matcher propertyMatcher = PROPERTY_PATTERN.matcher(rawProperty);
        StringBuilder propertyBuilder = new StringBuilder();
        while (propertyMatcher.find()) {
            if (propertyMatcher.group(1) != null) {
                propertyMatcher.appendReplacement(propertyBuilder, Matcher.quoteReplacement(propertyMatcher.group()));
                continue;
            }
            String replacement = System.getProperty(propertyMatcher.group(2));
            if (replacement == null) {
                throw new IllegalStateException("No system property for " + propertyMatcher.group(2));
            }
            propertyMatcher.appendReplacement(propertyBuilder, Matcher.quoteReplacement(replacement));
        }
        propertyMatcher.appendTail(propertyBuilder);
        return propertyBuilder.toString();
    }

    private MessagePolicy parsePolicy(RequestPolicy policy) {
        if (policy == null) {
            return null;
        }
        String authSource = policy.getAuthSource();
        String authRecipient = policy.getAuthRecipient();
        return AuthMessagePolicy.getMessagePolicy(authSource, authRecipient);
    }

    private MessagePolicy parsePolicy(ResponsePolicy policy) {
        if (policy == null) {
            return null;
        }
        String authSource = policy.getAuthSource();
        String authRecipient = policy.getAuthRecipient();
        return AuthMessagePolicy.getMessagePolicy(authSource, authRecipient);
    }
}

