/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.realm.config;

import com.sun.enterprise.util.StringUtils;
import fish.payara.nucleus.microprofile.config.spi.ConfigValueResolver;
import fish.payara.security.annotations.FileIdentityStoreDefinition;
import fish.payara.security.realm.RealmUtil;
import fish.payara.security.realm.config.RealmConfiguration;
import java.util.Arrays;
import java.util.List;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class FileRealmIdentityStoreConfiguration
implements RealmConfiguration {
    private final String name;
    private final String file;
    private final List<String> assignGroups;
    private final String jaasContext;

    private FileRealmIdentityStoreConfiguration(FileIdentityStoreDefinition definition) {
        Config config = ConfigProvider.getConfig();
        this.name = definition.value();
        this.file = RealmUtil.getConfiguredValue(String.class, definition.file(), config, "payara.security.file");
        this.assignGroups = config.getValue("payara.security.file.assignGroups", ConfigValueResolver.class).asList(String.class, Arrays.asList(definition.assignGroups()));
        this.jaasContext = RealmUtil.getConfiguredValue(String.class, definition.jaasContext(), config, "payara.security.file.jaasContext");
    }

    public static FileRealmIdentityStoreConfiguration from(FileIdentityStoreDefinition definition) {
        return new FileRealmIdentityStoreConfiguration(definition);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFile() {
        if (StringUtils.ok((String)this.file)) {
            return this.file;
        }
        return this.name;
    }

    @Override
    public List<String> getAssignGroups() {
        return this.assignGroups;
    }

    public String getJaasContext() {
        return this.jaasContext;
    }
}

