/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.MessageType;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Properties;

public class UpdateClusterBrokerListHandler
extends AdminCmdHandler {
    private static boolean DEBUG = UpdateClusterBrokerListHandler.getDEBUG();

    public UpdateClusterBrokerListHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        int status = 200;
        String msg = null;
        if (DEBUG) {
            this.logger.log(8, this.getClass().getName() + ": " + cmd_props);
        }
        if (Globals.getHAEnabled()) {
            status = 500;
            msg = this.rb.getKString("B3262", MessageType.getString(94));
            this.logger.log(32, msg);
        } else if (!Globals.isJMSRAManagedBroker()) {
            status = 500;
            msg = this.rb.getKString("B3264", MessageType.getString(94));
            this.logger.log(32, msg);
            msg = "BAD REQUEST";
        } else {
            try {
                ClusterManager cm = Globals.getClusterManager();
                MQAddress self = cm.getMQAddress();
                String brokerlist = (String)cmd_props.get("JMQClusterBrokerList");
                LinkedHashSet brokers = cm.parseBrokerList(brokerlist);
                MQAddress master = cm.getMasterBroker() == null ? null : cm.getMasterBroker().getBrokerURL();
                this.logger.log(8, this.rb.getKString("B1368", self + (String)(master == null ? "]" : "(" + "imq.cluster.masterbroker" + "=" + master + ")"), "[" + brokerlist + "]"));
                if (master != null && !brokers.contains(master)) {
                    msg = this.rb.getKString("B4323", master.toString(), ((Object)brokers).toString() + "[" + brokerlist + "]");
                    throw new BrokerException(msg);
                }
                if (!brokers.contains(self)) {
                    brokerlist = "";
                }
                Properties prop = new Properties();
                prop.put("imq.cluster.brokerlist", brokerlist);
                BrokerConfig bcfg = Globals.getConfig();
                bcfg.updateProperties(prop, true);
            }
            catch (PropertyUpdateException e) {
                status = 400;
                msg = e.getMessage();
                this.logger.log(16, msg);
            }
            catch (Exception e) {
                status = 500;
                msg = e.toString();
                this.logger.log(16, msg);
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        UpdateClusterBrokerListHandler.setProperties(reply, 95, status, msg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

