/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.service;

import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import java.util.Objects;

final class MethodKey {
    final Class<?> targetClass;
    final Method method;
    private String methodId;

    MethodKey(InvocationContext ctx) {
        this.targetClass = ctx.getTarget().getClass();
        this.method = ctx.getMethod();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodKey methodKey = (MethodKey)o;
        return this.targetClass.equals(methodKey.targetClass) && this.method.equals(methodKey.method);
    }

    public int hashCode() {
        return Objects.hash(this.targetClass, this.method);
    }

    String getMethodId() {
        if (this.methodId != null) {
            return this.methodId;
        }
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(this.targetClass.getName()).append('.').append(this.method.getName());
        if (this.method.getParameterCount() > 0) {
            idBuilder.append('(');
            for (Class<?> param : this.method.getParameterTypes()) {
                idBuilder.append(param.getName()).append(' ');
            }
            idBuilder.append(')');
        }
        this.methodId = idBuilder.toString();
        return this.methodId;
    }

    public String toString() {
        return this.getMethodId();
    }
}

