/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.v3.admin.cluster.ListNodesHelper;
import jakarta.inject.Inject;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-nodes")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.nodes.command")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-nodes", description="list-nodes")})
public class ListNodesCommand
implements AdminCommand {
    @Inject
    Servers servers;
    @Inject
    private Nodes nodes;
    @Param(optional=true, defaultValue="false", name="long", shortName="l")
    private boolean long_opt;
    @Param(optional=true)
    private boolean terse;
    private ActionReport report;
    Logger logger;

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.logger = context.getLogger();
        ListNodesHelper lnh = new ListNodesHelper(this.logger, this.servers, this.nodes, "ALL", this.long_opt, this.terse);
        String nodeList = lnh.getNodeList();
        this.report.setMessage(nodeList);
        Properties extraProperties = new Properties();
        extraProperties.put("nodeNames", lnh.getNodeNamesList());
        this.report.setExtraProperties(extraProperties);
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

