/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.remote.RemoteRestAdminCommand;
import com.sun.enterprise.admin.remote.ServerRemoteRestAdminCommand;
import com.sun.enterprise.admin.util.InstanceStateService;
import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.admin.util.TimeoutParamDefaultCalculator;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.StartInstanceCommand;
import com.sun.enterprise.v3.admin.cluster.Strings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="restart-instance")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="restart.instance.command")
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="_restart-instance", description="_restart-instance"), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="restart-instance", description="restart-instance", params={@RestParam(name="id", value="$parent")})})
public class RestartInstanceCommand
implements AdminCommand {
    @Inject
    private InstanceStateService stateSvc;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private Nodes nodes;
    @Inject
    private ServerEnvironment env;
    @Inject
    @Named(value="default-instance-name")
    Config dasConfig;
    @Param(optional=false, primary=true)
    private String instanceName;
    @Param(name="debug", optional=true)
    private String debug;
    @Param(name="sync", optional=true, defaultValue="normal", acceptableValues="none, normal, full")
    private String sync;
    @Param(name="delay", optional=true, defaultValue="0")
    private int delay;
    @Param(optional=true, defaultCalculator=TimeoutParamDefaultCalculator.class)
    private int timeout;
    private Logger logger;
    private RemoteInstanceCommandHelper helper;
    private ActionReport report;
    private Server instance;
    private String host;
    private int port;
    private String oldPid;
    private AdminCommandContext context;
    private static final long WAIT_TIME_MS = 600000L;

    public void execute(AdminCommandContext ctx) {
        try {
            this.context = ctx;
            this.helper = new RemoteInstanceCommandHelper(this.habitat);
            this.report = this.context.getActionReport();
            this.logger = this.context.getLogger();
            if (this.timeout <= 0) {
                String msg = "Timeout must be at least 1 second long.";
                this.logger.warning(msg);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            if (!this.env.isDas()) {
                this.setError(Strings.get("restart.instance.notDas", this.env.getRuntimeType().toString()));
            }
            this.prepare();
            this.setOldPid();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Restart-instance old-pid = {0}", this.oldPid);
            }
            this.callInstance();
            this.checkForRestart();
            if (!this.isError()) {
                String msg = Strings.get("restart.instance.success", this.instanceName);
                this.logger.info(msg);
                this.report.setMessage(msg);
            }
            this.synchronizeInstance();
        }
        catch (InstanceNotRunningException inre) {
            this.start();
        }
        catch (CommandException ce) {
            this.setError(Strings.get("restart.instance.racError", this.instanceName, ce.getLocalizedMessage()));
        }
    }

    private void synchronizeInstance() {
        NodeUtils nodeUtils = new NodeUtils(this.habitat, this.logger);
        ArrayList<String> command = new ArrayList<String>();
        String noderef = this.instance.getNodeRef();
        Node node = this.nodes.getNode(noderef);
        String nodeDir = node.getNodeDirUnixStyle();
        command.add("_synchronize-instance");
        if (this.sync != null) {
            command.add("--sync");
            command.add(this.sync);
        }
        if (nodeDir != null) {
            command.add("--nodedir");
            command.add(nodeDir);
        }
        command.add("--node");
        command.add(noderef);
        if (this.instanceName != null) {
            command.add(this.instanceName);
        }
        String humanCommand = this.makeCommandHuman(command);
        if (node == null) {
            String msg = Strings.get("missingNode", noderef);
            this.logger.severe(msg);
            this.report.setMessage(msg);
            return;
        }
        String nodeHost = node.getNodeHost();
        String firstErrorMessage = Strings.get("restart.instance.syncFailed", this.instanceName, noderef, nodeHost);
        StringBuilder output = new StringBuilder();
        boolean waitForReaderThreads = true;
        if (OS.isWindows()) {
            waitForReaderThreads = false;
        }
        nodeUtils.runAdminCommandOnNode(node, command, this.context, firstErrorMessage, humanCommand, output, waitForReaderThreads);
        if (this.report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
            String msg = Strings.get("restart.instance.success", this.instanceName);
            this.report.setMessage(msg);
        }
    }

    private String makeCommandHuman(List<String> command) {
        StringBuilder fullCommand = new StringBuilder("lib/nadmin ");
        for (String s : command) {
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }

    private void prepare() throws InstanceNotRunningException {
        if (this.isError()) {
            return;
        }
        if (!StringUtils.ok((String)this.instanceName)) {
            this.setError(Strings.get("stop.instance.noInstanceName"));
            return;
        }
        this.instance = this.helper.getServer(this.instanceName);
        if (this.instance == null) {
            this.setError(Strings.get("stop.instance.noSuchInstance", this.instanceName));
            return;
        }
        this.host = this.instance.getAdminHost();
        if (this.host == null) {
            this.setError(Strings.get("stop.instance.noHost", this.instanceName));
            return;
        }
        this.port = this.helper.getAdminPort(this.instance);
        if (this.port < 0) {
            this.setError(Strings.get("stop.instance.noPort", this.instanceName));
            return;
        }
        if (!this.isInstanceRestartable()) {
            this.setError(Strings.get("restart.notRestartable", this.instanceName));
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer(ObjectAnalyzer.toString((Object)this));
        }
    }

    private void callInstance() throws CommandException {
        if (this.isError()) {
            return;
        }
        String cmdName = "_restart-instance";
        RemoteRestAdminCommand rac = this.createRac(cmdName);
        ParameterMap map = new ParameterMap();
        if (this.debug != null) {
            map.add((Object)"debug", (Object)this.debug);
        }
        rac.setReadTimeout(this.timeout * 1000);
        rac.executeCommand(map);
    }

    private boolean isInstanceRestartable() throws InstanceNotRunningException {
        RemoteRestAdminCommand rac;
        if (this.isError()) {
            return false;
        }
        String cmdName = "_get-runtime-info";
        try {
            rac = this.createRac(cmdName);
            rac.executeCommand(new ParameterMap());
        }
        catch (CommandException ex) {
            throw new InstanceNotRunningException();
        }
        String val = rac.findPropertyInReport("restartable");
        return val == null || !val.equals("false");
    }

    private void checkForRestart() {
        block6: {
            if (this.isError()) {
                return;
            }
            try {
                String newpid = this.getPid();
                if (!StringUtils.ok((String)newpid) || newpid.equals(this.oldPid)) break block6;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Restarted instance pid = " + newpid);
                }
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setError(Strings.get("restart.instance.racError", this.instanceName, "instance pid is the same"));
    }

    private RemoteRestAdminCommand createRac(String cmdName) throws CommandException {
        return new ServerRemoteRestAdminCommand(this.habitat, cmdName, this.host, this.port, false, "admin", null, this.logger);
    }

    private void setError(String s) {
        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        this.report.setMessage(s);
    }

    private void setSuccess(String s) {
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        this.report.setMessage(s);
    }

    private boolean isError() {
        return this.report.getActionExitCode() == ActionReport.ExitCode.FAILURE;
    }

    private void setOldPid() throws CommandException {
        if (this.isError()) {
            return;
        }
        this.oldPid = this.getPid();
        if (!StringUtils.ok((String)this.oldPid)) {
            this.setError(Strings.get("restart.instance.nopid", this.instanceName));
        }
    }

    private String getPid() throws CommandException {
        String cmdName = "_get-runtime-info";
        RemoteRestAdminCommand rac = this.createRac(cmdName);
        rac.executeCommand(new ParameterMap());
        return rac.findPropertyInReport("pid");
    }

    private void start() {
        try {
            StartInstanceCommand sic = new StartInstanceCommand(this.habitat, this.instanceName, Boolean.parseBoolean(this.debug), this.env);
            sic.execute(this.context);
        }
        catch (Exception e) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setFailureCause((Throwable)e);
        }
        String messageFromStartCommand = this.report.getMessage();
        if (this.isError()) {
            this.setError(Strings.get("restart.instance.startFailed", messageFromStartCommand));
        } else {
            this.setSuccess(Strings.get("restart.instance.startSucceeded", messageFromStartCommand));
        }
    }

    private static class InstanceNotRunningException
    extends Exception {
        private InstanceNotRunningException() {
        }
    }
}

