/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.ArgumentManager;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.RespawnInfo;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.HostAndPort;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.admin.RuntimeType;

public class GFLauncherInfo {
    private RuntimeType type;
    private boolean verbose = false;
    private boolean watchdog = false;
    private boolean debug = false;
    private boolean upgrade = false;
    File installDir;
    private File domainParentDir;
    private File domainRootDir;
    private File instanceRootDir;
    private File configDir;
    private File configFile;
    private String domainName;
    private String instanceName;
    private boolean dropInterruptedCommands = false;
    private boolean valid = false;
    private Map<String, String> argsMap;
    private ArrayList<String> argsRaw = new ArrayList();
    private List<HostAndPort> adminAddresses;
    private RespawnInfo respawnInfo;
    private File postbootCommandsFile;
    private File prebootCommandsFile;
    private static final String DEFAULT_DOMAIN_PARENT_DIR = "domains";
    private static final String CONFIG_DIR = "config";
    private static final String CONFIG_FILENAME = "domain.xml";
    final List<String> securityTokens = new ArrayList<String>();

    public void addArgs(String ... args) {
        for (String s : args) {
            this.argsRaw.add(s);
        }
    }

    public void setPrebootCommandsFile(String file) {
        this.prebootCommandsFile = file == null ? null : new File(file);
    }

    public void setpostbootCommandsFile(File file) {
        this.postbootCommandsFile = file;
    }

    public void setpostbootCommandsFile(String file) {
        this.postbootCommandsFile = file == null ? null : new File(file);
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setDomainParentDir(String domainParentName) {
        this.domainParentDir = new File(domainParentName);
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public void setWatchdog(boolean b) {
        this.watchdog = b;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public void setUpgrade(boolean b) {
        this.upgrade = b;
    }

    public void setDomainRootDir(File f) {
        this.domainRootDir = f;
    }

    public void setInstanceName(String name) {
        this.instanceName = name;
    }

    public void setInstanceRootDir(File f) {
        this.instanceRootDir = f;
    }

    public void setDropInterruptedCommands(boolean dropInterruptedCommands) {
        this.dropInterruptedCommands = dropInterruptedCommands;
    }

    public final boolean isDomain() {
        return this.type == RuntimeType.DAS;
    }

    public final boolean isInstance() {
        return this.type == RuntimeType.INSTANCE;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isWatchdog() {
        return this.watchdog;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public File getPrebootCommandsFile() {
        return this.prebootCommandsFile;
    }

    public File getPostbootCommandsFile() {
        return this.postbootCommandsFile;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public File getDomainRootDir() {
        return this.domainRootDir;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public List<HostAndPort> getAdminAddresses() {
        return this.adminAddresses;
    }

    public RuntimeType getType() {
        return this.type;
    }

    public File getConfigDir() {
        return SmartFile.sanitize(this.configDir);
    }

    void setConfigDir(File f) {
        this.configDir = SmartFile.sanitize(f);
    }

    public File getInstanceRootDir() throws GFLauncherException {
        if (!this.valid) {
            throw new GFLauncherException("internalError", "Call to getInstanceRootDir() on an invalid GFLauncherInfo object.");
        }
        if (this.instanceRootDir != null) {
            return this.instanceRootDir;
        }
        if (this.isDomain()) {
            return this.domainRootDir;
        }
        throw new GFLauncherException("internalError", "Call to getInstanceRootDir() on an invalid GFLauncherInfo object.");
    }

    File getDomainParentDir() {
        return this.domainParentDir;
    }

    public boolean isDropInterruptedCommands() {
        return this.dropInterruptedCommands;
    }

    public String[] getArgsAsStringArray() throws GFLauncherException {
        List<String> list = this.getArgsAsList();
        String[] ss = new String[list.size()];
        return list.toArray(ss);
    }

    public List<String> getArgsAsList() throws GFLauncherException {
        Map<String, String> map = this.getArgs();
        Set<String> keys = map.keySet();
        ArrayList<String> argList = new ArrayList<String>();
        for (String key : keys) {
            argList.add(key);
            argList.add(map.get(key));
        }
        return argList;
    }

    public Map<String, String> getArgs() throws GFLauncherException {
        if (!this.valid) {
            throw new GFLauncherException("internalError", "Call to getArgs() on an invalid GFLauncherInfo object.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("-type", this.type.toString());
        if (this.isDomain()) {
            map.put("-domaindir", SmartFile.sanitize(this.domainRootDir.getPath()));
            map.put("-domainname", this.domainName);
        } else if (this.isInstance()) {
            map.put("-instancedir", SmartFile.sanitize(this.instanceRootDir.getPath()));
        }
        if (this.prebootCommandsFile != null) {
            map.put("-prebootcommandfile", SmartFile.sanitize(this.prebootCommandsFile.getPath()));
        }
        if (this.postbootCommandsFile != null) {
            map.put("-postbootcommandfile", SmartFile.sanitize(this.postbootCommandsFile.getPath()));
        }
        map.put("-watchdog", Boolean.toString(this.watchdog));
        map.put("-verbose", Boolean.toString(this.verbose));
        map.put("-debug", Boolean.toString(this.debug));
        map.put("-instancename", this.instanceName);
        map.put("-upgrade", Boolean.toString(this.upgrade));
        map.put("-read-stdin", "true");
        if (this.respawnInfo != null) {
            this.respawnInfo.put(map);
        }
        return map;
    }

    public void setRespawnInfo(String classname, String classpath, String[] args) {
        this.respawnInfo = new RespawnInfo(classname, classpath, args);
    }

    public void addSecurityToken(String name, String value) {
        if (name == null || value == null) {
            throw new NullPointerException();
        }
        this.securityTokens.add(name + "=" + value);
    }

    GFLauncherInfo(RuntimeType type) {
        this.type = type;
    }

    void setAdminAddresses(List<HostAndPort> adminAddresses) {
        this.adminAddresses = adminAddresses;
    }

    void setup() throws GFLauncherException {
        this.setupFromArgs();
        this.finalSetup();
    }

    void setInstallDir(File f) {
        this.installDir = f;
    }

    File getInstallDir() {
        return this.installDir;
    }

    private void setupFromArgs() {
        this.argsMap = ArgumentManager.argsToMap(this.argsRaw);
        File f = null;
        String s = null;
        ThreeStateBoolean tsb = null;
        f = this.getFile("domaindir");
        if (f != null) {
            this.domainParentDir = f;
        }
        if ((f = this.getFile("instanceRootDir")) != null) {
            this.instanceRootDir = f;
        }
        if ((f = this.getFile("domainroot")) != null) {
            this.domainRootDir = f;
        }
        if ((s = this.getString("domain")) != null) {
            this.domainName = s;
        }
        if (!GFLauncherUtils.ok(this.domainName) && (s = this.getString("default")) != null) {
            this.domainName = s;
        }
        if ((s = this.getString("instancename")) != null) {
            this.instanceName = s;
        }
        if ((tsb = this.getBoolean("debug")).isTrue()) {
            this.debug = true;
        } else if (tsb.isFalse()) {
            this.debug = false;
        }
        tsb = this.getBoolean("verbose");
        if (tsb.isTrue()) {
            this.verbose = true;
        } else if (tsb.isFalse()) {
            this.verbose = false;
        }
        tsb = this.getBoolean("watchdog");
        if (tsb.isTrue()) {
            this.watchdog = true;
        } else if (tsb.isFalse()) {
            this.watchdog = false;
        }
        tsb = this.getBoolean("upgrade");
        if (tsb.isTrue()) {
            this.upgrade = true;
        } else if (tsb.isFalse()) {
            this.upgrade = false;
        }
    }

    private void finalSetup() throws GFLauncherException {
        if (this.installDir == null) {
            this.installDir = GFLauncherUtils.getInstallDir();
        }
        if (!GFLauncherUtils.safeIsDirectory(this.installDir)) {
            throw new GFLauncherException("noInstallDir", this.installDir);
        }
        if (this.domainParentDir != null && !GFLauncherUtils.safeIsDirectory(this.domainParentDir)) {
            throw new GFLauncherException("noDomainParentDir", this.domainParentDir);
        }
        this.setupServerDirs();
        if (!GFLauncherUtils.safeIsDirectory(this.configDir)) {
            throw new GFLauncherException("noConfigDir", this.configDir);
        }
        this.configFile = new File(this.configDir, CONFIG_FILENAME);
        if (!GFLauncherUtils.safeExists(this.configFile)) {
            throw new GFLauncherException("noConfigFile", this.configFile);
        }
        if (this.instanceName == null) {
            this.instanceName = "server";
        }
        this.valid = true;
    }

    private void setupServerDirs() throws GFLauncherException {
        if (this.isDomain()) {
            this.setupDomainDirs();
        } else if (this.isInstance()) {
            this.setupInstanceDirs();
        }
    }

    private void setupDomainDirs() throws GFLauncherException {
        if (this.domainRootDir != null) {
            this.domainParentDir = this.domainRootDir.getParentFile();
            this.domainName = this.domainRootDir.getName();
            return;
        }
        if (this.domainParentDir == null) {
            this.domainParentDir = new File(this.installDir, DEFAULT_DOMAIN_PARENT_DIR);
        }
        if (this.domainName == null) {
            this.domainName = this.getTheOneAndOnlyDomain();
        }
        this.domainRootDir = new File(this.domainParentDir, this.domainName);
        if (!GFLauncherUtils.safeIsDirectory(this.domainRootDir)) {
            throw new GFLauncherException("noDomainRootDir", this.domainRootDir);
        }
        this.configDir = new File(this.domainRootDir, CONFIG_DIR);
    }

    private void setupInstanceDirs() throws GFLauncherException {
        if (this.instanceRootDir == null) {
            throw new GFLauncherException("Missing instanceRootDir");
        }
        if (this.instanceName == null) {
            throw new GFLauncherException("Missing instanceName");
        }
        this.configDir = new File(this.instanceRootDir, CONFIG_DIR);
    }

    private String getTheOneAndOnlyDomain() throws GFLauncherException {
        File[] files = this.domainParentDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return GFLauncherUtils.safeIsDirectory(f);
            }
        });
        if (files == null || files.length == 0) {
            throw new GFLauncherException("noDomainDirs", this.domainParentDir);
        }
        if (files.length > 1) {
            throw new GFLauncherException("tooManyDomainDirs", this.domainParentDir);
        }
        return files[0].getName();
    }

    private ThreeStateBoolean getBoolean(String key) {
        String s = this.getValueIgnoreCommandDelimiter(key);
        if (s != null) {
            return new ThreeStateBoolean(Boolean.valueOf(s));
        }
        return new ThreeStateBoolean(null);
    }

    private File getFile(String key) {
        String s = this.getString(key);
        if (s == null) {
            return null;
        }
        return new File(s);
    }

    private String getString(String key) {
        return this.getValueIgnoreCommandDelimiter(key);
    }

    private String getValueIgnoreCommandDelimiter(String key) {
        if (this.argsMap.containsKey(key)) {
            return this.argsMap.get(key);
        }
        if (this.argsMap.containsKey(key = "-" + (String)key)) {
            return this.argsMap.get(key);
        }
        if (this.argsMap.containsKey(key = "-" + (String)key)) {
            return this.argsMap.get(key);
        }
        return null;
    }

    boolean isVerboseOrWatchdog() {
        return this.verbose || this.watchdog;
    }

    private static final class ThreeStateBoolean {
        Boolean b;

        ThreeStateBoolean(Boolean b) {
            this.b = b;
        }

        boolean isNull() {
            return this.b == null;
        }

        boolean isTrue() {
            return !this.isNull() && this.b != false;
        }

        boolean isFalse() {
            return !this.isNull() && this.b == false;
        }
    }
}

