/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.ejb.entitybean.container.distributed;

import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.logging.LogDomains;
import fish.payara.nucleus.cluster.PayaraCluster;
import fish.payara.nucleus.eventbus.ClusterMessage;
import fish.payara.nucleus.eventbus.EventBus;
import fish.payara.nucleus.eventbus.MessageReceiver;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.persistence.ejb.entitybean.container.distributed.DistributedEJBServiceFactory;
import org.glassfish.persistence.ejb.entitybean.container.distributed.DistributedReadOnlyBeanNotifier;
import org.glassfish.persistence.ejb.entitybean.container.distributed.DistributedReadOnlyBeanService;
import org.jvnet.hk2.annotations.Service;

@Service
public class ReadOnlyBeanMessageCallBack
implements MessageReceiver,
DistributedReadOnlyBeanNotifier {
    @Inject
    private EjbContainerUtil ejbContainerUtil;
    @Inject
    EventBus eventBus;
    @Inject
    PayaraCluster cluster;
    private static DistributedReadOnlyBeanService _readOnlyBeanService = DistributedEJBServiceFactory.getDistributedEJBService().getDistributedReadOnlyBeanService();
    private static final String GMS_READ_ONLY_COMPONENT_NAME = "__GMS__READ_ONLY_BEAN__";
    static final Logger _logger = LogDomains.getLogger(ReadOnlyBeanMessageCallBack.class, (String)"javax.enterprise.system.container.ejb");

    public void postConstruct() {
        if (!this.ejbContainerUtil.isDas() && this.eventBus != null && this.cluster != null && this.cluster.isEnabled()) {
            _readOnlyBeanService.setDistributedReadOnlyBeanNotifier(this);
            this.eventBus.addMessageReceiver(GMS_READ_ONLY_COMPONENT_NAME, (MessageReceiver)this);
        }
    }

    public void receiveMessage(ClusterMessage cm) {
        RefreshPayload message = (RefreshPayload)cm.getPayload();
        byte[] payload = message.payload;
        int size = payload.length;
        long ejbID = ReadOnlyBeanMessageCallBack.bytesToLong(payload, 0);
        if (size == 8) {
            _logger.log(Level.WARNING, "ReadOnlyBeanMessageCallBack:  Got message for ejbID: " + ejbID);
            _readOnlyBeanService.handleRefreshAllRequest(ejbID);
        } else {
            byte[] pkData = new byte[size - 8];
            System.arraycopy(payload, 8, pkData, 0, pkData.length);
            _readOnlyBeanService.handleRefreshRequest(ejbID, pkData);
            _logger.log(Level.WARNING, "ReadOnlyBeanMessageCallBack:  Handled message for ejbID: " + ejbID);
        }
    }

    @Override
    public void notifyRefresh(long ejbID, byte[] pk) {
        int size = pk.length;
        byte[] payload = new byte[size + 8];
        ReadOnlyBeanMessageCallBack.longToBytes(ejbID, payload, 0);
        System.arraycopy(pk, 0, payload, 8, size);
        try {
            this.eventBus.publish(GMS_READ_ONLY_COMPONENT_NAME, new ClusterMessage((Serializable)new RefreshPayload(payload)));
            _logger.log(Level.WARNING, "ReadOnlyBeanMessageCallBack:  Sent message for ejbID: " + ejbID);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ReadOnlyBeanMessageCallBack: Got exception during notifyRefresh", ex);
        }
    }

    @Override
    public void notifyRefreshAll(long ejbID) {
        byte[] payload = new byte[8];
        ReadOnlyBeanMessageCallBack.longToBytes(ejbID, payload, 0);
        try {
            this.eventBus.publish(GMS_READ_ONLY_COMPONENT_NAME, new ClusterMessage((Serializable)new RefreshPayload(payload)));
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ReadOnlyBeanMessageCallBack: Got exception during notifyRefreshAll", ex);
        }
    }

    private static void longToBytes(long value, byte[] array, int offset) {
        array[offset] = (byte)(value >>> 56 & 0xFFL);
        array[offset + 1] = (byte)(value >>> 48 & 0xFFL);
        array[offset + 2] = (byte)(value >>> 40 & 0xFFL);
        array[offset + 3] = (byte)(value >>> 32 & 0xFFL);
        array[offset + 4] = (byte)(value >>> 24 & 0xFFL);
        array[offset + 5] = (byte)(value >>> 16 & 0xFFL);
        array[offset + 6] = (byte)(value >>> 8 & 0xFFL);
        array[offset + 7] = (byte)(value >>> 0 & 0xFFL);
    }

    private static long bytesToLong(byte[] array, int offset) {
        long l1 = (long)ReadOnlyBeanMessageCallBack.bytesToInt(array, offset) << 32;
        long l2 = (long)ReadOnlyBeanMessageCallBack.bytesToInt(array, offset + 4) & 0xFFFFFFFFL;
        return l1 | l2;
    }

    private static int bytesToInt(byte[] array, int offset) {
        int b1 = array[offset] << 24 & 0xFF000000;
        int b2 = array[offset + 1] << 16 & 0xFF0000;
        int b3 = array[offset + 2] << 8 & 0xFF00;
        int b4 = array[offset + 3] << 0 & 0xFF;
        return b1 | b2 | b3 | b4;
    }

    private class RefreshPayload
    implements Serializable {
        byte[] payload;

        private RefreshPayload(byte[] payload) {
            this.payload = payload;
        }
    }
}

