/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.docker.instance;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JsonRequestConstructor {
    public static JsonObject constructJsonRequest(Properties containerConfig, Node node, Server server, String dasHost, String dasPort) {
        JsonObjectBuilder rootObjectBuilder = Json.createObjectBuilder();
        rootObjectBuilder.add("Image", node.getDockerImage());
        if (containerConfig.isEmpty()) {
            rootObjectBuilder.add("HostConfig", Json.createObjectBuilder().add("Mounts", Json.createArrayBuilder().add(Json.createObjectBuilder().add("Type", "bind").add("Source", node.getDockerPasswordFile()).add("Target", "/opt/payara/passwords/passwordfile.txt").add("ReadOnly", true))).add("NetworkMode", "host"));
            rootObjectBuilder.add("Env", Json.createArrayBuilder().add("PAYARA_DAS_HOST=" + dasHost).add("PAYARA_DAS_PORT=" + dasPort).add("PAYARA_NODE_NAME=" + node.getName()).add("PAYARA_CONFIG_NAME=" + server.getConfigRef()).add("PAYARA_INSTANCE_NAME=" + server.getName()));
        } else {
            JsonRequestConstructor.translatePropertyValuesToJson(rootObjectBuilder, containerConfig, node, server, dasHost, dasPort);
        }
        return rootObjectBuilder.build();
    }

    private static void translatePropertyValuesToJson(JsonObjectBuilder rootObjectBuilder, Properties containerConfig, Node node, Server server, String dasHost, String dasPort) {
        ArrayList<String> processedProperties = new ArrayList<String>();
        boolean hostConfigAdded = false;
        boolean envConfigAdded = false;
        for (String property : containerConfig.stringPropertyNames()) {
            if (processedProperties.contains(property)) continue;
            if (property.startsWith("HostConfig")) {
                hostConfigAdded = true;
                JsonRequestConstructor.addHostConfigProperties(rootObjectBuilder, containerConfig, processedProperties, node);
                continue;
            }
            if (property.startsWith("Env")) {
                envConfigAdded = true;
                JsonRequestConstructor.addEnvProperties(rootObjectBuilder, containerConfig, node, server, dasHost, dasPort);
                continue;
            }
            if (property.contains(".")) {
                JsonRequestConstructor.addNestedProperties(rootObjectBuilder, containerConfig, processedProperties, property);
                continue;
            }
            String propertyValue = containerConfig.getProperty(property);
            JsonRequestConstructor.addPropertyToJson(rootObjectBuilder, property, propertyValue);
            processedProperties.add(property);
        }
        if (!hostConfigAdded) {
            rootObjectBuilder.add("HostConfig", Json.createObjectBuilder().add("Mounts", Json.createArrayBuilder().add(Json.createObjectBuilder().add("Type", "bind").add("Source", node.getDockerPasswordFile()).add("Target", "/opt/payara/passwords/passwordfile.txt").add("ReadOnly", true))).add("NetworkMode", "host"));
        }
        if (!envConfigAdded) {
            rootObjectBuilder.add("Env", Json.createArrayBuilder().add("PAYARA_DAS_HOST=" + dasHost).add("PAYARA_DAS_PORT=" + dasPort).add("PAYARA_NODE_NAME=" + node.getName()).add("PAYARA_CONFIG_NAME=" + server.getConfigRef()).add("PAYARA_INSTANCE_NAME=" + server.getName()));
        }
    }

    private static void addHostConfigProperties(JsonObjectBuilder rootObjectBuilder, Properties containerConfig, List<String> processedProperties, Node node) {
        JsonObjectBuilder hostConfigObjectBuilder = Json.createObjectBuilder();
        HashMap<String, Boolean> defaultsOverridden = new HashMap<String, Boolean>();
        defaultsOverridden.put("Mounts", false);
        defaultsOverridden.put("NetworkMode", false);
        JsonRequestConstructor.loopOverNestedProperties(rootObjectBuilder, containerConfig, processedProperties, "HostConfig", hostConfigObjectBuilder, defaultsOverridden);
        if (!((Boolean)defaultsOverridden.get("Mounts")).booleanValue()) {
            hostConfigObjectBuilder.add("Mounts", Json.createArrayBuilder().add(Json.createObjectBuilder().add("Type", "bind").add("Source", node.getDockerPasswordFile()).add("Target", "/opt/payara/passwords/passwordfile.txt").add("ReadOnly", true)));
        }
        if (!((Boolean)defaultsOverridden.get("NetworkMode")).booleanValue()) {
            hostConfigObjectBuilder.add("NetworkMode", "host");
        }
        rootObjectBuilder.add("HostConfig", hostConfigObjectBuilder);
    }

    private static void addNestedProperties(JsonObjectBuilder rootObjectBuilder, Properties containerConfig, List<String> processedProperties, String originalProperty) {
        JsonObjectBuilder topLevelObjectBuilder = Json.createObjectBuilder();
        String topLevelProperty = originalProperty.substring(0, originalProperty.indexOf(46));
        JsonRequestConstructor.loopOverNestedProperties(rootObjectBuilder, containerConfig, processedProperties, topLevelProperty, topLevelObjectBuilder, null);
        rootObjectBuilder.add(topLevelProperty, topLevelObjectBuilder);
    }

    private static void addEnvProperties(JsonObjectBuilder rootObjectBuilder, Properties containerConfig, Node node, Server server, String dasHost, String dasPort) {
        Object envConfigString = containerConfig.getProperty("Env").replaceAll("\\[", "").replaceAll("\\]", "");
        if (!((String)envConfigString).contains("PAYARA_DAS_HOST")) {
            envConfigString = (String)envConfigString + "|PAYARA_DAS_HOST=" + dasHost;
        }
        if (!((String)envConfigString).contains("PAYARA_DAS_PORT")) {
            envConfigString = (String)envConfigString + "|PAYARA_DAS_PORT=" + dasPort;
        }
        if (!((String)envConfigString).contains("PAYARA_NODE_NAME")) {
            envConfigString = (String)envConfigString + "|PAYARA_NODE_NAME=" + node.getName();
        }
        if (!((String)envConfigString).contains("PAYARA_CONFIG_NAME")) {
            envConfigString = (String)envConfigString + "|PAYARA_CONFIG_NAME=" + server.getConfigRef();
        }
        if (!((String)envConfigString).contains("PAYARA_INSTANCE_NAME")) {
            envConfigString = (String)envConfigString + "|PAYARA_INSTANCE_NAME=" + server.getName();
        }
        envConfigString = ((String)envConfigString).replaceAll(":", "=");
        envConfigString = "[" + (String)envConfigString + "]";
        JsonRequestConstructor.addPropertyToJson(rootObjectBuilder, "Env", (String)envConfigString);
    }

    private static void loopOverNestedProperties(JsonObjectBuilder rootObjectBuilder, Properties containerConfig, List<String> processedProperties, String topLevelProperty, JsonObjectBuilder topLevelObjectBuilder, Map<String, Boolean> defaultsOverridden) {
        ArrayList<String> nestedProperties = new ArrayList<String>();
        for (String property : containerConfig.stringPropertyNames()) {
            if (!property.startsWith(topLevelProperty)) continue;
            nestedProperties.add(property);
        }
        nestedProperties.sort(Comparator.comparing(String::toString));
        for (String property : nestedProperties) {
            if (processedProperties.contains(property)) continue;
            if (defaultsOverridden != null) {
                switch (property) {
                    case "HostConfig.Mounts": {
                        defaultsOverridden.put("Mounts", true);
                        break;
                    }
                    case "HostConfig.NetworkMode": {
                        defaultsOverridden.put("NetworkMode", true);
                    }
                }
            }
            HashMap<String, JsonObjectBuilder> propertyComponentObjectBuilders = new HashMap<String, JsonObjectBuilder>();
            propertyComponentObjectBuilders.put(topLevelProperty, topLevelObjectBuilder);
            JsonRequestConstructor.recurseOverNested(rootObjectBuilder, containerConfig, processedProperties, nestedProperties, property, propertyComponentObjectBuilders, null);
        }
    }

    private static void recurseOverNested(JsonObjectBuilder parentObjectBuilder, Properties containerConfig, List<String> processedProperties, List<String> nestedProperties, String property, Map<String, JsonObjectBuilder> propertyComponentObjectBuilders, String parent) {
        block5: {
            String immediateParent;
            List<String> propertyComponents;
            block6: {
                propertyComponents = Arrays.asList(property.split("\\."));
                for (String propertyComponent : propertyComponents) {
                    if (propertyComponents.indexOf(propertyComponent) == propertyComponents.size() - 1) continue;
                    propertyComponentObjectBuilders.putIfAbsent(propertyComponent, Json.createObjectBuilder());
                }
                immediateParent = propertyComponents.get(propertyComponents.size() - 2);
                JsonObjectBuilder immediateParentObjectBuilder = immediateParent.equals(parent) ? parentObjectBuilder : propertyComponentObjectBuilders.get(immediateParent);
                String propertyComponentKey = propertyComponents.get(propertyComponents.size() - 1);
                String propertyValue = containerConfig.getProperty(property);
                JsonRequestConstructor.addPropertyToJson(immediateParentObjectBuilder, propertyComponentKey, propertyValue);
                processedProperties.add(property);
                if (nestedProperties.indexOf(property) + 1 == nestedProperties.size()) break block6;
                String nextProperty = nestedProperties.get(nestedProperties.indexOf(property) + 1);
                for (int i = propertyComponents.size() - 2; i > 0; --i) {
                    StringBuffer parents = new StringBuffer();
                    for (int j = 0; j < i + 1; ++j) {
                        parents.append(propertyComponents.get(j));
                        if (j == i) continue;
                        parents.append(".");
                    }
                    if (nextProperty.startsWith(parents.toString())) {
                        JsonRequestConstructor.recurseOverNested(propertyComponentObjectBuilders.get(propertyComponents.get(i)), containerConfig, processedProperties, nestedProperties, nextProperty, propertyComponentObjectBuilders, immediateParent);
                        break block5;
                    }
                    if (i == 0) continue;
                    JsonObjectBuilder parentPropertyComponentObjectBuilder = propertyComponentObjectBuilders.get(propertyComponents.get(i - 1));
                    parentPropertyComponentObjectBuilder.add(propertyComponents.get(i), propertyComponentObjectBuilders.get(propertyComponents.get(i)));
                    propertyComponentObjectBuilders.remove(propertyComponents.get(i));
                }
                break block5;
            }
            if (propertyComponents.size() <= 2) break block5;
            for (int i = propertyComponents.size() - 2; i > 0; --i) {
                propertyComponentObjectBuilders.get(propertyComponents.get(i - 1)).add(propertyComponents.get(i), propertyComponentObjectBuilders.get(propertyComponents.get(i)));
                propertyComponentObjectBuilders.remove(propertyComponents.get(propertyComponents.indexOf(immediateParent)));
            }
        }
    }

    private static void addPropertyToJson(JsonObjectBuilder jsonObjectBuilder, String property, String propertyValue) {
        if (propertyValue.startsWith("[") && propertyValue.endsWith("]")) {
            if ((propertyValue = propertyValue.replaceAll("\\[", "").replaceAll("\\]", "")).contains(",")) {
                JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
                for (String arrayElement : propertyValue.split("\\|")) {
                    JsonObjectBuilder arrayObjectBuilder = Json.createObjectBuilder();
                    for (String object : arrayElement.split(",")) {
                        String[] keyValue = object.split(":");
                        arrayObjectBuilder.add(keyValue[0], keyValue[1]);
                    }
                    jsonArrayBuilder.add(arrayObjectBuilder);
                }
                jsonObjectBuilder.add(property, jsonArrayBuilder);
            } else {
                JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
                for (String arrayElement : propertyValue.split("\\|")) {
                    jsonArrayBuilder.add(arrayElement);
                }
                jsonObjectBuilder.add(property, jsonArrayBuilder);
            }
        } else {
            jsonObjectBuilder.add(property, propertyValue);
        }
    }
}

