/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cdi.jsr107.implementation;

import fish.payara.cdi.jsr107.implementation.PayaraCacheInvocationParameter;
import fish.payara.cdi.jsr107.implementation.PayaraCacheKeyGenerator;
import fish.payara.cdi.jsr107.implementation.PayaraCacheResolverFactory;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheInvocationParameter;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.CacheValue;

public class PayaraCacheKeyInvocationContext<A extends Annotation>
implements CacheKeyInvocationContext<A> {
    private final InvocationContext ctx;
    private final A annotation;
    private CacheDefaults defaults;
    private CacheResolverFactory factory;
    private CacheKeyGenerator generator;

    public PayaraCacheKeyInvocationContext(InvocationContext ctx, A annotation) {
        this.ctx = ctx;
        this.annotation = annotation;
        Class<?> clazz = ctx.getTarget().getClass();
        while (this.defaults == null && clazz != null) {
            this.defaults = clazz.getAnnotation(CacheDefaults.class);
            if (this.defaults != null) continue;
            clazz = clazz.getSuperclass();
        }
        if (!(annotation instanceof CacheRemoveAll)) {
            this.generator = this.getGenerator();
        }
        this.factory = this.getFactory();
    }

    public Object getTarget() {
        return this.ctx.getTarget();
    }

    public final CacheResolverFactory getFactory() {
        CachePut put;
        if (this.factory != null) {
            return this.factory;
        }
        this.factory = new PayaraCacheResolverFactory();
        Class<CacheResolverFactory> defaultClazz = CacheResolverFactory.class;
        Class suggestedClazz = null;
        if (this.annotation instanceof CachePut) {
            put = (CachePut)CachePut.class.cast(this.annotation);
            suggestedClazz = put.cacheResolverFactory();
        } else if (this.annotation instanceof CacheRemove) {
            put = (CacheRemove)CacheRemove.class.cast(this.annotation);
            suggestedClazz = put.cacheResolverFactory();
        } else if (this.annotation instanceof CacheResult) {
            put = (CacheResult)CacheResult.class.cast(this.annotation);
            suggestedClazz = put.cacheResolverFactory();
        } else if (this.annotation instanceof CacheRemoveAll) {
            put = (CacheRemoveAll)CacheRemoveAll.class.cast(this.annotation);
            suggestedClazz = put.cacheResolverFactory();
        }
        if (suggestedClazz == defaultClazz && this.defaults != null) {
            suggestedClazz = this.defaults.cacheResolverFactory();
        }
        if (defaultClazz != suggestedClazz && suggestedClazz != null) {
            try {
                this.factory = (CacheResolverFactory)suggestedClazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(PayaraCacheKeyInvocationContext.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.factory;
    }

    public final CacheKeyGenerator getGenerator() {
        CachePut put;
        if (this.generator != null) {
            return this.generator;
        }
        this.generator = new PayaraCacheKeyGenerator();
        Class<CacheKeyGenerator> defaultClazz = CacheKeyGenerator.class;
        Class suggestedClazz = null;
        if (this.annotation instanceof CachePut) {
            put = (CachePut)CachePut.class.cast(this.annotation);
            suggestedClazz = put.cacheKeyGenerator();
        } else if (this.annotation instanceof CacheRemove) {
            put = (CacheRemove)CacheRemove.class.cast(this.annotation);
            suggestedClazz = put.cacheKeyGenerator();
        } else if (this.annotation instanceof CacheResult) {
            put = (CacheResult)CacheResult.class.cast(this.annotation);
            suggestedClazz = put.cacheKeyGenerator();
        }
        if (suggestedClazz == defaultClazz && this.defaults != null) {
            suggestedClazz = this.defaults.cacheKeyGenerator();
        }
        if (defaultClazz != suggestedClazz && suggestedClazz != null) {
            try {
                this.generator = (CacheKeyGenerator)suggestedClazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(PayaraCacheKeyInvocationContext.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.generator;
    }

    public CacheInvocationParameter[] getAllParameters() {
        Class<?>[] parameters = this.getMethod().getParameterTypes();
        Annotation[][] annotations = this.getMethod().getParameterAnnotations();
        Object[] values = this.ctx.getParameters();
        CacheInvocationParameter[] result = new CacheInvocationParameter[parameters.length];
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                result[i] = new PayaraCacheInvocationParameter(parameters[i], annotations[i], value, i);
            }
        }
        return result;
    }

    public Object unwrap(Class type) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Method getMethod() {
        return this.ctx.getMethod();
    }

    public Set getAnnotations() {
        Annotation[] annotations;
        HashSet<Annotation> result = new HashSet<Annotation>();
        for (Annotation annotation1 : annotations = this.getMethod().getAnnotations()) {
            result.add(annotation1);
        }
        return result;
    }

    public String getCacheName() {
        CachePut put;
        String result = null;
        if (this.annotation instanceof CachePut) {
            put = (CachePut)CachePut.class.cast(this.annotation);
            result = put.cacheName();
        } else if (this.annotation instanceof CacheRemove) {
            put = (CacheRemove)CacheRemove.class.cast(this.annotation);
            result = put.cacheName();
        } else if (this.annotation instanceof CacheRemoveAll) {
            put = (CacheRemoveAll)CacheRemoveAll.class.cast(this.annotation);
            result = put.cacheName();
        } else if (this.annotation instanceof CacheResult) {
            put = (CacheResult)CacheResult.class.cast(this.annotation);
            result = put.cacheName();
        }
        if ((result == null || result.isEmpty()) && this.defaults != null) {
            result = this.defaults.cacheName();
        }
        if (result == null || result.isEmpty()) {
            String targetClassName = this.ctx.getTarget().getClass().getName();
            String methodName = this.ctx.getMethod().getName();
            Object[] params = this.ctx.getParameters();
            StringBuilder cacheName = new StringBuilder(targetClassName);
            cacheName.append('.').append(methodName).append('(');
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    cacheName.append(params[i].getClass().getName());
                    if (i == params.length - 1) continue;
                    cacheName.append(',');
                }
            }
            cacheName.append(')');
            result = cacheName.toString();
        }
        return result;
    }

    public A getCacheAnnotation() {
        return this.annotation;
    }

    public CacheInvocationParameter[] getKeyParameters() {
        CacheInvocationParameter[] allParams = this.getAllParameters();
        LinkedList<CacheInvocationParameter> result = new LinkedList<CacheInvocationParameter>();
        for (CacheInvocationParameter result1 : allParams) {
            for (Annotation annotation : result1.getAnnotations()) {
                if (!annotation.annotationType().equals(CacheKey.class)) continue;
                result.add(result1);
            }
        }
        if (result.isEmpty()) {
            for (CacheInvocationParameter result1 : allParams) {
                boolean add = true;
                for (Annotation annotation : result1.getAnnotations()) {
                    if (!annotation.annotationType().equals(CacheValue.class)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                result.add(result1);
            }
        }
        CacheInvocationParameter[] resultArray = new CacheInvocationParameter[result.size()];
        int i = 0;
        for (CacheInvocationParameter resultArray1 : result) {
            resultArray[i++] = resultArray1;
        }
        return resultArray;
    }

    public CacheInvocationParameter getValueParameter() {
        CacheInvocationParameter[] allParams;
        CacheInvocationParameter result = null;
        block0: for (CacheInvocationParameter result1 : allParams = this.getAllParameters()) {
            for (Annotation annotation : result1.getAnnotations()) {
                if (!annotation.annotationType().equals(CacheValue.class)) continue;
                result = result1;
                continue block0;
            }
        }
        return result;
    }
}

