/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.security.application;

import com.sun.ejb.EjbInvocation;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityManager;
import com.sun.enterprise.security.auth.WebAndEjbToJaasBridge;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.ee.SecurityUtil;
import com.sun.enterprise.security.ee.audit.AppServerAuditManager;
import com.sun.enterprise.security.jacc.JaccEJBConstraintsTranslator;
import com.sun.enterprise.security.jacc.cache.CachedPermission;
import com.sun.enterprise.security.jacc.cache.CachedPermissionImpl;
import com.sun.enterprise.security.jacc.cache.PermissionCache;
import com.sun.enterprise.security.jacc.cache.PermissionCacheFactory;
import com.sun.enterprise.security.jacc.context.PolicyContextHandlerImpl;
import com.sun.logging.LogDomains;
import jakarta.security.jacc.EJBMethodPermission;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.security.application.EjbSecurityProbeProvider;
import org.glassfish.ejb.security.application.EjbSecurityStatsProvider;
import org.glassfish.ejb.security.factory.EJBSecurityManagerFactory;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;

public final class EJBSecurityManager
implements SecurityManager {
    private static final Logger _logger = LogDomains.getLogger(EJBSecurityManager.class, (String)"javax.enterprise.system.container.ejb");
    private AppServerAuditManager auditManager;
    private static final PolicyContextHandlerImpl pcHandlerImpl = (PolicyContextHandlerImpl)PolicyContextHandlerImpl.getInstance();
    private final SecurityRoleMapperFactory roleMapperFactory;
    private final EjbDescriptor deploymentDescriptor;
    private final RunAsIdentityDescriptor runAs;
    private static PolicyConfigurationFactory policyConfigurationFactory;
    private String ejbName;
    private String contextId;
    private CodeSource codesource;
    private String realmName;
    private final Map cacheProtectionDomain = Collections.synchronizedMap(new WeakHashMap());
    private final Map protectionDomainCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map accessControlContextCache = Collections.synchronizedMap(new WeakHashMap());
    private PermissionCache uncheckedMethodPermissionCache;
    private final Policy policy;
    private static final CodeSource managerCodeSource;
    private final InvocationManager invocationManager;
    private final EJBSecurityManagerFactory securityManagerFactory;
    private final EjbSecurityProbeProvider probeProvider = new EjbSecurityProbeProvider();
    private static volatile EjbSecurityStatsProvider ejbStatsProvider;

    public EJBSecurityManager(EjbDescriptor ejbDescriptor, InvocationManager invocationManager, EJBSecurityManagerFactory fact) throws Exception {
        boolean runas;
        this.deploymentDescriptor = ejbDescriptor;
        this.invocationManager = invocationManager;
        this.roleMapperFactory = SecurityUtil.getRoleMapperFactory();
        this.policy = Policy.getPolicy();
        this.securityManagerFactory = fact;
        boolean bl = runas = this.deploymentDescriptor.getUsesCallerIdentity() == false;
        if (runas) {
            this.runAs = this.deploymentDescriptor.getRunAsIdentity();
            if (this.runAs != null && _logger.isLoggable(Level.FINE)) {
                _logger.fine(this.deploymentDescriptor.getEjbClassName() + " will run-as: " + this.runAs.getPrincipal() + " (" + this.runAs.getRoleName() + ")");
            }
        } else {
            this.runAs = null;
        }
        this.initialize();
    }

    public static String getContextID(EjbDescriptor ejbDescriptor) {
        return SecurityUtil.getContextID((EjbBundleDescriptor)ejbDescriptor.getEjbBundleDescriptor());
    }

    public void preInvoke(ComponentInvocation inv) {
        if (this.runAs == null) {
            inv.setPreInvokeDone(true);
            return;
        }
        boolean isWebService = false;
        if (inv instanceof EjbInvocation) {
            isWebService = ((EjbInvocation)inv).isWebService;
        }
        if ((!isWebService || inv.getAuth() != null && inv.getAuth().booleanValue()) && !inv.isPreInvokeDone()) {
            inv.setOldSecurityContext((Object)SecurityContext.getCurrent());
            this.loginForRunAs();
            inv.setPreInvokeDone(true);
        }
    }

    public void postInvoke(ComponentInvocation inv) {
        if (this.runAs != null && inv.isPreInvokeDone()) {
            AppservAccessController.privileged(() -> SecurityContext.setCurrent((SecurityContext)((SecurityContext)inv.getOldSecurityContext())));
        }
    }

    public boolean getUsesCallerIdentity() {
        return this.runAs == null;
    }

    public void loadPolicyConfiguration(EjbDescriptor ejbDescriptor) throws Exception {
        PolicyConfigurationFactory factory = EJBSecurityManager.getPolicyFactory();
        boolean inService = factory.inService(this.contextId);
        if (!inService) {
            JaccEJBConstraintsTranslator.translateConstraintsToPermissions((com.sun.enterprise.deployment.EjbDescriptor)ejbDescriptor, (PolicyConfiguration)factory.getPolicyConfiguration(this.contextId, false));
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC: policy translated for policy context:" + this.contextId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authorize(ComponentInvocation componentInvocation) {
        if (!(componentInvocation instanceof EjbInvocation)) {
            return false;
        }
        EjbInvocation ejbInvocation = (EjbInvocation)componentInvocation;
        if (ejbInvocation.getAuth() != null) {
            return ejbInvocation.getAuth();
        }
        boolean isAuthorized = false;
        CachedPermission cachedPermission = null;
        Object permission = null;
        if (ejbInvocation.invocationInfo == null || ejbInvocation.invocationInfo.cachedPermission == null) {
            permission = new EJBMethodPermission(this.ejbName, ejbInvocation.getMethodInterface(), ejbInvocation.method);
            cachedPermission = new CachedPermissionImpl(this.uncheckedMethodPermissionCache, (Permission)permission);
            if (ejbInvocation.invocationInfo != null) {
                ejbInvocation.invocationInfo.cachedPermission = cachedPermission;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("JACC: permission initialized in InvocationInfo: EJBMethodPermission (Name) = " + ((Permission)permission).getName() + " (Action) = " + ((Permission)permission).getActions());
                }
            }
        } else {
            cachedPermission = ejbInvocation.invocationInfo.cachedPermission;
            permission = cachedPermission.getPermission();
        }
        String caller = null;
        SecurityContext securityContext = null;
        pcHandlerImpl.getHandlerData().setInvocation((ComponentInvocation)ejbInvocation);
        isAuthorized = cachedPermission.checkPermission();
        if (!isAuthorized) {
            securityContext = SecurityContext.getCurrent();
            try {
                String oldContextId = EJBSecurityManager.setPolicyContext(this.contextId);
                try {
                    isAuthorized = this.policy.implies(this.getCachedProtectionDomain(securityContext.getPrincipalSet(), true), (Permission)permission);
                }
                catch (Throwable t) {
                    _logger.log(Level.SEVERE, "jacc_access_exception", t);
                    isAuthorized = false;
                }
                finally {
                    EJBSecurityManager.resetPolicyContext(oldContextId, this.contextId);
                }
            }
            catch (Throwable t) {
                _logger.log(Level.SEVERE, "jacc_policy_context_exception", t);
                isAuthorized = false;
            }
        }
        ejbInvocation.setAuth(isAuthorized);
        if (this.auditManager.isAuditOn()) {
            if (securityContext == null) {
                securityContext = SecurityContext.getCurrent();
            }
            caller = securityContext.getCallerPrincipal().getName();
            this.auditManager.ejbInvocation(caller, this.ejbName, ejbInvocation.method.toString(), isAuthorized);
        }
        if (isAuthorized && ejbInvocation.isWebService && !ejbInvocation.isPreInvokeDone()) {
            this.preInvoke(ejbInvocation);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JACC: Access Control Decision Result: " + isAuthorized + " EJBMethodPermission (Name) = " + ((Permission)permission).getName() + " (Action) = " + ((Permission)permission).getActions() + " (Caller) = " + caller);
        }
        return isAuthorized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCallerInRole(String role) {
        boolean isCallerInRole = false;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("EJBSecurityManager", "isCallerInRole", role);
        }
        EJBRoleRefPermission ejbRoleRefPermission = new EJBRoleRefPermission(this.ejbName, role);
        SecurityContext securityContext = this.runAs != null ? (SecurityContext)this.invocationManager.getCurrentInvocation().getOldSecurityContext() : SecurityContext.getCurrent();
        Set principalSet = securityContext != null ? securityContext.getPrincipalSet() : null;
        ProtectionDomain prdm = this.getCachedProtectionDomain(principalSet, true);
        String oldContextId = null;
        try {
            oldContextId = EJBSecurityManager.setPolicyContext(this.contextId);
            isCallerInRole = this.policy.implies(prdm, (Permission)ejbRoleRefPermission);
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "jacc_is_caller_in_role_exception", t);
            isCallerInRole = false;
        }
        finally {
            try {
                EJBSecurityManager.resetPolicyContext(oldContextId, this.contextId);
            }
            catch (Throwable ex) {
                _logger.log(Level.SEVERE, "jacc_policy_context_exception", ex);
                isCallerInRole = false;
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JACC: isCallerInRole Result: " + isCallerInRole + " EJBRoleRefPermission (Name) = " + ejbRoleRefPermission.getName() + " (Action) = " + ejbRoleRefPermission.getActions() + " (Codesource) = " + prdm.getCodeSource());
        }
        return isCallerInRole;
    }

    public Object invoke(Method beanClassMethod, boolean isLocal, Object beanObject, Object[] parameters) throws Throwable {
        if (isLocal && this.getUsesCallerIdentity() || System.getSecurityManager() == null) {
            return this.runMethod(beanClassMethod, beanObject, parameters);
        }
        try {
            return this.doAsPrivileged(() -> beanClassMethod.invoke(beanObject, parameters));
        }
        catch (PrivilegedActionException pae) {
            throw pae.getCause();
        }
    }

    public void resetPolicyContext() {
        try {
            AppservAccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ((PolicyContextHandlerImpl)PolicyContextHandlerImpl.getInstance()).reset();
                    PolicyContext.setContextID(null);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof AccessControlException) {
                _logger.log(Level.SEVERE, "jacc_policy_context_security_exception", cause);
            } else {
                _logger.log(Level.SEVERE, "jacc_policy_context_exception", cause);
            }
            throw new RuntimeException(cause);
        }
    }

    public Principal getCallerPrincipal() {
        SecurityContext securityContext = null;
        if (this.runAs != null) {
            ComponentInvocation componentInvocation = this.invocationManager.getCurrentInvocation();
            if (componentInvocation == null) {
                throw new InvocationException();
            }
            securityContext = (SecurityContext)componentInvocation.getOldSecurityContext();
        } else {
            securityContext = SecurityContext.getCurrent();
        }
        if (securityContext != null) {
            return securityContext.getCallerPrincipal();
        }
        return SecurityContext.getDefaultCallerPrincipal();
    }

    public void destroy() {
        try {
            boolean wasInService = EJBSecurityManager.getPolicyFactory().inService(this.contextId);
            if (wasInService) {
                this.policy.refresh();
            }
            PermissionCacheFactory.removePermissionCache((PermissionCache)this.uncheckedMethodPermissionCache);
            this.uncheckedMethodPermissionCache = null;
            this.roleMapperFactory.removeAppNameForContext(this.contextId);
        }
        catch (PolicyContextException pce) {
            _logger.log(Level.WARNING, "ejbsm.could_not_delete", pce);
        }
        this.probeProvider.securityManagerDestructionStartedEvent(this.ejbName);
        this.securityManagerFactory.getManager(this.contextId, this.ejbName, true);
        this.probeProvider.securityManagerDestructionEndedEvent(this.ejbName);
        this.probeProvider.securityManagerDestructionEvent(this.ejbName);
    }

    public Subject getCurrentSubject() {
        return SecurityContext.getCurrent().getSubject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doAsPrivileged(PrivilegedExceptionAction pea) throws Throwable {
        SecurityContext sc = SecurityContext.getCurrent();
        Set principalSet = sc.getPrincipalSet();
        AccessControlContext acc = (AccessControlContext)this.accessControlContextCache.get(principalSet);
        if (acc == null) {
            final ProtectionDomain[] pdArray = new ProtectionDomain[]{this.getCachedProtectionDomain(principalSet, false)};
            try {
                if (principalSet != null) {
                    final Subject s = sc.getSubject();
                    acc = (AccessControlContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return new AccessControlContext(new AccessControlContext(pdArray), new SubjectDomainCombiner(s));
                        }
                    });
                } else {
                    acc = new AccessControlContext(pdArray);
                }
                if (principalSet != null) {
                    this.accessControlContextCache.put(new HashSet(principalSet), acc);
                }
                _logger.fine("JACC: new AccessControlContext added to cache");
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "java_security.security_context_exception", e);
                acc = null;
                throw e;
            }
        }
        Object rvalue = null;
        String oldContextId = EJBSecurityManager.setPolicyContext(this.contextId);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JACC: doAsPrivileged contextId(" + this.contextId + ")");
        }
        try {
            rvalue = AccessController.doPrivileged(pea, acc);
        }
        finally {
            EJBSecurityManager.resetPolicyContext(oldContextId, this.contextId);
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runMethod(Method beanClassMethod, Object beanObject, Object[] parameters) throws Throwable {
        String oldContextId = EJBSecurityManager.setPolicyContext(this.contextId);
        try {
            Object object = beanClassMethod.invoke(beanObject, parameters);
            return object;
        }
        finally {
            EJBSecurityManager.resetPolicyContext(oldContextId, this.contextId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void initialize() throws Exception {
        Set<EjbIORConfigurationDescriptor> iorConfigs;
        Iterator<EjbIORConfigurationDescriptor> iter;
        if (ejbStatsProvider == null) {
            Class<EjbSecurityStatsProvider> clazz = EjbSecurityStatsProvider.class;
            // MONITORENTER : org.glassfish.ejb.security.application.EjbSecurityStatsProvider.class
            if (ejbStatsProvider == null) {
                ejbStatsProvider = new EjbSecurityStatsProvider();
                StatsProviderManager.register((String)"security", (PluginPoint)PluginPoint.SERVER, (String)"security/ejb", (Object)ejbStatsProvider);
            }
            // MONITOREXIT : clazz
        }
        this.contextId = EJBSecurityManager.getContextID(this.deploymentDescriptor);
        String appName = this.deploymentDescriptor.getApplication().getRegistrationName();
        this.roleMapperFactory.setAppNameForContext(appName, this.contextId);
        this.codesource = EJBSecurityManager.getApplicationCodeSource(this.contextId);
        this.ejbName = this.deploymentDescriptor.getName();
        this.realmName = this.deploymentDescriptor.getApplication().getRealm();
        if (this.realmName == null && (iter = (iorConfigs = this.deploymentDescriptor.getIORConfigurationDescriptors()).iterator()) != null) {
            while (iter.hasNext()) {
                this.realmName = iter.next().getRealmName();
            }
        }
        _logger.fine(() -> "JACC: EJB name = '" + this.ejbName + "'. Context id (id under which all EJB's in application will be created) = '" + this.contextId + "'");
        this.loadPolicyConfiguration(this.deploymentDescriptor);
        this.uncheckedMethodPermissionCache = PermissionCacheFactory.createPermissionCache((String)this.contextId, (CodeSource)this.codesource, EJBMethodPermission.class, (String)this.ejbName);
        this.auditManager = this.securityManagerFactory.getAuditManager();
    }

    private ProtectionDomain getCachedProtectionDomain(Set principalSet, boolean applicationCodeSource) {
        ProtectionDomain prdm = null;
        Principal[] principals = null;
        CodeSource cs = null;
        if (applicationCodeSource) {
            prdm = (ProtectionDomain)this.cacheProtectionDomain.get(principalSet);
            cs = this.codesource;
        } else {
            prdm = (ProtectionDomain)this.protectionDomainCache.get(principalSet);
            cs = managerCodeSource;
        }
        if (prdm == null) {
            HashSet newKeySet;
            principals = principalSet == null ? null : principalSet.toArray(new Principal[principalSet.size()]);
            prdm = new ProtectionDomain(cs, null, null, principals);
            HashSet hashSet = newKeySet = principalSet != null ? new HashSet(principalSet) : new HashSet();
            if (applicationCodeSource) {
                this.cacheProtectionDomain.put(newKeySet, prdm);
            } else {
                this.protectionDomainCache.put(newKeySet, prdm);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC: new ProtectionDomain added to cache");
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            if (principalSet == null) {
                _logger.fine("JACC: returning cached ProtectionDomain PrincipalSet: null");
            } else {
                StringBuilder pBuf = null;
                principals = principalSet.toArray(new Principal[principalSet.size()]);
                for (int i = 0; i < principals.length; ++i) {
                    if (i == 0) {
                        pBuf = new StringBuilder(principals[i].toString());
                        continue;
                    }
                    pBuf.append(" " + principals[i].toString());
                }
                _logger.fine("JACC: returning cached ProtectionDomain - CodeSource: (" + cs + ") PrincipalSet: " + pBuf);
            }
        }
        return prdm;
    }

    private void loginForRunAs() {
        AppservAccessController.privileged(() -> WebAndEjbToJaasBridge.loginPrincipal((String)this.runAs.getPrincipal(), (String)this.realmName));
    }

    private static CodeSource getApplicationCodeSource(String pcid) throws Exception {
        CodeSource result = null;
        String archiveURI = "file:///" + pcid.replace(' ', '_');
        try {
            URI uri = null;
            try {
                uri = new URI(archiveURI);
                if (uri != null) {
                    result = new CodeSource(uri.toURL(), (Certificate[])null);
                }
            }
            catch (URISyntaxException use) {
                _logger.log(Level.SEVERE, "JACC_createurierror", use);
                throw new RuntimeException(use);
            }
        }
        catch (MalformedURLException mue) {
            _logger.log(Level.SEVERE, "JACC_ejbsm.codesourceerror", mue);
            throw new RuntimeException(mue);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PolicyConfigurationFactory getPolicyFactory() throws PolicyContextException {
        Class<EJBSecurityManager> clazz = EJBSecurityManager.class;
        synchronized (EJBSecurityManager.class) {
            if (policyConfigurationFactory == null) {
                try {
                    policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                }
                catch (ClassNotFoundException cnfe) {
                    _logger.severe("jaccfactory.notfound");
                    throw new PolicyContextException((Throwable)cnfe);
                }
                catch (PolicyContextException pce) {
                    _logger.severe("jaccfactory.notfound");
                    throw pce;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return policyConfigurationFactory;
        }
    }

    private static void resetPolicyContext(final String newV, String oldV) throws Throwable {
        if (!(oldV == newV || newV == null || oldV != null && oldV.equals(newV))) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC: Changing Policy Context ID: oldV = " + oldV + " newV = " + newV);
            }
            try {
                AppservAccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        PolicyContext.setContextID((String)newV);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof AccessControlException) {
                    _logger.log(Level.SEVERE, "jacc_policy_context_security_exception", cause);
                } else {
                    _logger.log(Level.SEVERE, "jacc_policy_context_exception", cause);
                }
                throw cause;
            }
        }
    }

    private static String setPolicyContext(String newV) throws Throwable {
        String oldV = PolicyContext.getContextID();
        EJBSecurityManager.resetPolicyContext(newV, oldV);
        return oldV;
    }

    static {
        managerCodeSource = EJBSecurityManager.class.getProtectionDomain().getCodeSource();
    }
}

