/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.generator;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.ws.api.TJavaGeneratorExtension;
import com.sun.tools.ws.processor.generator.GeneratorBase;
import com.sun.tools.ws.processor.generator.GeneratorUtil;
import com.sun.tools.ws.processor.generator.JavaGeneratorExtensionFacade;
import com.sun.tools.ws.processor.generator.Names;
import com.sun.tools.ws.processor.generator.W3CAddressingJavaGeneratorExtension;
import com.sun.tools.ws.processor.model.AsyncOperation;
import com.sun.tools.ws.processor.model.Block;
import com.sun.tools.ws.processor.model.Fault;
import com.sun.tools.ws.processor.model.Message;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.Parameter;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Request;
import com.sun.tools.ws.processor.model.Response;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.model.java.JavaInterface;
import com.sun.tools.ws.processor.model.java.JavaMethod;
import com.sun.tools.ws.processor.model.java.JavaParameter;
import com.sun.tools.ws.processor.model.jaxb.JAXBType;
import com.sun.tools.ws.processor.model.jaxb.JAXBTypeAndAnnotation;
import com.sun.tools.ws.resources.GeneratorMessages;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.document.Operation;
import com.sun.tools.ws.wsdl.document.PortType;
import com.sun.tools.ws.wsdl.document.soap.SOAPStyle;
import jakarta.jws.Oneway;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import jakarta.jws.soap.SOAPBinding;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.RequestWrapper;
import jakarta.xml.ws.ResponseWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.xml.sax.Locator;

public class SeiGenerator
extends GeneratorBase {
    private TJavaGeneratorExtension extension;
    private List<TJavaGeneratorExtension> extensionHandlers;
    private boolean isDocStyle = true;
    private boolean sameParamStyle = true;

    public static void generate(Model model, WsimportOptions options, ErrorReceiver receiver, TJavaGeneratorExtension ... extensions) {
        SeiGenerator seiGenerator = new SeiGenerator();
        seiGenerator.init(model, options, receiver, extensions);
        seiGenerator.doGeneration();
    }

    public void init(Model model, WsimportOptions options, ErrorReceiver receiver, TJavaGeneratorExtension ... extensions) {
        this.init(model, options, receiver);
        this.extensionHandlers = new ArrayList<TJavaGeneratorExtension>();
        this.register(new W3CAddressingJavaGeneratorExtension());
        for (TJavaGeneratorExtension j : extensions) {
            this.register(j);
        }
        this.extension = new JavaGeneratorExtensionFacade(this.extensionHandlers.toArray(new TJavaGeneratorExtension[0]));
    }

    private void write(Port port) {
        JDefinedClass cls;
        JavaInterface intf = port.getJavaInterface();
        String className = Names.customJavaTypeClassName(intf);
        if (this.donotOverride && GeneratorUtil.classExists(this.options, className)) {
            this.log("Class " + className + " exists. Not overriding.");
            return;
        }
        try {
            cls = this.getClass(className, ClassType.INTERFACE);
        }
        catch (JClassAlreadyExistsException e) {
            PortType pt;
            QName portTypeName = (QName)port.getProperty("com.sun.xml.ws.processor.model.WSDLPortTypeName");
            Locator loc = null;
            if (portTypeName != null && (pt = port.portTypes.get(portTypeName)) != null) {
                loc = pt.getLocator();
            }
            this.receiver.error(loc, GeneratorMessages.GENERATOR_SEI_CLASS_ALREADY_EXIST(intf.getName(), portTypeName));
            return;
        }
        if (!cls.methods().isEmpty()) {
            return;
        }
        JDocComment comment = cls.javadoc();
        String ptDoc = intf.getJavaDoc();
        if (ptDoc != null) {
            comment.add((Object)ptDoc);
            comment.add((Object)"\n\n");
        }
        comment.addAll(this.getJAXWSClassComment());
        JAnnotationUse webServiceAnn = cls.annotate(this.cm.ref(WebService.class));
        this.writeWebServiceAnnotation(port, webServiceAnn);
        this.writeHandlerConfig(Names.customJavaTypeClassName(port.getJavaInterface()), cls, this.options);
        this.writeSOAPBinding(port, cls);
        this.writeXmlSeeAlso(cls);
        for (com.sun.tools.ws.processor.model.Operation operation : port.getOperations()) {
            JDocComment methodDoc;
            JMethod m;
            JavaMethod method = operation.getJavaMethod();
            String methodJavaDoc = operation.getJavaDoc();
            if (method.getReturnType().getName().equals("void")) {
                m = cls.method(1, Void.TYPE, method.getName());
                methodDoc = m.javadoc();
            } else {
                JAXBTypeAndAnnotation retType = method.getReturnType().getType();
                m = cls.method(1, retType.getType(), method.getName());
                retType.annotate((JAnnotatable)m);
                methodDoc = m.javadoc();
                JCommentPart ret = methodDoc.addReturn();
                ret.add((Object)("returns " + retType.getName()));
            }
            if (methodJavaDoc != null) {
                methodDoc.add((Object)methodJavaDoc);
            }
            this.writeWebMethod(operation, m);
            JClass holder = this.cm.ref(Holder.class);
            for (JavaParameter parameter : method.getParametersList()) {
                JAXBTypeAndAnnotation paramType = parameter.getType().getType();
                JVar var = parameter.isHolder() ? m.param((JType)holder.narrow(paramType.getType().boxify()), parameter.getName()) : m.param(paramType.getType(), parameter.getName());
                paramType.annotate((JAnnotatable)var);
                methodDoc.addParam(var);
                JAnnotationUse paramAnn = var.annotate(this.cm.ref(WebParam.class));
                this.writeWebParam(operation, parameter, paramAnn);
            }
            Operation wsdlOp = operation.getWSDLPortTypeOperation();
            for (Fault fault : operation.getFaultsSet()) {
                m._throws(fault.getExceptionClass());
                methodDoc.addThrows(fault.getExceptionClass());
                wsdlOp.putFault(fault.getWsdlFaultName(), fault.getExceptionClass());
            }
            this.extension.writeMethodAnnotations(wsdlOp, m);
        }
    }

    private void writeXmlSeeAlso(JDefinedClass cls) {
        if (this.model.getJAXBModel().getS2JJAXBModel() != null) {
            List objectFactories = this.model.getJAXBModel().getS2JJAXBModel().getAllObjectFactories();
            if (objectFactories.isEmpty()) {
                return;
            }
            JAnnotationUse xmlSeeAlso = cls.annotate(this.cm.ref(XmlSeeAlso.class));
            JAnnotationArrayMember paramArray = xmlSeeAlso.paramArray("value");
            for (JClass of : objectFactories) {
                paramArray = paramArray.param((JType)of);
            }
        }
    }

    private void writeWebMethod(com.sun.tools.ws.processor.model.Operation operation, JMethod m) {
        String operationName;
        Response response = operation.getResponse();
        JAnnotationUse webMethodAnn = m.annotate(this.cm.ref(WebMethod.class));
        String string = operationName = operation instanceof AsyncOperation ? ((AsyncOperation)operation).getNormalOperation().getName().getLocalPart() : operation.getName().getLocalPart();
        if (!m.name().equals(operationName)) {
            webMethodAnn.param("operationName", operationName);
        }
        if (operation.getSOAPAction() != null && operation.getSOAPAction().length() > 0) {
            webMethodAnn.param("action", operation.getSOAPAction());
        }
        if (operation.getResponse() == null) {
            m.annotate(Oneway.class);
        } else if (!operation.getJavaMethod().getReturnType().getName().equals("void") && operation.getResponse().getParametersList().size() > 0) {
            String resultName = null;
            String nsURI = null;
            if (operation.getResponse().getBodyBlocks().hasNext()) {
                Block block = operation.getResponse().getBodyBlocks().next();
                resultName = block.getName().getLocalPart();
                if (this.isDocStyle || block.getLocation() == 2) {
                    nsURI = block.getName().getNamespaceURI();
                }
            }
            for (Parameter parameter : operation.getResponse().getParametersList()) {
                if (parameter.getParameterIndex() != -1) continue;
                if (operation.isWrapped() || !this.isDocStyle) {
                    resultName = parameter.getBlock().getLocation() == 2 ? parameter.getBlock().getName().getLocalPart() : parameter.getName();
                    if (this.isDocStyle || parameter.getBlock().getLocation() == 2) {
                        nsURI = parameter.getType().getName().getNamespaceURI();
                    }
                } else if (this.isDocStyle) {
                    JAXBType t = (JAXBType)parameter.getType();
                    resultName = t.getName().getLocalPart();
                    nsURI = t.getName().getNamespaceURI();
                }
                if (operation instanceof AsyncOperation) continue;
                JAnnotationUse wr = null;
                if (!resultName.equals("return")) {
                    wr = m.annotate(WebResult.class);
                    wr.param("name", resultName);
                }
                if (nsURI != null || this.isDocStyle && operation.isWrapped()) {
                    if (wr == null) {
                        wr = m.annotate(WebResult.class);
                    }
                    wr.param("targetNamespace", nsURI);
                }
                if (!this.isDocStyle || !operation.isWrapped() || parameter.getBlock().getLocation() == 2) {
                    if (wr == null) {
                        wr = m.annotate(WebResult.class);
                    }
                    wr.param("partName", parameter.getName());
                }
                if (parameter.getBlock().getLocation() != 2) continue;
                if (wr == null) {
                    wr = m.annotate(WebResult.class);
                }
                wr.param("header", true);
            }
        }
        if (!this.sameParamStyle && !operation.isWrapped()) {
            JAnnotationUse sb = m.annotate(SOAPBinding.class);
            sb.param("parameterStyle", (Enum)SOAPBinding.ParameterStyle.BARE);
        }
        if (operation.isWrapped() && operation.getStyle().equals(SOAPStyle.DOCUMENT)) {
            Block reqBlock = operation.getRequest().getBodyBlocks().next();
            JAnnotationUse reqW = m.annotate(RequestWrapper.class);
            reqW.param("localName", reqBlock.getName().getLocalPart());
            reqW.param("targetNamespace", reqBlock.getName().getNamespaceURI());
            reqW.param("className", reqBlock.getType().getJavaType().getName());
            if (response != null) {
                JAnnotationUse resW = m.annotate(ResponseWrapper.class);
                Block resBlock = response.getBodyBlocks().next();
                resW.param("localName", resBlock.getName().getLocalPart());
                resW.param("targetNamespace", resBlock.getName().getNamespaceURI());
                resW.param("className", resBlock.getType().getJavaType().getName());
            }
        }
    }

    private boolean isMessageParam(Parameter param, Message message) {
        Block block = param.getBlock();
        return message.getBodyBlockCount() > 0 && block.equals(message.getBodyBlocks().next()) || message.getHeaderBlockCount() > 0 && block.equals(message.getHeaderBlocks().next());
    }

    private boolean isHeaderParam(Parameter param, Message message) {
        if (message.getHeaderBlockCount() == 0) {
            return false;
        }
        for (Block headerBlock : message.getHeaderBlocksMap().values()) {
            if (!param.getBlock().equals(headerBlock)) continue;
            return true;
        }
        return false;
    }

    private boolean isAttachmentParam(Parameter param, Message message) {
        if (message.getAttachmentBlockCount() == 0) {
            return false;
        }
        for (Block attBlock : message.getAttachmentBlocksMap().values()) {
            if (!param.getBlock().equals(attBlock)) continue;
            return true;
        }
        return false;
    }

    private boolean isUnboundParam(Parameter param, Message message) {
        if (message.getUnboundBlocksCount() == 0) {
            return false;
        }
        for (Block unboundBlock : message.getUnboundBlocksMap().values()) {
            if (!param.getBlock().equals(unboundBlock)) continue;
            return true;
        }
        return false;
    }

    private void writeWebParam(com.sun.tools.ws.processor.model.Operation operation, JavaParameter javaParameter, JAnnotationUse paramAnno) {
        Parameter param = javaParameter.getParameter();
        Request req = operation.getRequest();
        Response res = operation.getResponse();
        boolean header = this.isHeaderParam(param, req) || res != null && this.isHeaderParam(param, res);
        boolean isWrapped = operation.isWrapped();
        String name = param.getBlock().getLocation() == 2 || this.isDocStyle && !isWrapped ? param.getBlock().getName().getLocalPart() : param.getName();
        paramAnno.param("name", name);
        String ns = null;
        if (this.isDocStyle) {
            ns = param.getBlock().getName().getNamespaceURI();
            if (isWrapped) {
                ns = param.getType().getName().getNamespaceURI();
            }
        } else if (header) {
            ns = param.getBlock().getName().getNamespaceURI();
        }
        if (ns != null || this.isDocStyle && isWrapped) {
            paramAnno.param("targetNamespace", ns);
        }
        if (header) {
            paramAnno.param("header", true);
        }
        if (param.isINOUT()) {
            paramAnno.param("mode", (Enum)WebParam.Mode.INOUT);
        } else if (res != null && (this.isMessageParam(param, res) || this.isHeaderParam(param, res) || this.isAttachmentParam(param, res) || this.isUnboundParam(param, res) || param.isOUT())) {
            paramAnno.param("mode", (Enum)WebParam.Mode.OUT);
        }
        if (!this.isDocStyle || !isWrapped || header) {
            paramAnno.param("partName", javaParameter.getParameter().getName());
        }
    }

    private void writeSOAPBinding(Port port, JDefinedClass cls) {
        JAnnotationUse soapBindingAnn = null;
        boolean bl = this.isDocStyle = port.getStyle() == null || port.getStyle().equals(SOAPStyle.DOCUMENT);
        if (!this.isDocStyle) {
            soapBindingAnn = cls.annotate(SOAPBinding.class);
            soapBindingAnn.param("style", (Enum)SOAPBinding.Style.RPC);
            port.setWrapped(true);
        }
        if (this.isDocStyle) {
            boolean first = true;
            boolean isWrapper = true;
            for (com.sun.tools.ws.processor.model.Operation operation : port.getOperations()) {
                if (first) {
                    isWrapper = operation.isWrapped();
                    first = false;
                    continue;
                }
                boolean bl2 = this.sameParamStyle = isWrapper == operation.isWrapped();
                if (this.sameParamStyle) continue;
                break;
            }
            if (this.sameParamStyle) {
                port.setWrapped(isWrapper);
            }
        }
        if (this.sameParamStyle && !port.isWrapped()) {
            if (soapBindingAnn == null) {
                soapBindingAnn = cls.annotate(SOAPBinding.class);
            }
            soapBindingAnn.param("parameterStyle", (Enum)SOAPBinding.ParameterStyle.BARE);
        }
    }

    private void writeWebServiceAnnotation(Port port, JAnnotationUse wsa) {
        QName name = (QName)port.getProperty("com.sun.xml.ws.processor.model.WSDLPortTypeName");
        wsa.param("name", name.getLocalPart());
        wsa.param("targetNamespace", name.getNamespaceURI());
    }

    @Override
    public void visit(Model model) throws Exception {
        for (Service s : model.getServices()) {
            s.accept(this);
        }
    }

    @Override
    public void visit(Service service) throws Exception {
        String jd = this.model.getJavaDoc();
        if (jd != null) {
            JPackage pkg = this.cm._package(this.options.defaultPackage);
            pkg.javadoc().add((Object)jd);
        }
        for (Port p : service.getPorts()) {
            this.visitPort(service, p);
        }
    }

    private void visitPort(Service service, Port port) {
        if (port.isProvider()) {
            return;
        }
        this.write(port);
    }

    private void register(TJavaGeneratorExtension h) {
        this.extensionHandlers.add(h);
    }
}

