/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMonitor;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.ExpirationInfo;
import com.sun.messaging.jmq.jmsserver.core.LowPriorityComparator;
import com.sun.messaging.jmq.jmsserver.core.MessageDeliveryTimeInfo;
import com.sun.messaging.jmq.jmsserver.core.MessageDeliveryTimeTimer;
import com.sun.messaging.jmq.jmsserver.core.OldestComparator;
import com.sun.messaging.jmq.jmsserver.core.PacketListDMPair;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.Queue;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.RefCompare;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.memory.MemoryManager;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.DiskFileStore;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.plugin.spi.DestinationSpi;
import com.sun.messaging.jmq.jmsserver.plugin.spi.ProducerSpi;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConsumerAlreadyAddedException;
import com.sun.messaging.jmq.jmsserver.util.DestinationNotFoundException;
import com.sun.messaging.jmq.jmsserver.util.lists.AddReason;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.DestMetricsCounters;
import com.sun.messaging.jmq.util.DestState;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.SimpleNFLHashMap;
import com.sun.messaging.jmq.util.lists.Sized;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.Vector;

public abstract class Destination
implements DestinationSpi,
Serializable,
EventListener {
    static final long serialVersionUID = 4399175316523022128L;
    protected static boolean DEBUG = false;
    protected static final boolean DEBUG_CLUSTER = DestinationList.DEBUG_CLUSTER;
    private static final FaultInjection FI = FaultInjection.getInjection();
    protected String INITIALIZEBY = "";
    protected transient boolean destvalid = true;
    protected transient boolean startedDestroy = false;
    protected transient Logger logger = Globals.getLogger();
    protected transient BrokerResources br = Globals.getBrokerResources();
    protected transient BrokerMonitor bm = null;
    protected transient boolean stored = false;
    protected transient boolean neverStore = false;
    protected transient SimpleNFLHashMap<SysMessageID, PacketReference> destMessages = null;
    private transient HashMap destMessagesInRemoving = null;
    private transient Object _removeMessageLock = null;
    private boolean dest_inited = false;
    private transient int refCount = 0;
    protected int expiredCnt = 0;
    protected int purgedCnt = 0;
    protected int ackedCnt = 0;
    protected int discardedCnt = 0;
    protected int overflowCnt = 0;
    protected int errorCnt = 0;
    protected int rollbackCnt = 0;
    transient Object sizeLock = new Object();
    transient int size = 0;
    transient int remoteSize = 0;
    transient long bytes = 0L;
    transient long remoteBytes = 0L;
    transient boolean loaded = false;
    protected transient SimpleNFLHashMap consumers = new SimpleNFLHashMap();
    protected transient SimpleNFLHashMap producers = new SimpleNFLHashMap();
    transient DestReaperTask destReaper = null;
    protected DestinationUID uid = null;
    protected int type = -1;
    protected transient int state = -1;
    protected int scope = 1;
    protected int limit = 2;
    protected ConnectionUID id = null;
    protected SizeString msgSizeLimit = null;
    protected int countLimit = 0;
    protected SizeString memoryLimit = null;
    protected int maxConsumerLimit = -1;
    protected int maxProducerLimit = 100;
    protected int maxPrefetch = 1000;
    protected transient int producerMsgBatchSize = DestinationList.MAX_PRODUCER_BATCH;
    protected transient long producerMsgBatchBytes = -1L;
    private long clientReconnectInterval = 0L;
    private transient ReconnectReaperTask reconnectReaper = null;
    private transient ProducerFlow producerFlow = new ProducerFlow();
    boolean useDMQ = true;
    boolean isDMQ = false;
    boolean validateXMLSchemaEnabled = false;
    String XMLSchemaUriList = null;
    boolean reloadXMLSchemaOnFailure = false;
    private transient boolean clusterNotifyFlag = false;
    private transient Map<Integer, ChangeRecordInfo> currentChangeRecordInfo = Collections.synchronizedMap(new HashMap());
    private transient DestinationList DL = null;
    protected transient PartitionedStore pstore = null;
    private transient String logsuffix = "";
    private transient Object queueRemoteLock = new Object();
    private transient Object queueRemoteLockThread = null;
    public static final int UNLIMITED = -1;
    public static final String TEMP_CNT = "JMQ_SUN_JMSQ_TempRedeliverCnt";
    public static final int DEFAULT_RECONNECT_MULTIPLIER = 5;
    public static final int RECONNECT_MULTIPLIER = Destination.getRECONNECT_MULTIPLIER();
    private static final int LOAD_COUNT = Globals.getConfig().getIntProperty("imq.destination.verbose.cnt", 10000);
    private static final boolean EXPIRE_DELIVERED_MSG = Globals.getConfig().getBooleanProperty("imq.destination.expireDeliveredMessages", false);
    private static final boolean PURGE_DELIVERED_MSG = Globals.getConfig().getBooleanProperty("imq.destination.purgeDeliveredMessages", false);
    public static final boolean PERSIST_SYNC = DestinationList.PERSIST_SYNC;
    protected static final int NONE = 0;
    private static MQTimer timer = Globals.getTimer();
    public int seqCnt = 0;
    transient Object behaviorListener = null;
    transient MsgExpirationReaper expireReaper = new MsgExpirationReaper();
    protected transient Filter filter = new DestFilter();
    protected transient DestMetricsCounters dmc = new DestMetricsCounters();
    protected transient MessageDeliveryTimeTimer deliveryTimeTimer = null;
    transient long lastMetricsTime;
    transient long msgsIn = 0L;
    transient long msgsOut = 0L;
    transient long lastMsgsIn = 0L;
    transient long lastMsgsOut = 0L;
    transient long msgBytesIn = 0L;
    transient long msgBytesOut = 0L;
    transient long lastMsgBytesIn = 0L;
    transient long lastMsgBytesOut = 0L;
    transient long msgsInInternal = 0L;
    transient long msgsOutInternal = 0L;
    transient long msgsInOutLastResetTime = 0L;
    private static final String SCOPE_PROPERTY = "scope";
    private static final String MAX_CONSUMERS = "max_consumers";
    private static final String MAX_PRODUCERS = "max_producers";
    private static final String MAX_PREFETCH = "max_prefetch";
    private static final String MAX_MESSAGES = "max_messages";
    private static final String MAX_BYTES = "max_bytes";
    private static final String MAX_MSG_BYTES = "max_msg_bytes";
    private static final String BEHAVIOUR = "behaviour";
    private static final String STATE = "state";
    private static final String NAME = "name";
    private static final String IS_QUEUE = "queue";
    private static final String IS_INTERNAL = "internal";
    private static final String IS_AUTOCREATED = "autocreated";
    private static final String IS_TEMPORARY = "temporary";
    private static final String IS_ADMIN = "admin";
    private static final String IS_LOCAL = "local";
    private static final String REAL_TYPE = "type";
    private static final String USE_DMQ = "useDMQ";
    private static final String VALIDATE_XML_SCHEMA_ENABLED = "validateXMLSchemaEnabled";
    private static final String XML_SCHEMA_URI_LIST = "XMLSchemaUriList";
    private static final String RELOAD_XML_SCHEMA_ON_FAILURE = "reloadXMLSchemaOnFailure";
    transient Filter unloadfilter = new UnloadFilter();
    boolean overrideP = false;
    boolean overridePvalue = false;
    boolean overrideTTL = false;
    long overrideTTLvalue = 0L;
    static final int DEST_PAUSE = 0;
    static final int DEST_RESUME = 1;
    static final int DEST_UPDATE = 2;
    static final int DEST_BEHAVIOR_CHANGE = 3;

    private static boolean getDEBUG() {
        return DEBUG || DestinationList.DEBUG;
    }

    private static int getRECONNECT_MULTIPLIER() {
        int v = Globals.getConfig().getIntProperty("imq.reconnect.interval", 5);
        if (v < 1) {
            v = 5;
        }
        return v;
    }

    public ChangeRecordInfo getCurrentChangeRecordInfo(int type) {
        return this.currentChangeRecordInfo.get(type);
    }

    public void setCurrentChangeRecordInfo(int type, ChangeRecordInfo cri) {
        this.currentChangeRecordInfo.put(type, cri);
    }

    public PacketReference peekNext() {
        return null;
    }

    public void setDestinationList(DestinationList dl) {
        this.DL = dl;
        this.pstore = dl.getPartitionedStore();
        Destination destination = this;
        if (destination.DL.isPartitionMode()) {
            this.logsuffix = " [" + this.pstore + "]";
        }
    }

    public PartitionedStore getPartitionedStore() {
        return this.pstore;
    }

    public void setUseDMQ(boolean use) throws BrokerException {
        if (use && this.isDMQ) {
            throw new BrokerException(this.br.getKString("B4189"));
        }
        Boolean oldVal = this.useDMQ;
        this.useDMQ = use;
        this.notifyAttrUpdated(16384, oldVal, this.useDMQ);
    }

    public boolean getUseDMQ() {
        return this.useDMQ;
    }

    protected Destination(DestinationUID uid) {
        this.uid = uid;
    }

    public boolean removeDeadMessage(PacketReference ref) throws IOException, BrokerException {
        return this.removeDeadMessage(ref, ref.getDeadComment(), ref.getDeadException(), ref.getDeadDeliverCnt(), ref.getDeadReason(), ref.getDeadBroker());
    }

    public boolean removeDeadMessage(PacketReference ref, String comment, Throwable exception, int deliverCnt, Reason r, String broker) throws IOException, BrokerException {
        if (Destination.getDEBUG()) {
            this.logger.log(4, "Calling removeDeadMessage on " + ref + " [" + comment + "," + exception + "," + deliverCnt + "," + r + "]");
        }
        if (ref.isInvalid()) {
            this.logger.log(4, "Internal Error: message is already dead");
            return false;
        }
        Destination d = ref.getDestination();
        if (d == this.DL.getDMQ()) {
            throw new RuntimeException("Already dead");
        }
        Hashtable<String, Object> m = new Hashtable<String, Object>();
        if (comment != null) {
            m.put("JMS_SUN_DMQ_UNDELIVERED_COMMENT", comment);
        }
        if (deliverCnt != -1) {
            m.put(TEMP_CNT, deliverCnt);
        }
        if (exception != null) {
            m.put("JMS_SUN_DMQ_UNDELIVERED_EXCEPTION", exception);
        }
        if (broker != null) {
            m.put("JMS_SUN_DMQ_DEAD_BROKER", broker);
        } else {
            m.put("JMS_SUN_DMQ_DEAD_BROKER", Globals.getMyAddress().toString());
        }
        if (r == null) {
            r = RemoveReason.ERROR;
        }
        RemoveMessageReturnInfo ret = this._removeMessage(ref.getSysMessageID(), r, m, null, !ref.isExpired());
        return ret.removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDead(PacketReference pr, Reason reason, Hashtable props) throws BrokerException {
        PacketReference ref;
        long expiredTime;
        long senderTime;
        long receivedTime;
        boolean useDMQforMsg;
        boolean useVerbose;
        block54: {
            Integer cnt;
            Packet p = pr.getPacket();
            if (p == null) {
                this.logger.log(4, "Internal Error: null packet for DMQ");
                return;
            }
            Hashtable packetProps = null;
            try {
                packetProps = p.getProperties();
                if (packetProps == null) {
                    packetProps = new Hashtable();
                }
            }
            catch (Exception ex) {
                this.logger.logStack(4, "could not get props ", (Throwable)ex);
                packetProps = new Hashtable();
            }
            useVerbose = false;
            Object o = packetProps.get("JMS_SUN_LOG_DEAD_MESSAGES");
            if (o != null) {
                if (o instanceof Boolean) {
                    useVerbose = (Boolean)o;
                } else if (o instanceof String) {
                    useVerbose = Boolean.parseBoolean((String)o);
                } else {
                    this.logger.log(16, "B3100", (Object)("Unknown type for verbose " + o.getClass()));
                    Destination destination = this;
                    useVerbose = destination.DL.getVerbose();
                }
            } else {
                Destination destination = this;
                useVerbose = destination.DL.getVerbose();
            }
            if (this.isDMQ) {
                if (Destination.getDEBUG() || useVerbose) {
                    this.logger.log(8, "B1145", (Object)pr.getSysMessageID(), (Object)DestinationUID.getUID(p.getDestination(), p.getIsQueue()).toString());
                }
                return;
            }
            useDMQforMsg = false;
            o = packetProps.get("JMS_SUN_PRESERVE_UNDELIVERED");
            if (o != null) {
                if (o instanceof Boolean) {
                    useDMQforMsg = (Boolean)o;
                } else if (o instanceof String) {
                    useDMQforMsg = Boolean.parseBoolean((String)o);
                } else {
                    this.logger.log(16, "B3100", (Object)("Unknown type for preserve undelivered " + o.getClass()));
                    useDMQforMsg = this.useDMQ;
                }
            } else {
                useDMQforMsg = this.useDMQ;
            }
            receivedTime = pr.getTime();
            senderTime = pr.getTimestamp();
            expiredTime = pr.getExpireTime();
            if (!useDMQforMsg) {
                if (Destination.getDEBUG() || useVerbose) {
                    Object[] args = new String[]{pr.getSysMessageID().toString(), pr.getDestinationUID().toString(), this.lookupReasonString(reason, receivedTime, expiredTime, senderTime)};
                    this.logger.log(8, "B1146", args);
                }
                if (!pr.isLocal()) {
                    boolean waitack = !pr.isNoAckRemoteConsumers();
                    Globals.getClusterBroadcast().acknowledgeMessage(pr.getBrokerAddress(), pr.getSysMessageID(), pr.getQueueUID(), 7, props, waitack);
                }
                return;
            }
            boolean truncateBody = false;
            o = packetProps.get("JMS_SUN_TRUNCATE_MSG_BODY");
            if (o != null) {
                if (o instanceof Boolean) {
                    truncateBody = (Boolean)o;
                } else if (o instanceof String) {
                    truncateBody = Boolean.parseBoolean((String)o);
                } else {
                    this.logger.log(16, "B3100", (Object)("Unknown type for preserve undelivered " + o.getClass()));
                    Destination destination = this;
                    truncateBody = !destination.DL.getStoreBodyInDMQ();
                }
            } else {
                Destination destination = this;
                boolean bl = truncateBody = !destination.DL.getStoreBodyInDMQ();
            }
            if (props == null) {
                props = new Hashtable<String, Object>();
            }
            if ((cnt = (Integer)props.remove(TEMP_CNT)) != null) {
                props.put("JMS_SUN_DMQ_DELIVERY_COUNT", cnt);
            }
            if (pr.isLocal()) {
                props.putAll(packetProps);
            } else {
                props.put("REASON", reason.intValue());
            }
            if (props.get("JMS_SUN_DMQ_UNDELIVERED_COMMENT") == null) {
                props.put("JMS_SUN_DMQ_UNDELIVERED_COMMENT", this.lookupReasonString(reason, receivedTime, expiredTime, senderTime));
            }
            props.put("JMS_SUN_DMQ_UNDELIVERED_TIMESTAMP", System.currentTimeMillis());
            props.put("JMS_SUN_DMQ_BODY_TRUNCATED", truncateBody);
            if (reason == RemoveReason.EXPIRED || reason == RemoveReason.EXPIRED_BY_CLIENT || reason == RemoveReason.EXPIRED_ON_DELIVERY) {
                props.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "EXPIRED");
            } else if (reason == RemoveReason.REMOVED_LOW_PRIORITY) {
                props.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "LOW_PRIORITY");
            } else if (reason == RemoveReason.REMOVED_OLDEST) {
                props.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "OLDEST");
            } else if (reason == RemoveReason.UNDELIVERABLE) {
                props.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "UNDELIVERABLE");
            } else {
                props.put("JMS_SUN_DMQ_UNDELIVERED_REASON", "ERROR");
            }
            if (pr.getBrokerAddress() != null) {
                props.put("JMS_SUN_DMQ_PRODUCING_BROKER", pr.getBrokerAddress().toString());
            } else {
                props.put("JMS_SUN_DMQ_PRODUCING_BROKER", Globals.getMyAddress().toString());
            }
            String deadbkr = (String)packetProps.get("JMS_SUN_DMQ_DEAD_BROKER");
            if (deadbkr != null) {
                props.put("JMS_SUN_DMQ_DEAD_BROKER", deadbkr);
            } else {
                props.put("JMS_SUN_DMQ_DEAD_BROKER", Globals.getMyAddress().toString());
            }
            if (!pr.isLocal()) {
                boolean waitack = !pr.isNoAckRemoteConsumers();
                Globals.getClusterBroadcast().acknowledgeMessage(pr.getBrokerAddress(), pr.getSysMessageID(), pr.getQueueUID(), 7, props, waitack);
                return;
            }
            Packet newp = new Packet();
            ref = null;
            try {
                newp.generateSequenceNumber(false);
                newp.generateTimestamp(false);
                newp.fill(p);
                newp.setProperties(props);
                if (truncateBody) {
                    newp.setMessageBody(new byte[0]);
                }
                Queue dmq = this.DL.getDMQ();
                ref = PacketReference.createReference(this.pstore, newp, dmq.getDestinationUID(), null);
                ref.overrideExpireTime(0L);
                ref.clearExpireInfo();
                ref.clearDeliveryTimeInfo();
                ref.setTimestamp(System.currentTimeMillis());
                Queue queue = dmq;
                synchronized (queue) {
                    ref.setSequence(dmq.seqCnt++);
                }
                DestinationList.routeMoveAndForwardMessage(pr, ref, dmq);
            }
            catch (Exception ex) {
                if (reason == RemoveReason.UNDELIVERABLE || reason == RemoveReason.ERROR) {
                    if (ex instanceof BrokerException) {
                        throw (BrokerException)ex;
                    }
                    throw new BrokerException(this.br.getKString("B4190"), ex);
                }
                if (!Destination.getDEBUG() && !useVerbose) break block54;
                this.logger.logStack(16, "B2090", (Object)pr.getSysMessageID().toString(), (Throwable)ex);
            }
        }
        if ((Destination.getDEBUG() || useVerbose) && useDMQforMsg) {
            Object[] args = new String[]{pr.getSysMessageID().toString(), pr.getDestinationUID().toString(), this.lookupReasonString(reason, receivedTime, expiredTime, senderTime)};
            this.logger.log(8, "B1147", args);
        }
        ref.unload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PacketReference _replaceMessage(SysMessageID old, Hashtable addProps, byte[] data) throws BrokerException, IOException {
        PacketReference ref = this.DL.get(old, true);
        if (ref == null) {
            throw new BrokerException(this.br.getKString("B1461", old, this.getDestinationUID()), 404);
        }
        if (!ref.checkDeliveryAndSetInReplacing()) {
            if (ref.isInvalid() || ref.isDestroyed() || ref.isExpired() || ref.isAcknowledged() || ref.inRemoval) {
                throw new BrokerException(this.br.getKString("B1462", old, this.getDestinationUID()), 409);
            }
            if (ref.inReplacing) {
                throw new BrokerException(this.br.getKString("B1463", old, this.getDestinationUID()), 409);
            }
            throw new BrokerException(this.br.getKString("B1464", old, this.getDestinationUID()), 409);
        }
        try {
            long oldbsize = ref.byteSize();
            ArrayList<Consumer> subs = new ArrayList<Consumer>();
            Consumer c = null;
            Iterator itr = this.getConsumers();
            while (itr.hasNext()) {
                c = (Consumer)itr.next();
                if (!(c instanceof Subscription) || !c.unrouteMessage(ref)) continue;
                subs.add(c);
            }
            SysMessageID newid = ref.replacePacket(addProps, data);
            this.destMessages.remove((Object)old);
            this.DL.removePacketList(old, ref.getDestinationUID(), ref);
            PacketListDMPair dmp = this.DL.packetlistAdd(newid, ref.getDestinationUID(), ref);
            this.destMessages.put((Object)newid, (Object)ref);
            dmp.nullRef();
            DestinationList.adjustTotalBytes(ref.byteSize() - oldbsize);
            Object var12_11 = null;
            for (Subscription subscription : subs) {
                subscription.routeMessage(ref, false);
            }
        }
        finally {
            ref.clearInReplacing();
        }
        return ref;
    }

    public SysMessageID replaceMessage(SysMessageID old, Hashtable addProps, byte[] data) throws BrokerException, IOException {
        return this._replaceMessage(old, addProps, data).getSysMessageID();
    }

    public String replaceMessageString(SysMessageID old, Hashtable addProps, byte[] data) throws BrokerException, IOException {
        return this._replaceMessage(old, addProps, data).getSysMessageIDString();
    }

    public abstract Set routeAndMoveMessage(PacketReference var1, PacketReference var2) throws IOException, BrokerException;

    public void setReconnectInterval(long val) {
        this.clientReconnectInterval = val * (long)RECONNECT_MULTIPLIER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientReconnect() {
        Destination destination = this;
        synchronized (destination) {
            if (this.reconnectReaper != null) {
                this.reconnectReaper.cancel();
                this.reconnectReaper = null;
            }
        }
    }

    private void updateProducerBatch(boolean notifyProducers) {
        int oldsize = this.producerMsgBatchSize;
        long oldbytes = this.producerMsgBatchBytes;
        boolean bl = notifyProducers = notifyProducers && this.limit == 0;
        if (this.limit == 0) {
            this.producerMsgBatchSize = DestinationList.calcProducerBatchCnt(this.destMessages.capacity(), this.maxProducerLimit);
            this.producerMsgBatchBytes = DestinationList.calcProducerBatchBytes(this.destMessages.byteCapacity(), this.maxProducerLimit);
        } else {
            this.producerMsgBatchSize = DestinationList.MAX_PRODUCER_BATCH;
            this.producerMsgBatchBytes = -1L;
        }
        if (notifyProducers && (oldsize != this.producerMsgBatchSize || oldbytes != this.producerMsgBatchBytes)) {
            this.producerFlow.updateAllProducers(2, "update batch");
        }
    }

    protected boolean sendClusterUpdate() {
        return !this.isInternal() && !this.isAdmin();
    }

    protected void handleLimitBehavior(int limit) {
        if (limit == 0) {
            this.destMessages.enforceLimits(false);
            FlowListener rl = new FlowListener();
            if (this.behaviorListener != null) {
                this.destMessages.removeEventListener(this.behaviorListener);
                this.behaviorListener = null;
            }
            this.behaviorListener = this.destMessages.addEventListener((EventListener)rl, EventType.FULL, null);
            this.producerFlow.updateAllProducers(3, "behavior change");
        } else if (limit == 1) {
            Set s = this.destMessages.subSet((Comparator)new OldestComparator());
            RemoveBehaviorListener rl = new RemoveBehaviorListener(s, RemoveReason.REMOVED_OLDEST);
            if (this.behaviorListener != null) {
                this.destMessages.removeEventListener(this.behaviorListener);
                this.behaviorListener = null;
            }
            this.behaviorListener = this.destMessages.addEventListener((EventListener)rl, EventType.SET_CHANGED_REQUEST, null);
            this.destMessages.enforceLimits(false);
        } else if (limit == 2) {
            this.destMessages.enforceLimits(true);
            if (this.behaviorListener != null) {
                this.destMessages.removeEventListener(this.behaviorListener);
                this.behaviorListener = null;
            }
        } else if (limit == 3) {
            this.destMessages.enforceLimits(false);
            Set s = this.destMessages.subSet((Comparator)new LowPriorityComparator());
            RemoveBehaviorListener rl = new RemoveBehaviorListener(s, RemoveReason.REMOVED_LOW_PRIORITY);
            if (this.behaviorListener != null) {
                this.destMessages.removeEventListener(this.behaviorListener);
                this.behaviorListener = null;
            }
            this.behaviorListener = this.destMessages.addEventListener((EventListener)rl, EventType.SET_CHANGED_REQUEST, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initialize() {
        block6: {
            try {
                if (!this.stored) break block6;
                Object object = this.sizeLock;
                synchronized (object) {
                    int oldsize = this.size;
                    long oldbytes = this.bytes;
                    HashMap data = this.pstore.getMessageStorageInfo(this);
                    this.size = (Integer)data.get("numMsgs");
                    this.bytes = (Long)data.get("totalMsgBytes");
                    this.size += this.remoteSize;
                    this.bytes += this.remoteBytes;
                    int sizediff = this.size - oldsize;
                    long bytediff = this.bytes - oldbytes;
                    if (!(this.isAdmin() || !this.getIsDMQ() && this.isInternal())) {
                        DestinationList.adjustTotals(sizediff, bytediff);
                    }
                }
            }
            catch (Exception ex) {
                this.logger.logStack(16, this.br.getKString("B3282", this), (Throwable)ex);
            }
        }
        this.dest_inited = true;
    }

    protected boolean isDestInited() {
        return this.dest_inited;
    }

    public void initializeOldDestination() {
        this.overridePersistence(true);
        this.stored = true;
        this.dest_inited = false;
        this.loaded = false;
    }

    public boolean getIsDMQ() {
        return this.isDMQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.logger = Globals.getLogger();
        this.br = Globals.getBrokerResources();
        this.DL = Globals.getDestinationList();
        this.currentChangeRecordInfo = Collections.synchronizedMap(new HashMap());
        this.producerFlow = new ProducerFlow();
        this.isDMQ = DestType.isDMQ((int)this.type);
        if (!this.isDMQ) {
            this.expireReaper = new MsgExpirationReaper();
        }
        this.dest_inited = false;
        this.loaded = false;
        this.destvalid = true;
        this.sizeLock = new Object();
        this.size = 0;
        this.remoteSize = 0;
        this.bytes = 0L;
        this.remoteBytes = 0L;
        this.destMessages = new SimpleNFLHashMap();
        this.destMessagesInRemoving = new HashMap();
        this._removeMessageLock = new Object();
        this.consumers = new SimpleNFLHashMap();
        this.producers = new SimpleNFLHashMap();
        if (this.maxConsumerLimit > -1) {
            this.consumers.setCapacity(this.maxConsumerLimit);
        }
        if (this.maxProducerLimit > -1) {
            this.producers.setCapacity(this.maxProducerLimit);
        }
        this.filter = new DestFilter();
        this.unloadfilter = new UnloadFilter();
        this.dmc = new DestMetricsCounters();
        this.stored = true;
        this.setMaxPrefetch(this.maxPrefetch);
        this.logsuffix = "";
        this.queueRemoteLock = new Object();
        this.queueRemoteLockThread = null;
        this.handleLimitBehavior(this.limit);
        if (this.memoryLimit != null) {
            this.setByteCapacity(this.memoryLimit);
        }
        if (this.countLimit > 0) {
            this.setCapacity(this.countLimit);
        }
        if (this.msgSizeLimit != null) {
            this.setMaxByteSize(this.msgSizeLimit);
        }
        if (!this.isDMQ) {
            this.deliveryTimeTimer = new MessageDeliveryTimeTimer(this);
        }
        this.updateProducerBatch(false);
        if (this.clientReconnectInterval > 0L) {
            Destination destination = this;
            synchronized (destination) {
                if (this.clientReconnectInterval > 0L) {
                    this.reconnectReaper = new ReconnectReaperTask(this.getDestinationUID(), this.clientReconnectInterval);
                    try {
                        timer.schedule((TimerTask)this.reconnectReaper, this.clientReconnectInterval);
                    }
                    catch (IllegalStateException ex) {
                        this.logger.logStack(8, "B3100", (Object)"Can not reschedule task, timer has been canceled, the broker is probably shutting down", (Throwable)ex);
                    }
                }
            }
        }
        this.logger.log(4, "Loading Stored destination " + this + " connectionUID=" + this.id);
    }

    protected void initMonitor() throws IOException {
        if (DestType.isInternal((int)this.type) && !DestType.destNameIsInternalLogging((String)this.getDestinationName())) {
            try {
                this.bm = new BrokerMonitor(this);
            }
            catch (IllegalArgumentException ex) {
                this.logger.logStack(8, "B3100", (Object)("Unknown Monitor destination " + this.getDestinationName()), (Throwable)ex);
            }
            catch (BrokerException ex) {
                this.logger.logStack(8, "B3100", (Object)("Monitor destination Error  " + this.getDestinationName()), (Throwable)ex);
            }
        }
    }

    protected void initVar() {
    }

    protected Destination(String destination, int type, boolean store, ConnectionUID id, boolean autocreate, DestinationList dl) throws BrokerException, IOException {
        int level;
        this.uid = new DestinationUID(destination, DestType.isQueue((int)type));
        this.initVar();
        if (this.uid.isWildcard()) {
            throw new RuntimeException("Do not create wildcards");
        }
        this.id = id;
        this.setDestinationList(dl);
        this.producers.setCapacity(this.maxProducerLimit);
        this.consumers.setCapacity(this.maxConsumerLimit);
        this.destMessages = new SimpleNFLHashMap();
        this.destMessagesInRemoving = new HashMap();
        this._removeMessageLock = new Object();
        this.destMessages.enforceLimits(true);
        if (autocreate) {
            if (!DestType.isAdmin((int)type)) {
                if (DestinationList.defaultMaxMsgCnt > 0) {
                    this.setCapacity(DestinationList.defaultMaxMsgCnt);
                }
                this.setByteCapacity(DestinationList.defaultMaxMsgBytes);
                this.setMaxByteSize(DestinationList.defaultMaxBytesPerMsg);
                this.setLimitBehavior(DestinationList.defaultLimitBehavior);
                this.setMaxProducers(DestinationList.defaultProducerCnt);
                this.setUseDMQ(DestinationList.autocreateUseDMQ);
                if (DestinationList.defaultIsLocal) {
                    this.setScope(0);
                }
            }
            if (!DestType.isAdmin((int)type)) {
                if (!DestinationList.canAutoCreate(DestType.isQueue((int)type), type) && !BrokerMonitor.isInternal(destination)) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B2083", this.getName()), "B2083", null, 403);
                }
            }
            level = DestType.isAdmin((int)type) ? 4 : 8;
            this.logger.log(level, "B1132", (Object)this.getName());
            this.type = type | 0x20;
        } else {
            level = DestType.isAdmin((int)type) ? 4 : 8;
            this.type = type;
            if ((type & 0x10) == 16) {
                this.logger.log(level, "B1160", (Object)(id == null ? "<none>" : id.toString()), (Object)this.getName());
            } else {
                this.logger.log(level, "B1158", (Object)this.getName());
            }
        }
        if ((type & 0x1000) == 0 && BrokerMonitor.isInternal(destination)) {
            if (DestType.isQueue((int)type)) {
                throw new BrokerException("Internal Exception: Only topics are supported for monitoring");
            }
            this.type = type | 0x40;
            this.setScope(this.scope);
            try {
                if (!DestType.destNameIsInternalLogging((String)this.getDestinationName())) {
                    this.bm = new BrokerMonitor(this);
                }
            }
            catch (IllegalArgumentException ex) {
                throw new BrokerException(this.br.getKString("B2084", this.getName()), "B2084", ex, 400);
            }
        }
        this.loaded = true;
        if (!store) {
            this.neverStore = true;
            this.overridePersistence(false);
        }
        this.deliveryTimeTimer = new MessageDeliveryTimeTimer(this);
        Iterator itr = Consumer.getWildcardConsumers();
        while (itr.hasNext()) {
            ConsumerUID cuid = (ConsumerUID)itr.next();
            Consumer c = Consumer.getConsumer(cuid);
            if (c == null) {
                this.logger.log(8, "Consumer [" + cuid + "] for destination [" + this.getName() + "] already destroyed.");
                continue;
            }
            DestinationUID wuid = c.getDestinationUID();
            if (!DestinationUID.match(this.getDestinationUID(), wuid)) continue;
            try {
                if (c.getSubscription() != null) {
                    this.addConsumer(c.getSubscription(), false);
                    continue;
                }
                c.attachToDestination(this, this.pstore);
            }
            catch (SelectorFormatException selectorFormatException) {}
        }
        this.handleLimitBehavior(this.limit);
        this.updateProducerBatch(false);
        this.state = 0;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public DestinationUID getDestinationUID() {
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseDestination(int type) {
        Agent agent;
        SimpleNFLHashMap simpleNFLHashMap;
        assert (type != -1);
        assert (type != 0);
        assert (type <= 3);
        int oldstate = this.state;
        boolean pauseCon = false;
        boolean pauseProd = false;
        boolean resumeCon = false;
        boolean resumeProd = false;
        if (oldstate == type) {
            return;
        }
        if (oldstate == 0) {
            if (type == 2 || type == 3) {
                pauseProd = true;
            }
            if (type == 1 || type == 3) {
                pauseCon = true;
            }
        } else if (oldstate == 3) {
            if (type == 1) {
                resumeProd = true;
            } else if (type == 2) {
                resumeCon = true;
            }
        } else if (oldstate == 1) {
            if (type == 3) {
                pauseProd = true;
            } else if (type == 2) {
                resumeCon = true;
                pauseProd = true;
            }
        } else if (oldstate == 2) {
            if (type == 3) {
                pauseCon = true;
            } else if (type == 1) {
                pauseCon = true;
                resumeProd = true;
            }
        }
        this.state = type;
        if (resumeProd) {
            this.producerFlow.updateAllProducers(1, "Destination is resumed");
        }
        if (resumeCon) {
            simpleNFLHashMap = this.consumers;
            synchronized (simpleNFLHashMap) {
                for (Consumer c : this.consumers.values()) {
                    c.resume("Destination.RESUME");
                }
            }
        }
        if (pauseProd) {
            this.producerFlow.updateAllProducers(0, "Destination is paused");
        }
        if (pauseCon) {
            simpleNFLHashMap = this.consumers;
            synchronized (simpleNFLHashMap) {
                for (Object o : this.consumers.values()) {
                    Consumer c = (Consumer)o;
                    c.pause("Destination PAUSE");
                }
            }
        }
        if ((agent = Globals.getAgent()) != null) {
            agent.notifyDestinationPause(this, type);
        }
    }

    public boolean isPaused() {
        return this.state > 0 && this.state <= 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeDestination() {
        Agent agent;
        assert (this.state > 0 && this.state <= 3);
        int oldstate = this.state;
        this.state = 0;
        if (oldstate == 2 || oldstate == 3) {
            this.producerFlow.updateAllProducers(1, "Destination is resumed");
        }
        if (oldstate == 1 || oldstate == 3) {
            SimpleNFLHashMap simpleNFLHashMap = this.consumers;
            synchronized (simpleNFLHashMap) {
                for (Consumer c : this.consumers.values()) {
                    c.resume("Destination.RESUME");
                }
            }
        }
        if ((agent = Globals.getAgent()) != null) {
            agent.notifyDestinationResume(this);
        }
    }

    public void compact() throws BrokerException {
        if (!(this.pstore instanceof DiskFileStore)) {
            throw new BrokerException("XXXI18N - operation not supported");
        }
        ((DiskFileStore)((Object)this.pstore)).compactDestination(this);
        Agent agent = Globals.getAgent();
        if (agent != null) {
            agent.notifyDestinationCompact(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMetrics() {
        DestMetricsCounters destMetricsCounters = this.dmc;
        synchronized (destMetricsCounters) {
            this.expiredCnt = 0;
            this.purgedCnt = 0;
            this.ackedCnt = 0;
            this.discardedCnt = 0;
            this.overflowCnt = 0;
            this.errorCnt = 0;
            this.msgsIn = 0L;
            this.msgsOut = 0L;
            this.lastMsgsIn = 0L;
            this.lastMsgsOut = 0L;
            this.msgBytesIn = 0L;
            this.msgBytesOut = 0L;
            this.lastMsgBytesIn = 0L;
            this.lastMsgBytesOut = 0L;
            this.destMessages.reset();
            this.consumers.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestMetricsCounters getMetrics() {
        DestMetricsCounters destMetricsCounters = this.dmc;
        synchronized (destMetricsCounters) {
            long currentTime;
            this.dmc.timeStamp = currentTime = System.currentTimeMillis();
            this.dmc.setMessagesIn(this.msgsIn);
            this.dmc.setMessagesOut(this.msgsOut);
            this.dmc.setHighWaterMessages(this.destMessages.highWaterCount());
            this.dmc.setHighWaterMessageBytes(this.destMessages.highWaterBytes());
            this.dmc.setHighWaterLargestMsgBytes(this.destMessages.highWaterLargestMessageBytes());
            this.dmc.setActiveConsumers(this.consumers.size());
            this.dmc.setNumConsumers(this.consumers.size());
            this.dmc.setFailoverConsumers(0);
            this.dmc.setHWActiveConsumers(this.consumers.highWaterCount());
            this.dmc.setHWNumConsumers(this.consumers.highWaterCount());
            this.dmc.setHWFailoverConsumers(0);
            this.dmc.setAvgActiveConsumers((int)this.consumers.averageCount());
            this.dmc.setAvgNumConsumers((int)this.consumers.averageCount());
            this.dmc.setAvgFailoverConsumers(0);
            this.dmc.setMessageBytesIn(this.msgBytesIn);
            this.dmc.setMessageBytesOut(this.msgBytesOut);
            this.dmc.setCurrentMessages(this.destMessages.size());
            this.dmc.setCurrentMessageBytes(this.destMessages.byteSize());
            this.dmc.setAverageMessages((int)this.destMessages.averageCount());
            this.dmc.setAverageMessageBytes((long)this.destMessages.averageBytes());
            if (this.isStored()) {
                try {
                    if (Globals.getStore().getStoreType().equals("file")) {
                        HashMap map = ((DiskFileStore)((Object)this.pstore)).getStorageInfo(this);
                        Object obj = null;
                        Object v = map.get("diskReserved");
                        obj = v;
                        if (v != null) {
                            this.dmc.setDiskReserved(((Long)obj).longValue());
                        }
                        Object v2 = map.get("diskUsed");
                        obj = v2;
                        if (v2 != null) {
                            this.dmc.setDiskUsed(((Long)obj).longValue());
                        }
                        Object v3 = map.get("diskUtilizationRatio");
                        obj = v3;
                        if (v3 != null) {
                            this.dmc.setUtilizationRatio(((Integer)obj).intValue());
                        }
                    }
                }
                catch (BrokerException e) {
                    this.logger.log(32, e.getMessage(), (Throwable)e);
                }
            }
            this.dmc.setExpiredMsgCnt(this.expiredCnt);
            this.dmc.setPurgedMsgCnt(this.purgedCnt);
            this.dmc.setAckedMsgCnt(this.ackedCnt);
            this.dmc.setDiscardedMsgCnt(this.discardedCnt);
            this.dmc.setRejectedMsgCnt(this.overflowCnt + this.errorCnt);
            this.dmc.setRollbackMsgCnt(this.rollbackCnt);
            this.lastMetricsTime = currentTime;
            this.lastMsgsIn = this.msgsIn;
            this.lastMsgsOut = this.msgsOut;
            this.lastMsgBytesIn = this.msgBytesIn;
            this.lastMsgBytesOut = this.msgBytesOut;
            return this.dmc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkIfMsgsInRateGTOutRate(long[] holder, boolean sampleOnly) {
        if (sampleOnly) {
            DestMetricsCounters destMetricsCounters = this.dmc;
            synchronized (destMetricsCounters) {
                holder[0] = this.msgsInInternal;
                holder[1] = this.msgsOutInternal;
            }
            holder[2] = System.currentTimeMillis();
            holder[3] = -1L;
            holder[4] = -1L;
            holder[5] = -1L;
            return 1;
        }
        long myins = holder[0];
        long myouts = holder[1];
        long mylastTimeStamp = holder[2];
        long myinr = holder[3];
        long myoutr = holder[4];
        long currtime = System.currentTimeMillis();
        if (currtime - mylastTimeStamp < 1000L) {
            if (myinr < 0L || myoutr < 0L) {
                return 1;
            }
            return myinr > myoutr ? 0 : 2;
        }
        holder[2] = currtime;
        DestMetricsCounters destMetricsCounters = this.dmc;
        synchronized (destMetricsCounters) {
            holder[0] = this.msgsInInternal;
            holder[1] = this.msgsOutInternal;
        }
        if (this.msgsInOutLastResetTime >= mylastTimeStamp) {
            return 1;
        }
        long mt = holder[2] - mylastTimeStamp;
        long st = mt / 1000L;
        if (st <= 0L) {
            return 1;
        }
        long outdiff = holder[1] - myouts;
        holder[3] = (holder[0] - myins) / st;
        holder[4] = outdiff / st;
        if (outdiff > 0L) {
            holder[5] = mt / outdiff;
        }
        if (holder[3] < 0L || holder[4] < 0L) {
            return 1;
        }
        return holder[3] > holder[4] ? 0 : 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementDestinationSize(PacketReference ref) {
        long objsize = ref.byteSize();
        boolean local = ref.isLocal();
        boolean persistent = ref.isPersistent();
        Object object = this.sizeLock;
        synchronized (object) {
            --this.size;
            this.bytes -= objsize;
            if (!local) {
                --this.remoteSize;
                this.remoteBytes -= objsize;
            }
            if (!(this.isAdmin() || !this.getIsDMQ() && this.isInternal())) {
                DestinationList.decrementTotals(objsize, !persistent && !this.getIsDMQ());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementDestinationSize(PacketReference ref) {
        long objsize = ref.byteSize();
        boolean local = ref.isLocal();
        boolean persistent = ref.isPersistent();
        Object object = this.sizeLock;
        synchronized (object) {
            ++this.size;
            this.bytes += objsize;
            if (!local) {
                ++this.remoteSize;
                this.remoteBytes += objsize;
            }
            if (!(this.isAdmin() || !this.getIsDMQ() && this.isInternal())) {
                DestinationList.incrementTotals(objsize, !persistent && !this.getIsDMQ());
            }
        }
    }

    public int getState() {
        return this.state;
    }

    protected void setState(int state) {
        this.state = state;
    }

    public void setIsLocal(boolean isLocal) throws BrokerException {
        int scopeval = 0;
        scopeval = isLocal ? 0 : 1;
        this.setScope(scopeval);
    }

    public void setScope(int scope) throws BrokerException {
        this.scope = scope;
    }

    public int getScope() {
        return this.scope;
    }

    public boolean getIsLocal() {
        return this.scope == 0;
    }

    public void setLimitBehavior(int behavior) throws BrokerException {
        if (this.isDMQ && behavior == 0) {
            throw new BrokerException(this.br.getKString("B4191"));
        }
        Integer oldVal = this.limit;
        this.limit = behavior;
        this.handleLimitBehavior(this.limit);
        this.notifyAttrUpdated(64, oldVal, this.limit);
    }

    public int getLimitBehavior() {
        return this.limit;
    }

    public void setClusterDeliveryPolicy(int policy) {
        throw new UnsupportedOperationException(" cluster delivery policy not supported for this type of destination ");
    }

    public int getClusterDeliveryPolicy() {
        return 0;
    }

    public boolean isStored() {
        return !this.neverStore || this.stored;
    }

    public synchronized boolean store() throws BrokerException, IOException {
        if (this.neverStore || this.stored) {
            return false;
        }
        this.pstore.storeDestination(this, PERSIST_SYNC);
        this.stored = true;
        return this.stored;
    }

    public boolean shouldSync() {
        return PERSIST_SYNC;
    }

    public void update() throws BrokerException, IOException {
        this.update(true);
    }

    public void update(boolean notify) throws BrokerException, IOException {
        boolean should_notify;
        boolean bl = should_notify = !this.getIsDMQ() && notify && this.sendClusterUpdate() && !this.isTemporary();
        if (should_notify) {
            Globals.getClusterBroadcast().recordUpdateDestination(this);
        }
        if (!this.neverStore && this.stored) {
            this.pstore.updateDestination(this, PERSIST_SYNC);
        }
        this.updateProducerBatch(true);
        if (should_notify) {
            Globals.getClusterBroadcast().updateDestination(this);
        }
    }

    public HashMap getDestinationProperties() {
        HashMap m = new HashMap();
        this.getDestinationProps(m);
        return m;
    }

    protected void getDestinationProps(Map m) {
        m.put(NAME, this.getDestinationName());
        m.put(IS_QUEUE, this.isQueue());
        m.put(IS_INTERNAL, this.isInternal());
        m.put(IS_AUTOCREATED, this.isAutoCreated());
        m.put(IS_TEMPORARY, this.isTemporary());
        m.put(IS_ADMIN, this.isAdmin());
        m.put(IS_LOCAL, this.getIsLocal());
        m.put(REAL_TYPE, this.type);
        m.put(SCOPE_PROPERTY, this.scope);
        m.put(MAX_CONSUMERS, this.maxConsumerLimit);
        m.put(MAX_PRODUCERS, this.maxProducerLimit);
        m.put(MAX_PREFETCH, this.maxPrefetch);
        m.put(MAX_MESSAGES, this.countLimit);
        m.put(USE_DMQ, this.useDMQ);
        if (this.memoryLimit != null) {
            m.put(MAX_BYTES, this.memoryLimit.getBytes());
        }
        if (this.msgSizeLimit != null) {
            m.put(MAX_MSG_BYTES, this.msgSizeLimit.getBytes());
        }
        m.put(BEHAVIOUR, this.limit);
        m.put(STATE, this.scope);
        m.put(VALIDATE_XML_SCHEMA_ENABLED, this.validateXMLSchemaEnabled);
        if (this.XMLSchemaUriList != null) {
            m.put(XML_SCHEMA_URI_LIST, this.XMLSchemaUriList);
        }
        m.put(RELOAD_XML_SCHEMA_ON_FAILURE, this.reloadXMLSchemaOnFailure);
    }

    public void setDestinationProperties(Map m) throws BrokerException {
        SizeString ss;
        if (Destination.getDEBUG()) {
            this.logger.log(4, "Setting destination properties for " + this + " to " + m);
        }
        if (m.get(MAX_CONSUMERS) != null) {
            try {
                this.setMaxConsumers((Integer)m.get(MAX_CONSUMERS));
            }
            catch (BrokerException ex) {
                this.logger.logStack(16, ex.getMessage(), (Throwable)ex);
            }
        }
        if (m.get(MAX_PRODUCERS) != null) {
            try {
                this.setMaxProducers((Integer)m.get(MAX_PRODUCERS));
            }
            catch (BrokerException ex) {
                this.logger.logStack(16, ex.getMessage(), (Throwable)ex);
            }
        }
        if (m.get(MAX_PREFETCH) != null) {
            this.setMaxPrefetch((Integer)m.get(MAX_PREFETCH));
        }
        if (m.get(MAX_MESSAGES) != null) {
            this.setCapacity((Integer)m.get(MAX_MESSAGES));
        }
        if (m.get(MAX_BYTES) != null) {
            ss = new SizeString();
            ss.setBytes(((Long)m.get(MAX_BYTES)).longValue());
            this.setByteCapacity(ss);
        }
        if (m.get(MAX_MSG_BYTES) != null) {
            ss = new SizeString();
            ss.setBytes(((Long)m.get(MAX_MSG_BYTES)).longValue());
            this.setMaxByteSize(ss);
        }
        if (m.get(BEHAVIOUR) != null) {
            this.setLimitBehavior((Integer)m.get(BEHAVIOUR));
        }
        if (m.get(IS_LOCAL) != null) {
            this.setIsLocal((Boolean)m.get(IS_LOCAL));
        }
        if (m.get(USE_DMQ) != null) {
            this.setUseDMQ((Boolean)m.get(USE_DMQ));
        }
        try {
            this.update(false);
        }
        catch (Exception ex) {
            this.logger.logStack(16, "B3100", (Object)("Unable to update destination " + this.getName()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Object cuid;
        Hashtable<Object, Object> ht = new Hashtable<Object, Object>();
        ht.put("TABLE", "Destination[" + this.uid.toString() + "]");
        this.getDestinationProps(ht);
        ht.putAll((Map<Object, Object>)this.getMetrics());
        ht.put("Consumers", String.valueOf(this.consumers.size()));
        Iterator<Object> itr = this.consumers.getAll(null).values().iterator();
        ArrayList pfers = null;
        SimpleNFLHashMap<SysMessageID, PacketReference> simpleNFLHashMap = this.destMessages;
        synchronized (simpleNFLHashMap) {
            pfers = new ArrayList(this.destMessages.values());
        }
        while (itr.hasNext()) {
            Consumer con = (Consumer)itr.next();
            cuid = con.getConsumerUID();
            ConsumerUID sid = con.getStoredConsumerUID();
            int total = pfers.size();
            int match = 0;
            int delivered = 0;
            int ackno = 0;
            for (int i = 0; i < total; ++i) {
                PacketReference ref = (PacketReference)pfers.get(i);
                try {
                    try {
                        if (!ref.matches(sid)) continue;
                        ++match;
                        if (ref.isAcknowledged(sid)) {
                            ++ackno;
                        }
                        if (!ref.isDelivered(sid)) continue;
                        ++delivered;
                    }
                    catch (Exception e) {
                        this.logger.log(8, "Destination.getDebugState(): " + this + " for message reference " + ref + " and stored consumer uid " + sid + ": " + e.toString());
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String ID = match + " of " + total + "[ d=" + delivered + ", a=" + ackno + "]";
            ht.put("Consumer[" + cuid.longValue() + "]", ID);
        }
        HashSet s = null;
        cuid = this.producers;
        synchronized (cuid) {
            s = new HashSet(this.producers.keySet());
        }
        itr = s.iterator();
        Vector<Object> v = new Vector<Object>();
        while (itr.hasNext()) {
            ProducerUID cuid2 = (ProducerUID)((Object)itr.next());
            v.add(String.valueOf(cuid2.longValue()));
        }
        ht.put("Producers", v);
        ht.put("_stored", String.valueOf(this.stored));
        ht.put("_neverStore", String.valueOf(this.neverStore));
        ht.put("_destvalid", String.valueOf(this.destvalid));
        ht.put("_loaded", String.valueOf(this.loaded));
        ht.put("_state", DestState.toString((int)this.state));
        ht.put("producerMsgBatchSize", String.valueOf(this.producerMsgBatchSize));
        ht.put("producerMsgBatchBytes", String.valueOf(this.producerMsgBatchBytes));
        if (this.reconnectReaper != null) {
            ht.put("_reconnectReaper", this.reconnectReaper.toString());
        }
        ht.put("_clientReconnectInterval", String.valueOf(this.clientReconnectInterval));
        ht.put("TrueType", DestType.toString((int)this.type));
        if (this.id != null) {
            ht.put("ConnectionUID", String.valueOf(this.id.longValue()));
        }
        ht.put("activeProducerCount", String.valueOf(this.producerFlow.activeProducerCnt()));
        ht.put("pausedProducerCount", String.valueOf(this.producerFlow.pausedProducerCnt()));
        ht.put("pausedProducerSet", this.producerFlow.getDebugPausedProducers());
        ht.put("activeProducerSet", this.producerFlow.getDebugActiveProducers());
        ht.put("size", this.size);
        ht.put("bytes", this.bytes);
        ht.put("remoteSize", Long.valueOf(this.remoteSize));
        ht.put("remoteBytes", this.remoteBytes);
        ArrayList sysids = null;
        SimpleNFLHashMap<SysMessageID, PacketReference> total = this.destMessages;
        synchronized (total) {
            ht.put("destMessagesSize", String.valueOf(this.destMessages.size()));
            sysids = new ArrayList(this.destMessages.keySet());
        }
        itr = sysids.iterator();
        v = new Vector();
        while (itr.hasNext()) {
            SysMessageID sysid = (SysMessageID)itr.next();
            PacketReference ref = (PacketReference)this.destMessages.get((Object)sysid);
            Object refs = "null";
            if (ref != null) {
                refs = "local=" + ref.isLocal() + ",invalid=" + ref.isInvalid() + ",destroyed=" + ref.isDestroyed() + ",overrided=" + ref.isOverrided() + ",overriding=" + ref.isOverriding() + ",locked=" + (ref.checkLock(false) == null);
            }
            v.add(sysid.toString() + "  ref=" + (String)refs);
        }
        ht.put("Messages", v);
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugMessages(boolean full) {
        if (!this.loaded) {
            try {
                this.load();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Vector<Hashtable> vt = new Vector<Hashtable>();
        try {
            Iterator itr = null;
            SimpleNFLHashMap<SysMessageID, PacketReference> simpleNFLHashMap = this.destMessages;
            synchronized (simpleNFLHashMap) {
                itr = new HashSet(this.destMessages.values()).iterator();
            }
            while (itr.hasNext()) {
                PacketReference pr = (PacketReference)itr.next();
                Hashtable pht = pr.getDebugState();
                pht.put("ID", pr.getSysMessageID().toString());
                if (full) {
                    pht.put("PACKET", pr.getPacket().dumpPacketString("        "));
                }
                vt.add(pht);
            }
        }
        catch (Throwable ex) {
            this.logger.log(4, "Error getting debugMessages ", ex);
        }
        Hashtable<String, Vector<Hashtable>> ht = new Hashtable<String, Vector<Hashtable>>();
        ht.put("  ", vt);
        return ht;
    }

    public SysMessageID[] getSysMessageIDs() throws BrokerException {
        return this.getSysMessageIDs(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SysMessageID[] getSysMessageIDs(Long startMsgIndex, Long maxMsgsRetrieved) throws BrokerException {
        long numMsgs;
        SysMessageID[] ids = new SysMessageID[]{};
        if (!this.loaded) {
            this.load();
        }
        if ((numMsgs = (long)this.destMessages.size()) == 0L) {
            return ids;
        }
        if (startMsgIndex == null) {
            startMsgIndex = 0L;
        } else if (startMsgIndex < 0L || startMsgIndex > numMsgs - 1L) {
            String errMsg = " Start message index needs to be in between 0 and " + (numMsgs - 1L);
            throw new BrokerException(errMsg);
        }
        if (maxMsgsRetrieved == null) {
            maxMsgsRetrieved = numMsgs - startMsgIndex;
        } else if (maxMsgsRetrieved < 0L) {
            String errMsg = " Max number of messages retrieved value needs to be greater than 0.";
            throw new BrokerException(errMsg);
        }
        long maxIndex = startMsgIndex + maxMsgsRetrieved;
        TreeSet<PacketReference> s = new TreeSet<PacketReference>(new RefCompare());
        try {
            HashSet msgset = null;
            SimpleNFLHashMap<SysMessageID, PacketReference> simpleNFLHashMap = this.destMessages;
            synchronized (simpleNFLHashMap) {
                msgset = new HashSet(this.destMessages.values());
            }
            for (PacketReference pr : msgset) {
                s.add(pr);
            }
        }
        catch (Throwable ex) {
            this.logger.log(4, "Error getting msg IDs ", ex);
        }
        ArrayList<SysMessageID> idsAl = new ArrayList<SysMessageID>();
        long i = 0L;
        for (PacketReference pr : s) {
            if (i >= startMsgIndex && i < maxIndex) {
                SysMessageID id = pr.getSysMessageID();
                idsAl.add(id);
            }
            if (i >= maxIndex) break;
            ++i;
        }
        ids = idsAl.toArray(ids);
        return ids;
    }

    public String getName() {
        return this.uid.getLocalizedName();
    }

    @Override
    public String getDestinationName() {
        return this.uid.getName();
    }

    @Override
    public ConnectionUID getConnectionUID() {
        return this.id;
    }

    @Override
    public boolean isAutoCreated() {
        return (this.type & 0x20) != 0;
    }

    @Override
    public boolean isTemporary() {
        return (this.type & 0x10) != 0;
    }

    @Override
    public boolean isQueue() {
        return (this.type & 1) != 0;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public Collection<PacketReference> getAllMessages() throws UnsupportedOperationException {
        return this.destMessages.values();
    }

    public void purgeDestination() throws BrokerException {
        this.purgeDestination(false);
    }

    public void purgeDestination(boolean noerrnotfound) throws BrokerException {
        if (!this.loaded) {
            this.load(noerrnotfound);
        }
        try {
            Agent agent;
            MemoryManager mm = Globals.getMemManager();
            int maxpurge = this.destMessages.size();
            long removedCount = 0L;
            long indeliveryCount = 0L;
            boolean do1 = false;
            boolean oomed = false;
            ArrayList list = null;
            int count = 0;
            while (maxpurge > 0 && count < maxpurge) {
                block17: {
                    do1 = false;
                    if (oomed) {
                        do1 = true;
                        oomed = false;
                    } else if (mm != null && mm.getCurrentLevel() > 0) {
                        do1 = true;
                    }
                    if (!do1) {
                        try {
                            list = new ArrayList(this.destMessages.getAllKeys());
                            count = maxpurge;
                            break block17;
                        }
                        catch (OutOfMemoryError oom) {
                            oomed = true;
                            continue;
                        }
                    }
                    list = this.destMessages.getFirstKeys(1);
                }
                if (list.isEmpty()) break;
                count += list.size();
                RemoveMessageReturnInfo ret = null;
                SysMessageID sysid2 = null;
                for (SysMessageID sysid2 : list) {
                    ret = this._removeMessage(sysid2, RemoveReason.PURGED, null, null, true);
                    if (ret.removed) {
                        ++removedCount;
                        continue;
                    }
                    if (!ret.indelivery) continue;
                    ++indeliveryCount;
                }
            }
            this.logger.log(8, this.br.getKString("B1387", removedCount, this.uid.getLocalizedName()));
            if (indeliveryCount > 0L) {
                this.logger.log(8, this.br.getKString("B1388", indeliveryCount, this.uid.getLocalizedName()));
            }
            if ((agent = Globals.getAgent()) != null) {
                agent.notifyDestinationPurge(this);
            }
        }
        catch (Exception ex) {
            if (BrokerStateHandler.isShuttingDown()) {
                this.logger.log(8, "B3232", (Object)this.getName(), (Throwable)ex);
            } else {
                this.logger.logStack(16, "B3232", (Object)this.getName(), (Throwable)ex);
            }
            if (ex instanceof BrokerException) {
                throw (BrokerException)ex;
            }
            throw new BrokerException(this.br.getKString("B3232", this.getName()), ex);
        }
    }

    public void purgeDestination(Filter criteria) throws BrokerException {
        if (!this.loaded) {
            this.load();
        }
        Map m = this.destMessages.getAll(criteria);
        Iterator itr = m.keySet().iterator();
        while (itr.hasNext()) {
            try {
                this.removeMessage((SysMessageID)itr.next(), RemoveReason.PURGED);
            }
            catch (Exception ex) {
                this.logger.logStack(8, "B3232", (Object)this.getName(), (Throwable)ex);
            }
        }
    }

    public Map<SysMessageID, PacketReference> getAll(Filter f) {
        if (!this.loaded) {
            try {
                this.load();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.destMessages.getAll(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSizeInfo(DestinationInfo dinfo) {
        if (!this.loaded) {
            Object object = this.sizeLock;
            synchronized (object) {
                dinfo.nMessages += this.size;
                dinfo.nMessageBytes += this.bytes;
            }
            dinfo.nRemoteMessages += 0;
            dinfo.nRemoteMessageBytes += 0L;
            dinfo.nUnackMessages += 0;
            dinfo.nInDelayMessages += 0;
            dinfo.nInDelayMessageBytes += 0L;
            dinfo.nTxnMessages += 0;
            dinfo.nTxnMessageBytes += 0L;
            return;
        }
        HashSet<PacketReference> msgs = null;
        SimpleNFLHashMap<SysMessageID, PacketReference> simpleNFLHashMap = this.destMessages;
        synchronized (simpleNFLHashMap) {
            msgs = new HashSet<PacketReference>(this.destMessages.values());
            dinfo.nMessages += this.destMessages.size();
            dinfo.nMessageBytes += this.destMessages.byteSize();
        }
        dinfo.nUnackMessages = this.isQueue() ? (dinfo.nUnackMessages += this.getUnackSize()) : (dinfo.nUnackMessages += this.getUnackSize(msgs));
        MessageDeliveryTimeTimer dt = this.deliveryTimeTimer;
        if (dt != null) {
            dt.getSizeInfo(msgs, dinfo);
        } else {
            dinfo.nInDelayMessages += 0;
            dinfo.nInDelayMessageBytes += 0L;
        }
        this.getRemoteSize(msgs, dinfo);
        this.txnSize(msgs, dinfo);
    }

    public int size() throws UnsupportedOperationException {
        if (!this.loaded) {
            return this.size;
        }
        return this.destMessages.size();
    }

    public long byteSize() throws UnsupportedOperationException {
        if (!this.loaded) {
            return this.bytes;
        }
        return this.destMessages.byteSize();
    }

    public int getRemoteSize() {
        return this.getRemoteSize(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemoteSize(Set<PacketReference> msgset, DestinationInfo dinfo) {
        int cnt = 0;
        Set<PacketReference> msgs = msgset;
        if (msgs == null) {
            SimpleNFLHashMap<SysMessageID, PacketReference> simpleNFLHashMap = this.destMessages;
            synchronized (simpleNFLHashMap) {
                msgs = new HashSet<PacketReference>(this.destMessages.values());
            }
        }
        for (PacketReference ref : msgs) {
            if (ref.isLocal()) continue;
            ++cnt;
            if (dinfo == null) continue;
            ++dinfo.nRemoteMessages;
            dinfo.nRemoteMessageBytes += ref.getSize();
        }
        return cnt;
    }

    public long getRemoteBytes() {
        return this.getRemoteBytes(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRemoteBytes(Set<PacketReference> msgset) {
        long rbytes = 0L;
        Set<PacketReference> msgs = msgset;
        if (msgs == null) {
            SimpleNFLHashMap<SysMessageID, PacketReference> simpleNFLHashMap = this.destMessages;
            synchronized (simpleNFLHashMap) {
                msgs = new HashSet<PacketReference>(this.destMessages.values());
            }
        }
        for (PacketReference ref : msgs) {
            if (ref.isLocal()) continue;
            rbytes += ref.getSize();
        }
        return rbytes;
    }

    public int txnSize() {
        return this.txnSize(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int txnSize(Set<PacketReference> msgset, DestinationInfo dinfo) {
        Set<PacketReference> msgs = msgset;
        if (msgs == null) {
            SimpleNFLHashMap<SysMessageID, PacketReference> simpleNFLHashMap = this.destMessages;
            synchronized (simpleNFLHashMap) {
                msgs = new HashSet<PacketReference>(this.destMessages.values());
            }
        }
        Iterator<PacketReference> itr = msgs.iterator();
        int cnt = 0;
        TransactionList tl = this.DL.getTransactionList();
        while (itr.hasNext()) {
            TransactionState ts;
            PacketReference ref = itr.next();
            TransactionUID tid = ref.getTransactionID();
            if (tid == null || (ts = tl.retrieveState(tid, true)) == null || ts.getState() == 6) continue;
            ++cnt;
            if (dinfo == null) continue;
            ++dinfo.nTxnMessages;
            dinfo.nTxnMessageBytes += ref.getSize();
        }
        return cnt;
    }

    public long txnByteSize() {
        return this.txnByteSize(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long txnByteSize(Set<PacketReference> msgset) {
        Set<PacketReference> msgs = msgset;
        if (msgs == null) {
            SimpleNFLHashMap<SysMessageID, PacketReference> simpleNFLHashMap = this.destMessages;
            synchronized (simpleNFLHashMap) {
                msgs = new HashSet<PacketReference>(this.destMessages.values());
            }
        }
        Iterator<PacketReference> itr = msgs.iterator();
        long sz = 0L;
        TransactionList tl = this.DL.getTransactionList();
        while (itr.hasNext()) {
            TransactionState ts;
            PacketReference ref = itr.next();
            TransactionUID tid = ref.getTransactionID();
            if (tid == null || (ts = tl.retrieveState(tid, true)) == null || ts.getState() == 6) continue;
            sz += ref.getSize();
        }
        return sz;
    }

    public long checkDestinationCapacity(PacketReference ref) {
        long room = -1L;
        int maxc = this.destMessages.capacity();
        if ((long)maxc > 0L && (room = (long)(maxc - this.destMessages.size())) < 0L) {
            room = 0L;
        }
        if (ref == null) {
            return room;
        }
        long maxb = this.destMessages.byteCapacity();
        if (maxb > 0L) {
            long cnt = (maxb - this.destMessages.byteSize()) / ref.byteSize();
            if (cnt < 0L) {
                cnt = 0L;
            }
            if (cnt < room) {
                room = cnt;
            }
        }
        return room;
    }

    public float destMessagesSizePercent() {
        int maxc = this.destMessages.capacity();
        if (maxc <= 0) {
            return 0.0f;
        }
        return (float)this.destMessages.size() / (float)maxc * 100.0f;
    }

    public abstract int getUnackSize();

    public abstract int getUnackSize(Set var1);

    public long getHighWaterBytes() {
        return this.destMessages.highWaterBytes();
    }

    public int getHighWaterCount() {
        return this.destMessages.highWaterCount();
    }

    public long highWaterLargestMessageBytes() {
        return this.destMessages.highWaterLargestMessageBytes();
    }

    public double getAverageBytes() {
        return this.destMessages.averageBytes();
    }

    public float getAverageCount() {
        return this.destMessages.averageCount();
    }

    public double averageMessageBytes() {
        return this.destMessages.averageMessageBytes();
    }

    public SizeString getMaxByteSize() {
        return this.msgSizeLimit;
    }

    public int getCapacity() {
        return this.countLimit;
    }

    public SizeString getByteCapacity() {
        return this.memoryLimit;
    }

    public void setMaxByteSize(SizeString limit) throws UnsupportedOperationException {
        Long oldVal;
        if (Destination.getDEBUG()) {
            this.logger.log(4, "attempting to set Message Size Limit to " + limit + " for destination " + this);
        }
        if ((oldVal = this.msgSizeLimit == null ? Long.valueOf(-1L) : Long.valueOf(this.msgSizeLimit.getBytes())) == 0L) {
            oldVal = -1L;
        }
        this.msgSizeLimit = limit;
        long bytes = 0L;
        bytes = limit == null ? -1L : limit.getBytes();
        if (bytes == 0L) {
            bytes = -1L;
        }
        this.destMessages.setMaxByteSize(bytes);
        this.notifyAttrUpdated(16, oldVal, bytes);
    }

    public void setCapacity(int limit) throws UnsupportedOperationException {
        if (Destination.getDEBUG()) {
            this.logger.log(4, "attempting to set Message Count Limit to " + limit + " for destination " + this);
        }
        Long oldVal = this.countLimit;
        if (limit == 0) {
            limit = -1;
        }
        this.countLimit = limit;
        this.destMessages.setCapacity(limit);
        this.updateProducerBatch(false);
        this.notifyAttrUpdated(4, oldVal, this.countLimit);
    }

    public void setByteCapacity(SizeString limit) throws UnsupportedOperationException {
        Long oldVal;
        if (Destination.getDEBUG()) {
            this.logger.log(8, "attempting to set Message Bytes Limit to " + limit + " for destination " + this);
        }
        if ((oldVal = this.memoryLimit == null ? Long.valueOf(-1L) : Long.valueOf(this.memoryLimit.getBytes())) == 0L) {
            oldVal = -1L;
        }
        this.memoryLimit = limit;
        long bytes = 0L;
        bytes = limit == null ? -1L : limit.getBytes();
        if (bytes == 0L) {
            bytes = -1L;
        }
        this.destMessages.setByteCapacity(bytes);
        this.updateProducerBatch(false);
        this.notifyAttrUpdated(8, oldVal, bytes);
    }

    public int getMaxActiveConsumers() {
        return -1;
    }

    public int getMaxFailoverConsumers() {
        return 0;
    }

    public void setMaxProducers(int cnt) throws BrokerException {
        if (this.isDMQ) {
            throw new BrokerException(this.br.getKString("B4192"));
        }
        if (cnt == 0) {
            throw new BrokerException(this.br.getKString("B4178", this.getName()), "B4178", null, 500);
        }
        Integer oldVal = this.maxProducerLimit;
        this.maxProducerLimit = cnt < -1 ? -1 : cnt;
        this.producers.setCapacity(this.maxProducerLimit);
        this.notifyAttrUpdated(2048, oldVal, this.maxProducerLimit);
    }

    public int getMaxProducers() {
        return this.maxProducerLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAllActiveConsumerCount() {
        int cnt = 0;
        SimpleNFLHashMap simpleNFLHashMap = this.consumers;
        synchronized (simpleNFLHashMap) {
            if (this.consumers.size() == 0) {
                return 0;
            }
            Iterator itr = this.consumers.values().iterator();
            Consumer c = null;
            while (itr.hasNext()) {
                c = (Consumer)itr.next();
                if (c instanceof Subscription) {
                    cnt += ((Subscription)c).getChildConsumers().size();
                    continue;
                }
                ++cnt;
            }
        }
        return cnt;
    }

    @Override
    public int getActiveConsumerCount() {
        return this.getConsumerCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getActiveConsumers() {
        HashSet<Consumer> set = new HashSet<Consumer>();
        SimpleNFLHashMap simpleNFLHashMap = this.consumers;
        synchronized (simpleNFLHashMap) {
            for (Consumer con : this.consumers.values()) {
                set.add(con);
            }
        }
        return set;
    }

    public Set getFailoverConsumers() {
        return new HashSet();
    }

    @Override
    public int getFailoverConsumerCount() {
        return 0;
    }

    public void setMaxConsumers(int count) throws BrokerException {
        if (count == 0) {
            throw new BrokerException(this.br.getKString("B4179", this.getName()), "B4179", null, 500);
        }
        this.maxConsumerLimit = count < -1 ? -1 : count;
        this.consumers.setCapacity(this.maxConsumerLimit);
    }

    public void setMaxActiveConsumers(int cnt) throws BrokerException {
        throw new UnsupportedOperationException("setting max active consumers not supported on this destination type");
    }

    public void setMaxFailoverConsumers(int cnt) throws BrokerException {
        throw new UnsupportedOperationException("setting max failover consumers not supported on this destination type");
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Destination) {
            if (this.uid == ((Destination)o).uid) {
                return true;
            }
            return this.uid.equals(((Destination)o).uid);
        }
        return false;
    }

    public boolean queueMessage(PacketReference pkt, boolean trans) throws BrokerException {
        return this.queueMessage(pkt, trans, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean queueMessage(PacketReference pkt, boolean trans, boolean enforcelimit) throws BrokerException {
        if (!this.DL.isValid()) {
            throw new BrokerException(this.br.getKString("B1157", this.getName()));
        }
        DestMetricsCounters destMetricsCounters = this.dmc;
        synchronized (destMetricsCounters) {
            ++this.msgsIn;
            this.msgBytesIn += pkt.byteSize();
            ++this.msgsInInternal;
            if (this.msgsInInternal >= Long.MAX_VALUE) {
                this.msgsInOutLastResetTime = System.currentTimeMillis();
                this.msgsInInternal = 0L;
                this.msgsOutInternal = 0L;
            }
        }
        PacketListDMPair dmp = null;
        try {
            boolean check = !this.isAdmin() && !this.isInternal();
            dmp = this.DL.addNewMessage(check && enforcelimit, pkt);
            boolean ok = dmp.getReturn();
            if (!ok && !this.isDMQ) {
                if (!this.isInternal()) {
                    pkt.setDestination(this);
                    this.markDead(pkt, RemoveReason.EXPIRED, null);
                    this.DL.removePacketList(pkt.getSysMessageID(), this.getDestinationUID(), pkt);
                }
                boolean bl = false;
                return bl;
            }
            pkt.setDestination(this);
            try {
                if (!this.DL.isValid()) {
                    pkt.destroy();
                    throw new BrokerException(this.br.getKString("B1157", this.getName()));
                }
                if (this.overrideP) {
                    pkt.overridePersistence(this.overridePvalue);
                }
                this.putMessage(pkt, AddReason.QUEUED, false, enforcelimit);
                if (this.overrideTTL) {
                    pkt.overrideExpireTime(System.currentTimeMillis() + this.overrideTTLvalue);
                }
                ExpirationInfo ei = pkt.getExpireInfo();
                MessageDeliveryTimeInfo di = pkt.getDeliveryTimeInfo();
                if (di != null && di.isDeliveryDue()) {
                    di = null;
                }
                MsgExpirationReaper er = null;
                MessageDeliveryTimeTimer dt = null;
                if (ei != null || di != null) {
                    er = this.expireReaper;
                    dt = this.deliveryTimeTimer;
                }
                if (er != null && ei != null) {
                    if (!this.DL.isValid()) {
                        String emsg = this.br.getKString("B2266", pkt, "" + this.uid);
                        RuntimeException ex = new RuntimeException(emsg);
                        this.logger.log(16, emsg);
                        this.removeMessage(pkt.getSysMessageID(), null);
                        throw ex;
                    }
                    er.addExpiringMessage(ei);
                }
                if (di == null) return true;
                if (!this.DL.isValid()) {
                    String emsg = this.br.getKString("B2266", pkt, "" + this.uid);
                    RuntimeException ex = new RuntimeException(emsg);
                    ex.fillInStackTrace();
                    this.logger.log(16, emsg);
                    this.removeMessage(pkt.getSysMessageID(), null);
                    throw ex;
                }
                if (dt == null) {
                    String emsg = this.br.getKString("B2267", pkt, this.uid + "[" + this.isValid() + "]");
                    RuntimeException ex = new RuntimeException(emsg);
                    ex.fillInStackTrace();
                    this.logger.log(16, emsg);
                    throw ex;
                }
                dt.addMessage(di);
                return true;
            }
            catch (IllegalStateException ex) {
                throw new BrokerException(this.br.getKString("B4212", pkt.getSysMessageID(), this.toString()), "B4212", ex, 304);
            }
            catch (OutOfLimitsException ex) {
                this.removeMessage(pkt.getSysMessageID(), RemoveReason.OVERFLOW);
                Object lmt = ex.getLimit();
                boolean unlimited = false;
                if (lmt != null) {
                    if (lmt instanceof Integer) {
                        unlimited = (Integer)ex.getLimit() <= 0;
                    } else if (lmt instanceof Long) {
                        unlimited = (Long)ex.getLimit() <= 0L;
                    }
                }
                Object[] args = new String[]{pkt.getSysMessageID().toString(), this.getName(), unlimited ? this.br.getString("B0012") : ex.getLimit().toString(), ex.getValue().toString()};
                String id = "B4117";
                int status = 414;
                switch (ex.getType()) {
                    case 0: {
                        id = "B4120";
                        throw new BrokerException(this.br.getKString(id, args), id, ex, status);
                    }
                    case 1: {
                        id = "B4121";
                        throw new BrokerException(this.br.getKString(id, args), id, ex, status);
                    }
                    case 2: {
                        id = "B4122";
                        status = 423;
                        throw new BrokerException(this.br.getKString(id, args), id, ex, status);
                    }
                }
                throw new BrokerException(this.br.getKString(id, args), id, ex, status);
            }
            catch (IllegalArgumentException ex) {
                this.removeMessage(pkt.getSysMessageID(), RemoveReason.ERROR);
                throw ex;
            }
        }
        catch (BrokerException ex) {
            pkt.destroy();
            throw ex;
        }
        finally {
            if (dmp != null) {
                dmp.nullRef();
            }
        }
    }

    public abstract ConsumerUID[] calculateStoredInterests(PacketReference var1) throws BrokerException, SelectorFormatException;

    public abstract Set routeNewMessage(PacketReference var1) throws BrokerException, SelectorFormatException;

    public abstract void routeNewMessageWithDeliveryDelay(PacketReference var1) throws BrokerException, SelectorFormatException;

    public abstract void forwardOrphanMessage(PacketReference var1, ConsumerUID var2) throws BrokerException;

    public abstract void forwardOrphanMessages(Collection var1, ConsumerUID var2) throws BrokerException;

    public abstract void forwardMessage(Set var1, PacketReference var2) throws BrokerException;

    public abstract void forwardDeliveryDelayedMessage(Set<ConsumerUID> var1, PacketReference var2) throws BrokerException;

    protected abstract ConsumerUID[] routeLoadedTransactionMessage(PacketReference var1) throws BrokerException, SelectorFormatException;

    public abstract void unrouteLoadedTransactionAckMessage(PacketReference var1, ConsumerUID var2) throws BrokerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireQueueRemoteLock() throws BrokerException {
        long totalwaited = 0L;
        long pretime = 0L;
        long curtime = 0L;
        long waitime = 15000L;
        Object object = this.queueRemoteLock;
        synchronized (object) {
            while (this.queueRemoteLockThread != null && this.isValid() && !DestinationList.isShutdown()) {
                curtime = System.currentTimeMillis();
                totalwaited += pretime == 0L ? 0L : curtime - pretime;
                if (pretime != 0L) {
                    waitime = 30000L;
                    Object[] args = new String[]{"" + this.getDestinationUID(), "[" + this.queueRemoteLockThread + "](" + totalwaited + ")"};
                    Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1469", args));
                }
                pretime = System.currentTimeMillis();
                try {
                    this.queueRemoteLock.wait(waitime);
                }
                catch (Exception exception) {}
            }
            if (!this.isValid()) {
                throw new BrokerException(this.br.getKString("B1159", "" + this.getDestinationUID()));
            }
            if (DestinationList.isShutdown()) {
                throw new BrokerException(this.br.getKString("B2066"));
            }
            this.queueRemoteLockThread = Thread.currentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearQueueRemoteLock() {
        Thread mythr = Thread.currentThread();
        Object object = this.queueRemoteLock;
        synchronized (object) {
            if (this.queueRemoteLockThread == mythr) {
                this.queueRemoteLockThread = null;
                this.queueRemoteLock.notifyAll();
            }
        }
    }

    public void putMessage(PacketReference ref, Reason r) throws IndexOutOfBoundsException, IllegalArgumentException, IllegalStateException {
        this.putMessage(ref, r, false, true);
    }

    public void putMessage(PacketReference ref, Reason r, boolean override) throws IndexOutOfBoundsException, IllegalArgumentException, IllegalStateException {
        this.putMessage(ref, r, override, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMessage(PacketReference ref, Reason r, boolean override, boolean enforcelimit) throws IndexOutOfBoundsException, IllegalArgumentException, IllegalStateException {
        if (!override) {
            if (!enforcelimit) {
                this.destMessages.put((Object)ref.getSysMessageID(), (Object)ref, r, override, enforcelimit);
            } else {
                this.destMessages.put((Object)ref.getSysMessageID(), (Object)ref, r, override);
            }
            this._messageAdded(ref, r, false);
            return;
        }
        boolean overrideRemote = false;
        SimpleNFLHashMap<SysMessageID, PacketReference> simpleNFLHashMap = this.destMessages;
        synchronized (simpleNFLHashMap) {
            PacketReference oldref = (PacketReference)this.destMessages.get((Object)ref.getSysMessageID());
            if (oldref != null && oldref != ref && !oldref.isLocal()) {
                oldref.overrided();
                ref.overriding();
                overrideRemote = true;
            }
            if (!enforcelimit) {
                this.destMessages.put((Object)ref.getSysMessageID(), (Object)ref, r, override, enforcelimit);
            } else {
                this.destMessages.put((Object)ref.getSysMessageID(), (Object)ref, r, override);
            }
        }
        this._messageAdded(ref, r, overrideRemote);
    }

    protected void unputMessage(PacketReference ref, Reason r) throws IndexOutOfBoundsException, IllegalArgumentException {
        PacketReference o = (PacketReference)this.destMessages.remove((Object)ref.getSysMessageID(), r);
        this._messageRemoved(ref, ref.byteSize(), r, o != null);
    }

    public boolean removeRemoteMessage(SysMessageID id, Reason r, PacketReference remoteRef, boolean wait) throws BrokerException {
        RemoveMessageReturnInfo ret = this._removeMessage(id, r, null, remoteRef, wait);
        return ret.removed;
    }

    public boolean removeRemoteMessage(SysMessageID id, Reason r, PacketReference remoteRef) throws BrokerException {
        RemoveMessageReturnInfo ret = this._removeMessage(id, r, null, remoteRef, true);
        return ret.removed;
    }

    public boolean removeMessage(SysMessageID id, Reason r, boolean wait) throws BrokerException {
        RemoveMessageReturnInfo ret = this._removeMessage(id, r, null, null, wait);
        return ret.removed;
    }

    public boolean removeMessage(SysMessageID id, Reason r) throws BrokerException {
        RemoveMessageReturnInfo ret = this._removeMessage(id, r, null, null, true);
        return ret.removed;
    }

    public RemoveMessageReturnInfo removeMessageWithReturnInfo(SysMessageID id, Reason r) throws BrokerException {
        return this._removeMessage(id, r, null, null, true);
    }

    public boolean removeMessage(SysMessageID id, Reason r, Hashtable dmqProps) throws BrokerException {
        RemoveMessageReturnInfo ret = this._removeMessage(id, r, dmqProps, null, true);
        return ret.removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private RemoveMessageReturnInfo _removeMessage(SysMessageID id, Reason r, Hashtable dmqProps, PacketReference remoteRef, boolean wait) throws BrokerException {
        ret = new RemoveMessageReturnInfo();
        ref = null;
        if (!this.loaded) {
            this.load();
        }
        if ((ref = (PacketReference)this.destMessages.get((Object)id)) == null) {
            this.DL.removePacketList(id, this.getDestinationUID(), null);
            this.logger.log(4, "Reference already gone for " + id);
            return ret;
        }
        if (remoteRef != null && remoteRef != ref) {
            this.logger.log(Destination.DEBUG_CLUSTER != false || Destination.getDEBUG() != false ? 8 : 4, "Reference for " + id + " is overrided, not remove");
            remoteRef.setInvalid();
            return ret;
        }
        ei = ref.getExpireInfo();
        if (this.isValid() && (r == RemoveReason.EXPIRED || r == RemoveReason.PURGED || r == RemoveReason.REMOVE_ADMIN) && !ref.checkDeliveryAndSetInRemoval()) {
            if (r == RemoveReason.EXPIRED && !Destination.EXPIRE_DELIVERED_MSG) {
                this.logger.log(Destination.DEBUG_CLUSTER != false || Destination.getDEBUG() != false ? 8 : 4, "Message " + ref.getSysMessageID() + " is not " + r + " because it is in delivery to client consumer");
                if (ei != null) {
                    ei.clearReapCount();
                }
                ret.inreplacing = ref.inReplacing;
                ret.indelivery = ret.inreplacing == false;
                return ret;
            }
            if (r == RemoveReason.PURGED && !Destination.PURGE_DELIVERED_MSG) {
                this.logger.log(Destination.DEBUG_CLUSTER != false || Destination.getDEBUG() != false ? 8 : 4, "Message " + ref.getSysMessageID() + " is not " + r + " because it is in delivery to client consumer");
                ret.inreplacing = ref.inReplacing;
                ret.indelivery = ret.inreplacing == false;
                return ret;
            }
            if (r == RemoveReason.REMOVE_ADMIN) {
                this.logger.log(Destination.DEBUG_CLUSTER != false || Destination.getDEBUG() != false ? 8 : 4, "Message " + ref.getSysMessageID() + " can not " + r + " because it is in delivery to client client");
                ret.inreplacing = ref.inReplacing;
                ret.indelivery = ret.inreplacing == false;
                return ret;
            }
        }
        var9_9 = ref;
        synchronized (var9_9) {
            if (ref.getLBitSet()) {
                ref.setInvalid();
                if (r == RemoveReason.EXPIRED && ei != null) {
                    ei.clearReapCount();
                }
                this.logger.log(4, "LBit set for " + id);
                return ret;
            }
        }
        var9_9 = this.destMessagesInRemoving;
        synchronized (var9_9) {
            if (this.destMessagesInRemoving.get(id) != null && !wait) {
                this.logger.log(Destination.DEBUG_CLUSTER != false || Destination.getDEBUG() != false ? 8 : 4, "Reference " + id + " is being removed by another thread ");
                return ret;
            }
            this.destMessagesInRemoving.put(id, id);
        }
        var9_9 = this._removeMessageLock;
        synchronized (var9_9) {
            if (this.destMessages.get((Object)id) != null) ** break block35
            this.logger.log(Destination.DEBUG_CLUSTER != false || Destination.getDEBUG() != false ? 8 : 4, "Reference has already been removed for " + id);
            var10_11 = ret;
            // MONITOREXIT @DISABLED, blocks:[2, 3, 11] lbl69 : MonitorExitStatement: MONITOREXIT : var9_9
            this.destMessagesInRemoving.remove(id);
        }
        return var10_11;
        {
            block37: {
                if (!(this.isInternal() || r != RemoveReason.EXPIRED && r != RemoveReason.EXPIRED_BY_CLIENT && r != RemoveReason.EXPIRED_ON_DELIVERY && r != RemoveReason.REMOVED_LOW_PRIORITY && r != RemoveReason.REMOVED_OLDEST && r != RemoveReason.ERROR && r != RemoveReason.UNDELIVERABLE)) {
                    this.markDead(ref, r, dmqProps);
                }
                ref.setInvalid();
                if (remoteRef != null) break block37;
                ref = (PacketReference)this.destMessages.remove((Object)id, r);
                ** GOTO lbl89
            }
            errValue = PacketReference.createReference(null, null, null);
            o = (PacketReference)this.destMessages.removeWithValue((Object)id, (Object)remoteRef, (Object)errValue, r);
            if (o != errValue) ** break block36
            this.logger.log(Destination.DEBUG_CLUSTER != false || Destination.getDEBUG() != false ? 8 : 4, "Requeued message found on removing remote reference@" + remoteRef.hashCode() + "=" + remoteRef + "[" + id + "]");
            var12_15 = ret;
            // MONITOREXIT @DISABLED, blocks:[4, 11] lbl85 : MonitorExitStatement: MONITOREXIT : var9_9
            this.destMessagesInRemoving.remove(id);
        }
        return var12_15;
        {
            ref = o;
lbl89:
            // 2 sources

            // MONITOREXIT @DISABLED, blocks:[5, 6, 11] lbl92 : MonitorExitStatement: MONITOREXIT : var9_9
            {
                catch (Throwable var13_16) {
                    throw var13_16;
                }
            }
            if (ref == null) {
                this.logger.log(Destination.DEBUG_CLUSTER != false || Destination.getDEBUG() != false ? 8 : 4, "Reference has already gone for " + id);
                var9_9 = ret;
                return var9_9;
            }
            ret.storermerror = this._messageRemoved(ref, ref.byteSize(), r, true) == false;
            ref.destroy();
            var9_9 = this.dmc;
            synchronized (var9_9) {
                ++this.msgsOut;
                this.msgBytesOut += ref.byteSize();
                ++this.msgsOutInternal;
                if (this.msgsOutInternal >= 0x7FFFFFFFFFFFFFFFL) {
                    this.msgsInOutLastResetTime = System.currentTimeMillis();
                    this.msgsInInternal = 0L;
                    this.msgsOutInternal = 0L;
                }
            }
            if (ei != null && r != RemoveReason.EXPIRED && (er = this.expireReaper) != null) {
                er.removeMessage(ei);
            }
            if ((di = ref.getDeliveryTimeInfo()) != null && (dt = this.deliveryTimeTimer) != null) {
                dt.removeMessage(di);
            }
            ret.removed = true;
            var10_12 = ret;
            return var10_12;
        }
        {
            finally {
                this.destMessagesInRemoving.remove(id);
            }
        }
    }

    public String lookupReasonString(Reason r, long arrivalTime, long expireTime, long senderTime) {
        String reason = null;
        if (r == RemoveReason.EXPIRED || r == RemoveReason.EXPIRED_ON_DELIVERY || r == RemoveReason.EXPIRED_BY_CLIENT) {
            Object[] args = new String[]{this.getDestinationUID().toString(), Long.valueOf(expireTime).toString(), Long.valueOf(arrivalTime).toString(), Long.valueOf(senderTime).toString()};
            reason = r == RemoveReason.EXPIRED ? (arrivalTime != 0L && expireTime != 0L && expireTime <= arrivalTime ? this.br.getKString("B0065", args) : this.br.getKString("B0053", args)) : (r == RemoveReason.EXPIRED_ON_DELIVERY ? this.br.getKString("B0088", args) : (r == RemoveReason.EXPIRED_BY_CLIENT ? this.br.getKString("B0089", args) : this.br.getKString("B0053", args)));
        } else if (r == RemoveReason.REMOVED_LOW_PRIORITY || r == RemoveReason.REMOVED_OLDEST) {
            String countLimitStr = this.countLimit <= 0 ? Globals.getBrokerResources().getString("B0012") : String.valueOf(this.countLimit);
            String sizeLimitStr = this.memoryLimit == null || this.memoryLimit.getBytes() <= 0L ? Globals.getBrokerResources().getString("B0012") : this.memoryLimit.toString();
            Object[] args = new String[]{this.getDestinationUID().toString(), countLimitStr, sizeLimitStr};
            reason = this.br.getKString("B0054", args);
        } else {
            reason = r == RemoveReason.UNDELIVERABLE ? this.br.getKString("B0055", this.getDestinationUID().toString()) : this.br.getKString("B0056", this.getDestinationUID().toString());
        }
        return reason;
    }

    public void primaryInterestChanged(Consumer interest) {
    }

    public Consumer addConsumer(Consumer interest, boolean local) throws BrokerException, SelectorFormatException {
        return this.addConsumer(interest, local, null);
    }

    public Consumer addConsumer(Consumer interest, boolean local, Connection conn) throws BrokerException, SelectorFormatException {
        return this.addConsumer(interest, local, conn, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Consumer addConsumer(Consumer interest, boolean local, Connection conn, boolean loadIfActive) throws BrokerException, SelectorFormatException {
        Object object = this.consumers;
        synchronized (object) {
            if (this.consumers.get((Object)interest.getConsumerUID()) != null) {
                throw new ConsumerAlreadyAddedException(this.br.getKString("B1331", interest.getConsumerUID(), this.toString()));
            }
        }
        if (this.isInternal() && !BrokerMonitor.isENABLED()) {
            throw new BrokerException(this.br.getKString("B4181", this.getName()));
        }
        interest.attachToDestination(this, this.pstore);
        interest.addRemoveListener((EventBroadcaster)this.destMessages);
        if (!this.loaded && interest.isActive() && loadIfActive) {
            this.load();
        }
        object = this.consumers;
        synchronized (object) {
            if (this.maxConsumerLimit != -1 && this.maxConsumerLimit <= this.consumers.size()) {
                throw new BrokerException(this.br.getKString("B4182", this.getName(), String.valueOf(this.maxConsumerLimit)), "B4182", null, 409);
            }
            this.consumers.put((Object)interest.getConsumerUID(), (Object)interest);
            if (this.bm != null && this.consumers.size() == 1) {
                this.bm.start();
            }
            if (this.state == 1 || this.state == 3) {
                interest.pause("Destination PAUSE2");
            }
        }
        object = this;
        synchronized (object) {
            if (this.destReaper != null) {
                this.destReaper.cancel();
                this.destReaper = null;
            }
            this.clientReconnect();
        }
        if (this.bm != null) {
            this.bm.updateNewConsumer(interest);
        }
        return null;
    }

    @Override
    public void removeConsumer(ConsumerUID interest, boolean notify) throws BrokerException {
        this.removeConsumer(interest, null, false, notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(ConsumerUID interest, Map remotePendings, boolean remoteCleanup, boolean notify) throws BrokerException {
        MessageDeliveryTimeTimer dt;
        Consumer c = null;
        SimpleNFLHashMap simpleNFLHashMap = this.consumers;
        synchronized (simpleNFLHashMap) {
            c = (Consumer)this.consumers.remove((Object)interest);
            Destination destination = this;
            synchronized (destination) {
                if (this.bm != null && this.consumers.size() == 0) {
                    this.bm.stop();
                }
                if (this.shouldDestroy()) {
                    if (this.destReaper != null) {
                        this.destReaper.cancel();
                        this.destReaper = null;
                    }
                    this.destReaper = new DestReaperTask(this.uid);
                    try {
                        timer.schedule((TimerTask)this.destReaper, DestinationList.AUTOCREATE_EXPIRE);
                    }
                    catch (IllegalStateException ex) {
                        this.logger.log(4, "Can not reschedule task, timer has been canceled, the broker  is probably shutting down", (Throwable)ex);
                    }
                }
            }
        }
        if (c != null) {
            c.removeRemoveListener((EventBroadcaster)this.destMessages);
        }
        if ((dt = this.deliveryTimeTimer) != null) {
            dt.consumerClosed(c);
        }
        if (c != null && this.sendClusterUpdate() && notify) {
            Globals.getClusterBroadcast().destroyConsumer(c, remotePendings, remoteCleanup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyConsumerAdded(Consumer c, Connection conn) {
        SimpleNFLHashMap simpleNFLHashMap = this.consumers;
        synchronized (simpleNFLHashMap) {
            BrokerAddress ba = c.getConsumerUID().getBrokerAddress();
            if (ba == null || ba == Globals.getMyAddress()) {
                Globals.getConnectionManager().getConsumerInfoNotifyManager().consumerAdded(this, conn);
            } else {
                Globals.getConnectionManager().getConsumerInfoNotifyManager().remoteConsumerAdded(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyConsumerRemoved() {
        SimpleNFLHashMap simpleNFLHashMap = this.consumers;
        synchronized (simpleNFLHashMap) {
            Globals.getConnectionManager().getConsumerInfoNotifyManager().consumerRemoved(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addProducer(ProducerSpi producer) throws BrokerException {
        if (this.isInternal()) {
            throw new BrokerException(this.br.getKString("B4184", this.getName()));
        }
        if (this.maxProducerLimit != -1 && this.producers.size() >= this.maxProducerLimit) {
            throw new BrokerException(this.br.getKString("B4183", this.getName(), String.valueOf(this.maxProducerLimit)), "B4183", null, 409);
        }
        Destination destination = this;
        synchronized (destination) {
            if (this.destReaper != null) {
                this.destReaper.cancel();
                this.destReaper = null;
            }
        }
        if (!this.loaded) {
            this.load();
        }
        try {
            destination = this.producers;
            synchronized (destination) {
                this.producers.put((Object)producer.getProducerUID(), (Object)producer);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new BrokerException(this.br.getKString("B4183", this.getName(), String.valueOf(this.maxProducerLimit)), "B4183", ex, 409);
        }
        this.producerFlow.addProducer((Producer)producer);
        boolean active = this.producerFlow.checkResumeFlow((Producer)producer, false);
        this.logger.log(1, "Producer " + producer + " is " + active);
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProducer(ProducerUID producerUID) {
        Producer p = null;
        Object object = this.producers;
        synchronized (object) {
            p = (Producer)this.producers.remove((Object)producerUID);
        }
        if (p == null) {
            return;
        }
        this.producerFlow.removeProducer(p);
        this.producerFlow.checkResumeFlow(p, false);
        object = this;
        synchronized (object) {
            if (this.shouldDestroy()) {
                if (this.destReaper != null) {
                    this.destReaper.cancel();
                    this.destReaper = null;
                }
                this.destReaper = new DestReaperTask(this.uid);
                try {
                    timer.schedule((TimerTask)this.destReaper, DestinationList.AUTOCREATE_EXPIRE);
                }
                catch (IllegalStateException ex) {
                    this.logger.log(4, "Can not reschedule task, timer has been canceled, the broker is probably shutting down", (Throwable)ex);
                }
            }
        }
    }

    public abstract void sort(Comparator var1);

    public synchronized void load() throws BrokerException {
        this.load(false, null, null);
    }

    public synchronized void load(boolean noerrnotfound) throws BrokerException {
        this.load(false, null, null, null, null, noerrnotfound);
    }

    public synchronized void load(Set takeoverMsgs) throws BrokerException {
        this.load(false, null, null, null, takeoverMsgs, false);
    }

    protected synchronized Map load(boolean neverExpire, Map preparedAcks, Map transactionStates) throws BrokerException {
        return this.load(neverExpire, preparedAcks, transactionStates, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized LinkedHashMap load(boolean neverExpire, Map preparedAcks, Map transactionStates, Map committingTrans, Set takeoverMsgs, boolean noerrnotfound) throws BrokerException {
        if (Globals.getStore().getPartitionModeEnabled() && takeoverMsgs != null) {
            String emsg = this.br.getKString("B3100", ": Unexpected call:Destination.load(takeoverMsgs) for partition mode");
            BrokerException ex = new BrokerException(emsg);
            this.logger.logStack(32, emsg, (Throwable)ex);
            throw ex;
        }
        if (this.loaded) {
            return null;
        }
        this.logger.log(8, this.br.getKString("B1151", this.toString(), String.valueOf(this.size)) + this.logsuffix);
        LinkedHashMap<SysMessageID, TransactionUID> preparedTrans = null;
        boolean enforceLimit = true;
        HashSet<PacketReference> deadMsgs = new HashSet<PacketReference>();
        int maxloadcnt = this.size;
        int curcnt = 0;
        try {
            enforceLimit = this.destMessages.getEnforceLimits();
            this.destMessages.enforceLimits(false);
            Enumeration msgs = null;
            try {
                msgs = this.pstore.messageEnumeration(this);
            }
            catch (DestinationNotFoundException e) {
                if (noerrnotfound) {
                    this.logger.log(8, this.br.getKString("B1302", this.getName(), e.getMessage()));
                    return null;
                }
                throw e;
            }
            MessageDeliveryTimeTimer dt = this.deliveryTimeTimer;
            TreeSet<PacketReference> s = null;
            try {
                boolean takingoverCheck;
                HAMonitorService haMonitor = Globals.getHAMonitorService();
                boolean bl = takingoverCheck = takeoverMsgs == null && !Globals.getStore().getPartitionModeEnabled() && Globals.getHAEnabled() && haMonitor != null && haMonitor.checkTakingoverDestination(this);
                if (dt == null && !this.isDMQ()) {
                    if (!this.isValid()) {
                        String emsg = this.br.getKString("B4405", this.getDestinationUID());
                        this.logger.log(16, emsg);
                        throw new BrokerException(emsg);
                    }
                    String emsg = this.br.getKString("B4406", this.getDestinationUID());
                    this.logger.log(16, emsg);
                    throw new BrokerException(emsg);
                }
                s = new TreeSet<PacketReference>(new RefCompare());
                while (msgs.hasMoreElements()) {
                    PacketReference pr;
                    block72: {
                        Packet p = (Packet)msgs.nextElement();
                        pr = PacketReference.createReference(this.pstore, p, this.uid, null);
                        if (this.isDMQ()) {
                            pr.clearDeliveryTimeInfo();
                        }
                        if (takeoverMsgs != null && takeoverMsgs.contains(pr)) {
                            pr = null;
                            continue;
                        }
                        if (takingoverCheck && haMonitor.checkTakingoverMessage(p)) {
                            pr = null;
                            continue;
                        }
                        MessageDeliveryTimeInfo di = pr.getDeliveryTimeInfo();
                        if (di != null) {
                            dt.removeMessage(di);
                        }
                        if (neverExpire) {
                            pr.overrideExpireTime(0L);
                        }
                        pr.setLoaded();
                        if (Destination.getDEBUG()) {
                            this.logger.log(8, "Loaded Message " + p + " into destination " + this);
                        }
                        try {
                            if (this.isDMQ || this.DL.addNewMessage(false, pr).getReturn()) break block72;
                            deadMsgs.add(pr);
                        }
                        catch (Exception ex) {
                            Object[] args = new String[]{pr.getSysMessageID().toString(), pr.getDestinationUID().toString(), ex.getMessage()};
                            this.logger.logStack(16, "B2089", args, (Throwable)ex);
                            continue;
                        }
                    }
                    s.add(pr);
                    this.DL.packetlistAdd(pr.getSysMessageID(), pr.getDestinationUID(), null);
                    if (++curcnt <= 0 || curcnt % LOAD_COUNT != 0 && (curcnt <= LOAD_COUNT || curcnt != this.size)) continue;
                    Object[] args = new String[]{this.toString(), String.valueOf(curcnt), String.valueOf(maxloadcnt), String.valueOf(curcnt * 100 / maxloadcnt)};
                    this.logger.log(8, "B1153", args);
                }
            }
            finally {
                this.pstore.closeEnumeration(msgs);
            }
            if (FaultInjection.getInjection().FAULT_INJECTION) {
                FaultInjection fi = FaultInjection.getInjection();
                try {
                    fi.checkFaultAndThrowBrokerException("load.dst.1_5", null);
                }
                catch (BrokerException e) {
                    fi.unsetFault("load.dst.1_5");
                    throw e;
                }
            }
            for (PacketReference pr : s) {
                TransactionUID sendtid;
                ConsumerUID[] consumers = this.pstore.getConsumerUIDs(this.getDestinationUID(), pr.getSysMessageID());
                if (consumers == null) {
                    consumers = new ConsumerUID[]{};
                }
                if (Destination.getDEBUG()) {
                    this.logger.log(8, consumers.length + " stored consumers for " + pr + ":" + this.getDestinationUID());
                }
                if (consumers.length == 0 && this.pstore.hasMessageBeenAcked(this.uid, pr.getSysMessageID())) {
                    if (Destination.getDEBUG()) {
                        this.logger.log(8, "Message " + pr.getSysMessageID() + "[" + this + "] has been acked, destory..");
                    }
                    this.decrementDestinationSize(pr);
                    this.DL.removePacketList(pr.getSysMessageID(), pr.getDestinationUID(), pr);
                    pr.destroy();
                    continue;
                }
                if (consumers.length > 0) {
                    pr.setStoredWithInterest(true);
                } else {
                    pr.setStoredWithInterest(false);
                }
                MessageDeliveryTimeInfo di = pr.getDeliveryTimeInfo();
                boolean dontRoute = false;
                boolean delayDelivery = false;
                if (di != null && !di.isDeliveryDue()) {
                    dt.addMessage(di);
                    delayDelivery = true;
                    dontRoute = true;
                }
                if ((sendtid = pr.getTransactionID()) != null) {
                    Boolean state = transactionStates == null ? null : transactionStates.get(sendtid);
                    if (state == null) {
                        if (consumers.length == 0 && !delayDelivery) {
                            try {
                                consumers = this.routeLoadedTransactionMessage(pr);
                            }
                            catch (Exception ex) {
                                this.logger.logStack(16, this.br.getKString("B2281", pr.getSysMessageID(), ex.getMessage()), (Throwable)ex);
                            }
                            if (consumers.length > 0) {
                                int[] states = new int[consumers.length];
                                for (int i = 0; i < states.length; ++i) {
                                    states[i] = 0;
                                }
                                try {
                                    this.pstore.storeInterestStates(this.getDestinationUID(), pr.getSysMessageID(), consumers, states, true, null);
                                    pr.setStoredWithInterest(true);
                                }
                                catch (Exception i) {}
                            } else {
                                if (Destination.getDEBUG()) {
                                    this.logger.log(8, "Message " + pr.getSysMessageID() + " [TUID=" + pr.getTransactionID() + ", " + this + "] no interest, destroy...");
                                }
                                this.decrementDestinationSize(pr);
                                this.DL.removePacketList(pr.getSysMessageID(), pr.getDestinationUID(), pr);
                                pr.destroy();
                                continue;
                            }
                        }
                    } else if (state.equals(Boolean.TRUE)) {
                        if (preparedTrans == null) {
                            preparedTrans = new LinkedHashMap<SysMessageID, TransactionUID>();
                        }
                        preparedTrans.put(pr.getSysMessageID(), pr.getTransactionID());
                        dontRoute = true;
                    } else {
                        if (Destination.getDEBUG()) {
                            this.logger.log(8, "Message " + pr.getSysMessageID() + " [TUID=" + pr.getTransactionID() + ", " + this + "] to be rolled back, destroy...");
                        }
                        this.decrementDestinationSize(pr);
                        this.DL.removePacketList(pr.getSysMessageID(), pr.getDestinationUID(), pr);
                        pr.destroy();
                        continue;
                    }
                }
                if (consumers.length == 0 && !dontRoute) {
                    if (Destination.getDEBUG()) {
                        this.logger.log(8, "No consumer and dontRoute: Unrouted packet " + pr + ", " + this);
                    }
                    this.decrementDestinationSize(pr);
                    this.DL.removePacketList(pr.getSysMessageID(), pr.getDestinationUID(), pr);
                    pr.destroy();
                    continue;
                }
                int[] states = new int[consumers.length];
                for (int i = 0; i < consumers.length; ++i) {
                    states[i] = this.pstore.getInterestState(this.getDestinationUID(), pr.getSysMessageID(), consumers[i]);
                }
                if (consumers.length > 0) {
                    pr.update(consumers, states);
                }
                try {
                    this.putMessage(pr, AddReason.LOADED);
                }
                catch (OutOfLimitsException | IllegalStateException ex) {
                    Object[] args = new String[]{pr.getSysMessageID().toString(), pr.getDestinationUID().toString(), ex.getMessage()};
                    this.logger.logStack(16, "B2089", args, ex);
                    continue;
                }
                ExpirationInfo ei = pr.getExpireInfo();
                if (ei != null && this.expireReaper != null) {
                    this.expireReaper.addExpiringMessage(ei);
                }
                List<ConsumerUID> consumerList = Arrays.asList(consumers);
                Map transCidToState = preparedAcks == null ? null : preparedAcks.get(pr.getSysMessageID());
                if (transCidToState != null) {
                    consumerList = new ArrayList<ConsumerUID>(consumerList);
                    Iterator<ConsumerUID> citr = consumerList.iterator();
                    while (citr.hasNext()) {
                        ConsumerUID cuid = citr.next();
                        TransactionUID tid = (TransactionUID)transCidToState.get(cuid);
                        Boolean state = Boolean.FALSE;
                        if (tid != null) {
                            state = transactionStates == null ? null : transactionStates.get(tid);
                        }
                        if (state == null) {
                            if (Destination.getDEBUG()) {
                                this.logger.log(8, "Consumed message has committed state " + pr.getSysMessageID() + " [TUID=" + tid + ", " + this + "], consumer: " + cuid);
                            }
                            if (pr.acknowledged(cuid, cuid, false, true)) {
                                if (committingTrans != null && committingTrans.get(tid) != null) {
                                    this.unputMessage(pr, RemoveReason.ACKNOWLEDGED);
                                }
                                this.decrementDestinationSize(pr);
                                this.DL.removePacketList(pr.getSysMessageID(), pr.getDestinationUID(), pr);
                                pr.destroy();
                                if (Destination.getDEBUG()) {
                                    this.logger.log(8, "Remove committed consumed message " + pr.getSysMessageID() + " [TUID=" + tid + ", " + this + "], consumer: " + cuid);
                                }
                            }
                            citr.remove();
                            continue;
                        }
                        if (state.equals(Boolean.TRUE)) {
                            citr.remove();
                            continue;
                        }
                        if (!state.equals(Boolean.FALSE) || !Destination.getDEBUG()) continue;
                        this.logger.log(8, "Redeliver message " + pr.getSysMessageID() + " [TUID=" + tid + ", " + this + "] to consumer " + cuid);
                    }
                }
                this.loaded = true;
                if (!dontRoute) {
                    if (Destination.getDEBUG()) {
                        this.logger.log(8, "Route loaded message " + pr.getSysMessageID() + " [" + this + "] to consumers " + consumerList);
                    }
                    if (di != null) {
                        this.forwardDeliveryDelayedMessage(new HashSet<ConsumerUID>(consumerList), pr);
                        continue;
                    }
                    this.routeLoadedMessage(pr, consumerList);
                    continue;
                }
                if (!delayDelivery) continue;
                di.setDeliveryReady();
            }
        }
        catch (Throwable ex) {
            String emsg = Globals.getBrokerResources().getKString("B2085", this.getName());
            this.logger.logStack(32, emsg, ex);
            this.loaded = true;
            this.unload(true);
            throw new BrokerException(emsg, ex);
        }
        this.destMessages.enforceLimits(enforceLimit);
        this.loaded = true;
        Iterator deaditr = deadMsgs.iterator();
        while (true) {
            if (!deaditr.hasNext()) {
                this.logger.log(8, this.br.getKString("B1152", this.toString(), String.valueOf(this.size)) + this.logsuffix);
                return preparedTrans;
            }
            PacketReference pr = (PacketReference)deaditr.next();
            try {
                if (preparedTrans != null) {
                    preparedTrans.remove(pr.getSysMessageID());
                }
                this.removeMessage(pr.getSysMessageID(), RemoveReason.EXPIRED);
            }
            catch (Exception ex) {
                this.logger.logStack(8, "B3100", (Object)("Processing " + pr + " while loading destination " + this), (Throwable)ex);
                continue;
            }
            break;
        }
    }

    protected void routeLoadedMessage(PacketReference ref, List consumerids) throws BrokerException, SelectorFormatException {
        if (consumerids == null || consumerids.size() == 0) {
            return;
        }
        for (ConsumerUID cuid : consumerids) {
            if (cuid == PacketReference.getQueueUID()) {
                Set s = this.routeNewMessage(ref);
                this.forwardMessage(s, ref);
                continue;
            }
            Consumer c = (Consumer)this.consumers.get((Object)cuid);
            if (c == null) {
                Set s = this.routeNewMessage(ref);
                this.forwardMessage(s, ref);
                continue;
            }
            c.routeMessage(ref, false);
        }
    }

    protected Consumer getConsumer(ConsumerUID uid) {
        return (Consumer)this.consumers.get((Object)uid);
    }

    public void unload(boolean refs) {
        this.unload(refs, false);
    }

    protected void unload(boolean refs, boolean closePartition) {
        block9: {
            if (Destination.getDEBUG()) {
                this.logger.log(4, "Unloading " + this);
            }
            if (!this.loaded) {
                return;
            }
            this.bytes = this.destMessages.byteSize();
            this.size = this.destMessages.size();
            Map m = this.destMessages.getAll(closePartition ? null : this.unloadfilter);
            try {
                if (refs) {
                    for (PacketReference ref : m.values()) {
                        this.destMessages.remove((Object)ref.getSysMessageID(), (Reason)RemoveReason.UNLOADED);
                        ref.clear();
                    }
                    this.destMessages = new SimpleNFLHashMap();
                    this.remoteSize = 0;
                    this.remoteBytes = 0L;
                    this.loaded = false;
                    if (!closePartition) {
                        this.initialize();
                    }
                } else {
                    for (PacketReference ref : this.destMessages.values()) {
                        ref.unload();
                    }
                }
            }
            catch (Throwable thr) {
                this.logger.logStack(16, "B3100", (Object)("Unloading destination " + this), thr);
                this.destMessages = new SimpleNFLHashMap();
                this.remoteSize = 0;
                this.remoteBytes = 0L;
                this.loaded = false;
                if (closePartition) break block9;
                this.initialize();
            }
        }
    }

    protected void destroy(String destroyReason) throws IOException, BrokerException {
        this.destroy(destroyReason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy(String destroyReason, boolean noerrnotfound) throws IOException, BrokerException {
        Object object = this.DL.destinationList;
        synchronized (object) {
            this.destvalid = false;
        }
        object = this;
        synchronized (object) {
            if (this.destReaper != null) {
                this.destReaper.cancel();
                this.destReaper = null;
            }
            if (this.reconnectReaper != null) {
                this.reconnectReaper.cancel();
                this.reconnectReaper = null;
            }
            if (this.expireReaper != null) {
                this.expireReaper.destroy();
                this.expireReaper = null;
            }
            if (this.deliveryTimeTimer != null) {
                this.deliveryTimeTimer.destroy();
            }
            if (!this.neverStore || this.stored) {
                this.purgeDestination(noerrnotfound);
                try {
                    this.pstore.removeDestination(this, PERSIST_SYNC);
                }
                catch (DestinationNotFoundException e) {
                    if (!noerrnotfound) {
                        throw e;
                    }
                    this.logger.log(8, this.br.getKString("B1304", this.getName(), e.getMessage()));
                }
                this.stored = false;
            }
            if (this.deliveryTimeTimer != null) {
                this.deliveryTimeTimer = null;
            }
        }
        Globals.getLogger().log(8, "B1159", (Object)this.getName());
    }

    public void routeCommittedMessageWithDeliveryTime(PacketReference ref) throws BrokerException {
        MessageDeliveryTimeTimer dt = this.deliveryTimeTimer;
        if (dt != null) {
            dt.routeTransactedMessage(ref);
        }
    }

    public String toString() {
        return this.uid.getLocalizedName();
    }

    @Override
    public String getUniqueName() {
        return this.uid.toString();
    }

    public void eventOccured(EventType type, Reason r, Object target, Object oldValue, Object newValue, Object userdata) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _messageAdded(PacketReference ref, Reason r, boolean overrideRemote) {
        if (r == AddReason.LOADED) {
            if (ref.isLocal() && overrideRemote) {
                Object object = this.sizeLock;
                synchronized (object) {
                    long objsize = ref.byteSize();
                    --this.remoteSize;
                    this.remoteBytes -= objsize;
                    --this.size;
                    this.bytes -= objsize;
                    DestinationList.decrementTotals(objsize, false);
                }
            }
            return;
        }
        this.incrementDestinationSize(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _messageRemoved(PacketReference ref, long objsize, Reason r, boolean doCount) {
        if (ref == null) {
            return true;
        }
        this.DL.removePacketList(ref.getSysMessageID(), this.getDestinationUID(), ref);
        if (!doCount) {
            return true;
        }
        boolean onRollback = false;
        Destination destination = this;
        synchronized (destination) {
            if (r == RemoveReason.REMOVED_LOW_PRIORITY || r == RemoveReason.REMOVED_OLDEST || r == RemoveReason.REMOVED_OTHER) {
                ++this.discardedCnt;
            } else if (r == RemoveReason.EXPIRED || r == RemoveReason.EXPIRED_BY_CLIENT || r == RemoveReason.EXPIRED_ON_DELIVERY) {
                ++this.expiredCnt;
            } else if (r == RemoveReason.PURGED) {
                ++this.purgedCnt;
            } else if (r == RemoveReason.ROLLBACK) {
                ++this.rollbackCnt;
                onRollback = true;
            } else if (r == RemoveReason.ACKNOWLEDGED) {
                ++this.ackedCnt;
            } else if (r == RemoveReason.OVERFLOW) {
                ++this.overflowCnt;
            } else if (r == RemoveReason.ERROR) {
                ++this.errorCnt;
            }
            this.decrementDestinationSize(ref);
        }
        boolean ret = ref.remove(onRollback);
        this.producerFlow.checkResumeFlow(null, true);
        return ret;
    }

    public boolean shouldDestroy() {
        HAMonitorService haMonitor;
        if (Globals.getHAEnabled() && (haMonitor = Globals.getHAMonitorService()) != null && haMonitor.checkTakingoverDestination(this)) {
            this.logger.log(4, "B4087", (Object)this.getUniqueName(), (Object)"destination is being taken over");
            return false;
        }
        return this.size() == 0 && this.isAutoCreated() && !this.isTemporary() && this.producers.isEmpty() && this.consumers.isEmpty();
    }

    public void overridePersistence(boolean persist) {
        this.neverStore = !persist;
        this.overrideP = true;
        this.overridePvalue = persist;
    }

    public void clearOverridePersistence() {
        this.overrideP = false;
    }

    public void overrideTTL(long ttl) {
        this.overrideTTL = true;
        this.overrideTTLvalue = ttl;
    }

    public void clearOverrideTTL() {
        this.overrideTTL = false;
    }

    public boolean shouldOverridePersistence() {
        return this.overrideP;
    }

    public boolean getOverridePersistence() {
        return this.overridePvalue;
    }

    public boolean shouldOverrideTTL() {
        return this.overrideTTL;
    }

    public long getOverrideTTL() {
        return this.overrideTTLvalue;
    }

    @Override
    public boolean isInternal() {
        boolean ret = DestType.isInternal((int)this.type);
        return ret;
    }

    @Override
    public boolean isDMQ() {
        boolean ret = DestType.isDMQ((int)this.type);
        return ret;
    }

    public boolean isAdmin() {
        boolean ret = DestType.isAdmin((int)this.type);
        return ret;
    }

    public int getConsumerCount() {
        return this.consumers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getConsumers() {
        ArrayList l = null;
        SimpleNFLHashMap simpleNFLHashMap = this.consumers;
        synchronized (simpleNFLHashMap) {
            l = new ArrayList(this.consumers.values());
        }
        return l.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllActiveConsumers() {
        ArrayList<Consumer> l = new ArrayList<Consumer>();
        SimpleNFLHashMap simpleNFLHashMap = this.consumers;
        synchronized (simpleNFLHashMap) {
            Iterator itr = this.consumers.values().iterator();
            Consumer c = null;
            while (itr.hasNext()) {
                c = (Consumer)itr.next();
                if (c instanceof Subscription) {
                    l.addAll(((Subscription)c).getChildConsumers());
                    continue;
                }
                l.add(c);
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getProducers() {
        ArrayList l = null;
        SimpleNFLHashMap simpleNFLHashMap = this.producers;
        synchronized (simpleNFLHashMap) {
            l = new ArrayList(this.producers.values());
        }
        return l.iterator();
    }

    public int getProducerCount() {
        return this.producers.size();
    }

    @Override
    public int getMaxPrefetch() {
        return this.maxPrefetch;
    }

    public void setMaxPrefetch(int prefetch) {
        Long oldVal = this.maxPrefetch;
        this.maxPrefetch = prefetch;
        this.notifyAttrUpdated(128, oldVal, this.maxPrefetch);
    }

    public void setMaxSharedConsumers(int max) {
    }

    public void setSharedFlowLimit(int prefetch) {
    }

    public int getMaxNumSharedConsumers() {
        return -1;
    }

    public int getSharedConsumerFlowLimit() {
        return 5;
    }

    public long getMsgBytesProducerFlow() {
        if (DestinationList.NO_PRODUCER_FLOW) {
            return -1L;
        }
        long bytes = 0L;
        bytes = this.msgSizeLimit == null || this.msgSizeLimit.getBytes() <= 0L ? -1L : this.msgSizeLimit.getBytes();
        return bytes;
    }

    @Override
    public long getBytesProducerFlow() {
        if (DestinationList.NO_PRODUCER_FLOW) {
            return -1L;
        }
        return this.producerMsgBatchBytes;
    }

    @Override
    public int getSizeProducerFlow() {
        if (DestinationList.NO_PRODUCER_FLOW) {
            return -1;
        }
        return this.producerMsgBatchSize;
    }

    public void forceResumeFlow(ProducerSpi p) {
        this.producerFlow.pauseProducer((Producer)p);
        this.producerFlow.forceResumeFlow((Producer)p);
    }

    public boolean producerFlow(IMQConnection con, Producer producer) {
        this.producerFlow.pauseProducer(producer);
        boolean retval = this.producerFlow.checkResumeFlow(producer, true);
        this.logger.log(1, "producerFlow " + producer + " resumed: " + retval);
        return retval;
    }

    public boolean isValid() {
        return this.DL.isValid() && this.destvalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRefCount() throws BrokerException {
        Map map = this.DL.destinationList;
        synchronized (map) {
            if (!this.DL.isValid()) {
                throw new IllegalStateException("Broker Shutting down");
            }
            if (!this.isValid()) {
                throw new BrokerException("Destination already destroyed");
            }
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void decrementRefCount() {
        Map map = this.DL.destinationList;
        synchronized (map) {
            --this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRefCount() {
        Map map = this.DL.destinationList;
        synchronized (map) {
            return this.refCount;
        }
    }

    protected void setClusterNotifyFlag(boolean b) {
        this.clusterNotifyFlag = b;
    }

    protected boolean getClusterNotifyFlag() {
        return this.clusterNotifyFlag;
    }

    public void updateDestination() throws BrokerException, IOException {
        this.update(true);
    }

    public void debug() {
        this.logger.log(8, "Dumping state for destination " + this);
        this.logger.log(8, "Consumer Count " + this.consumers.size());
        this.logger.log(8, "Producer Count " + this.producers.size());
        this.logger.log(8, "Message count " + this.destMessages.size());
        this.logger.log(8, " --------- consumers");
        for (Consumer c : this.consumers.values()) {
            c.debug("\t");
        }
    }

    public PacketReference getMessage(SysMessageID id) {
        return (PacketReference)this.destMessages.get((Object)id);
    }

    private RemoveMessageReturnInfo removeExpiredMessage(DestinationUID duid, SysMessageID id) throws BrokerException {
        RemoveMessageReturnInfo ret = null;
        if (duid == null) {
            throw new RuntimeException("expired messages");
        }
        Destination d = this.DL.findDestination(duid);
        if (d != null) {
            ret = d._removeMessage(id, RemoveReason.EXPIRED, null, null, true);
            if (ret.removed) {
                this.DL.removePacketList(id, d.getDestinationUID(), null);
            }
        }
        if (ret == null) {
            ret = new RemoveMessageReturnInfo();
            ret.removed = false;
            ret.indelivery = false;
        }
        return ret;
    }

    @Override
    public boolean isProducerActive(ProducerUID uid) {
        return this.producerFlow.isProducerActive(uid);
    }

    public void notifyAttrUpdated(int attr, Object oldVal, Object newVal) {
        Agent agent = Globals.getAgent();
        if (agent != null) {
            agent.notifyDestinationAttrUpdated(this, attr, oldVal, newVal);
        }
    }

    @Override
    public void setValidateXMLSchemaEnabled(boolean b) {
        this.validateXMLSchemaEnabled = b;
    }

    @Override
    public boolean validateXMLSchemaEnabled() {
        return this.validateXMLSchemaEnabled;
    }

    @Override
    public void setXMLSchemaUriList(String s) {
        this.XMLSchemaUriList = s;
    }

    @Override
    public String getXMLSchemaUriList() {
        return this.XMLSchemaUriList;
    }

    @Override
    public void setReloadXMLSchemaOnFailure(boolean b) {
        this.reloadXMLSchemaOnFailure = b;
    }

    @Override
    public boolean reloadXMLSchemaOnFailure() {
        return this.reloadXMLSchemaOnFailure;
    }

    class ProducerFlow {
        Map pausedProducerMap = new LinkedHashMap();
        Map activeProducerMap = new LinkedHashMap();

        ProducerFlow() {
        }

        public synchronized int pausedProducerCnt() {
            return this.pausedProducerMap.size();
        }

        public synchronized int activeProducerCnt() {
            return this.activeProducerMap.size();
        }

        public synchronized Vector getDebugPausedProducers() {
            Vector<String> v = new Vector<String>();
            Iterator itr = this.pausedProducerMap.values().iterator();
            while (itr.hasNext()) {
                try {
                    ProducerUID pid = ((Producer)itr.next()).getProducerUID();
                    v.add(String.valueOf(pid.longValue()));
                }
                catch (Exception ex) {
                    v.add(ex.toString());
                }
            }
            return v;
        }

        public synchronized Vector getDebugActiveProducers() {
            Vector<String> v = new Vector<String>();
            Iterator itr = this.activeProducerMap.values().iterator();
            while (itr.hasNext()) {
                try {
                    ProducerUID pid = ((Producer)itr.next()).getProducerUID();
                    v.add(String.valueOf(pid.longValue()));
                }
                catch (Exception ex) {
                    v.add(ex.toString());
                }
            }
            return v;
        }

        private void sendResumeFlow(Producer p, boolean pause, String reason) {
            int sz = 0;
            long bs = 0L;
            long mbytes = 0L;
            if (!pause) {
                sz = Destination.this.producerMsgBatchSize;
                bs = Destination.this.producerMsgBatchBytes;
                mbytes = Destination.this.getMsgBytesProducerFlow();
            }
            p.sendResumeFlow(Destination.this.getDestinationUID(), sz, bs, mbytes, reason, false, DestinationList.MAX_PRODUCER_BATCH);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAllProducers(int why, String info) {
            if (why == 0) {
                ProducerFlow producerFlow = this;
                synchronized (producerFlow) {
                    Iterator itr = this.activeProducerMap.values().iterator();
                    while (itr.hasNext()) {
                        Producer p = (Producer)itr.next();
                        this.pausedProducerMap.put(p.getProducerUID(), p);
                        itr.remove();
                        p.pause();
                        this.sendResumeFlow(p, true, info);
                    }
                }
            }
            if (why == 1) {
                this.checkResumeFlow(null, true, info);
            } else if (why == 2 || why == 3) {
                ProducerFlow producerFlow = this;
                synchronized (producerFlow) {
                    for (Producer p : this.activeProducerMap.values()) {
                        this.sendResumeFlow(p, false, info);
                    }
                }
            }
        }

        public synchronized boolean pauseProducer(Producer producer) {
            boolean wasActive = false;
            if (this.activeProducerMap.remove((Object)producer.getProducerUID()) != null) {
                this.pausedProducerMap.put(producer.getProducerUID(), producer);
                wasActive = true;
            }
            producer.pause();
            return wasActive;
        }

        public boolean isProducerActive(ProducerUID uid) {
            return this.pausedProducerMap.get((Object)uid) == null;
        }

        public boolean checkResumeFlow(Producer p, boolean notify) {
            return this.checkResumeFlow(p, notify, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkResumeFlow(Producer producer, boolean notify, String info) {
            ProducerFlow producerFlow = this;
            synchronized (producerFlow) {
                if (Destination.this.state == 2 || Destination.this.state == 3) {
                    if (this.activeProducerMap != null) {
                        Iterator itr = this.activeProducerMap.values().iterator();
                        while (itr.hasNext()) {
                            Producer p = (Producer)itr.next();
                            this.pausedProducerMap.put(p.getProducerUID(), p);
                            itr.remove();
                            p.pause();
                            boolean shouldNotify = notify || producer != null && !p.getProducerUID().equals((Object)producer.getProducerUID());
                            if (!shouldNotify) continue;
                            this.sendResumeFlow(p, true, (String)info);
                        }
                    }
                    return false;
                }
                if (Destination.this.limit != 0) {
                    if (this.pausedProducerMap != null) {
                        Iterator itr = this.pausedProducerMap.values().iterator();
                        while (itr.hasNext()) {
                            Producer p = (Producer)itr.next();
                            this.activeProducerMap.put(p.getProducerUID(), p);
                            itr.remove();
                            p.resume();
                            boolean shouldNotify = notify || producer != null && !p.getProducerUID().equals((Object)producer.getProducerUID());
                            if (!shouldNotify) continue;
                            this.sendResumeFlow(p, false, (String)info);
                        }
                    }
                    return true;
                }
            }
            boolean resumedProducer = false;
            SimpleNFLHashMap<SysMessageID, PacketReference> simpleNFLHashMap = Destination.this.destMessages;
            synchronized (simpleNFLHashMap) {
                int fs = Destination.this.destMessages.freeSpace();
                long fsb = Destination.this.destMessages.freeBytes();
                ProducerFlow producerFlow2 = this;
                synchronized (producerFlow2) {
                    Iterator itr = this.pausedProducerMap.values().iterator();
                    while (itr.hasNext() && (fs == -1 || fs > 0 && fs > this.activeProducerMap.size() * Destination.this.producerMsgBatchSize) && (fsb == -1L || fsb > 0L && fsb > (long)this.activeProducerMap.size() * Destination.this.producerMsgBatchBytes)) {
                        Producer p = (Producer)itr.next();
                        if (!p.isValid()) continue;
                        if (Destination.getDEBUG()) {
                            Logger cfr_ignored_0 = Destination.this.logger;
                            Destination.this.logger.log(1, "Resuming producer " + p + " The destination has " + fs + " more space and " + this.activeProducerMap.size() + " active producers [ batch size " + Destination.this.producerMsgBatchSize + "  msg " + Destination.this.destMessages.size());
                        }
                        this.activeProducerMap.put(p.getProducerUID(), p);
                        itr.remove();
                        p.resume();
                        boolean shouldNotify = notify || producer != null && !p.getProducerUID().equals((Object)producer.getProducerUID());
                        if (!shouldNotify) continue;
                        if (info == null) {
                            info = "Producer " + p.getProducerUID() + " has become active";
                        }
                        this.sendResumeFlow(p, false, (String)info);
                    }
                    if (producer != null) {
                        resumedProducer = this.activeProducerMap.containsKey((Object)producer.getProducerUID());
                    }
                }
            }
            return resumedProducer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forceResumeFlow(Producer p) {
            SimpleNFLHashMap<SysMessageID, PacketReference> simpleNFLHashMap = Destination.this.destMessages;
            synchronized (simpleNFLHashMap) {
                int fs = Destination.this.destMessages.freeSpace();
                long fsb = Destination.this.destMessages.freeBytes();
                ProducerFlow producerFlow = this;
                synchronized (producerFlow) {
                    if (!(fs != -1 && fs < this.activeProducerMap.size() * Destination.this.producerMsgBatchSize || fsb != -1L && fsb < (long)this.activeProducerMap.size() * Destination.this.producerMsgBatchBytes)) {
                        this.activeProducerMap.put(p.getProducerUID(), p);
                        this.pausedProducerMap.remove((Object)p.getProducerUID());
                        p.resume();
                        this.sendResumeFlow(p, false, "Producer " + p.getProducerUID() + " has become active");
                    }
                }
            }
        }

        public synchronized boolean removeProducer(Producer producer) {
            producer.destroy();
            Object oldobj = this.activeProducerMap.remove((Object)producer.getProducerUID());
            this.pausedProducerMap.remove((Object)producer.getProducerUID());
            return oldobj != null;
        }

        public synchronized boolean addProducer(Producer producer) {
            Producer o = this.pausedProducerMap.put(producer.getProducerUID(), producer);
            return o == null;
        }
    }

    static class UnloadFilter
    implements Filter {
        UnloadFilter() {
        }

        public boolean matches(Object o) {
            assert (o instanceof PacketReference);
            return ((PacketReference)o).isPersistent();
        }
    }

    public static class RemoveMessageReturnInfo {
        public boolean removed = false;
        public boolean indelivery = false;
        public boolean inreplacing = false;
        public boolean storermerror = false;
    }

    class DestFilter
    implements Filter {
        DestFilter() {
        }

        public boolean matches(Object o) {
            return Destination.this.uid.equals(((PacketReference)o).getDestinationUID());
        }
    }

    class MsgExpirationReaper {
        SortedSet messages = new TreeSet(ExpirationInfo.getComparator());
        TimerTask mytimer = null;

        MsgExpirationReaper() {
        }

        public synchronized void addExpiringMessage(ExpirationInfo ei) {
            this.messages.add(ei);
            if (this.mytimer == null) {
                this.addTimer();
            }
        }

        public synchronized void removeMessage(ExpirationInfo ei) {
            boolean rem = this.messages.remove(ei);
            if (rem && this.messages.isEmpty()) {
                this.removeTimer();
            }
        }

        public synchronized void destroy() {
            if (this.mytimer != null) {
                this.removeTimer();
            }
            this.messages.clear();
        }

        void addTimer() {
            assert (Thread.holdsLock(this));
            assert (this.mytimer == null);
            this.mytimer = new MyExpireTimerTask();
            try {
                DestinationList cfr_ignored_0 = Destination.this.DL;
                DestinationList cfr_ignored_1 = Destination.this.DL;
                timer.schedule(this.mytimer, DestinationList.MESSAGE_EXPIRE, DestinationList.MESSAGE_EXPIRE);
            }
            catch (IllegalStateException ex) {
                Destination.this.logger.log(8, "B3100", (Object)("Canceling message expiration on " + this), (Throwable)ex);
            }
        }

        void removeTimer() {
            assert (Thread.holdsLock(this));
            try {
                if (this.mytimer != null) {
                    this.mytimer.cancel();
                }
            }
            catch (IllegalStateException ex) {
                Destination.this.logger.logStack(4, "timer canceled ", (Throwable)ex);
            }
            this.mytimer = null;
        }

        class MyExpireTimerTask
        extends TimerTask {
            MyExpireTimerTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long currentTime = System.currentTimeMillis();
                int removedCount = 0;
                int indeliveryCount = 0;
                LinkedHashSet<ExpirationInfo> removed = new LinkedHashSet<ExpirationInfo>();
                DestinationUID duid = Destination.this.uid;
                MsgExpirationReaper msgExpirationReaper = MsgExpirationReaper.this;
                synchronized (msgExpirationReaper) {
                    for (ExpirationInfo ei : MsgExpirationReaper.this.messages) {
                        if (ei.getExpireTime() > currentTime) {
                            if (!Destination.FI.FAULT_INJECTION) break;
                            if (!FI.checkFault("msg.expirereaper.expire1", null)) break;
                            FI.unsetFault("msg.expirereaper.expire1");
                            removed.add(ei);
                            continue;
                        }
                        removed.add(ei);
                    }
                }
                for (ExpirationInfo ei : removed) {
                    try {
                        ei.incrementReapCount();
                        RemoveMessageReturnInfo ret = Destination.this.removeExpiredMessage(duid, ei.id);
                        if (ret.removed) {
                            MsgExpirationReaper.this.removeMessage(ei);
                            ++removedCount;
                            continue;
                        }
                        if (ret.indelivery) {
                            ++indeliveryCount;
                            continue;
                        }
                        if (ei.getReapCount() <= 1) continue;
                        MsgExpirationReaper.this.removeMessage(ei);
                        ++removedCount;
                    }
                    catch (Exception ex) {
                        Destination.this.logger.logStack(16, ex.getMessage(), (Throwable)ex);
                    }
                }
                if (removedCount > 0) {
                    Destination.this.logger.log(8, "B1140", (Object)String.valueOf(removedCount), (Object)duid.getLocalizedName());
                }
                if (indeliveryCount > 0) {
                    Destination.this.logger.log(8, "B1389", (Object)String.valueOf(indeliveryCount), (Object)duid.getLocalizedName());
                }
                removed.clear();
            }
        }
    }

    class ReconnectReaperTask
    extends TimerTask {
        DestinationUID uid = null;
        private boolean canceled = false;
        private long time = 0L;

        ReconnectReaperTask(DestinationUID uid, long time) {
            this.uid = uid;
            this.time = time;
        }

        @Override
        public synchronized boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReconnectReaperTask reconnectReaperTask = this;
            synchronized (reconnectReaperTask) {
                if (this.canceled) {
                    return;
                }
            }
            Globals.getLogger().log(4, "Destroying temp destination " + this.uid + " inactive for " + this.time / 1000L + " seconds");
            try {
                Destination.this.DL.removeDestination(this.uid, false, Globals.getBrokerResources().getString("B0070"));
            }
            catch (Exception ex) {
                if (BrokerStateHandler.isShuttingDown()) {
                    Globals.getLogger().log(8, "B4144", (Object)this.uid.getLocalizedName(), (Throwable)ex);
                }
                Globals.getLogger().logStack(16, "B4144", (Object)this.uid.getLocalizedName(), (Throwable)ex);
            }
        }
    }

    class DestReaperTask
    extends TimerTask {
        DestinationUID uid = null;
        private boolean canceled = false;
        Logger logger = Globals.getLogger();

        DestReaperTask(DestinationUID uid) {
            this.uid = uid;
        }

        @Override
        public synchronized boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DestReaperTask destReaperTask = this;
            synchronized (destReaperTask) {
                if (this.canceled) {
                    return;
                }
                this.canceled = true;
            }
            try {
                Destination d = Destination.this.DL.getDestination(this.uid);
                if (d == null) {
                    return;
                }
                Object object = d;
                synchronized (object) {
                    if (!d.shouldDestroy()) {
                        return;
                    }
                }
                object = Destination.this.DL.destinationList;
                synchronized (object) {
                    if (d.getRefCount() > 0) {
                        return;
                    }
                    int level = DestType.isAdmin((int)d.getType()) ? 4 : 8;
                    DestinationList cfr_ignored_0 = Destination.this.DL;
                    this.logger.log(level, "B1130", (Object)this.uid.getLocalizedName(), (Object)String.valueOf(DestinationList.AUTOCREATE_EXPIRE / 1000L));
                    d.destvalid = false;
                    Destination.this.DL.removeDestination(this.uid, false, Globals.getBrokerResources().getString("B0069"));
                }
            }
            catch (Exception ex) {
                this.logger.logStack(16, "B4144", (Object)this.uid.getLocalizedName(), (Throwable)ex);
            }
        }
    }

    class FlowListener
    implements EventListener {
        FlowListener() {
        }

        public void eventOccured(EventType type, Reason reason, Object target, Object orig_value, Object cur_value, Object userdata) {
            if (reason instanceof RemoveReason) {
                return;
            }
            assert (type == EventType.FULL);
            if (reason != AddReason.LOADED) {
                assert (cur_value instanceof Boolean);
                boolean shouldStop = Destination.this.destMessages.isFull();
                if (shouldStop) {
                    Destination.this.logger.log(4, "Destination " + Destination.this + " is full,  all producers should be stopped");
                    Destination.this.producerFlow.updateAllProducers(0, "Destination Full");
                } else {
                    Destination.this.logger.log(4, "Destination " + Destination.this + " is not full,  some producers should be stopped");
                    Destination.this.producerFlow.checkResumeFlow(null, true);
                }
            }
        }
    }

    class RemoveBehaviorListener
    implements EventListener {
        Set orderedSet = null;
        Reason r = null;

        RemoveBehaviorListener(Set orderedSet, Reason r) {
            this.orderedSet = orderedSet;
            this.r = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void eventOccured(EventType type, Reason reason, Object target, Object orig_value, Object cur_value, Object userdata) {
            assert (type == EventType.SET_CHANGED_REQUEST);
            boolean full = Destination.this.destMessages.isFull();
            if (!full || cur_value == null) return;
            long tbytes = ((Sized)cur_value).byteSize();
            while (true) {
                Iterator itr = null;
                Set set = this.orderedSet;
                synchronized (set) {
                    itr = new LinkedHashSet(this.orderedSet).iterator();
                }
                if (!itr.hasNext()) return;
                Object n = itr.next();
                if (n == null) continue;
                try {
                    Destination.this.removeMessage(((PacketReference)n).getSysMessageID(), this.r);
                }
                catch (Exception ex) {
                    Destination.this.logger.logStack(16, ex.getMessage(), (Throwable)ex);
                    itr.remove();
                    continue;
                }
                if (!(Destination.this.destMessages.capacity() != -1 && Destination.this.destMessages.freeSpace() <= 0 || Destination.this.destMessages.byteCapacity() != -1L && Destination.this.destMessages.freeBytes() <= tbytes)) return;
            }
        }
    }
}

