/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketUtil;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.Hashtable;

public class DeliverHandler
extends PacketHandler {
    static final int DELIVER_BLOCK_SIZE = 32;
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;
    private DestinationList DL = Globals.getDestinationList();

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        Hashtable<String, Object> hash;
        Packet pkt;
        int sentPackets;
        Packet[] sentp;
        block24: {
            block23: {
                int status;
                String reason;
                block22: {
                    int ackcount;
                    block21: {
                        Long lid;
                        long id;
                        reason = null;
                        Hashtable props = null;
                        try {
                            props = msg.getProperties();
                        }
                        catch (Exception ex) {
                            this.logger.logStack(16, "Unable to retrieve  properties from deliver message " + msg, (Throwable)ex);
                            props = new Hashtable();
                        }
                        int size = msg.getMessageBodySize();
                        ackcount = size / 32;
                        int mod = size % 32;
                        if (ackcount == 0) {
                            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Empty Deliver Message"));
                        }
                        if (mod != 0) {
                            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Invalid Deliver Message Size: " + size + ". Not multiple of 32"));
                        }
                        if (DEBUG) {
                            this.logger.log(4, "Deliver Message: processing message {0} {1}", (Object)msg.toString(), (Object)con.getConnectionUID().toString());
                        }
                        long l = id = (lid = (Long)props.get("JMQConsumerID")) == null ? 0L : lid;
                        assert (id != 0L);
                        DataInputStream is = new DataInputStream(msg.getMessageBodyStream());
                        sentp = new Packet[ackcount];
                        sentPackets = 0;
                        try {
                            for (int i = 0; i < ackcount; ++i) {
                                Packet realp;
                                SysMessageID sysid = new SysMessageID();
                                sysid.readID((DataInput)is);
                                PacketReference ref = DestinationList.get(con.getPartitionedStore(), sysid);
                                Packet packet = realp = ref == null ? null : ref.getPacket();
                                if (ref == null || ref.isInvalid() || realp == null) continue;
                                Packet p = new Packet(con.useDirectBuffers());
                                p.fill(realp);
                                p.setConsumerID(id);
                                sentp[sentPackets] = p;
                                ++sentPackets;
                            }
                        }
                        catch (Exception ex) {
                            this.logger.logStack(32, Globals.getBrokerResources().getString("B4117", "\tackcnt = " + ackcount + "\n" + PacketUtil.dumpPacket((Packet)msg) + "\n\t" + PacketUtil.dumpThrowable((Throwable)ex)), (Throwable)ex);
                            if ($assertionsDisabled) break block21;
                            throw new AssertionError();
                        }
                    }
                    status = 200;
                    try {
                        if (sentPackets > 0) {
                            assert (sentp[sentPackets - 1] != null);
                            sentp[sentPackets - 1].setIsLast(true);
                        } else {
                            reason = "NOT FOUND";
                            status = 404;
                        }
                    }
                    catch (Exception ex) {
                        this.logger.logStack(32, Globals.getBrokerResources().getString("B4117", "\tackcnt = " + ackcount + "\n" + PacketUtil.dumpPacket((Packet)msg) + "\n\t" + PacketUtil.dumpThrowable((Throwable)ex)), (Throwable)ex);
                        assert (false);
                        reason = ex.getMessage();
                        status = 500;
                        if (!(ex instanceof BrokerException)) break block22;
                        status = ((BrokerException)ex).getStatusCode();
                    }
                }
                pkt = new Packet(con.useDirectBuffers());
                pkt.setConsumerID(msg.getConsumerID());
                pkt.setPacketType(43);
                hash = new Hashtable<String, Object>();
                hash.put("JMQStatus", status);
                if (reason != null) {
                    hash.put("JMQReason", reason);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                if (IMQBasicConnection.getDumpPacket()) break block23;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                if (!IMQBasicConnection.getDumpOutPacket()) break block24;
            }
            hash.put("JMQReqID", msg.getSysMessageID().toString());
        }
        pkt.setProperties(hash);
        con.sendControlMessage(pkt);
        for (int j = 0; j < sentPackets; ++j) {
            assert (sentp[j] != null);
            if (sentp[j] == null) continue;
            con.sendControlMessage(sentp[j]);
        }
        return true;
    }
}

