/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.data.handlers.DataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ChangeClusterMasterBrokerHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.CheckpointBrokerHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.CompactDestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.CreateDestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DebugHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DeleteMessageHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DestroyConnectionsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DestroyDestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DestroyDurableHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetBrokerPropsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetClusterHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetConnectionsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetConsumersHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetDestinationsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetDurablesHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetJMXConnectorsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetLogsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetMessagesHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetMetricsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetServicesHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetTransactionsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.HelloHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.MigrateStoreHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.PauseHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.PurgeDestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.PurgeDurableHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.QuiesceHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ReloadClusterHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ReplaceMessageHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ResetMetricsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ResumeHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.RollbackCommitHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ShutdownHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.TakeoverHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.UnquiesceHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.UpdateBrokerPropsHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.UpdateClusterBrokerListHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.UpdateDestinationHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.UpdateServiceHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ViewLogHandler;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.MessageType;
import java.io.IOException;
import java.util.Hashtable;

public class AdminDataHandler
extends DataHandler {
    private static boolean DEBUG = AdminDataHandler.getDEBUG();
    private AdminCmdHandler[] handlers = null;
    private BrokerResources rb = Globals.getBrokerResources();
    public PacketRouter adminPktRtr = null;
    private int activeHandlers = 0;

    public AdminDataHandler() {
        this.initHandlers();
    }

    public AdminCmdHandler getHandler(int typ) {
        if (typ < 0 || typ >= this.handlers.length) {
            return null;
        }
        return this.handlers[typ];
    }

    public void setPacketRouter(PacketRouter pktrtr) {
        this.adminPktRtr = pktrtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        Producer pausedProducer;
        if (DEBUG) {
            this.logger.log(2, "AdminDataHandler: handle() [ Received JMS Admin Message] {0} ", (Object)msg.toString());
            if (this.logger.level >= 1) {
                msg.dump(System.out);
            }
        }
        String dest = msg.getDestination();
        if (!msg.getIsQueue() || !dest.equals("__JMQAdmin") && !dest.equals("__JMQBridgeAdmin")) {
            return super.handle(con, msg);
        }
        boolean bridgeAdmin = false;
        if (dest.equals("__JMQBridgeAdmin")) {
            if (DEBUG) {
                this.logger.log(8, "Received bridge admin message");
            }
            bridgeAdmin = true;
        }
        Hashtable props = null;
        Integer msgType = null;
        try {
            props = msg.getProperties();
            msgType = (Integer)props.get("JMQMessageType");
        }
        catch (Exception e) {
            String emsg = this.rb.getString("B3100", "Admin: Could not extract properties from pkt");
            this.logger.logStack(16, emsg, (Throwable)e);
            throw new BrokerException(emsg, e);
        }
        if (msgType == null) {
            String emsg = this.rb.getString("B3100", "Message received on administration destination " + dest + " has no JMQMessageType property ignoring it.");
            this.logger.log(16, emsg);
            throw new BrokerException(emsg);
        }
        if (bridgeAdmin && msgType != 28) {
            return super.handle(con, msg);
        }
        if (msg.getSendAcknowledge()) {
            Packet pkt = new Packet(con.useDirectBuffers());
            pkt.setPacketType(9);
            pkt.setConsumerID(msg.getConsumerID());
            Hashtable<String, Integer> hash = new Hashtable<String, Integer>();
            hash.put("JMQStatus", 200);
            pkt.setProperties(hash);
            con.sendControlMessage(pkt);
        }
        if ((pausedProducer = this.checkFlow(msg, con)) != null) {
            DestinationUID duid = DestinationUID.getUID(msg.getDestination(), msg.getIsQueue());
            AdminDataHandler adminDataHandler = this;
            Destination[] ds = DestinationList.findDestination(adminDataHandler.DL.getAdminPartition(), duid);
            Destination d = ds[0];
            this.pauseProducer(d, duid, pausedProducer, con);
        }
        int t = msgType;
        AdminCmdHandler ach = null;
        if (con.getAccessController().isRestrictedAdmin() && t != 38 && t != 28 && t != 34) {
            this.logger.log(16, "B2050", (Object)MessageType.getString((int)t));
            Packet reply = new Packet(con.useDirectBuffers());
            reply.setPacketType(5);
            AdminCmdHandler.setProperties(reply, t + 1, 403, null);
            this.sendReply(con, msg, reply);
            return true;
        }
        if (t != 38 && t != 98) {
            this.incrementActiveHandlers();
        }
        try {
            String message;
            if (BrokerStateHandler.isShuttingDown()) {
                message = Globals.getBrokerResources().getKString("B1156", MessageType.getString((int)t));
                this.logger.log(16, message);
                Packet reply = new Packet(con.useDirectBuffers());
                reply.setPacketType(5);
                AdminCmdHandler.setProperties(reply, t + 1, 503, message);
                this.sendReply(con, msg, reply);
                boolean bl = true;
                return bl;
            }
            if (!Broker.getBroker().startupComplete) {
                message = Globals.getBrokerResources().getKString("B1155", MessageType.getString((int)t));
                this.logger.log(16, message);
                Packet reply = new Packet(con.useDirectBuffers());
                reply.setPacketType(5);
                AdminCmdHandler.setProperties(reply, t + 1, 503, message);
                this.sendReply(con, msg, reply);
                boolean bl = true;
                return bl;
            }
            try {
                ach = this.handlers[t];
            }
            catch (IndexOutOfBoundsException e) {
                this.logger.logStack(32, "B3100", (Object)("Bad JMQMessageType: " + t), (Throwable)e);
                boolean reply = true;
                if (t != 38 && t != 98) {
                    this.decrementActiveHandlers();
                }
                return reply;
            }
            if (ach == null) {
                this.logger.log(32, "B3100", (Object)("No administration handler found for message type " + msgType + ". Ignoring."));
                boolean e = true;
                return e;
            }
            boolean e = ach.handle(con, msg, props);
            return e;
        }
        finally {
            if (t != 38 && t != 98) {
                this.decrementActiveHandlers();
            }
        }
    }

    private void initHandlers() {
        this.handlers = new AdminCmdHandler[100];
        this.handlers[10] = new CreateDestinationHandler(this);
        this.handlers[70] = new DestroyConnectionsHandler(this);
        this.handlers[12] = new DestroyDestinationHandler(this);
        this.handlers[14] = new DestroyDurableHandler(this);
        this.handlers[16] = new GetConnectionsHandler(this);
        this.handlers[18] = new GetConsumersHandler(this);
        this.handlers[20] = new GetDestinationsHandler(this);
        this.handlers[22] = new GetDurablesHandler(this);
        this.handlers[24] = new GetLogsHandler(this);
        this.handlers[26] = new GetServicesHandler(this);
        this.handlers[28] = new HelloHandler(this);
        this.handlers[30] = new PauseHandler(this);
        this.handlers[32] = new PurgeDestinationHandler(this);
        this.handlers[36] = new ResumeHandler(this);
        this.handlers[38] = new ShutdownHandler(this);
        this.handlers[40] = new UpdateDestinationHandler(this);
        this.handlers[46] = new UpdateServiceHandler(this);
        this.handlers[44] = new ViewLogHandler(this);
        this.handlers[52] = new GetMetricsHandler(this);
        this.handlers[54] = new GetBrokerPropsHandler(this);
        this.handlers[56] = new UpdateBrokerPropsHandler(this);
        this.handlers[58] = new ReloadClusterHandler(this);
        this.handlers[60] = new GetTransactionsHandler(this);
        this.handlers[64] = new RollbackCommitHandler(this);
        this.handlers[62] = new RollbackCommitHandler(this);
        this.handlers[66] = new PurgeDurableHandler(this);
        this.handlers[68] = new CompactDestinationHandler(this);
        this.handlers[72] = new DebugHandler(this);
        this.handlers[74] = new QuiesceHandler(this);
        this.handlers[76] = new TakeoverHandler(this);
        this.handlers[78] = new GetClusterHandler(this);
        this.handlers[80] = new GetJMXConnectorsHandler(this);
        this.handlers[82] = new UnquiesceHandler(this);
        this.handlers[84] = new ResetMetricsHandler(this);
        this.handlers[86] = new GetMessagesHandler(this);
        this.handlers[88] = new DeleteMessageHandler(this);
        this.handlers[90] = new ReplaceMessageHandler(this);
        this.handlers[92] = new CheckpointBrokerHandler(this);
        this.handlers[94] = new UpdateClusterBrokerListHandler(this);
        this.handlers[96] = new ChangeClusterMasterBrokerHandler(this);
        this.handlers[98] = new MigrateStoreHandler(this);
    }

    public SysMessageID sendReply(IMQConnection con, Packet cmd_msg, Packet reply_msg) {
        try {
            String destination = cmd_msg.getReplyTo();
            if (destination == null) {
                this.logger.log(32, "B3100", (Object)"Administration message has no ReplyTo destination. Not replying.");
                return null;
            }
            reply_msg.setDestination(destination);
            reply_msg.setIsQueue(true);
            reply_msg.setPersistent(false);
            reply_msg.setTransactionID(0L);
            reply_msg.setSendAcknowledge(false);
            if (con instanceof IMQBasicConnection) {
                reply_msg.setPort(((IMQBasicConnection)con).getLocalPort());
            }
            reply_msg.setIP(Globals.getBrokerInetAddress().getAddress());
            reply_msg.updateTimestamp();
            reply_msg.updateSequenceNumber();
            reply_msg.generateTimestamp(false);
            reply_msg.generateSequenceNumber(false);
            if (DEBUG) {
                try {
                    this.logger.log(4, "AdminDataHandler: REPLY: " + reply_msg + ": " + reply_msg.getProperties());
                }
                catch (IOException | ClassNotFoundException e) {
                    this.logger.logStack(16, "B3100", (Object)"Admin: Could not extract properties from pkt", (Throwable)e);
                }
            }
            SysMessageID mid = reply_msg.getSysMessageID();
            super.handle(con, reply_msg, true);
            return mid;
        }
        catch (Exception e) {
            this.logger.logStack(32, "B3100", (Object)"Could not reply to administrative message.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementActiveHandlers() {
        AdminDataHandler adminDataHandler = this;
        synchronized (adminDataHandler) {
            ++this.activeHandlers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementActiveHandlers() {
        AdminDataHandler adminDataHandler = this;
        synchronized (adminDataHandler) {
            --this.activeHandlers;
            if (this.activeHandlers == 0) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForHandlersToComplete(int secs) {
        AdminDataHandler adminDataHandler = this;
        synchronized (adminDataHandler) {
            try {
                if (this.activeHandlers > 0) {
                    this.wait((long)secs * 1000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

