/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Container;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.ejb.EJBException;
import jakarta.ejb.NoSuchEntityException;
import jakarta.ejb.NoSuchObjectLocalException;
import jakarta.ejb.TransactionRequiredLocalException;
import jakarta.ejb.TransactionRolledbackLocalException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.UserTransaction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.deployment.descriptor.ContainerTransaction;
import org.glassfish.ejb.deployment.descriptor.EjbApplicationExceptionInfo;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.IASEjbExtraDescriptors;

public class EJBContainerTransactionManager {
    private static final Logger LOG = EjbContainerUtilImpl.getLogger();
    private static final String USER_TX = "java:comp/UserTransaction";
    private final EjbContainerUtil ejbContainerUtilImpl = EjbContainerUtilImpl.getInstance();
    private final JavaEETransactionManager transactionManager;
    private final BaseContainer container;
    private final EjbDescriptor ejbDescriptor;
    private final int cmtTimeoutInSeconds;

    EJBContainerTransactionManager(Container c, EjbDescriptor ejbDesc) {
        this.container = (BaseContainer)c;
        this.ejbDescriptor = ejbDesc;
        this.transactionManager = this.ejbContainerUtilImpl.getTransactionManager();
        IASEjbExtraDescriptors iased = ejbDesc.getIASEjbExtraDescriptors();
        this.cmtTimeoutInSeconds = iased.getCmtTimeoutInSeconds();
    }

    int findTxAttr(MethodDescriptor md) {
        if (this.container.isBeanManagedTran) {
            return 2;
        }
        int txAttr = this.getTransactionAttribute(md);
        if (txAttr < 0) {
            throw new EJBException("Transaction Attribute not found for method " + md.prettyPrint());
        }
        this.container.validateTxAttr(md, txAttr);
        return txAttr;
    }

    private int getTransactionAttribute(MethodDescriptor md) {
        ContainerTransaction containerTx = this.ejbDescriptor.getContainerTransactionFor(md);
        if (containerTx == null) {
            return -1;
        }
        String attr = containerTx.getTransactionAttribute();
        if (attr.equals("NotSupported")) {
            return 1;
        }
        if (attr.equals("Supports")) {
            return 4;
        }
        if (attr.equals("Required")) {
            return 3;
        }
        if (attr.equals("RequiresNew")) {
            return 5;
        }
        if (attr.equals("Mandatory")) {
            return 6;
        }
        if (attr.equals("Never")) {
            return 7;
        }
        return -2;
    }

    final void preInvokeTx(EjbInvocation inv) throws Exception {
        int status;
        LOG.finest(() -> String.format("preInvokeTx(inv=%s)", inv));
        Integer preInvokeTxStatus = inv.getPreInvokeTxStatus();
        int n = status = preInvokeTxStatus == null ? this.transactionManager.getStatus() : preInvokeTxStatus.intValue();
        if (this.container.suspendTransaction(inv)) {
            if (status != 6) {
                try {
                    inv.clientTx = this.transactionManager.suspend();
                }
                catch (SystemException ex) {
                    throw new EJBException(ex);
                }
            }
            return;
        }
        boolean isNullTx = inv.isRemote ? this.transactionManager.isNullTransaction() : false;
        int txAttr = this.container.getTxAttr(inv);
        EJBContextImpl context = (EJBContextImpl)inv.context;
        Transaction prevTx = context.getTransaction();
        switch (txAttr) {
            case 2: {
                if (status != 6) {
                    inv.clientTx = this.transactionManager.suspend();
                }
                if (!this.container.isStatefulSession || prevTx == null || prevTx.getStatus() == 6) break;
                this.transactionManager.resume(prevTx);
                this.transactionManager.enlistComponentResources();
                break;
            }
            case 1: {
                if (status != 6) {
                    inv.clientTx = this.transactionManager.suspend();
                }
                this.container.checkUnfinishedTx(prevTx, inv);
                this.container.preInvokeNoTx(inv);
                break;
            }
            case 6: {
                if (isNullTx || status == 6) {
                    throw new TransactionRequiredLocalException();
                }
                this.useClientTx(prevTx, inv);
                break;
            }
            case 3: {
                if (isNullTx) {
                    throw new TransactionRequiredLocalException();
                }
                if (status == 6) {
                    inv.clientTx = null;
                    this.startNewTx(prevTx, inv);
                    break;
                }
                inv.clientTx = this.transactionManager.getTransaction();
                this.useClientTx(prevTx, inv);
                break;
            }
            case 5: {
                if (status != 6) {
                    inv.clientTx = this.transactionManager.suspend();
                }
                this.startNewTx(prevTx, inv);
                break;
            }
            case 4: {
                if (isNullTx) {
                    throw new TransactionRequiredLocalException();
                }
                if (status != 6) {
                    this.useClientTx(prevTx, inv);
                    break;
                }
                this.container.checkUnfinishedTx(prevTx, inv);
                this.container.preInvokeNoTx(inv);
                break;
            }
            case 7: {
                if (isNullTx || status != 6) {
                    throw new EJBException("EJB cannot be invoked in global transaction");
                }
                this.container.checkUnfinishedTx(prevTx, inv);
                this.container.preInvokeNoTx(inv);
                break;
            }
            default: {
                throw new EJBException("Bad transaction attribute");
            }
        }
    }

    private void startNewTx(Transaction prevTx, EjbInvocation inv) throws Exception {
        LOG.finest(() -> String.format("startNewTx(prevTx=%s, inv=%s)", prevTx, inv));
        this.container.checkUnfinishedTx(prevTx, inv);
        if (this.cmtTimeoutInSeconds > 0) {
            this.transactionManager.begin(this.cmtTimeoutInSeconds);
        } else {
            this.transactionManager.begin();
        }
        EJBContextImpl context = (EJBContextImpl)inv.context;
        Transaction tx = this.transactionManager.getTransaction();
        if (!this.container.isSingleton) {
            context.setTransaction(tx);
        }
        this.transactionManager.enlistComponentResources();
        if (!inv.invocationInfo.isHomeFinder) {
            this.ejbContainerUtilImpl.getContainerSync(tx).addBean(context);
        }
        this.container.afterBegin(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void useClientTx(Transaction prevTx, EjbInvocation inv) {
        int prevStatus;
        int status;
        Transaction clientTx;
        LOG.finest(() -> String.format("useClientTx(prevTx=%s, inv=%s)", prevTx, inv));
        try {
            clientTx = this.transactionManager.getTransaction();
            status = clientTx.getStatus();
            prevStatus = prevTx == null ? -1 : prevTx.getStatus();
        }
        catch (Exception ex) {
            TransactionRolledbackLocalException toThrow = new TransactionRolledbackLocalException(ex.getMessage(), ex);
            try {
                this.transactionManager.setRollbackOnly();
                throw toThrow;
            }
            catch (Exception e) {
                toThrow.addSuppressed(ex);
            }
            throw toThrow;
        }
        if (status == 1 || status == 4 || status == 9) {
            throw new TransactionRolledbackLocalException("Client's transaction aborted");
        }
        this.container.validateEMForClientTx(inv, (JavaEETransaction)clientTx);
        if (prevTx == null || prevStatus == 6) {
            EJBContextImpl context = (EJBContextImpl)inv.context;
            if (!this.container.isSingleton) {
                context.setTransaction(clientTx);
            }
            try {
                this.transactionManager.enlistComponentResources();
                if (this.container.isStatelessSession || this.container.isMessageDriven || this.container.isSingleton) return;
                if (!inv.invocationInfo.isHomeFinder) {
                    this.ejbContainerUtilImpl.getContainerSync(clientTx).addBean(context);
                }
                this.container.afterBegin(context);
                return;
            }
            catch (Exception ex) {
                TransactionRolledbackLocalException toThrow = new TransactionRolledbackLocalException("", ex);
                try {
                    this.transactionManager.setRollbackOnly();
                    throw toThrow;
                }
                catch (Exception e) {
                    toThrow.addSuppressed(e);
                }
                throw toThrow;
            }
        }
        if (!prevTx.equals(clientTx)) {
            if (!this.container.isSession) return;
            throw new IllegalStateException("EJB is already associated with an incomplete transaction");
        }
        try {
            this.transactionManager.enlistComponentResources();
            return;
        }
        catch (Exception ex) {
            TransactionRolledbackLocalException toThrow = new TransactionRolledbackLocalException("", ex);
            try {
                this.transactionManager.setRollbackOnly();
                throw toThrow;
            }
            catch (Exception e) {
                toThrow.addSuppressed(e);
            }
            throw toThrow;
        }
    }

    protected void postInvokeTx(EjbInvocation inv) throws Exception {
        Throwable newException;
        LOG.finest(() -> String.format("postInvokeTx(inv=%s)", inv));
        if (this.container.resumeTransaction(inv)) {
            if (inv.clientTx != null) {
                this.transactionManager.resume(inv.clientTx);
            }
            if (inv.exception != null && inv.exception instanceof BaseContainer.PreInvokeException) {
                inv.exception = inv.exception.getCause();
            }
            return;
        }
        EJBContextImpl context = (EJBContextImpl)inv.context;
        int status = this.transactionManager.getStatus();
        int txAttr = inv.invocationInfo.txAttr;
        Throwable oriException = inv.exception;
        switch (txAttr) {
            case 2: {
                newException = this.checkExceptionBeanMgTx(context, oriException, status);
                if (inv.clientTx == null) break;
                this.transactionManager.resume(inv.clientTx);
                break;
            }
            case 1: 
            case 7: {
                newException = this.checkExceptionNoTx(context, oriException);
                this.container.postInvokeNoTx(inv);
                if (inv.clientTx == null) break;
                this.transactionManager.resume(inv.clientTx);
                break;
            }
            case 6: {
                newException = this.checkExceptionClientTx(context, oriException);
                break;
            }
            case 3: {
                if (inv.clientTx == null) {
                    newException = this.completeNewTx(context, oriException, status);
                    break;
                }
                newException = this.checkExceptionClientTx(context, oriException);
                break;
            }
            case 5: {
                newException = this.completeNewTx(context, oriException, status);
                if (inv.clientTx == null) break;
                this.transactionManager.resume(inv.clientTx);
                break;
            }
            case 4: {
                if (status != 6) {
                    newException = this.checkExceptionClientTx(context, oriException);
                    break;
                }
                newException = this.checkExceptionNoTx(context, oriException);
                this.container.postInvokeNoTx(inv);
                break;
            }
            default: {
                newException = oriException;
            }
        }
        inv.exception = newException;
    }

    final UserTransaction getUserTransaction() {
        if ((this.container.isSession || this.container.isMessageDriven) && this.container.isBeanManagedTran) {
            try {
                return (UserTransaction)this.container.namingManager.getInitialContext().lookup(USER_TX);
            }
            catch (Exception ex) {
                String message = LOG.getResourceBundle().getString("ejb.user_transaction_exception");
                throw new EJBException(message, ex);
            }
        }
        LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EJBContainerTransactionManager.class);
        throw new IllegalStateException(localStrings.getLocalString("ejb.ut_only_for_bmt", "Only session beans with bean-managed transactions can obtain UserTransaction"));
    }

    private Throwable checkExceptionBeanMgTx(EJBContextImpl context, Throwable exception, int status) throws Exception {
        LOG.finest(() -> String.format("checkExceptionBeanMgTx(context=%s, exception=%s, status=%s)", context, exception, status));
        if (exception != null && exception instanceof BaseContainer.PreInvokeException) {
            return exception.getCause();
        }
        if (status == 6) {
            return this.checkExceptionNoTx(context, exception);
        }
        if (this.container.isStatefulSession) {
            if (this.container.isSystemUncheckedException(exception)) {
                this.destroyBeanAndRollback(context, null);
                return this.processSystemException(exception);
            }
            if (this.isAppExceptionRequiringRollback(exception)) {
                this.rollback();
            } else {
                this.transactionManager.suspend();
            }
            return exception;
        }
        if (this.container.isStatelessSession) {
            return this.destroyBeanAndRollback(context, "Stateless SessionBean");
        }
        if (this.container.isSingleton) {
            return this.destroyBeanAndRollback(context, "Singleton SessionBean");
        }
        return this.destroyBeanAndRollback(context, "MessageDrivenBean");
    }

    private Throwable checkExceptionNoTx(EJBContextImpl context, Throwable exception) throws EJBException {
        LOG.finest(() -> String.format("checkExceptionNoTx(context=%s, exception=%s)", context, exception));
        if (exception == null) {
            return null;
        }
        if (exception instanceof BaseContainer.PreInvokeException) {
            return exception.getCause();
        }
        if (this.container.isSystemUncheckedException(exception)) {
            Throwable newException = this.processSystemException(exception);
            this.container.forceDestroyBean(context);
            return newException;
        }
        return exception;
    }

    Throwable checkExceptionClientTx(EJBContextImpl context, Throwable exception) throws SystemException {
        LOG.finest(() -> String.format("checkExceptionClientTx(context=%s, exception=%s)", context, exception));
        if (exception == null) {
            return null;
        }
        if (exception instanceof BaseContainer.PreInvokeException) {
            return exception.getCause();
        }
        if (this.container.isSystemUncheckedException(exception)) {
            try {
                this.container.forceDestroyBean(context);
            }
            finally {
                this.transactionManager.setRollbackOnly();
            }
            TransactionRolledbackLocalException newException = new TransactionRolledbackLocalException("Exception thrown from bean: " + exception);
            newException.initCause(exception);
            return newException;
        }
        if (this.isAppExceptionRequiringRollback(exception)) {
            this.transactionManager.setRollbackOnly();
        }
        return exception;
    }

    private Throwable completeNewTx(EJBContextImpl context, Throwable exception, int status) throws Exception {
        LOG.finest(() -> String.format("completeNewTx(context=%s, exception=%s, status=%s)", context, exception, status));
        Throwable newException = exception instanceof BaseContainer.PreInvokeException ? exception.getCause() : exception;
        if (status == 6) {
            return newException;
        }
        if (this.container.isStatefulSession && context instanceof SessionContextImpl) {
            ((SessionContextImpl)context).setTxCompleting(true);
        }
        if (this.container.isSystemUncheckedException(newException)) {
            this.destroyBeanAndRollback(context, null);
            return this.processSystemException(newException);
        }
        try {
            if (status == 1) {
                this.rollback();
            } else if (newException != null && this.isAppExceptionRequiringRollback(newException)) {
                this.rollback();
            } else {
                this.transactionManager.commit();
            }
            return newException;
        }
        catch (RollbackException ex) {
            LOG.log(Level.FINE, "ejb.transaction_abort_exception", ex);
            EJBException result = new EJBException("Transaction aborted", ex);
            if (newException != null) {
                result.addSuppressed(newException);
            }
            return result;
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "ejb.cmt_exception", ex);
            EJBException result = new EJBException("Unable to complete container-managed transaction.", ex);
            if (newException != null) {
                result.addSuppressed(newException);
            }
            return result;
        }
    }

    private EJBException destroyBeanAndRollback(EJBContextImpl context, String type) throws SystemException {
        LOG.finest(() -> String.format("destroyBeanAndRollback(context=%s, type=%s)", context, type));
        try {
            this.container.forceDestroyBean(context);
        }
        finally {
            this.rollback();
        }
        if (type == null) {
            return null;
        }
        LOG.log(Level.FINE, "ejb.incomplete_sessionbean_txn_exception");
        return new EJBException(type + " method returned without completing transaction");
    }

    private void rollback() throws SystemException {
        if (this.transactionManager.isTimedOut()) {
            LOG.log(Level.WARNING, "ejb.tx_timeout", new Object[]{this.transactionManager.getTransaction(), this.ejbDescriptor.getName()});
        }
        this.transactionManager.rollback();
    }

    private Throwable processSystemException(Throwable sysEx) {
        if (sysEx instanceof EJBException) {
            return sysEx;
        }
        if (sysEx instanceof NoSuchEntityException) {
            return new NoSuchObjectLocalException("NoSuchEntityException thrown by EJB method.").initCause(sysEx);
        }
        return new EJBException(sysEx.getMessage()).initCause(sysEx);
    }

    private boolean isAppExceptionRequiringRollback(Throwable exception) {
        if (exception == null) {
            return false;
        }
        String exceptionClassName = exception.getClass().getName();
        Map<String, EjbApplicationExceptionInfo> appExceptions = this.ejbDescriptor.getEjbBundleDescriptor().getApplicationExceptions();
        for (Class<?> exceptionClass = exception.getClass(); exceptionClass != null; exceptionClass = exceptionClass.getSuperclass()) {
            String eClassName = exceptionClass.getName();
            if (!appExceptions.containsKey(eClassName)) continue;
            EjbApplicationExceptionInfo exceptionInfo = appExceptions.get(eClassName);
            if (!exceptionClassName.equals(eClassName) && !exceptionInfo.getInherited()) break;
            return exceptionInfo.getRollback();
        }
        return false;
    }
}

