/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.container.common.spi.util.IndirectlySerializable;
import com.sun.enterprise.container.common.spi.util.SerializableObjectFactory;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EJBLocalHome;
import jakarta.ejb.RemoveException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class EJBLocalHomeImpl
implements EJBLocalHome,
IndirectlySerializable {
    protected BaseContainer container;
    private static final Logger _logger = EjbContainerUtilImpl.getLogger();

    final void setContainer(BaseContainer c) {
        this.container = c;
    }

    protected final BaseContainer getContainer() {
        return this.container;
    }

    protected EJBLocalHome getEJBLocalHome() {
        return this;
    }

    protected EJBLocalObjectImpl createEJBLocalObjectImpl() throws CreateException {
        return this.container.createEJBLocalObjectImpl();
    }

    protected final EJBLocalObjectImpl createEJBLocalBusinessObjectImpl(String intfName) throws CreateException {
        return this.container.createEJBLocalBusinessObjectImpl(intfName);
    }

    @Override
    public final void remove(Object primaryKey) throws RemoveException, EJBException {
        if (this.container.getContainerType() != BaseContainer.ContainerType.ENTITY) {
            throw new RemoveException("Attempt to call remove(Object primaryKey) on a session bean.");
        }
        this.container.authorizeLocalMethod(4);
        Method method = null;
        try {
            method = EJBLocalHome.class.getMethod("remove", Object.class);
        }
        catch (NoSuchMethodException e) {
            _logger.log(Level.FINE, "Exception in method remove()", e);
        }
        try {
            this.container.doEJBHomeRemove(primaryKey, method, true);
        }
        catch (RemoteException re) {
            EJBException ejbEx = new EJBException("unexpected RemoteException");
            ejbEx.initCause(re);
            throw ejbEx;
        }
    }

    public SerializableObjectFactory getSerializableObjectFactory() {
        return new SerializableLocalHome(this.container.getEjbDescriptor().getUniqueId());
    }

    public static final class SerializableLocalHome
    implements SerializableObjectFactory {
        private long ejbId;

        public SerializableLocalHome(long uniqueId) {
            this.ejbId = uniqueId;
        }

        public Object createObject(long appUniqueId) throws IOException {
            BaseContainer container = EjbContainerUtilImpl.getInstance().getContainer(this.ejbId, appUniqueId);
            return container.getEJBLocalHome();
        }
    }
}

