/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.pool;

import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.enterprise.util.Utility;
import java.lang.invoke.LambdaMetafactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;
import java.util.logging.Level;

public class NonBlockingPool
extends AbstractPool {
    private TimerTask poolTimerTask;
    protected boolean addedResizeTask = false;
    protected volatile boolean addedIdleBeanWork = false;
    protected boolean inResizing = false;
    private boolean maintainSteadySize = false;
    protected boolean singletonBeanPool;
    private boolean poolClosed = false;
    private int resizeTaskCount;

    protected NonBlockingPool() {
    }

    public NonBlockingPool(long beanId, String poolName, ObjectFactory factory, int steadyPoolSize, int resizeQuantity, int maxPoolSize, int idleTimeoutInSeconds, ClassLoader loader) {
        this(beanId, poolName, factory, steadyPoolSize, resizeQuantity, maxPoolSize, idleTimeoutInSeconds, loader, false);
    }

    public NonBlockingPool(long beanId, String poolName, ObjectFactory factory, int steadyPoolSize, int resizeQuantity, int maxPoolSize, int idleTimeoutInSeconds, ClassLoader loader, boolean singletonBeanPool) {
        this.poolName = poolName;
        this.beanId = beanId;
        this.singletonBeanPool = singletonBeanPool && steadyPoolSize == 1 && maxPoolSize == 1;
        this.initializePool(factory, steadyPoolSize, resizeQuantity, maxPoolSize, idleTimeoutInSeconds, loader);
    }

    private void initializePool(ObjectFactory factory, int steadyPoolSize, int resizeQuantity, int maxPoolSize, int idleTimeoutInSeconds, ClassLoader loader) {
        this.factory = factory;
        this.steadyPoolSize = steadyPoolSize <= 0 ? 0 : steadyPoolSize;
        this.resizeQuantity = resizeQuantity <= 0 ? 0 : resizeQuantity;
        this.maxPoolSize = maxPoolSize <= 0 ? Integer.MAX_VALUE : maxPoolSize;
        this.steadyPoolSize = this.steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : this.steadyPoolSize;
        this.idleTimeoutInSeconds = idleTimeoutInSeconds <= 0 || this.singletonBeanPool ? 0 : idleTimeoutInSeconds;
        this.containerClassLoader = loader;
        boolean bl = this.maintainSteadySize = !this.singletonBeanPool && this.steadyPoolSize > 0;
        if (this.idleTimeoutInSeconds > 0 && this.resizeQuantity > 0) {
            try {
                this.poolTimerTask = new PoolResizeTimerTask();
                EjbContainerUtilImpl.getInstance().getTimer().scheduleAtFixedRate(this.poolTimerTask, (long)idleTimeoutInSeconds * 1000L, (long)idleTimeoutInSeconds * 1000L);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[Pool-{0}]: Added PoolResizeTimerTask...", this.poolName);
                }
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Could not add PoolTimerTask. Continuing anyway...", th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getObject(Object param) {
        boolean toAddResizeTask = false;
        Object obj = null;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int size = this.list.size();
            if (size > this.steadyPoolSize) {
                ++this.poolSuccess;
                return this.list.remove(size - 1);
            }
            if (size > 0) {
                ++this.poolSuccess;
                if (!this.maintainSteadySize) return this.list.remove(size - 1);
                if (this.addedResizeTask) return this.list.remove(size - 1);
                this.addedResizeTask = true;
                toAddResizeTask = true;
                obj = this.list.remove(size - 1);
            } else if (!this.singletonBeanPool) {
                if (this.maintainSteadySize && !this.addedResizeTask) {
                    this.addedResizeTask = true;
                    toAddResizeTask = true;
                }
                this.poolProbeNotifier.ejbObjectAddedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                ++this.createdCount;
            }
        }
        if (toAddResizeTask) {
            this.addResizeTaskForImmediateExecution();
        }
        if (obj != null) {
            return obj;
        }
        if (this.singletonBeanPool) {
            arrayList = this.list;
            synchronized (arrayList) {
                while (this.list.isEmpty() && this.createdCount - this.destroyedCount > 0) {
                    try {
                        this.list.wait();
                    }
                    catch (InterruptedException size) {}
                }
                if (!this.list.isEmpty()) {
                    return this.list.remove(0);
                }
                try {
                    obj = this.factory.create(param);
                    ++this.createdCount;
                    return obj;
                }
                catch (RuntimeException th) {
                    this.poolProbeNotifier.ejbObjectAddFailedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                    throw th;
                }
            }
        }
        try {
            return this.factory.create(param);
        }
        catch (RuntimeException th) {
            ArrayList arrayList2 = this.list;
            synchronized (arrayList2) {
                this.poolProbeNotifier.ejbObjectAddFailedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                --this.createdCount;
                throw th;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResizeTaskForImmediateExecution() {
        block6: {
            try {
                ReSizeWork work = new ReSizeWork();
                EjbContainerUtilImpl.getInstance().addWork(work);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[Pool-{0}]: Added PoolResizeTimerTask...", this.poolName);
                }
                ++this.resizeTaskCount;
            }
            catch (Exception ex) {
                ArrayList arrayList = this.list;
                synchronized (arrayList) {
                    this.addedResizeTask = false;
                }
                if (!_logger.isLoggable(Level.WARNING)) break block6;
                _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Cannot perform  pool resize task", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.list.size() < this.maxPoolSize) {
                this.list.add(object);
                if (this.singletonBeanPool) {
                    this.list.notifyAll();
                }
                return;
            }
            this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
            ++this.destroyedCount;
        }
        try {
            this.factory.destroy(object);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "exception in returnObj", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
            ++this.destroyedCount;
            if (this.singletonBeanPool) {
                this.list.notifyAll();
            }
        }
        try {
            this.factory.destroy(object);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "exception in destroyObject", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preload(int count) {
        int sz;
        ArrayList<Object> instances = new ArrayList<Object>(count);
        try {
            for (int i = 0; i < count; ++i) {
                instances.add(this.factory.create(null));
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        if ((sz = instances.size()) == 0) {
            return;
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n = this.list.size();
            int addsz = sz;
            if (n + sz > this.maxPoolSize) {
                addsz = this.maxPoolSize - n;
            }
            for (int i = 0; i < addsz; ++i) {
                this.list.add(instances.remove(0));
            }
            this.createdCount += sz;
        }
        for (Object e : instances) {
            this.destroyObject(e);
        }
    }

    public void prepopulate(int count) {
        this.steadyPoolSize = count <= 0 ? 0 : count;
        int n = this.steadyPoolSize = this.steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : this.steadyPoolSize;
        if (this.steadyPoolSize > 0) {
            this.preload(this.steadyPoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object[] array;
            if (this.poolTimerTask != null) {
                try {
                    this.poolTimerTask.cancel();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[Pool-{0}]: Cancelled pool timer task  at: {1}", new Object[]{this.poolName, new Date()});
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[Pool-{0}]: Destroying {1} beans from the pool...", new Object[]{this.poolName, this.list.size()});
            }
            ClassLoader origLoader = Utility.setContextClassLoader((ClassLoader)this.containerClassLoader);
            for (Object elt : array = this.list.toArray()) {
                try {
                    this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                    ++this.destroyedCount;
                    try {
                        this.factory.destroy(elt);
                    }
                    catch (Throwable th) {
                        _logger.log(Level.FINE, "exception in close", th);
                    }
                }
                catch (Throwable th) {
                    _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Error while destroying", th);
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Pool-{0}]: Pool closed....", this.poolName);
            }
            this.list.clear();
            this.unregisterProbeProvider();
            Utility.setContextClassLoader((ClassLoader)origLoader);
            this.poolClosed = true;
            this.list.clear();
            this.factory = null;
            this.poolTimerTask = null;
            this.containerClassLoader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int count) {
        ArrayList removeList = new ArrayList();
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int size = this.list.size();
            for (int i = 0; i < count && size > 0; ++i) {
                removeList.add(this.list.remove(--size));
                this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                ++this.destroyedCount;
            }
        }
        int sz = removeList.size();
        for (int i = 0; i < sz; ++i) {
            try {
                this.factory.destroy(removeList.get(i));
                continue;
            }
            catch (Throwable th) {
                _logger.log(Level.FINE, "exception in remove", th);
            }
        }
    }

    @Override
    protected void removeIdleObjects() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doResize() {
        block62: {
            block60: {
                block58: {
                    if (this.poolClosed) {
                        return;
                    }
                    currentThread = Thread.currentThread();
                    previousClassLoader = currentThread.getContextClassLoader();
                    ctxClassLoader = this.containerClassLoader;
                    startTime = 0L;
                    enteredResizeBlock = false;
                    if (System.getSecurityManager() == null) {
                        currentThread.setContextClassLoader(ctxClassLoader);
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                currentThread.setContextClassLoader(ctxClassLoader);
                                return null;
                            }
                        });
                    }
                    if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                        NonBlockingPool._logger.log(Level.FINE, "[Pool-{0}]: Resize started at: {1} steadyPoolSize ::{2} resizeQuantity ::{3} maxPoolSize ::{4}", new Object[]{this.poolName, new Date(), this.steadyPoolSize, this.resizeQuantity, this.maxPoolSize});
                    }
                    startTime = System.currentTimeMillis();
                    removeList = new ArrayList();
                    populateCount = 0L;
                    var10_10 = this.list;
                    synchronized (var10_10) {
                        if (!this.inResizing && !this.poolClosed) ** break block57
                        // MONITOREXIT @DISABLED, blocks:[16, 0, 1] lbl23 : MonitorExitStatement: MONITOREXIT : var10_10
                        if (!enteredResizeBlock) break block58;
                        var11_11 = this.list;
                    }
                    synchronized (var11_11) {
                        this.inResizing = false;
                    }
                }
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(previousClassLoader);
                } else {
                    AccessController.doPrivileged((PrivilegedAction<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doResize$0(java.lang.Thread java.lang.ClassLoader ), ()Ljava/lang/Object;)((Thread)currentThread, (ClassLoader)previousClassLoader));
                }
                return;
                {
                    enteredResizeBlock = true;
                    this.inResizing = true;
                    curSize = this.list.size();
                    if (curSize <= this.steadyPoolSize) ** GOTO lbl75
                    if (this.idleTimeoutInSeconds > 0 && this.resizeQuantity > 0) ** break block59
                    // MONITOREXIT @DISABLED, blocks:[16, 3] lbl46 : MonitorExitStatement: MONITOREXIT : var10_10
                    if (!enteredResizeBlock) break block60;
                    var12_15 = this.list;
                }
                synchronized (var12_15) {
                    this.inResizing = false;
                }
            }
            if (System.getSecurityManager() == null) {
                currentThread.setContextClassLoader(previousClassLoader);
            } else {
                AccessController.doPrivileged((PrivilegedAction<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doResize$0(java.lang.Thread java.lang.ClassLoader ), ()Ljava/lang/Object;)((Thread)currentThread, (ClassLoader)previousClassLoader));
            }
            return;
            {
                victimCount = curSize > this.steadyPoolSize + this.resizeQuantity ? this.resizeQuantity : curSize - this.steadyPoolSize;
                allowedIdleTime = System.currentTimeMillis() - (long)this.idleTimeoutInSeconds * 1000L;
                if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                    NonBlockingPool._logger.log(Level.FINE, "[Pool-{0}]: Resize:: reducing  pool size by: {1}", new Object[]{this.poolName, victimCount});
                }
                for (i = 0; i < victimCount && (ctx = (EJBContextImpl)this.list.get(0)).getLastTimeUsed() <= allowedIdleTime; ++i) {
                    removeList.add(this.list.remove(0));
                    this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                    ++this.destroyedCount;
                }
                ** GOTO lbl104
lbl75:
                // 1 sources

                if (curSize >= this.steadyPoolSize) ** GOTO lbl104
                if (this.maintainSteadySize) ** break block61
                // MONITOREXIT @DISABLED, blocks:[16, 5] lbl77 : MonitorExitStatement: MONITOREXIT : var10_10
                if (!enteredResizeBlock) break block62;
                victimCount = this.list;
            }
            synchronized (victimCount) {
                this.inResizing = false;
            }
        }
        if (System.getSecurityManager() == null) {
            currentThread.setContextClassLoader(previousClassLoader);
        } else {
            AccessController.doPrivileged((PrivilegedAction<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doResize$0(java.lang.Thread java.lang.ClassLoader ), ()Ljava/lang/Object;)((Thread)currentThread, (ClassLoader)previousClassLoader));
        }
        return;
        {
            try {
                if (this.resizeQuantity <= 0) {
                    populateCount = this.steadyPoolSize - curSize;
                } else {
                    while ((long)curSize + populateCount < (long)this.steadyPoolSize) {
                        populateCount += (long)this.resizeQuantity;
                    }
                    if ((long)curSize + populateCount > (long)this.maxPoolSize) {
                        populateCount -= (long)curSize + populateCount - (long)this.maxPoolSize;
                    }
                }
lbl104:
                // 6 sources

                // MONITOREXIT @DISABLED, blocks:[16, 7, 8] lbl104 : MonitorExitStatement: MONITOREXIT : var10_10
                {
                    catch (Throwable var18_24) {
                        throw var18_24;
                    }
                }
                if (removeList.size() > 0) {
                    for (E aRemoveList : removeList) {
                        try {
                            this.factory.destroy(aRemoveList);
                        }
                        catch (Throwable th) {
                            NonBlockingPool._logger.log(Level.FINE, "exception in doResize", th);
                        }
                    }
                }
                if (populateCount > 0L) {
                    if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                        NonBlockingPool._logger.log(Level.FINE, "[Pool-{0}]: Attempting to preload {1} beans. CurSize/MaxPoolSize: {2}/{3}", new Object[]{this.poolName, populateCount, this.list.size(), this.maxPoolSize});
                    }
                    this.preload((int)populateCount);
                    if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                        NonBlockingPool._logger.log(Level.FINE, "[Pool-{0}]: After preload CurSize/MaxPoolSize: {1}/{2}", new Object[]{this.poolName, this.list.size(), this.maxPoolSize});
                    }
                }
                break block63;
            }
            catch (Throwable th) {
                NonBlockingPool._logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Exception during reSize", th);
            }
            break block63;
        }
        {
            block63: {
                finally {
                    if (enteredResizeBlock) {
                        removeList = this.list;
                        synchronized (removeList) {
                            this.inResizing = false;
                        }
                    }
                    if (System.getSecurityManager() == null) {
                        currentThread.setContextClassLoader(previousClassLoader);
                    } else {
                        AccessController.doPrivileged((PrivilegedAction<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doResize$0(java.lang.Thread java.lang.ClassLoader ), ()Ljava/lang/Object;)((Thread)currentThread, (ClassLoader)previousClassLoader));
                    }
                }
            }
            endTime = System.currentTimeMillis();
            if (NonBlockingPool._logger.isLoggable(Level.FINE)) {
                NonBlockingPool._logger.log(Level.FINE, "[Pool-{0}]: Resize completed at: {1}; after reSize: {2}", new Object[]{this.poolName, new Date(), this.getAllAttrValues()});
                NonBlockingPool._logger.log(Level.FINE, "[Pool-{0}]: Resize took: {1} seconds.", new Object[]{this.poolName, (double)(endTime - startTime) / 1000.0});
            }
            return;
        }
    }

    @Override
    public String getAllAttrValues() {
        StringBuilder sbuf = new StringBuilder("[Pool-" + this.poolName + "] ");
        sbuf.append("CC=").append(this.createdCount).append("; ").append("DC=").append(this.destroyedCount).append("; ").append("CS=").append(this.list.size()).append("; ").append("SS=").append(this.steadyPoolSize).append("; ").append("MS=").append(this.maxPoolSize).append(";");
        return sbuf.toString();
    }

    private static /* synthetic */ Object lambda$doResize$0(Thread currentThread, ClassLoader previousClassLoader) {
        currentThread.setContextClassLoader(previousClassLoader);
        return null;
    }

    private class PoolResizeTimerTask
    extends TimerTask {
        PoolResizeTimerTask() {
        }

        @Override
        public void run() {
            try {
                if (NonBlockingPool.this.addedIdleBeanWork) {
                    return;
                }
                NonBlockingPool.this.addedIdleBeanWork = true;
                IdleBeanWork work = new IdleBeanWork();
                EjbContainerUtilImpl.getInstance().addWork(work);
            }
            catch (Exception ex) {
                NonBlockingPool.this.addedIdleBeanWork = false;
                AbstractPool._logger.log(Level.WARNING, "[Pool-" + NonBlockingPool.this.poolName + "]: Cannot perform  pool idle bean cleanup", ex);
            }
        }
    }

    private class IdleBeanWork
    implements Runnable {
        private IdleBeanWork() {
        }

        public void prolog() {
        }

        public void service() {
            this.run();
        }

        public void epilog() {
        }

        @Override
        public void run() {
            try {
                NonBlockingPool.this.doResize();
            }
            catch (Exception exception) {
            }
            finally {
                NonBlockingPool.this.addedIdleBeanWork = false;
            }
        }
    }

    private class ReSizeWork
    implements Runnable {
        private ReSizeWork() {
        }

        public void prolog() {
        }

        public void service() {
            this.run();
        }

        public void epilog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                NonBlockingPool.this.doResize();
            }
            catch (Exception ex) {
                AbstractPool._logger.log(Level.WARNING, "[Pool-" + NonBlockingPool.this.poolName + "]: Exception during reSize", ex);
            }
            finally {
                ArrayList arrayList = NonBlockingPool.this.list;
                synchronized (arrayList) {
                    NonBlockingPool.this.addedResizeTask = false;
                }
            }
        }
    }
}

