/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.descriptor;

import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.deployment.common.Descriptor;

public final class ContainerTransaction
extends Descriptor {
    private String transactionAttribute;
    public static final String NOT_SUPPORTED = "NotSupported";
    public static final String SUPPORTS = "Supports";
    public static final String REQUIRED = "Required";
    public static final String REQUIRES_NEW = "RequiresNew";
    public static final String MANDATORY = "Mandatory";
    public static final String NEVER = "Never";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ContainerTransaction.class);

    public ContainerTransaction(ContainerTransaction other) {
        if (other != null) {
            this.transactionAttribute = other.transactionAttribute;
            this.setDescription(other.getDescription());
        }
    }

    public ContainerTransaction(String transactionAttribute, String description) {
        super("a Container Transaction", description);
        boolean isValidAttribute;
        boolean bl = isValidAttribute = NOT_SUPPORTED.equals(transactionAttribute) || SUPPORTS.equals(transactionAttribute) || REQUIRED.equals(transactionAttribute) || REQUIRES_NEW.equals(transactionAttribute) || MANDATORY.equals(transactionAttribute) || NEVER.equals(transactionAttribute);
        if (!isValidAttribute && ContainerTransaction.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionunknowncontainertxtype", "Unknown ContainerTransaction type: {0}", new Object[]{transactionAttribute}));
        }
        this.transactionAttribute = transactionAttribute;
    }

    public String getTransactionAttribute() {
        return this.transactionAttribute;
    }

    public boolean equals(Object other) {
        if (other instanceof ContainerTransaction) {
            ContainerTransaction otherContainerTransaction = (ContainerTransaction)((Object)other);
            return otherContainerTransaction.getTransactionAttribute().equals(this.getTransactionAttribute());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getTransactionAttribute().hashCode();
        return result;
    }

    public void print(StringBuilder toStringBuilder) {
        toStringBuilder.append("Container Transaction: ").append(this.getTransactionAttribute()).append("@").append(this.getDescription());
    }
}

