/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.policy;

import fish.payara.microprofile.faulttolerance.FaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.policy.Policy;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.faulttolerance.Timeout;

public final class TimeoutPolicy
extends Policy {
    public final long value;
    public final ChronoUnit unit;

    public TimeoutPolicy(Method annotatedMethod, long value, ChronoUnit unit) {
        TimeoutPolicy.checkAtLeast(0L, annotatedMethod, Timeout.class, "value", value);
        this.value = value;
        this.unit = unit;
    }

    public static TimeoutPolicy create(InvocationContext context, FaultToleranceConfig config) {
        if (config.isAnnotationPresent(Timeout.class) && config.isEnabled(Timeout.class)) {
            Timeout annotation = config.getAnnotation(Timeout.class);
            return new TimeoutPolicy(context.getMethod(), config.value(annotation), config.unit(annotation));
        }
        return null;
    }

    public long toMillis() {
        return Duration.of(this.value, this.unit).toMillis();
    }
}

