/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.rest.app.service;

import fish.payara.microprofile.openapi.api.OpenAPIBuildException;
import fish.payara.microprofile.openapi.impl.OpenApiService;
import fish.payara.microprofile.openapi.impl.model.OpenAPIImpl;
import fish.payara.microprofile.openapi.impl.processor.BaseProcessor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.openapi.models.OpenAPI;

@Path(value="/")
public class OpenApiResource {
    private static final Logger LOGGER = Logger.getLogger(OpenApiResource.class.getName());

    @GET
    @Produces(value={"text/plain", "application/json"})
    public Response getResponse(@Context HttpServletRequest request, @Context HttpServletResponse response) throws IOException {
        OpenApiService openApiService = OpenApiService.getInstance();
        if (!openApiService.isEnabled()) {
            response.sendError(Response.Status.FORBIDDEN.getStatusCode(), "MicroProfile OpenAPI Service is disabled.");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        OpenAPI document = null;
        try {
            document = openApiService.getDocument();
        }
        catch (OpenAPIBuildException | IOException | CloneNotSupportedException ex) {
            LOGGER.log(Level.WARNING, "OpenAPI document creation failed: " + ex.getMessage(), ex);
        }
        if (document == null) {
            LOGGER.info("No OpenAPI document found.");
            OpenAPI result = new BaseProcessor(new ArrayList<URL>()).process(new OpenAPIImpl(), null);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)result).build();
        }
        return Response.ok((Object)document).build();
    }
}

