/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.rest.init;

import fish.payara.microprofile.openapi.impl.admin.OpenApiServiceConfiguration;
import fish.payara.microprofile.openapi.rest.app.OpenApiApplication;
import jakarta.servlet.HttpConstraintElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.annotation.ServletSecurity;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.glassfish.common.util.StringHelper;
import org.glassfish.internal.api.Globals;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class OpenApiServletContainerInitializer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        if (!"".equals(ctx.getContextPath())) {
            return;
        }
        OpenApiServiceConfiguration configuration = (OpenApiServiceConfiguration)Globals.getDefaultHabitat().getService(OpenApiServiceConfiguration.class, new Annotation[0]);
        Map registrations = ctx.getServletRegistrations();
        for (ServletRegistration reg : registrations.values()) {
            if (!reg.getMappings().contains(configuration.getEndpoint())) continue;
            return;
        }
        String virtualServers = configuration.getVirtualServers();
        if (!StringHelper.isEmpty((String)virtualServers) && !Arrays.asList(virtualServers.split(",")).contains(ctx.getVirtualServerName())) {
            return;
        }
        ServletContainer servletContainer = new ServletContainer((ResourceConfig)new OpenApiApplication());
        ServletRegistration.Dynamic reg = ctx.addServlet("microprofile-openapi-servlet", (Servlet)servletContainer);
        reg.setLoadOnStartup(1);
        reg.addMapping(new String[]{"/" + configuration.getEndpoint() + "/*"});
        if (Boolean.parseBoolean(configuration.getSecurityEnabled())) {
            String[] roles = configuration.getRoles().split(",");
            reg.setServletSecurity(new ServletSecurityElement(new HttpConstraintElement(ServletSecurity.TransportGuarantee.CONFIDENTIAL, roles)));
            ctx.declareRoles(roles);
        }
    }
}

