/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.visitor;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.FieldModel;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.MethodModel;
import org.glassfish.hk2.classmodel.reflect.Parameter;

public final class AnnotationInfo {
    private final ExtensibleType<? extends ExtensibleType> type;
    private final Map<String, AnnotationModel> typeAnnotations = new ConcurrentHashMap<String, AnnotationModel>();
    private final Map<String, Map<String, AnnotationModel>> fieldAnnotations = new ConcurrentHashMap<String, Map<String, AnnotationModel>>();
    private final Map<String, Map<String, AnnotationModel>> methodAnnotations = new ConcurrentHashMap<String, Map<String, AnnotationModel>>();
    private final Map<String, Map<String, AnnotationModel>> methodParameterAnnotations = new ConcurrentHashMap<String, Map<String, AnnotationModel>>();

    AnnotationInfo(ExtensibleType<? extends ExtensibleType> type) {
        this.type = type;
        this.init(type);
    }

    public ExtensibleType<? extends ExtensibleType> getType() {
        return this.type;
    }

    public AnnotationModel getAnnotation(Class<? extends Annotation> annotationType) {
        return this.typeAnnotations.get(annotationType.getName());
    }

    public AnnotationModel getAnnotation(Class<? extends Annotation> annotationType, FieldModel field) {
        return this.fieldAnnotations.get(field.getName()).get(annotationType.getName());
    }

    public AnnotationModel getAnnotation(Class<? extends Annotation> annotationType, MethodModel method) {
        return this.methodAnnotations.get(AnnotationInfo.getSignature(method)).get(annotationType.getName());
    }

    public AnnotationModel getAnnotation(Class<? extends Annotation> annotationType, Parameter parameter) {
        return this.methodParameterAnnotations.get(AnnotationInfo.getIdentifier(parameter)).get(annotationType.getName());
    }

    public String getAnnotationValue(Class<? extends Annotation> annotationType) {
        AnnotationModel model = this.getAnnotation(annotationType);
        if (model != null) {
            return (String)model.getValue("value", String.class);
        }
        return null;
    }

    public String getAnnotationValue(Class<? extends Annotation> annotationType, AnnotatedElement parameter) {
        AnnotationModel model = this.getAnnotation(annotationType, parameter);
        if (model != null) {
            return (String)model.getValue("value", String.class);
        }
        return null;
    }

    public AnnotationModel getAnnotation(Class<? extends Annotation> annotationType, AnnotatedElement element) {
        if (element instanceof ClassModel) {
            return this.getAnnotation(annotationType);
        }
        if (element instanceof FieldModel) {
            return this.getAnnotation(annotationType, (FieldModel)element);
        }
        if (element instanceof MethodModel) {
            return this.getAnnotation(annotationType, (MethodModel)element);
        }
        if (element instanceof Parameter) {
            return this.getAnnotation(annotationType, (Parameter)element);
        }
        return null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType, FieldModel field) {
        return this.getAnnotation(annotationType, field) != null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType, MethodModel method) {
        return this.getAnnotation(annotationType, method) != null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType, Parameter parameter) {
        return this.getAnnotation(annotationType, parameter) != null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType, AnnotatedElement element) {
        return this.getAnnotation(annotationType, element) != null;
    }

    @SafeVarargs
    public final boolean isAnyAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> ... annotationTypes) {
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            if (!this.isAnnotationPresent(annotationType, element)) continue;
            return true;
        }
        return false;
    }

    public int getAnnotationCount(Parameter parameter) {
        return this.methodParameterAnnotations.get(AnnotationInfo.getIdentifier(parameter)).size();
    }

    private void init(ExtensibleType<? extends ExtensibleType> type) {
        ExtensibleType supertype = type.getParent();
        if (supertype != null) {
            this.init((ExtensibleType<? extends ExtensibleType>)supertype);
        }
        for (InterfaceModel implementedInterface : type.getInterfaces()) {
            if (implementedInterface == null || implementedInterface == type) continue;
            this.init((ExtensibleType<? extends ExtensibleType>)implementedInterface);
        }
        AnnotationInfo.putAll(type.getAnnotations(), this.typeAnnotations);
        if (type instanceof ClassModel) {
            for (FieldModel field : ((ClassModel)type).getFields()) {
                AnnotationInfo.putAll(field.getAnnotations(), this.fieldAnnotations.computeIfAbsent(field.getName(), key -> new ConcurrentHashMap()));
            }
        }
        for (MethodModel method : type.getMethods()) {
            AnnotationInfo.putAll(method.getAnnotations(), this.methodAnnotations.computeIfAbsent(AnnotationInfo.getSignature(method), key -> new ConcurrentHashMap()));
            for (Parameter parameter : method.getParameters()) {
                AnnotationInfo.putAll(parameter.getAnnotations(), this.methodParameterAnnotations.computeIfAbsent(AnnotationInfo.getIdentifier(parameter), key -> new ConcurrentHashMap()));
            }
        }
    }

    private static void putAll(Collection<AnnotationModel> annotations, Map<String, AnnotationModel> map) {
        for (AnnotationModel a : annotations) {
            map.put(a.getType().getName(), a);
        }
    }

    private static String getIdentifier(Parameter parameter) {
        return AnnotationInfo.getSignature(parameter.getMethod()) + "#" + parameter.getIndex();
    }

    private static String getSignature(MethodModel method) {
        StringBuilder signature = new StringBuilder();
        signature.append(method.getName());
        signature.append('(');
        for (String parameterType : method.getArgumentTypes()) {
            signature.append(parameterType).append(", ");
        }
        signature.append(')');
        return signature.toString();
    }
}

