/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid;

import fish.payara.security.openid.OpenIdUtil;
import fish.payara.security.openid.api.AccessToken;
import fish.payara.security.openid.api.IdentityToken;
import fish.payara.security.openid.domain.AccessTokenImpl;
import fish.payara.security.openid.domain.IdentityTokenImpl;
import jakarta.json.JsonObject;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.credential.Credential;
import java.util.Objects;

public class OpenIdCredential
implements Credential {
    private final HttpMessageContext httpContext;
    private final IdentityTokenImpl identityToken;
    private AccessToken accessToken;

    public OpenIdCredential(JsonObject tokensObject, HttpMessageContext httpContext, long tokenMinValidity) {
        this.httpContext = httpContext;
        this.identityToken = new IdentityTokenImpl(tokensObject.getString("id_token"), tokenMinValidity);
        String accessTokenString = tokensObject.getString("access_token", null);
        Long expiresIn = null;
        if (tokensObject.containsKey((Object)"expires_in")) {
            expiresIn = OpenIdUtil.parseLong(tokensObject, "expires_in");
        }
        String tokenType = tokensObject.getString("token_type", null);
        String scopeString = tokensObject.getString("scope", null);
        if (Objects.nonNull(accessTokenString)) {
            this.accessToken = new AccessTokenImpl(tokenType, accessTokenString, expiresIn, scopeString, tokenMinValidity);
        }
    }

    public IdentityToken getIdentityToken() {
        return this.identityToken;
    }

    IdentityTokenImpl getIdentityTokenImpl() {
        return this.identityToken;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public HttpMessageContext getHttpContext() {
        return this.httpContext;
    }
}

