/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid;

import fish.payara.security.annotations.AzureAuthenticationDefinition;
import fish.payara.security.annotations.GoogleAuthenticationDefinition;
import fish.payara.security.annotations.OpenIdAuthenticationDefinition;
import fish.payara.security.openid.AccessTokenIdentityStore;
import fish.payara.security.openid.AzureDefinitionConverter;
import fish.payara.security.openid.GoogleDefinitionConverter;
import fish.payara.security.openid.InjectionWorkaround;
import fish.payara.security.openid.OpenIdAuthenticationMechanism;
import fish.payara.security.openid.OpenIdIdentityStore;
import fish.payara.security.openid.controller.AuthenticationController;
import fish.payara.security.openid.controller.ConfigurationController;
import fish.payara.security.openid.controller.JWTValidator;
import fish.payara.security.openid.controller.NonceController;
import fish.payara.security.openid.controller.ProviderMetadataContoller;
import fish.payara.security.openid.controller.StateController;
import fish.payara.security.openid.controller.TokenController;
import fish.payara.security.openid.controller.UserInfoController;
import fish.payara.security.openid.domain.OpenIdContextImpl;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessBeanAttributes;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.Producer;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class OpenIdExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(OpenIdExtension.class.getName());
    private OpenIdAuthenticationDefinition definition;
    private Class<?> definitionSource;
    private boolean definitionActive;
    private Producer<IdentityStoreHandler> storeHandlerWorkaroundProducer;

    protected void registerTypes(@Observes BeforeBeanDiscovery before) {
        this.registerTypes(before, AuthenticationController.class, ConfigurationController.class, NonceController.class, ProviderMetadataContoller.class, StateController.class, TokenController.class, UserInfoController.class, OpenIdContextImpl.class, OpenIdIdentityStore.class, AccessTokenIdentityStore.class, OpenIdAuthenticationMechanism.class, JWTValidator.class);
    }

    private void registerTypes(BeforeBeanDiscovery event, Class<?> ... classes) {
        for (Class<?> aClass : classes) {
            event.addAnnotatedType(aClass, aClass.getName());
        }
    }

    protected void findOpenIdDefinitionAnnotation(@Observes @WithAnnotations(value={OpenIdAuthenticationDefinition.class}) ProcessAnnotatedType<?> event) {
        Class beanClass = event.getAnnotatedType().getJavaClass();
        OpenIdAuthenticationDefinition standardDefinition = (OpenIdAuthenticationDefinition)event.getAnnotatedType().getAnnotation(OpenIdAuthenticationDefinition.class);
        this.setDefinition(standardDefinition, beanClass, "Generic");
    }

    private void setDefinition(OpenIdAuthenticationDefinition definition, Class<?> sourceClass, String definitionKind) {
        if (this.definition != null) {
            LOGGER.warning("Multiple authentication definition found. Will ignore the definition in " + sourceClass);
            return;
        }
        this.validateExtraParametersFormat(definition);
        this.definitionSource = sourceClass;
        this.definition = definition;
        LOGGER.log(Level.INFO, "Activating {0} OpenID Connect authentication definition from class {1}", new Object[]{definitionKind, sourceClass.getName()});
    }

    protected void findGoogleDefinitionAnnotation(@Observes @WithAnnotations(value={GoogleAuthenticationDefinition.class}) ProcessAnnotatedType<?> event) {
        Class beanClass = event.getAnnotatedType().getJavaClass();
        OpenIdAuthenticationDefinition standardDefinition = GoogleDefinitionConverter.toOpenIdAuthDefinition((GoogleAuthenticationDefinition)event.getAnnotatedType().getAnnotation(GoogleAuthenticationDefinition.class));
        this.setDefinition(standardDefinition, beanClass, "Google");
    }

    protected void findAzureDefinitionAnnotation(@Observes @WithAnnotations(value={AzureAuthenticationDefinition.class}) ProcessAnnotatedType<?> event) {
        Class beanClass = event.getAnnotatedType().getJavaClass();
        OpenIdAuthenticationDefinition standardDefinition = AzureDefinitionConverter.toOpenIdAuthDefinition((AzureAuthenticationDefinition)event.getAnnotatedType().getAnnotation(AzureAuthenticationDefinition.class));
        this.setDefinition(standardDefinition, beanClass, "Azure");
    }

    protected void validateExtraParametersFormat(OpenIdAuthenticationDefinition definition) {
        for (String extraParameter : definition.extraParameters()) {
            String[] parts = extraParameter.split("=");
            if (parts.length == 2) continue;
            throw new DefinitionException(OpenIdAuthenticationDefinition.class.getSimpleName() + ".extraParameters() value '" + extraParameter + "' is not of the format key=value");
        }
    }

    protected void watchActiveBeans(@Observes ProcessBean<?> processBean) {
        if (this.definitionSource != null && this.definitionSource.equals(processBean.getAnnotated().getBaseType())) {
            this.definitionActive = true;
        }
    }

    protected void watchForInjectionWorkaround(@Observes @Any ProcessProducer<?, IdentityStoreHandler> workedAroundBean) {
        if (!workedAroundBean.getAnnotatedMember().isAnnotationPresent(InjectionWorkaround.class)) {
            return;
        }
        this.storeHandlerWorkaroundProducer = workedAroundBean.getProducer();
    }

    protected void redefineConfigControllerScope(@Observes ProcessBeanAttributes<ConfigurationController> controller) {
        Config mpConfig = ConfigProvider.getConfig();
        boolean sessionScopedConfig = false;
        try {
            sessionScopedConfig = mpConfig.getOptionalValue("payara.security.openid.sessionScopedConfiguration", Boolean.TYPE).orElse(false);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warning("The value of payara.security.openid.sessionScopedConfigurationis not a boolean value. The OpenID connector will be configured only once for all requests.");
        }
        if (sessionScopedConfig) {
            LOGGER.info("Using per-session OpenIdConfiguration");
            controller.configureBeanAttributes().scope(SessionScoped.class);
        }
    }

    protected void registerDefinition(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (this.definitionActive) {
            Set workaroundBeans;
            afterBeanDiscovery.addBean().beanClass(HttpAuthenticationMechanism.class).addType(HttpAuthenticationMechanism.class).id(OpenIdExtension.class.getName() + "/OpenIdAuthenticationMechanism").scope(ApplicationScoped.class).produceWith(in -> (OpenIdAuthenticationMechanism)in.select(OpenIdAuthenticationMechanism.class, new Annotation[0]).get()).disposeWith((inst, callback) -> callback.destroy(inst));
            afterBeanDiscovery.addBean().beanClass(IdentityStore.class).addType(IdentityStore.class).id(OpenIdExtension.class.getName() + "/OpenIdIdentityStore").scope(ApplicationScoped.class).produceWith(in -> (OpenIdIdentityStore)in.select(OpenIdIdentityStore.class, new Annotation[0]).get()).disposeWith((inst, callback) -> callback.destroy(inst));
            afterBeanDiscovery.addBean().beanClass(IdentityStore.class).addType(IdentityStore.class).id(OpenIdExtension.class.getName() + "/AccessTokenIdentityStore").scope(ApplicationScoped.class).produceWith(in -> (AccessTokenIdentityStore)in.select(AccessTokenIdentityStore.class, new Annotation[0]).get()).disposeWith((inst, callback) -> callback.destroy(inst));
            afterBeanDiscovery.addBean().beanClass(OpenIdAuthenticationDefinition.class).types(new Type[]{OpenIdAuthenticationDefinition.class}).scope(ApplicationScoped.class).id("OpenId Definition").createWith(cc -> this.definition);
            if (this.storeHandlerWorkaroundProducer != null && (workaroundBeans = beanManager.getBeans(IdentityStoreHandler.class, new Annotation[]{InjectionWorkaround.LITERAL})).isEmpty()) {
                afterBeanDiscovery.addBean().beanClass(IdentityStoreHandler.class).types(new Type[]{IdentityStoreHandler.class}).addQualifier((Annotation)InjectionWorkaround.LITERAL).createWith(arg_0 -> this.storeHandlerWorkaroundProducer.produce(arg_0)).destroyWith((inst, cc) -> this.storeHandlerWorkaroundProducer.dispose(inst));
            }
        } else {
            afterBeanDiscovery.addBean().beanClass(OpenIdAuthenticationDefinition.class).types(new Type[]{OpenIdAuthenticationDefinition.class}).scope(Dependent.class).id("Null OpenId Definition").createWith(cc -> null);
        }
    }
}

