/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.domain;

import fish.payara.security.openid.OpenIdUtil;
import fish.payara.security.openid.api.AccessToken;
import fish.payara.security.openid.api.IdentityToken;
import fish.payara.security.openid.api.JwtClaims;
import fish.payara.security.openid.api.OpenIdClaims;
import fish.payara.security.openid.api.OpenIdContext;
import fish.payara.security.openid.api.RefreshToken;
import fish.payara.security.openid.controller.AuthenticationController;
import fish.payara.security.openid.controller.UserInfoController;
import fish.payara.security.openid.domain.JsonClaims;
import fish.payara.security.openid.domain.LogoutConfiguration;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import jakarta.enterprise.context.SessionScoped;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@SessionScoped
public class OpenIdContextImpl
implements OpenIdContext {
    @Inject
    UserInfoController userInfoController;
    private String callerName;
    private Set<String> callerGroups;
    private String tokenType;
    private AccessToken accessToken;
    private IdentityToken identityToken;
    private RefreshToken refreshToken;
    private Long expiresIn;
    private JsonObject claims;
    @Inject
    private OpenIdConfiguration configuration;
    @Inject
    private AuthenticationController authenticationController;
    private static final Logger LOGGER = Logger.getLogger(OpenIdContextImpl.class.getName());

    @Override
    public String getCallerName() {
        return this.callerName;
    }

    public void setCallerName(String callerName) {
        this.callerName = callerName;
    }

    @Override
    public Set<String> getCallerGroups() {
        return this.callerGroups;
    }

    public void setCallerGroups(Set<String> callerGroups) {
        this.callerGroups = callerGroups;
    }

    @Override
    public String getSubject() {
        return (String)this.getIdentityToken().getClaim("sub");
    }

    @Override
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @Override
    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(AccessToken token) {
        this.accessToken = token;
    }

    @Override
    public IdentityToken getIdentityToken() {
        return this.identityToken;
    }

    public void setIdentityToken(IdentityToken identityToken) {
        this.identityToken = identityToken;
    }

    @Override
    public Optional<RefreshToken> getRefreshToken() {
        return Optional.ofNullable(this.refreshToken);
    }

    public void setRefreshToken(RefreshToken refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Override
    public Optional<Long> getExpiresIn() {
        return Optional.ofNullable(this.expiresIn);
    }

    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Override
    public JsonObject getClaimsJson() {
        if (this.claims == null) {
            if (this.configuration != null && this.accessToken != null) {
                if (!this.configuration.isUserClaimsFromIDToken()) {
                    this.claims = this.userInfoController.getUserInfo(this.configuration, this.accessToken);
                } else {
                    LOGGER.log(Level.FINEST, "Processing user info from ID Token");
                    this.claims = this.processUserClaimsFromIDToken();
                }
            } else {
                this.claims = Json.createObjectBuilder().build();
            }
        }
        return this.claims;
    }

    protected JsonObject processUserClaimsFromIDToken() {
        JwtClaims identityTokenJWTClaims = this.identityToken.getJwtClaims();
        JwtClaims accessTokenJWTClaims = this.accessToken.getJwtClaims();
        JsonObject userInfo = Json.createObjectBuilder().add("sub", identityTokenJWTClaims.getStringClaim("sub").orElse("")).add("name", identityTokenJWTClaims.getStringClaim("name").orElse("")).add("family_name", accessTokenJWTClaims.getStringClaim("family_name").orElse("")).add("given_name", accessTokenJWTClaims.getStringClaim("given_name").orElse("")).add("email", identityTokenJWTClaims.getStringClaim("email").orElse("")).build();
        if (!this.getSubject().equals(userInfo.getString("sub"))) {
            throw new IllegalStateException("UserInfo Response is invalid as sub claim must match with the sub Claim in the ID Token");
        }
        return userInfo;
    }

    @Override
    public OpenIdClaims getClaims() {
        return new JsonClaims(this.getClaimsJson());
    }

    @Override
    public JsonObject getProviderMetadata() {
        return this.configuration.getProviderMetadata().getDocument();
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response) {
        LogoutConfiguration logout = this.configuration.getLogoutConfiguration();
        try {
            request.logout();
        }
        catch (ServletException ex) {
            LOGGER.log(Level.WARNING, "Failed to logout the user.", ex);
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        if (logout == null) {
            LOGGER.log(Level.WARNING, "Logout invoked on session without OpenID session");
            OpenIdContextImpl.redirect(response, request.getContextPath());
            return;
        }
        String endSessionEndpoint = this.configuration.getProviderMetadata().getEndSessionEndpoint();
        if (logout.isNotifyProvider() && !OpenIdUtil.isEmpty(endSessionEndpoint) && this.getIdentityToken() != null) {
            UriBuilder logoutURI = UriBuilder.fromUri((String)endSessionEndpoint).queryParam("id_token_hint", new Object[]{this.getIdentityToken().getToken()});
            if (!OpenIdUtil.isEmpty(logout.getRedirectURI())) {
                logoutURI.queryParam("post_logout_redirect_uri", new Object[]{logout.buildRedirectURI(this.configuration.getProxyConfiguration(), request)});
            }
            OpenIdContextImpl.redirect(response, logoutURI.toString());
        } else if (!OpenIdUtil.isEmpty(logout.getRedirectURI())) {
            OpenIdContextImpl.redirect(response, logout.buildRedirectURI(this.configuration.getProxyConfiguration(), request));
        } else {
            this.authenticationController.authenticateUser(request, response);
        }
    }

    private static void redirect(HttpServletResponse response, String uri) {
        try {
            response.sendRedirect(uri);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

