/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.shaded.nimbusds.jose.crypto.factories;

import fish.payara.security.shaded.nimbusds.jose.JOSEException;
import fish.payara.security.shaded.nimbusds.jose.JWSAlgorithm;
import fish.payara.security.shaded.nimbusds.jose.JWSSigner;
import fish.payara.security.shaded.nimbusds.jose.crypto.ECDSASigner;
import fish.payara.security.shaded.nimbusds.jose.crypto.Ed25519Signer;
import fish.payara.security.shaded.nimbusds.jose.crypto.MACSigner;
import fish.payara.security.shaded.nimbusds.jose.crypto.RSASSASigner;
import fish.payara.security.shaded.nimbusds.jose.crypto.impl.BaseJWSProvider;
import fish.payara.security.shaded.nimbusds.jose.jca.JCAContext;
import fish.payara.security.shaded.nimbusds.jose.jwk.ECKey;
import fish.payara.security.shaded.nimbusds.jose.jwk.JWK;
import fish.payara.security.shaded.nimbusds.jose.jwk.JWKException;
import fish.payara.security.shaded.nimbusds.jose.jwk.KeyUse;
import fish.payara.security.shaded.nimbusds.jose.jwk.OctetKeyPair;
import fish.payara.security.shaded.nimbusds.jose.jwk.OctetSequenceKey;
import fish.payara.security.shaded.nimbusds.jose.jwk.RSAKey;
import fish.payara.security.shaded.nimbusds.jose.produce.JWSSignerFactory;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultJWSSignerFactory
implements JWSSignerFactory {
    private final JCAContext jcaContext = new JCAContext();
    public static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS;

    @Override
    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return SUPPORTED_ALGORITHMS;
    }

    @Override
    public JCAContext getJCAContext() {
        return this.jcaContext;
    }

    @Override
    public JWSSigner createJWSSigner(JWK key) throws JOSEException {
        BaseJWSProvider signer;
        if (!key.isPrivate()) {
            throw JWKException.expectedPrivate();
        }
        if (key.getKeyUse() != null && !KeyUse.SIGNATURE.equals(key.getKeyUse())) {
            throw new JWKException("The JWK use must be sig (signature) or unspecified");
        }
        if (key instanceof OctetSequenceKey) {
            signer = new MACSigner((OctetSequenceKey)key);
        } else if (key instanceof RSAKey) {
            signer = new RSASSASigner((RSAKey)key);
        } else if (key instanceof ECKey && ECDSASigner.SUPPORTED_CURVES.contains(((ECKey)key).getCurve())) {
            signer = new ECDSASigner((ECKey)key);
        } else if (key instanceof OctetKeyPair && Ed25519Signer.SUPPORTED_CURVES.contains(((OctetKeyPair)key).getCurve())) {
            signer = new Ed25519Signer((OctetKeyPair)key);
        } else {
            throw new JOSEException("Unsupported JWK type and / or curve");
        }
        ((JCAContext)signer.getJCAContext()).setSecureRandom(this.jcaContext.getSecureRandom());
        ((JCAContext)signer.getJCAContext()).setProvider(this.jcaContext.getProvider());
        return signer;
    }

    @Override
    public JWSSigner createJWSSigner(JWK key, JWSAlgorithm alg) throws JOSEException {
        BaseJWSProvider signer;
        if (!key.isPrivate()) {
            throw JWKException.expectedPrivate();
        }
        if (key.getKeyUse() != null && !KeyUse.SIGNATURE.equals(key.getKeyUse())) {
            throw new JWKException("The JWK use must be sig (signature) or unspecified");
        }
        if (MACSigner.SUPPORTED_ALGORITHMS.contains(alg) && key instanceof OctetSequenceKey) {
            signer = new MACSigner((OctetSequenceKey)key);
        } else if (RSASSASigner.SUPPORTED_ALGORITHMS.contains(alg) && key instanceof RSAKey) {
            signer = new RSASSASigner((RSAKey)key);
        } else if (ECDSASigner.SUPPORTED_ALGORITHMS.contains(alg) && key instanceof ECKey && ECDSASigner.SUPPORTED_CURVES.contains(((ECKey)key).getCurve())) {
            signer = new ECDSASigner((ECKey)key);
        } else if (Ed25519Signer.SUPPORTED_ALGORITHMS.contains(alg) && key instanceof OctetKeyPair && Ed25519Signer.SUPPORTED_CURVES.contains(((OctetKeyPair)key).getCurve())) {
            signer = new Ed25519Signer((OctetKeyPair)key);
        } else {
            throw new JOSEException("Unsupported JWK type, JWK curve and / or JWS algorithm");
        }
        ((JCAContext)signer.getJCAContext()).setSecureRandom(this.jcaContext.getSecureRandom());
        ((JCAContext)signer.getJCAContext()).setProvider(this.jcaContext.getProvider());
        return signer;
    }

    static {
        LinkedHashSet algs = new LinkedHashSet();
        algs.addAll(MACSigner.SUPPORTED_ALGORITHMS);
        algs.addAll(RSASSASigner.SUPPORTED_ALGORITHMS);
        algs.addAll(ECDSASigner.SUPPORTED_ALGORITHMS);
        algs.addAll(Ed25519Signer.SUPPORTED_ALGORITHMS);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(algs);
    }
}

