/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.shaded.nimbusds.jose.crypto.factories;

import fish.payara.security.shaded.nimbusds.jose.JOSEException;
import fish.payara.security.shaded.nimbusds.jose.JWSAlgorithm;
import fish.payara.security.shaded.nimbusds.jose.JWSHeader;
import fish.payara.security.shaded.nimbusds.jose.JWSVerifier;
import fish.payara.security.shaded.nimbusds.jose.KeyTypeException;
import fish.payara.security.shaded.nimbusds.jose.crypto.ECDSAVerifier;
import fish.payara.security.shaded.nimbusds.jose.crypto.MACVerifier;
import fish.payara.security.shaded.nimbusds.jose.crypto.RSASSAVerifier;
import fish.payara.security.shaded.nimbusds.jose.crypto.impl.BaseJWSProvider;
import fish.payara.security.shaded.nimbusds.jose.jca.JCAContext;
import fish.payara.security.shaded.nimbusds.jose.proc.JWSVerifierFactory;
import fish.payara.security.shaded.nimbusds.jose.shaded.jcip.ThreadSafe;
import java.security.Key;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.SecretKey;

@ThreadSafe
public class DefaultJWSVerifierFactory
implements JWSVerifierFactory {
    public static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS;
    private final JCAContext jcaContext = new JCAContext();

    @Override
    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return SUPPORTED_ALGORITHMS;
    }

    @Override
    public JCAContext getJCAContext() {
        return this.jcaContext;
    }

    @Override
    public JWSVerifier createJWSVerifier(JWSHeader header, Key key) throws JOSEException {
        BaseJWSProvider verifier;
        if (MACVerifier.SUPPORTED_ALGORITHMS.contains(header.getAlgorithm())) {
            if (!(key instanceof SecretKey)) {
                throw new KeyTypeException(SecretKey.class);
            }
            SecretKey macKey = (SecretKey)key;
            verifier = new MACVerifier(macKey);
        } else if (RSASSAVerifier.SUPPORTED_ALGORITHMS.contains(header.getAlgorithm())) {
            if (!(key instanceof RSAPublicKey)) {
                throw new KeyTypeException(RSAPublicKey.class);
            }
            RSAPublicKey rsaPublicKey = (RSAPublicKey)key;
            verifier = new RSASSAVerifier(rsaPublicKey);
        } else if (ECDSAVerifier.SUPPORTED_ALGORITHMS.contains(header.getAlgorithm())) {
            if (!(key instanceof ECPublicKey)) {
                throw new KeyTypeException(ECPublicKey.class);
            }
            ECPublicKey ecPublicKey = (ECPublicKey)key;
            verifier = new ECDSAVerifier(ecPublicKey);
        } else {
            throw new JOSEException("Unsupported JWS algorithm: " + header.getAlgorithm());
        }
        ((JCAContext)verifier.getJCAContext()).setProvider(this.jcaContext.getProvider());
        return verifier;
    }

    static {
        LinkedHashSet algs = new LinkedHashSet();
        algs.addAll(MACVerifier.SUPPORTED_ALGORITHMS);
        algs.addAll(RSASSAVerifier.SUPPORTED_ALGORITHMS);
        algs.addAll(ECDSAVerifier.SUPPORTED_ALGORITHMS);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(algs);
    }
}

