/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class ConnectionExecutionContext {
    public static final String IIOP_CLIENT_PER_THREAD_FLAG = "com.sun.appserv.iiopclient.perthreadauth";
    private static final boolean isPerThreadAuth = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean(ConnectionExecutionContext.IIOP_CLIENT_PER_THREAD_FLAG);
        }
    });
    private static final ThreadLocal<Hashtable<String, Object>> currentContext = isPerThreadAuth ? new ThreadLocal() : new InheritableThreadLocal();
    private static final ThreadLocal<Long> ClientThreadID = new ThreadLocal();

    public static Long readClientThreadID() {
        return ClientThreadID.get();
    }

    public static void setClientThreadID(Long ClientThreadID) {
        ConnectionExecutionContext.ClientThreadID.set(ClientThreadID);
    }

    public static void removeClientThreadID() {
        ClientThreadID.remove();
    }

    public static void setContext(Hashtable<String, Object> ctxTable) {
        if (ctxTable != null) {
            currentContext.set(ctxTable);
        } else {
            currentContext.set(new Hashtable());
        }
    }

    public static Hashtable<String, Object> getContext() {
        if (currentContext.get() == null) {
            ConnectionExecutionContext.setContext(null);
        }
        return currentContext.get();
    }
}

