/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSI.CompleteEstablishContext;
import com.sun.corba.ee.org.omg.CSI.ContextError;
import com.sun.corba.ee.org.omg.CSI.EstablishContext;
import com.sun.corba.ee.org.omg.CSI.GSS_NT_ExportedNameHelper;
import com.sun.corba.ee.org.omg.CSI.IdentityToken;
import com.sun.corba.ee.org.omg.CSI.SASContextBody;
import com.sun.corba.ee.org.omg.CSI.SASContextBodyHelper;
import com.sun.corba.ee.org.omg.CSI.X501DistinguishedNameHelper;
import com.sun.corba.ee.org.omg.CSI.X509CertificateChainHelper;
import com.sun.corba.ee.spi.legacy.connection.Connection;
import com.sun.corba.ee.spi.legacy.interceptor.RequestInfoExt;
import com.sun.enterprise.common.iiop.security.AnonCredential;
import com.sun.enterprise.common.iiop.security.GSSUPName;
import com.sun.enterprise.common.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.ConnectionExecutionContext;
import com.sun.enterprise.iiop.security.Counter;
import com.sun.enterprise.iiop.security.GSSUPToken;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.iiop.security.Lookups;
import com.sun.enterprise.iiop.security.SecurityContextUtil;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.iiop.security.ServerConnectionContext;
import com.sun.enterprise.iiop.security.SvcContextUtils;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.enterprise.security.auth.realm.certificate.OID;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class SecServerRequestInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LogDomains.getLogger(SecServerRequestInterceptor.class, (String)"javax.enterprise.system.core.security");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SecServerRequestInterceptor.class);
    private final ThreadLocal<Counter> counterForCalls = new ThreadLocal<Counter>(){

        @Override
        protected Counter initialValue() {
            return new Counter();
        }
    };
    protected static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;
    private static final int INVALID_MECHANISM_MAJOR = 2;
    private static final int INVALID_MECHANISM_MINOR = 1;
    public static final String SERVER_CONNECTION_CONTEXT = "ServerConnContext";
    private static final boolean NO_REPLACE = false;
    private final String prname;
    private final String name;
    private final Codec codec;
    private final SecurityContextUtil secContextUtil;
    private final GlassFishORBHelper orbHelper;
    private final SecurityMechanismSelector smSelector;

    public SecServerRequestInterceptor(String name, Codec codec) {
        this.name = name;
        this.codec = codec;
        this.prname = name + "::";
        this.secContextUtil = Lookups.getSecurityContextUtil();
        this.orbHelper = Lookups.getGlassFishORBHelper();
        this.smSelector = Lookups.getSecurityMechanismSelector();
    }

    public String name() {
        return this.name;
    }

    private SASContextBody createContextError(int status) {
        return this.createContextError(1, status);
    }

    private SASContextBody createContextError(int major, int minor) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Creating ContextError message: major code = {0}minor code= {1}", new Object[]{major, minor});
        }
        byte[] error_token = new byte[]{};
        ContextError ce = new ContextError(0L, major, minor, error_token);
        SASContextBody sasctxtbody = new SASContextBody();
        sasctxtbody.error_msg(ce);
        return sasctxtbody;
    }

    private SASContextBody createCompleteEstablishContext(int status) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Creating CompleteEstablishContext message");
        }
        byte[] final_context_token = new byte[]{};
        CompleteEstablishContext completeEstablishContext = new CompleteEstablishContext(0L, false, final_context_token);
        SASContextBody sasctxtbody = new SASContextBody();
        sasctxtbody.complete_msg(completeEstablishContext);
        return sasctxtbody;
    }

    private ServiceContext createSvcContext(SASContextBody sasContextBody, ORB orb) {
        Any any = orb.create_any();
        SASContextBodyHelper.insert((Any)any, (SASContextBody)sasContextBody);
        byte[] cdr_encoded_saselm = new byte[]{};
        try {
            cdr_encoded_saselm = this.codec.encode_value(any);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "iiop.encode_exception", e);
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.context_id = 15;
        serviceContext.context_data = cdr_encoded_saselm;
        return serviceContext;
    }

    private void createIdCred(SecurityContext securityContext, IdentityToken identityToken) throws Exception {
        switch (identityToken.discriminator()) {
            case 0: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Identity token type is Absent");
                }
                securityContext.identcls = null;
                break;
            }
            case 1: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Identity token type is Anonymous");
                    logger.log(Level.FINE, "Adding AnonyCredential to subject's PublicCredentials");
                }
                securityContext.subject.getPublicCredentials().add(new AnonCredential());
                securityContext.identcls = AnonCredential.class;
                break;
            }
            case 8: {
                byte[] derEncoding = identityToken.dn();
                if (this.isCDR(derEncoding)) {
                    Any any = this.codec.decode_value(derEncoding, X501DistinguishedNameHelper.type());
                    derEncoding = X501DistinguishedNameHelper.extract((Any)any);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Create an X500Principal object from identity token");
                }
                X500Principal xname = new X500Principal(derEncoding);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Identity to be asserted is {0}", xname.toString());
                    logger.log(Level.FINE, "Adding X500Principal to subject's PublicCredentials");
                }
                securityContext.subject.getPublicCredentials().add(xname);
                securityContext.identcls = X500Principal.class;
                break;
            }
            case 4: {
                byte[] derEncoding;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Identity token type is a X509 Certificate Chain");
                }
                if (this.isCDR(derEncoding = identityToken.certificate_chain())) {
                    Any any = this.codec.decode_value(derEncoding, X509CertificateChainHelper.type());
                    derEncoding = X509CertificateChainHelper.extract((Any)any);
                }
                List<? extends Certificate> certificates = CertificateFactory.getInstance("X.509").generateCertPath(new ByteArrayInputStream(derEncoding)).getCertificates();
                X509Certificate[] certchain = new X509Certificate[certificates.size()];
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Content of X509 Certificate chain:");
                }
                for (int i = 0; i < certchain.length; ++i) {
                    certchain[i] = (X509Certificate)certificates.get(i);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "    " + certchain[i].getSubjectX500Principal().getName("RFC2253", OID.getOIDMap()));
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Creating a X509CertificateCredential object from certchain");
                }
                X509CertificateCredential cred = new X509CertificateCredential(certchain, certchain[0].getSubjectX500Principal().getName("RFC2253", OID.getOIDMap()), "default");
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Adding X509CertificateCredential to subject's PublicCredentials");
                }
                securityContext.subject.getPublicCredentials().add(cred);
                securityContext.identcls = X509CertificateCredential.class;
                break;
            }
            case 2: {
                byte[] expname;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Identity token type is GSS Exported Name");
                }
                if (this.isCDR(expname = identityToken.principal_name())) {
                    Any any = this.codec.decode_value(expname, GSS_NT_ExportedNameHelper.type());
                    expname = GSS_NT_ExportedNameHelper.extract((Any)any);
                }
                if (!GSSUtils.verifyMechOID(GSSUtils.GSSUP_MECH_OID, expname)) {
                    throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_unknown_idassert_type", "Unknown identity assertion type."));
                }
                GSSUPName gssname = new GSSUPName(expname);
                securityContext.subject.getPublicCredentials().add(gssname);
                securityContext.identcls = GSSUPName.class;
                logger.log(Level.FINE, "Adding GSSUPName credential to subject");
                break;
            }
            default: {
                logger.log(Level.SEVERE, "iiop.unknown_identity");
                throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_unknown_idassert_type", "Unknown identity assertion type."));
            }
        }
    }

    private boolean isCDR(byte[] bytes) {
        return bytes != null && bytes.length > 0 && (bytes[0] == 0 || bytes[0] == 1);
    }

    private void createAuthCredential(final SecurityContext securityContext, byte[] authToken, ORB orb) throws Exception {
        logger.log(Level.FINE, "Constructing a PasswordCredential from client authentication token");
        final PasswordCredential passwordCredential = GSSUPToken.getServerSideInstance(orb, this.codec, authToken).getPwdcred();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Password credential = " + passwordCredential.toString());
            logger.log(Level.FINE, "Adding PasswordCredential to subject's PrivateCredentials");
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                securityContext.subject.getPrivateCredentials().add(passwordCredential);
                return null;
            }
        });
        securityContext.authcls = PasswordCredential.class;
    }

    private void handle_null_service_context(ServerRequestInfo serverRequestInfo, ORB orb) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "No SAS context element found in service context list for operation: " + serverRequestInfo.operation());
        }
        ServiceContext serviceContext = null;
        int secStatus = this.secContextUtil.setSecurityContext(null, serverRequestInfo.object_id(), serverRequestInfo.operation(), this.getServerSocket());
        if (secStatus == 1) {
            SASContextBody sasctxbody = this.createContextError(2, 1);
            serviceContext = this.createSvcContext(sasctxbody, orb);
            serverRequestInfo.add_reply_service_context(serviceContext, false);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "SecServerRequestInterceptor.receive_request: NO_PERMISSION");
            }
            throw new NO_PERMISSION();
        }
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        Any SasAny;
        SecurityContext securityContext = null;
        ServiceContext serviceContext = null;
        int status = 0;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "++++ Entered " + this.prname + "receive_request");
        }
        ORB orb = this.orbHelper.getORB();
        try {
            serviceContext = serverRequestInfo.get_request_service_context(15);
            if (serviceContext == null) {
                this.handle_null_service_context(serverRequestInfo, orb);
                return;
            }
        }
        catch (BAD_PARAM e) {
            this.handle_null_service_context(serverRequestInfo, orb);
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Received a non null SAS context element");
        }
        try {
            SasAny = this.codec.decode_value(serviceContext.context_data, SASContextBodyHelper.type());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "iiop.decode_exception", e);
            throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_cdr_decode", "CDR Decoding error for SAS context element."));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Successfully decoded CDR encoded SAS context element.");
        }
        SASContextBody sasctxbody = SASContextBodyHelper.extract((Any)SasAny);
        short sasdiscr = sasctxbody.discriminator();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "SAS context element is a/an " + SvcContextUtils.getMsgname(sasdiscr) + " message");
        }
        if (sasdiscr == 5) {
            sasctxbody = this.createContextError(4);
            serviceContext = this.createSvcContext(sasctxbody, orb);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Adding ContextError message to service context list");
                logger.log(Level.FINE, "SecurityContext set to null");
            }
            serverRequestInfo.add_reply_service_context(serviceContext, false);
            throw new NO_PERMISSION();
        }
        if (sasdiscr != 0) {
            logger.log(Level.SEVERE, "iiop.not_establishcontext_msg");
            throw new SecurityException(localStrings.getLocalString("secserverreqinterceptor.err_not_ec_msg", "Received message not an EstablishContext message."));
        }
        EstablishContext establishContext = sasctxbody.establish_msg();
        securityContext = new SecurityContext();
        securityContext.subject = new Subject();
        try {
            if (establishContext.client_authentication_token.length != 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Message contains Client Authentication Token");
                }
                this.createAuthCredential(securityContext, establishContext.client_authentication_token, orb);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "iiop.authentication_exception", e);
            throw new SecurityException(localStrings.getLocalString("secsercverreqinterceptor.err_cred_create", "Error while creating a JAAS subject credential."));
        }
        try {
            if (establishContext.identity_token != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Message contains an Identity Token");
                }
                this.createIdCred(securityContext, establishContext.identity_token);
            }
        }
        catch (SecurityException secex) {
            logger.log(Level.SEVERE, "iiop.security_exception", secex);
            sasctxbody = this.createContextError(2, 1);
            serviceContext = this.createSvcContext(sasctxbody, orb);
            serverRequestInfo.add_reply_service_context(serviceContext, false);
            throw new NO_PERMISSION();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "iiop.generic_exception", e);
            throw new SecurityException(localStrings.getLocalString("secsercverreqinterceptor.err_cred_create", "Error while creating a JAAS subject credential."));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Invoking setSecurityContext() to set security context");
        }
        status = this.secContextUtil.setSecurityContext(securityContext, serverRequestInfo.object_id(), serverRequestInfo.operation(), this.getServerSocket());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "setSecurityContext() returned status code " + status);
        }
        if (status == 1) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "setSecurityContext() returned STATUS_FAILED");
            }
            sasctxbody = this.createContextError(status);
            serviceContext = this.createSvcContext(sasctxbody, orb);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Adding ContextError message to service context list");
            }
            serverRequestInfo.add_reply_service_context(serviceContext, false);
            throw new NO_PERMISSION();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "setSecurityContext() returned SUCCESS");
        }
        sasctxbody = this.createCompleteEstablishContext(status);
        serviceContext = this.createSvcContext(sasctxbody, orb);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Adding CompleteEstablisContext message to service context list");
        }
        serverRequestInfo.add_reply_service_context(serviceContext, false);
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        Counter cntr = this.counterForCalls.get();
        if (cntr.count == 0) {
            SecurityContextUtil.unsetSecurityContext(this.isLocal());
        }
        cntr.increment();
        Socket socket = null;
        Connection connection = null;
        if (serverRequestInfo instanceof RequestInfoExt) {
            connection = ((RequestInfoExt)serverRequestInfo).connection();
        }
        ServerConnectionContext serverConnectionContext = null;
        if (connection != null) {
            socket = connection.getSocket();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "RECEIVED request on connection: " + connection);
                logger.log(Level.FINE, "Socket =" + socket);
            }
            serverConnectionContext = new ServerConnectionContext(socket);
        } else {
            serverConnectionContext = new ServerConnectionContext();
        }
        SecServerRequestInterceptor.setServerConnectionContext(serverConnectionContext);
    }

    public void send_reply(ServerRequestInfo ri) {
        this.unsetSecurityContext();
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        this.unsetSecurityContext();
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        this.unsetSecurityContext();
    }

    public void destroy() {
    }

    private void unsetSecurityContext() {
        try {
            Counter cntr = this.counterForCalls.get();
            cntr.decrement();
            if (cntr.count <= 0) {
                cntr.count = 0;
                SecurityContextUtil.unsetSecurityContext(this.isLocal());
            }
        }
        finally {
            ConnectionExecutionContext.removeClientThreadID();
        }
    }

    private boolean isLocal() {
        Long clientID;
        boolean local = true;
        ServerConnectionContext scc = this.getServerConnectionContext();
        if (scc != null && scc.getSocket() != null) {
            local = false;
        }
        if ((clientID = ConnectionExecutionContext.readClientThreadID()) != null && clientID.longValue() == Thread.currentThread().getId()) {
            local = true;
        }
        return local;
    }

    private Socket getServerSocket() {
        ServerConnectionContext scc = this.getServerConnectionContext();
        if (scc != null) {
            return scc.getSocket();
        }
        return null;
    }

    private ServerConnectionContext getServerConnectionContext() {
        Hashtable<String, Object> h = ConnectionExecutionContext.getContext();
        ServerConnectionContext scc = (ServerConnectionContext)h.get(SERVER_CONNECTION_CONTEXT);
        return scc;
    }

    public static void setServerConnectionContext(ServerConnectionContext scc) {
        Hashtable<String, Object> h = ConnectionExecutionContext.getContext();
        h.put(SERVER_CONNECTION_CONTEXT, scc);
    }
}

