/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deployment.deploy.shared.JarArchive;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;

public class DeploymentPlanArchive
extends JarArchive
implements ReadableArchive {
    JarFile jarFile = null;
    URI uri = null;
    Vector elements = null;
    String subArchiveUri = null;
    private static final ServiceLocator locator = Globals.getDefaultHabitat();

    public void open(URI uri) throws IOException {
        this.uri = uri;
        File f = new File(uri);
        if (f.exists()) {
            this.jarFile = new JarFile(f);
        }
    }

    public long getArchiveSize() throws NullPointerException, SecurityException {
        if (this.uri == null) {
            return -1L;
        }
        File tmpFile = new File(this.uri);
        return tmpFile.length();
    }

    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
            this.jarFile = null;
        }
    }

    public void closeEntry() throws IOException {
    }

    public void closeEntry(ReadableArchive sub) throws IOException {
    }

    public boolean delete() {
        File f = new File(this.uri);
        if (f.exists()) {
            return FileUtils.deleteFile((File)f);
        }
        return false;
    }

    @Override
    public JarEntry getJarEntry(String name) {
        if (this.jarFile != null) {
            return this.jarFile.getJarEntry(name);
        }
        return null;
    }

    public Collection<String> getDirectories() throws IOException {
        return new Vector<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration entries() {
        Enumeration<Object> e;
        if (this.elements == null) {
            DeploymentPlanArchive deploymentPlanArchive = this;
            synchronized (deploymentPlanArchive) {
                this.elements = new Vector();
                e = this.jarFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry ze = (ZipEntry)e.nextElement();
                    if (ze.isDirectory() || ze.getName().startsWith("META-INF/")) continue;
                    this.elements.add(ze.getName());
                }
            }
        }
        Vector<Object> entries = new Vector<Object>();
        e = this.elements.elements();
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            Object mangledName = entryName;
            String prefix = "META-INF/";
            ArchiveType warType = (ArchiveType)locator.getService(ArchiveType.class, "war", new Annotation[0]);
            boolean isWar = DeploymentUtils.isArchiveOfType(this.getParentArchive(), warType, locator);
            if (entryName.contains("sun-web.xml") || entryName.contains("glassfish-web.xml") || entryName.contains("payara-web.xml")) {
                prefix = "WEB-INF/";
            } else if ((entryName.contains("glassfish-resources.xml") || entryName.contains("payara-resources.xml")) && isWar) {
                prefix = "WEB-INF/";
            } else if (entryName.contains("glassfish-services.xml") && isWar) {
                prefix = "WEB-INF/";
            }
            if (this.subArchiveUri != null && entryName.startsWith(this.subArchiveUri)) {
                mangledName = ((String)mangledName).substring(this.subArchiveUri.length() + 1);
            }
            mangledName = entryName.endsWith(".dbschema") ? ((String)mangledName).replaceAll("#", "/") : prefix + (String)mangledName;
            if (this.subArchiveUri == null) {
                if (entryName.contains(".jar.") || entryName.contains(".war.") || entryName.contains(".rar.")) continue;
                entries.add(mangledName);
                continue;
            }
            if (!entryName.startsWith(this.subArchiveUri)) continue;
            entries.add(mangledName);
        }
        return entries.elements();
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    public boolean exists() {
        File f = new File(this.uri);
        return f.exists();
    }

    public ReadableArchive getSubArchive(String name) throws IOException {
        if (this.jarFile == null) {
            return null;
        }
        DeploymentPlanArchive dpArchive = new DeploymentPlanArchive();
        dpArchive.jarFile = new JarFile(new File(this.uri));
        try {
            if (this.uri != null) {
                dpArchive.uri = new URI("file", this.uri.getSchemeSpecificPart() + File.separator + name, null);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        dpArchive.subArchiveUri = name;
        dpArchive.elements = this.elements;
        return dpArchive;
    }

    @Override
    public boolean exists(String name) throws IOException {
        return this.getEntry(name) != null;
    }

    public InputStream getEntry(String name) throws IOException {
        name = name.endsWith(".dbschema") ? name.replaceAll("/", "#") : name.substring(name.lastIndexOf(47) + 1);
        if (this.subArchiveUri == null) {
            return this.getElement(name);
        }
        String mangledName = this.subArchiveUri + "." + name;
        return this.getElement(mangledName);
    }

    public long getEntrySize(String name) {
        if (this.elements.contains(name)) {
            ZipEntry je = this.jarFile.getEntry(name);
            return je.getSize();
        }
        return 0L;
    }

    private InputStream getElement(String name) throws IOException {
        if (this.elements.contains(name)) {
            return this.jarFile.getInputStream(this.jarFile.getEntry(name));
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        return new Manifest();
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean renameTo(String name) {
        File f = new File(this.uri);
        File to = new File(name);
        boolean result = FileUtils.renameFile((File)f, (File)to);
        if (result) {
            this.uri = to.toURI();
        }
        return result;
    }
}

