/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.ClientArtifactsManager;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.logging.annotation.LogMessageInfo;

public class ClientJarWriter {
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    @LogMessageInfo(message="Exception caught:  {0}", level="WARNING")
    private static final String EXCEPTION_CAUGHT = "NCLS-DEPLOYMENT-00004";
    private final String LINE_SEP = System.getProperty("line.separator");
    private final ExtendedDeploymentContext deploymentContext;
    private final String name;
    private Map<URI, JarFile> jarFiles = new HashMap<URI, JarFile>();

    public ClientJarWriter(ExtendedDeploymentContext deploymentContext) {
        this.deploymentContext = deploymentContext;
        this.name = VersioningUtils.getUntaggedName(((DeployCommandParameters)deploymentContext.getCommandParameters(DeployCommandParameters.class)).name());
    }

    public void run() throws IOException {
        if (this.isArtifactsPresent()) {
            deplLogger.log(Level.FINE, "Skipping possible client JAR generation because it would already have been done");
            return;
        }
        Artifacts downloadableArtifacts = DeploymentUtils.downloadableArtifacts((DeploymentContext)this.deploymentContext);
        Artifacts generatedArtifacts = DeploymentUtils.generatedArtifacts((DeploymentContext)this.deploymentContext);
        File clientJarFile = this.createClientJARIfNeeded(this.deploymentContext, this.name);
        if (clientJarFile == null) {
            deplLogger.log(Level.FINE, "No client JAR generation is needed.");
        } else {
            deplLogger.log(Level.FINE, "Generated client JAR {0} for possible download", clientJarFile.getAbsolutePath());
            downloadableArtifacts.addArtifact(clientJarFile.toURI(), clientJarFile.getName());
            generatedArtifacts.addArtifact(clientJarFile.toURI(), clientJarFile.getName());
        }
    }

    private boolean isArtifactsPresent() {
        return this.deploymentContext.getCommandParameters(OpsParams.class).origin.isArtifactsPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createClientJARIfNeeded(ExtendedDeploymentContext deploymentContext, String appName) throws IOException {
        ClientArtifactsManager clientArtifactsManager = ClientArtifactsManager.get((DeploymentContext)deploymentContext);
        if (clientArtifactsManager.isEmpty()) {
            return null;
        }
        deploymentContext.prepareScratchDirs();
        String generatedClientJARName = ClientJarWriter.generatedClientJARNameAndType(appName);
        File generatedClientJARFile = new File(deploymentContext.getScratchDir("xml"), generatedClientJARName);
        File movedPreexistingFile = null;
        if (generatedClientJARFile.exists()) {
            try {
                movedPreexistingFile = this.mergeContentsToClientArtifactsManager(generatedClientJARFile, clientArtifactsManager);
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        }
        ArrayList<Artifacts.FullAndPartURIs> artifacts = new ArrayList<Artifacts.FullAndPartURIs>(clientArtifactsManager.artifacts());
        OutputJarArchive generatedClientJAR = new OutputJarArchive();
        try {
            try {
                generatedClientJAR.create(generatedClientJARFile.toURI());
                if (!this.isManifestPresent(artifacts)) {
                    deplLogger.log(Level.FINER, "Adding a simple manifest; one was not already generated");
                    this.addManifest(artifacts);
                }
                this.copyArtifactsToClientJAR(generatedClientJAR, artifacts);
            }
            finally {
                generatedClientJAR.close();
            }
        }
        catch (IOException ex) {
            FileUtils.deleteFileNowOrLater((File)generatedClientJARFile);
        }
        finally {
            if (movedPreexistingFile != null) {
                FileUtils.deleteFileNowOrLater((File)movedPreexistingFile);
            }
        }
        return generatedClientJARFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File mergeContentsToClientArtifactsManager(File generatedClientJARFile, ClientArtifactsManager clientArtifactsManager) throws IOException, URISyntaxException {
        File movedGeneratedFile = File.createTempFile(generatedClientJARFile.getName(), ".tmp", generatedClientJARFile.getParentFile());
        FileUtils.renameFile((File)generatedClientJARFile, (File)movedGeneratedFile);
        existingGeneratedJAR.open(movedGeneratedFile.toURI());
        try (InputJarArchive existingGeneratedJAR = new InputJarArchive();){
            Enumeration e = existingGeneratedJAR.entries();
            while (e.hasMoreElements()) {
                String entryName = (String)e.nextElement();
                URI entryURI = new URI("jar", movedGeneratedFile.toURI().toASCIIString() + "!/" + entryName, null);
                Artifacts.FullAndPartURIs uris = new Artifacts.FullAndPartURIs(entryURI, entryName);
                clientArtifactsManager.add(uris);
            }
            Artifacts.FullAndPartURIs manifestURIs = new Artifacts.FullAndPartURIs(new URI("jar", movedGeneratedFile.toURI().toASCIIString() + "!/META-INF/MANIFEST.MF", null), "META-INF/MANIFEST.MF");
            clientArtifactsManager.add(manifestURIs);
            File file = movedGeneratedFile;
            return file;
        }
    }

    private boolean isManifestPresent(Collection<Artifacts.FullAndPartURIs> artifacts) {
        boolean isManifestPresent = false;
        for (Artifacts.FullAndPartURIs a : artifacts) {
            isManifestPresent |= a.getPart().toASCIIString().equals("META-INF/MANIFEST.MF");
        }
        return isManifestPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addManifest(Collection<Artifacts.FullAndPartURIs> artifacts) throws IOException {
        File mfFile = File.createTempFile("clientmf", ".MF");
        try (BufferedOutputStream mfOS = new BufferedOutputStream(new FileOutputStream(mfFile));){
            Manifest mf = new Manifest();
            mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            mf.write(mfOS);
        }
        artifacts.add(new Artifacts.FullAndPartURIs(mfFile.toURI(), "META-INF/MANIFEST.MF", true));
    }

    private static String generatedClientJARNameAndType(String earName) {
        return ClientJarWriter.generatedClientJARPrefix(earName) + ".jar";
    }

    private static String generatedClientJARPrefix(String earName) {
        return earName + "Client";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyArtifactsToClientJAR(WritableArchive generatedClientJARArchive, Collection<Artifacts.FullAndPartURIs> artifacts) throws IOException {
        HashSet<String> pathsWrittenToJAR = new HashSet<String>();
        StringBuilder copiedFiles = deplLogger.isLoggable(Level.FINER) ? new StringBuilder() : null;
        for (Artifacts.FullAndPartURIs artifact : artifacts) {
            String artPath = artifact.getPart().getRawPath();
            int previousSlash = artPath.indexOf(47);
            while (previousSlash != -1) {
                String partialAncestorPath = artPath.substring(0, previousSlash + 1);
                if (!pathsWrittenToJAR.contains(partialAncestorPath)) {
                    generatedClientJARArchive.putNextEntry(partialAncestorPath);
                    generatedClientJARArchive.closeEntry();
                    pathsWrittenToJAR.add(partialAncestorPath);
                }
                previousSlash = artPath.indexOf(47, previousSlash + 1);
            }
            OutputStream os = generatedClientJARArchive.putNextEntry(artifact.getPart().toASCIIString());
            InputStream is = null;
            try {
                URI fullURI = artifact.getFull();
                String scheme = fullURI.getScheme();
                if (scheme.equals("file")) {
                    is = new BufferedInputStream(new FileInputStream(new File(artifact.getFull())));
                } else if (scheme.equals("jar")) {
                    String ssp = fullURI.getSchemeSpecificPart();
                    URI jarURI = new URI(ssp.substring(0, ssp.indexOf("!/")));
                    JarFile jf = this.jarFiles.get(jarURI);
                    if (jf == null) {
                        jf = new JarFile(new File(jarURI));
                        this.jarFiles.put(jarURI, jf);
                    }
                    String entryName = ssp.substring(ssp.indexOf("!/") + 2);
                    JarEntry jarEntry = jf.getJarEntry(entryName);
                    is = jf.getInputStream(jarEntry);
                } else {
                    throw new IllegalArgumentException(scheme + " != [file,jar]");
                }
                DeploymentUtils.copyStream(is, os);
                if (copiedFiles == null) continue;
                copiedFiles.append(this.LINE_SEP).append("  ").append(artifact.getFull().toASCIIString()).append(" -> ").append(artifact.getPart().toASCIIString());
            }
            catch (Exception ex) {
                deplLogger.log(Level.WARNING, EXCEPTION_CAUGHT, ex.getLocalizedMessage());
            }
            finally {
                if (is != null) {
                    is.close();
                }
                generatedClientJARArchive.closeEntry();
                if (!artifact.isTemporary()) continue;
                FileUtils.deleteFileNowOrLater((File)new File(artifact.getFull()));
            }
        }
        if (copiedFiles != null) {
            deplLogger.log(Level.FINER, copiedFiles.toString());
        }
    }
}

