/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.aws.client;

import fish.payara.microprofile.config.extensions.aws.client.AuthUtils;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

@Provider
public class AwsAuthFeature
implements ClientRequestFilter {
    private static final Logger LOGGER = Logger.getLogger(AwsAuthFeature.class.getName());
    private final String accessKey;
    private final String secretKey;

    public AwsAuthFeature(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public synchronized void filter(ClientRequestContext requestContext) throws IOException {
        MultivaluedMap headers = requestContext.getStringHeaders();
        Context filterContext = new Context();
        filterContext.method = requestContext.getMethod();
        filterContext.query = requestContext.getUri().getQuery();
        filterContext.timestamp = (String)headers.getFirst((Object)"X-Amz-Date");
        filterContext.date = filterContext.timestamp.split("T")[0];
        filterContext.host = requestContext.getUri().getHost();
        filterContext.region = filterContext.host.split("\\.")[1];
        filterContext.serviceName = filterContext.host.split("\\.")[0];
        filterContext.payload = requestContext.getEntity().toString().trim();
        filterContext.xAmzContentSha256 = requestContext.getHeaderString("X-Amz-Content-Sha256");
        filterContext.xAmzTarget = requestContext.getHeaderString("X-Amz-Target");
        filterContext.contentType = requestContext.getHeaderString("Content-Type");
        try {
            requestContext.getHeaders().putSingle((Object)"Authorization", (Object)this.generateAwsAuthSignature(filterContext));
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to create Authorization header", ex);
        }
    }

    private String generateAwsAuthSignature(Context filterContext) throws Exception {
        Object stringToSign = "";
        stringToSign = "AWS4-HMAC-SHA256\n";
        stringToSign = (String)stringToSign + filterContext.timestamp + "\n";
        stringToSign = (String)stringToSign + filterContext.date + "/" + filterContext.region + "/" + filterContext.serviceName + "/aws4_request\n";
        stringToSign = (String)stringToSign + AuthUtils.generateHex(this.prepareCanonicalUrl(filterContext));
        if (LOGGER.isLoggable(Level.FINER)) {
            System.out.println("String to sign: " + (String)stringToSign);
        }
        byte[] signatureKey = AuthUtils.getSignatureKey(this.secretKey, filterContext.date, filterContext.region, filterContext.serviceName);
        byte[] signature = AuthUtils.HmacSHA256(signatureKey, (String)stringToSign);
        String strHexSignature = AuthUtils.bytesToHex(signature);
        return MessageFormat.format("AWS4-HMAC-SHA256 Credential={0}/{1}/{2}/{3}/aws4_request, SignedHeaders=content-type;host;x-amz-content-sha256;x-amz-date;x-amz-target, Signature={4}", this.accessKey, filterContext.date, filterContext.region, filterContext.serviceName, strHexSignature);
    }

    private String prepareCanonicalUrl(Context filterContext) {
        Object canonicalURL = "";
        canonicalURL = (String)canonicalURL + filterContext.method;
        canonicalURL = (String)canonicalURL + "\n";
        canonicalURL = (String)canonicalURL + "/";
        canonicalURL = (String)canonicalURL + "\n";
        canonicalURL = (String)canonicalURL + filterContext.query;
        canonicalURL = (String)canonicalURL + "\n";
        canonicalURL = (String)canonicalURL + MessageFormat.format("content-type:{0}\n", filterContext.contentType);
        canonicalURL = (String)canonicalURL + MessageFormat.format("host:{0}\n", filterContext.host);
        canonicalURL = (String)canonicalURL + MessageFormat.format("x-amz-content-sha256:{0}\n", filterContext.xAmzContentSha256);
        canonicalURL = (String)canonicalURL + MessageFormat.format("x-amz-date:{0}\n", filterContext.timestamp);
        canonicalURL = (String)canonicalURL + MessageFormat.format("x-amz-target:{0}\n", filterContext.xAmzTarget);
        canonicalURL = (String)canonicalURL + "\ncontent-type;host;x-amz-content-sha256;x-amz-date;x-amz-target\n";
        canonicalURL = (String)canonicalURL + AuthUtils.generateHex(filterContext.payload);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Canonical URL: " + (String)canonicalURL);
        }
        return canonicalURL;
    }

    private static class Context {
        private String method;
        private String query;
        private String timestamp;
        private String date;
        private String host;
        private String region;
        private String serviceName;
        private String payload;
        private String xAmzContentSha256;
        private String xAmzTarget;
        private String contentType;

        private Context() {
        }
    }
}

