/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.toml.admin;

import fish.payara.microprofile.config.extensions.toml.TOMLConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.source.extension.BaseSetConfigSourceConfigurationCommand;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import java.beans.PropertyVetoException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="set-toml-config-source-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileConfigConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-toml-config-source-configuration", description="Configures TOML Config Source")})
public class SetTOMLConfigurationCommand
extends BaseSetConfigSourceConfigurationCommand<TOMLConfigSourceConfiguration> {
    @Param
    private String path;
    @Param
    private int depth;

    @Override
    protected void applyValues(ActionReport report, TOMLConfigSourceConfiguration configuration) throws PropertyVetoException {
        Path tomlPath = Paths.get(this.path, new String[0]);
        if (!Files.exists(tomlPath, new LinkOption[0]) || !Files.isReadable(tomlPath)) {
            report.appendMessage("Could not find readable file at " + tomlPath + "\n");
            if (tomlPath.isAbsolute()) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            Path instanceRoot = this.server.getInstanceRoot().toPath();
            Path relative = Paths.get(instanceRoot.toString(), this.path);
            if (!Files.exists(relative, new LinkOption[0]) || !Files.isReadable(relative)) {
                report.appendMessage("Could not find readable file at " + relative + "\n");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            tomlPath = relative;
        }
        report.appendMessage("Using readable file at " + tomlPath + "\n");
        super.applyValues(report, configuration);
        if (this.depth > 0) {
            configuration.setDepth(String.valueOf(this.depth));
        }
        if (this.path != null) {
            configuration.setPath(String.valueOf(tomlPath));
        }
    }
}

