/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.pool.BasicRunnable;
import com.sun.messaging.jmq.jmsserver.pool.ThreadPool;
import com.sun.messaging.jmq.jmsserver.service.imq.Operation;
import java.io.EOFException;
import java.io.IOException;

public class OperationRunnable
extends BasicRunnable {
    public static final int FOREVER = -1;
    public static final int UNTIL_DONE = 0;
    Operation op = null;
    int opcnt = 0;
    int operationCount = 0;
    protected int ioevents = 0;
    protected boolean wait = false;
    Object opUpdateLock = new Object();

    public OperationRunnable(int id, ThreadPool pool, boolean wait) {
        super(id, pool);
        this.wait = wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.opUpdateLock;
        synchronized (object) {
            this.op = null;
        }
        this.release();
    }

    @Override
    public void suspend() {
        super.suspend();
        if (this.op != null) {
            this.op.suspend();
        }
    }

    @Override
    public void resume() {
        super.resume();
        if (this.op != null) {
            this.op.resume();
        }
    }

    @Override
    public String toString() {
        return "OpRun[id =" + this.id + ", ioevents=" + this.ioevents + ", behavior=" + OperationRunnable.behaviorToString(this.behavior) + ", op={" + this.op + "}, state=" + this.stateToString(this.state) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignOperation(Operation newop, int ioevents, int how_long) throws IllegalAccessException {
        Object object = this.opUpdateLock;
        synchronized (object) {
            if (this.op != null) {
                throw new IllegalAccessException(Globals.getBrokerResources().getKString("B4117", "Error trying to assign " + newop + " to  assigned operation " + this));
            }
            this.op = newop;
            this.op.threadAssigned(this, ioevents);
            this.operationCount = how_long;
            this.opcnt = 0;
            this.ioevents = ioevents;
        }
        this.assigned();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeOperation() {
        Object object = this.opUpdateLock;
        synchronized (object) {
            if (this.op != null) {
                this.op.notifyRelease(this, this.ioevents);
                this.op = null;
            }
        }
        this.release();
    }

    public void destroy(String reason) {
        if (this.op != null) {
            this.op.destroy(true, 6, reason);
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process() throws IOException {
        Operation myop = null;
        Object object = this.opUpdateLock;
        synchronized (object) {
            myop = this.op;
        }
        if (myop == null || this.state < 3) {
            return;
        }
        if (!myop.isValid()) {
            this.freeOperation();
            return;
        }
        if (this.state > 5) {
            if (myop.isValid()) {
                myop.destroy(false, 4, "invalid operation");
            }
            this.freeOperation();
            throw new IOException(Globals.getBrokerResources().getKString("B4117", "Exiting"));
        }
        try {
            boolean done = myop.process(this.ioevents, this.wait);
            switch (this.operationCount) {
                case -1: {
                    return;
                }
                case 0: {
                    if (done) {
                        this.freeOperation();
                    }
                    return;
                }
            }
            ++this.opcnt;
            if (this.opcnt >= this.operationCount || done) {
                this.freeOperation();
            }
            return;
        }
        catch (IOException ex) {
            if (OperationRunnable.getDEBUG()) {
                this.logger.logStack(4, "Debug: Connection going away", ex);
            }
            if (ex instanceof EOFException) {
                myop.destroy(false, 5, Globals.getBrokerResources().getKString("B0061"));
            } else {
                myop.destroy(false, 4, ex.toString());
            }
            this.freeOperation();
            return;
        }
    }
}

