/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jacc;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.AuthorizationConstraint;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.SecurityRoleReference;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import com.sun.enterprise.security.jacc.ConstraintValue;
import com.sun.enterprise.security.jacc.MethodValue;
import com.sun.enterprise.security.jacc.PatternBuilder;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.security.common.Role;

public class JaccWebConstraintsTranslator {
    static final Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private static final int PT_DEFAULT = 0;
    private static final int PT_EXTENSION = 1;
    private static final int PT_PREFIX = 2;
    private static final int PT_EXACT = 3;

    private JaccWebConstraintsTranslator() {
    }

    public static void translateConstraintsToPermissions(WebBundleDescriptor webBundleDescriptor, PolicyConfiguration policyConfiguration) throws PolicyContextException {
        JaccWebConstraintsTranslator.createResourceAndDataPermissions(webBundleDescriptor, policyConfiguration);
        JaccWebConstraintsTranslator.createWebRoleRefPermission(webBundleDescriptor, policyConfiguration);
    }

    private static void createResourceAndDataPermissions(WebBundleDescriptor webBundleDescriptor, PolicyConfiguration policyConfiguration) throws PolicyContextException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(JaccWebConstraintsTranslator.class.getSimpleName(), "processConstraints");
            logger.log(Level.FINE, "JACC: constraint translation: CODEBASE = " + policyConfiguration.getContextID());
        }
        Map<String, PatternBuilder> patternBuilderMap = JaccWebConstraintsTranslator.parseConstraints(webBundleDescriptor);
        Permissions excluded = new Permissions();
        Permissions unchecked = new Permissions();
        HashMap<String, Permissions> perRole = new HashMap<String, Permissions>();
        boolean deny = webBundleDescriptor.isDenyUncoveredHttpMethods();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC: constraint capture: begin processing qualified url patterns - uncovered http methods will be " + (deny ? "denied" : "permitted"));
        }
        for (PatternBuilder patternBuilder : patternBuilderMap.values()) {
            if (patternBuilder.irrelevantByQualifier) continue;
            String urlPatternSpec = patternBuilder.urlPatternSpec.toString();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC: constraint capture: urlPattern: " + urlPatternSpec);
            }
            patternBuilder.handleUncovered(deny);
            JaccWebConstraintsTranslator.handleExcluded(excluded, patternBuilder, urlPatternSpec);
            JaccWebConstraintsTranslator.handlePerRole(perRole, patternBuilder, urlPatternSpec);
            JaccWebConstraintsTranslator.handleUnchecked(unchecked, patternBuilder, urlPatternSpec);
            JaccWebConstraintsTranslator.handleConnections(unchecked, patternBuilder, urlPatternSpec);
        }
        policyConfiguration.addToExcludedPolicy((PermissionCollection)excluded);
        policyConfiguration.addToUncheckedPolicy((PermissionCollection)unchecked);
        JaccWebConstraintsTranslator.logExcludedUncheckedPermissionsWritten(excluded, unchecked);
        for (Map.Entry entry : perRole.entrySet()) {
            String role = (String)entry.getKey();
            Permissions permissions = (Permissions)entry.getValue();
            policyConfiguration.addToRole(role, (PermissionCollection)permissions);
            JaccWebConstraintsTranslator.logPerRolePermissionsWritten(role, permissions);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(JaccWebConstraintsTranslator.class.getSimpleName(), "processConstraints");
        }
    }

    private static Map<String, PatternBuilder> parseConstraints(WebBundleDescriptor webBundleDescriptor) {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(JaccWebConstraintsTranslator.class.getSimpleName(), "parseConstraints");
        }
        Set roleSet = webBundleDescriptor.getRoles();
        HashMap<String, PatternBuilder> patternBuilderMap = new HashMap<String, PatternBuilder>();
        patternBuilderMap.put("/", new PatternBuilder("/"));
        for (SecurityConstraint securityConstraint : webBundleDescriptor.getSecurityConstraintsSet()) {
            logger.fine("JACC: constraint translation: begin parsing security constraint");
            AuthorizationConstraint authorizationConstraint = securityConstraint.getAuthorizationConstraint();
            UserDataConstraint dataConstraint = securityConstraint.getUserDataConstraint();
            for (WebResourceCollection webResourceCollection : securityConstraint.getWebResourceCollections()) {
                logger.fine("JACC: constraint translation: begin parsing web resource collection");
                for (String urlPattern : webResourceCollection.getUrlPatterns()) {
                    PatternBuilder patternBuilder;
                    if (urlPattern != null) {
                        urlPattern = urlPattern.replaceAll(":", "%3A");
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("JACC: constraint translation: process url pattern: " + urlPattern);
                    }
                    if ((patternBuilder = (PatternBuilder)patternBuilderMap.get(urlPattern)) == null) {
                        patternBuilder = new PatternBuilder(urlPattern);
                        for (Map.Entry patternBuilderEntry : patternBuilderMap.entrySet()) {
                            String otherUrl = (String)patternBuilderEntry.getKey();
                            int otherUrlType = JaccWebConstraintsTranslator.patternType(otherUrl);
                            switch (JaccWebConstraintsTranslator.patternType(urlPattern)) {
                                case 2: {
                                    if ((otherUrlType == 2 || otherUrlType == 3) && JaccWebConstraintsTranslator.implies(urlPattern, otherUrl)) {
                                        patternBuilder.addQualifier(otherUrl);
                                        break;
                                    }
                                    if (otherUrlType == 2 && JaccWebConstraintsTranslator.implies(otherUrl, urlPattern)) {
                                        ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                        break;
                                    }
                                    if (otherUrlType != 1 && otherUrlType != 0) break;
                                    ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                    break;
                                }
                                case 1: {
                                    if (otherUrlType == 2 || otherUrlType == 3 && JaccWebConstraintsTranslator.implies(urlPattern, otherUrl)) {
                                        patternBuilder.addQualifier(otherUrl);
                                        break;
                                    }
                                    if (otherUrlType != 0) break;
                                    ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                    break;
                                }
                                case 0: {
                                    if (otherUrlType == 0) break;
                                    patternBuilder.addQualifier(otherUrl);
                                    break;
                                }
                                case 3: {
                                    if ((otherUrlType == 2 || otherUrlType == 1) && JaccWebConstraintsTranslator.implies(otherUrl, urlPattern)) {
                                        ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                        break;
                                    }
                                    if (otherUrlType != 0) break;
                                    ((PatternBuilder)patternBuilderEntry.getValue()).addQualifier(urlPattern);
                                    break;
                                }
                            }
                        }
                        patternBuilderMap.put(urlPattern, patternBuilder);
                    }
                    BitSet methods = MethodValue.methodArrayToSet(webResourceCollection.getHttpMethodsAsArray());
                    BitSet omittedMethods = null;
                    if (methods.isEmpty()) {
                        omittedMethods = MethodValue.methodArrayToSet(webResourceCollection.getHttpMethodOmissionsAsArray());
                    }
                    patternBuilder.setMethodOutcomes(roleSet, authorizationConstraint, dataConstraint, methods, omittedMethods);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("JACC: constraint translation: end processing url pattern: " + urlPattern);
                }
                logger.fine("JACC: constraint translation: end parsing web resource collection");
            }
            logger.fine("JACC: constraint translation: end parsing security constraint");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(JaccWebConstraintsTranslator.class.getName(), "parseConstraints");
        }
        return patternBuilderMap;
    }

    private static void handleExcluded(Permissions collection, PatternBuilder patternBuilder, String name) {
        Object actions = null;
        BitSet excludedMethods = patternBuilder.getExcludedMethods();
        if (patternBuilder.otherConstraint.isExcluded()) {
            BitSet methods = patternBuilder.getMethodSet();
            methods.andNot(excludedMethods);
            if (!methods.isEmpty()) {
                actions = "!" + MethodValue.getActions(methods);
            }
        } else if (!excludedMethods.isEmpty()) {
            actions = MethodValue.getActions(excludedMethods);
        } else {
            return;
        }
        collection.add((Permission)new WebResourcePermission(name, (String)actions));
        collection.add((Permission)new WebUserDataPermission(name, (String)actions));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC: constraint capture: adding excluded methods: " + (String)actions);
        }
    }

    private static void handlePerRole(Map<String, Permissions> map, PatternBuilder patternBuilder, String urlPatternSpec) {
        BitSet methods;
        HashMap<String, BitSet> roleMap = patternBuilder.getRoleMap();
        List<String> roleList = null;
        if (!patternBuilder.otherConstraint.isExcluded() && patternBuilder.otherConstraint.isAuthConstrained()) {
            roleList = patternBuilder.otherConstraint.roleList;
            for (String roleName : roleList) {
                BitSet methods2 = patternBuilder.getMethodSet();
                BitSet roleMethods = (BitSet)roleMap.get(roleName);
                if (roleMethods != null) {
                    methods2.andNot(roleMethods);
                }
                String httpMethodSpec = null;
                if (!methods2.isEmpty()) {
                    httpMethodSpec = "!" + MethodValue.getActions(methods2);
                }
                JaccWebConstraintsTranslator.addToRoleMap(map, roleName, (Permission)new WebResourcePermission(urlPatternSpec, httpMethodSpec));
            }
        }
        if (!(methods = patternBuilder.getMethodSet()).isEmpty()) {
            for (Map.Entry roleEntry : roleMap.entrySet()) {
                BitSet roleMethods;
                String roleName = (String)roleEntry.getKey();
                if (roleList != null && roleList.contains(roleName) || (roleMethods = (BitSet)roleEntry.getValue()).isEmpty()) continue;
                JaccWebConstraintsTranslator.addToRoleMap(map, roleName, (Permission)new WebResourcePermission(urlPatternSpec, MethodValue.getActions(roleMethods)));
            }
        }
    }

    private static void handleUnchecked(Permissions collection, PatternBuilder patternBuilder, String urlPatternSpec) {
        Object httpMethodSpec = null;
        BitSet noAuthMethods = patternBuilder.getNoAuthMethods();
        if (!patternBuilder.otherConstraint.isAuthConstrained()) {
            BitSet methods = patternBuilder.getMethodSet();
            methods.andNot(noAuthMethods);
            if (!methods.isEmpty()) {
                httpMethodSpec = "!" + MethodValue.getActions(methods);
            }
        } else if (!noAuthMethods.isEmpty()) {
            httpMethodSpec = MethodValue.getActions(noAuthMethods);
        } else {
            return;
        }
        collection.add((Permission)new WebResourcePermission(urlPatternSpec, (String)httpMethodSpec));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC: constraint capture: adding unchecked (for authorization) methods: " + (String)httpMethodSpec);
        }
    }

    private static void handleConnections(Permissions permissions, PatternBuilder patternBuilder, String name) {
        BitSet allConnectMethods = null;
        boolean allConnectAtOther = patternBuilder.otherConstraint.isConnectAllowed(ConstraintValue.connectTypeNone);
        for (int i = 0; i < ConstraintValue.connectKeys.length; ++i) {
            Object actions = null;
            String transport = ConstraintValue.connectKeys[i];
            BitSet connectMethods = patternBuilder.getConnectMap(1 << i);
            if (i == 0) {
                allConnectMethods = connectMethods;
            } else {
                connectMethods.andNot(allConnectMethods);
            }
            if (patternBuilder.otherConstraint.isConnectAllowed(1 << i)) {
                if (i != 0 && allConnectAtOther) {
                    if (connectMethods.isEmpty()) continue;
                    actions = MethodValue.getActions(connectMethods);
                } else {
                    BitSet methods = patternBuilder.getMethodSet();
                    methods.andNot(connectMethods);
                    if (!methods.isEmpty()) {
                        actions = "!" + MethodValue.getActions(methods);
                    }
                }
            } else {
                if (connectMethods.isEmpty()) continue;
                actions = MethodValue.getActions(connectMethods);
            }
            actions = actions == null ? "" : actions;
            String combinedActions = (String)actions + ":" + transport;
            permissions.add((Permission)new WebUserDataPermission(name, combinedActions));
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("JACC: constraint capture: adding methods that accept connections with protection: " + transport + " methods: " + (String)actions);
        }
    }

    static int patternType(Object urlPattern) {
        String pattern = urlPattern.toString();
        if (pattern.startsWith("*.")) {
            return 1;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            return 2;
        }
        if (pattern.equals("/")) {
            return 0;
        }
        return 3;
    }

    static boolean implies(String pattern, String path) {
        if (pattern.equals(path)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            int length = (pattern = pattern.substring(0, pattern.length() - 2)).length();
            if (length == 0) {
                return true;
            }
            return path.startsWith(pattern) && (path.length() == length || path.substring(length).startsWith("/"));
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(pattern.substring(1));
        }
        return pattern.equals("/");
    }

    private static void addToRoleMap(Map<String, Permissions> roleMap, String roleName, Permission permission) {
        roleMap.computeIfAbsent(roleName, e -> new Permissions()).add(permission);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC: constraint capture: adding methods to role: " + roleName + " methods: " + permission.getActions());
        }
    }

    private static void createWebRoleRefPermission(WebBundleDescriptor webBundleDescriptor, PolicyConfiguration policyConfiguration) throws PolicyContextException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(JaccWebConstraintsTranslator.class.getSimpleName(), "createWebRoleRefPermission");
            logger.log(Level.FINE, "JACC: role-reference translation: Processing WebRoleRefPermission : CODEBASE = " + policyConfiguration.getContextID());
        }
        ArrayList<Role> servletScopedRoleNames = new ArrayList<Role>();
        Set allRoles = webBundleDescriptor.getRoles();
        Role anyAuthUserRole = new Role("**");
        boolean rolesetContainsAnyAuthUserRole = allRoles.contains(anyAuthUserRole);
        for (WebComponentDescriptor componentDescriptor : webBundleDescriptor.getWebComponentDescriptors()) {
            String servletName = componentDescriptor.getCanonicalName();
            JaccWebConstraintsTranslator.writeOutPermissionsForRoleRefRoles(componentDescriptor.getSecurityRoleReferenceSet(), servletScopedRoleNames, servletName, policyConfiguration);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC: role-reference translation: Going through the list of roles not present in RoleRef elements and creating WebRoleRefPermissions ");
            }
            JaccWebConstraintsTranslator.writeOutPermissionsForNonRoleRefRoles(allRoles, servletScopedRoleNames, servletName, policyConfiguration);
            if (servletScopedRoleNames.contains(anyAuthUserRole) || rolesetContainsAnyAuthUserRole) continue;
            JaccWebConstraintsTranslator.addAnyAuthenticatedUserRoleRef(policyConfiguration, servletName);
        }
        JaccWebConstraintsTranslator.writeOutGlobalPermissionsForAllRoles(allRoles, policyConfiguration);
        if (!rolesetContainsAnyAuthUserRole) {
            JaccWebConstraintsTranslator.addAnyAuthenticatedUserRoleRef(policyConfiguration, "");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(JaccWebConstraintsTranslator.class.getName(), "createWebRoleRefPermission");
        }
    }

    private static void writeOutGlobalPermissionsForAllRoles(Collection<Role> allRoles, PolicyConfiguration policyConfiguration) throws PolicyContextException {
        for (Role role : allRoles) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC: role-reference translation: Looking at Role =  " + role.getName());
            }
            String roleName = role.getName();
            policyConfiguration.addToRole(roleName, (Permission)new WebRoleRefPermission("", roleName));
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("JACC: role-reference translation: RoleRef  = " + roleName + " is added for jsp's that can't be mapped to servlets");
            logger.fine("JACC: role-reference translation: Permission added for above role-ref =" + roleName + " ");
        }
    }

    private static void writeOutPermissionsForRoleRefRoles(Collection<SecurityRoleReference> securityRoleReferences, Collection<Role> servletScopedRoleNames, String servletName, PolicyConfiguration policyConfiguration) throws PolicyContextException {
        for (SecurityRoleReference roleReference : securityRoleReferences) {
            if (roleReference == null) continue;
            String servletScopedRoleName = roleReference.getRoleName();
            servletScopedRoleNames.add(new Role(servletScopedRoleName));
            String globalRoleName = roleReference.getSecurityRoleLink().getName();
            policyConfiguration.addToRole(globalRoleName, (Permission)new WebRoleRefPermission(servletName, servletScopedRoleName));
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("JACC: role-reference translation: RoleRefPermission created with name (servlet-name) = " + servletName + " and action (role-name tag) = " + servletScopedRoleName + " added to role (role-link tag) = " + globalRoleName);
        }
    }

    private static void writeOutPermissionsForNonRoleRefRoles(Collection<Role> allRoles, Collection<Role> roleRefRoles, String componentName, PolicyConfiguration policyConfiguration) throws PolicyContextException {
        for (Role role : allRoles) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JACC: role-reference translation: Looking at Role =  " + role.getName());
            }
            if (roleRefRoles.contains(role)) continue;
            String roleName = role.getName();
            policyConfiguration.addToRole(roleName, (Permission)new WebRoleRefPermission(componentName, roleName));
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("JACC: role-reference translation: RoleRef  = " + roleName + " is added for servlet-resource = " + componentName);
            logger.fine("JACC: role-reference translation: Permission added for above role-ref =" + componentName + " " + roleName);
        }
    }

    private static void addAnyAuthenticatedUserRoleRef(PolicyConfiguration policyConfiguration, String name) throws PolicyContextException {
        String action = "**";
        policyConfiguration.addToRole(action, (Permission)new WebRoleRefPermission(name, action));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC: any authenticated user role-reference translation: Permission added for role-ref =" + name + " " + action);
        }
    }

    private static void logExcludedUncheckedPermissionsWritten(Permissions excluded, Permissions unchecked) {
        if (logger.isLoggable(Level.FINE)) {
            String ptype;
            logger.fine("JACC: constraint capture: end processing qualified url patterns");
            for (Permission p : Collections.list(excluded.elements())) {
                ptype = p instanceof WebResourcePermission ? "WRP  " : "WUDP ";
                logger.fine("JACC: permission(excluded) type: " + ptype + " name: " + p.getName() + " actions: " + p.getActions());
            }
            for (Permission p : Collections.list(unchecked.elements())) {
                ptype = p instanceof WebResourcePermission ? "WRP  " : "WUDP ";
                logger.fine("JACC: permission(unchecked) type: " + ptype + " name: " + p.getName() + " actions: " + p.getActions());
            }
        }
    }

    private static void logPerRolePermissionsWritten(String role, Permissions permissions) {
        if (logger.isLoggable(Level.FINE)) {
            for (Permission p : Collections.list(permissions.elements())) {
                String ptype = p instanceof WebResourcePermission ? "WRP  " : "WUDP ";
                logger.fine("JACC: permission(" + role + ") type: " + ptype + " name: " + p.getName() + " actions: " + p.getActions());
            }
        }
    }
}

