/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jacc.context;

import com.sun.enterprise.security.jacc.context.PolicyContextHandlerData;
import jakarta.security.jacc.PolicyContextHandler;
import java.security.SecurityPermission;

public class PolicyContextHandlerImpl
implements PolicyContextHandler {
    public static final String HTTP_SERVLET_REQUEST = "jakarta.servlet.http.HttpServletRequest";
    public static final String SOAP_MESSAGE = "jakarta.xml.soap.SOAPMessage";
    public static final String ENTERPRISE_BEAN = "jakarta.ejb.EnterpriseBean";
    public static final String EJB_ARGUMENTS = "jakarta.ejb.arguments";
    public static final String SUBJECT = "javax.security.auth.Subject.container";
    public static final String REUSE = "java.security.Policy.supportsReuse";
    private static PolicyContextHandlerImpl policyContextHandler;
    private ThreadLocal<PolicyContextHandlerData> thisHandlerData = new ThreadLocal();

    private PolicyContextHandlerImpl() {
    }

    private static synchronized PolicyContextHandlerImpl _getInstance() {
        if (policyContextHandler == null) {
            policyContextHandler = new PolicyContextHandlerImpl();
        }
        return policyContextHandler;
    }

    public static PolicyContextHandler getInstance() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        return PolicyContextHandlerImpl._getInstance();
    }

    public boolean supports(String key) {
        String[] s = this.getKeys();
        for (int i = 0; i < s.length; ++i) {
            if (!s[i].equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public String[] getKeys() {
        String[] s = new String[]{HTTP_SERVLET_REQUEST, SOAP_MESSAGE, ENTERPRISE_BEAN, SUBJECT, EJB_ARGUMENTS, REUSE};
        return s;
    }

    public Object getContext(String key, Object data) {
        return this.getHandlerData().get(key);
    }

    public PolicyContextHandlerData getHandlerData() {
        PolicyContextHandlerData handlerData = this.thisHandlerData.get();
        if (handlerData == null) {
            handlerData = PolicyContextHandlerData.getInstance();
            this.thisHandlerData.set(handlerData);
        }
        return handlerData;
    }

    public void reset() {
        PolicyContextHandlerData handlerData = this.thisHandlerData.get();
        if (handlerData != null) {
            handlerData.reset();
        }
        this.thisHandlerData.set(null);
    }
}

