/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.permissionsxml;

import com.sun.enterprise.security.permissionsxml.CommponentType;
import java.io.File;
import java.io.FilePermission;
import java.net.MalformedURLException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;

public class BasePermissionsProcessor {
    protected static final Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    public static final String CURRENT_FOLDER = "*";
    public static final String TEMP_FOLDER = "SERVLET-CONTEXT-TEMPDIR";
    protected DeploymentContext context;
    protected CommponentType type;

    public BasePermissionsProcessor(CommponentType type, DeploymentContext context) throws SecurityException {
        this.type = type;
        this.context = context;
    }

    protected static PermissionCollection processPermisssonsForPath(PermissionCollection originalPermissions, DeploymentContext context) throws MalformedURLException {
        if (originalPermissions == null) {
            return originalPermissions;
        }
        Permissions revisedPermissions = new Permissions();
        Enumeration<Permission> pcEnum = originalPermissions.elements();
        while (pcEnum.hasMoreElements()) {
            Permission permissions = pcEnum.nextElement();
            if (permissions instanceof FilePermission) {
                BasePermissionsProcessor.processFilePermission(revisedPermissions, context, (FilePermission)permissions);
                continue;
            }
            revisedPermissions.add(permissions);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Revised permissions = " + revisedPermissions);
        }
        return revisedPermissions;
    }

    protected static void processFilePermission(PermissionCollection revisedPC, DeploymentContext deploymentContext, FilePermission filePermission) throws MalformedURLException {
        if (BasePermissionsProcessor.isFilePermforCurrentDir(filePermission)) {
            BasePermissionsProcessor.addFilePermissionsForCurrentDir(revisedPC, deploymentContext, filePermission);
        } else if (BasePermissionsProcessor.isFilePermissionForTempDir(filePermission)) {
            BasePermissionsProcessor.convertTempDirPermission(revisedPC, deploymentContext, filePermission);
        } else {
            revisedPC.add(filePermission);
        }
    }

    protected static boolean isFilePermforCurrentDir(FilePermission filePermission) {
        if (filePermission == null) {
            return false;
        }
        String name = filePermission.getName();
        return CURRENT_FOLDER.equals(name);
    }

    protected static boolean isFilePermissionForTempDir(FilePermission filePermission) {
        if (filePermission == null) {
            return false;
        }
        String name = filePermission.getName();
        return TEMP_FOLDER.equals(name);
    }

    protected static void addFilePermissionsForCurrentDir(PermissionCollection revisedPermissions, DeploymentContext context, FilePermission perm) throws MalformedURLException {
        if (!BasePermissionsProcessor.isFilePermforCurrentDir(perm)) {
            revisedPermissions.add(perm);
            return;
        }
        String actions = perm.getActions();
        String rootDir = context.getSource().getURI().toURL().toString();
        FilePermission rootDirPerm = new FilePermission(rootDir, actions);
        revisedPermissions.add(rootDirPerm);
        FilePermission rootPerm = new FilePermission(rootDir + File.separator + "-", actions);
        revisedPermissions.add(rootPerm);
        if (context.getScratchDir("ejb") != null) {
            String ejbTmpDir = context.getScratchDir("ejb").toURI().toURL().toString();
            FilePermission ejbDirPerm = new FilePermission(ejbTmpDir, actions);
            revisedPermissions.add(ejbDirPerm);
            FilePermission ejbPerm = new FilePermission(ejbTmpDir + File.separator + "-", actions);
            revisedPermissions.add(ejbPerm);
        }
        if (context.getScratchDir("jsp") != null) {
            String jspdir = context.getScratchDir("jsp").toURI().toURL().toString();
            FilePermission jpsDirPerm = new FilePermission(jspdir, actions);
            revisedPermissions.add(jpsDirPerm);
            FilePermission jpsPerm = new FilePermission(jspdir + File.separator + "-", actions);
            revisedPermissions.add(jpsPerm);
        }
    }

    protected static Permission convertTempDirPermission(PermissionCollection revisedPermissions, DeploymentContext context, FilePermission filePermission) throws MalformedURLException {
        if (!BasePermissionsProcessor.isFilePermissionForTempDir(filePermission)) {
            return filePermission;
        }
        String actions = filePermission.getActions();
        if (context.getScratchDir("jsp") != null) {
            String jspdir = context.getScratchDir("jsp").toURI().toURL().toString();
            FilePermission jspDirPerm = new FilePermission(jspdir, actions);
            revisedPermissions.add(jspDirPerm);
            FilePermission jspPermission = new FilePermission(jspdir + File.separator + "-", actions);
            revisedPermissions.add(jspPermission);
            return jspPermission;
        }
        return filePermission;
    }
}

