/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.permissionsxml;

import com.sun.enterprise.security.permissionsxml.CommponentType;
import com.sun.enterprise.security.permissionsxml.DeclaredPermissionsProcessor;
import com.sun.enterprise.security.permissionsxml.PermissionsXMLLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.URIParameter;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.glassfish.api.deployment.DeploymentContext;

public class GlobalPolicyUtil {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    public static final String EE_GRANT_FILE = "javaee.server.policy";
    public static final String EE_RESTRICTED_FILE = "restrict.server.policy";
    public static final String SERVER_ALLOWED_FILE = "restrict.server.policy";
    protected static final String SYS_PROP_JAVA_SEC_POLICY = "java.security.policy";
    public static final String EJB_TYPE_CODESOURCE = "file:/module/Ejb";
    public static final String WEB_TYPE_CODESOURCE = "file:/module/Web";
    public static final String RAR_TYPE_CODESOURCE = "file:/module/Rar";
    public static final String CLIENT_TYPE_CODESOURCE = "file:/module/Car";
    public static final String EAR_TYPE_CODESOURCE = "file:/module/Ear";
    public static final String EAR_CLASS_LOADER = "org.glassfish.javaee.full.deployment.EarClassLoader";
    private static final List<String> JDK_REQUIRED_PERMISSIONS = Arrays.asList("accessClassInPackage.com.sun.beans", "accessClassInPackage.com.sun.beans.*", "accessClassInPackage.com.sun.java.swing.plaf.*", "accessClassInPackage.com.apple.*");
    private static final Map<CommponentType, String> CompTypeToCodeBaseMap = new HashMap<CommponentType, String>();
    private static final Map<CommponentType, PermissionCollection> compTypeToEEGarntsMap;
    private static final Map<CommponentType, PermissionCollection> compTypeToEERestrictedMap;
    private static final Map<CommponentType, PermissionCollection> compTypeToServAllowedMap;
    private static boolean eeGrantedPolicyInitDone;
    protected static final String domainCfgFolder;

    public static CommponentType convertComponentType(String type) {
        return Enum.valueOf(CommponentType.class, type);
    }

    public static PermissionCollection getDeclaredPermissions(CommponentType type, DeploymentContext context) throws SecurityException {
        try {
            return new DeclaredPermissionsProcessor(type, context, new PermissionsXMLLoader(new File(context.getSource().getURI()), type).getAppDeclaredPermissions()).getAdjustedDeclaredPermissions();
        }
        catch (FileNotFoundException | SecurityException | XMLStreamException e) {
            throw new SecurityException(e);
        }
    }

    public static PermissionCollection getEECompGrantededPerms(String type) {
        return GlobalPolicyUtil.getEECompGrantededPerms(GlobalPolicyUtil.convertComponentType(type));
    }

    public static PermissionCollection getEECompGrantededPerms(CommponentType type) {
        GlobalPolicyUtil.initDefPolicy();
        return compTypeToEEGarntsMap.get((Object)type);
    }

    public static PermissionCollection getCompRestrictedPerms(String type) {
        return GlobalPolicyUtil.getCompRestrictedPerms(GlobalPolicyUtil.convertComponentType(type));
    }

    public static PermissionCollection getCompRestrictedPerms(CommponentType type) {
        GlobalPolicyUtil.initDefPolicy();
        return compTypeToEERestrictedMap.get((Object)type);
    }

    private static synchronized void initDefPolicy() {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("defGrantedPolicyInitDone= " + eeGrantedPolicyInitDone);
            }
            if (eeGrantedPolicyInitDone) {
                return;
            }
            eeGrantedPolicyInitDone = true;
            GlobalPolicyUtil.loadServerPolicy(PolicyType.EEGranted);
            GlobalPolicyUtil.loadServerPolicy(PolicyType.EERestricted);
            GlobalPolicyUtil.loadServerPolicy(PolicyType.ServerAllowed);
            GlobalPolicyUtil.checkDomainRestrictionsForDefaultPermissions();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException | URISyntaxException | NoSuchAlgorithmException e) {
            logger.warning(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static String getJavaPolicyFolder() {
        String policyPath = System.getProperty(SYS_PROP_JAVA_SEC_POLICY);
        if (policyPath == null) {
            return null;
        }
        return new File(policyPath).getParent();
    }

    private static void loadServerPolicy(PolicyType policyType) throws IOException, NoSuchAlgorithmException, URISyntaxException {
        if (policyType == null) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("PolicyType= " + policyType);
        }
        String policyFilename = null;
        Map<CommponentType, PermissionCollection> policyMap = null;
        switch (policyType) {
            case EEGranted: {
                policyFilename = domainCfgFolder + EE_GRANT_FILE;
                policyMap = compTypeToEEGarntsMap;
                break;
            }
            case EERestricted: {
                policyFilename = domainCfgFolder + "restrict.server.policy";
                policyMap = compTypeToEERestrictedMap;
                break;
            }
            case ServerAllowed: {
                policyFilename = domainCfgFolder + "restrict.server.policy";
                policyMap = compTypeToServAllowedMap;
            }
        }
        if (policyFilename == null || policyMap == null) {
            throw new IllegalArgumentException("Unrecognized policy type: " + policyType);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("policyFilename= " + policyFilename);
        }
        if (!new File(policyFilename).exists()) {
            return;
        }
        URL policyFileURL = new URL("file:" + policyFilename);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loading policy from " + policyFileURL);
        }
        Policy pf = Policy.getInstance("JavaPolicy", new URIParameter(policyFileURL.toURI()));
        CodeSource codeSource = new CodeSource(new URL(EJB_TYPE_CODESOURCE), (Certificate[])null);
        PermissionCollection pc = pf.getPermissions(codeSource);
        policyMap.put(CommponentType.ejb, pc);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded EJB policy = " + pc);
        }
        codeSource = new CodeSource(new URL(WEB_TYPE_CODESOURCE), (Certificate[])null);
        pc = pf.getPermissions(codeSource);
        policyMap.put(CommponentType.war, pc);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded WEB policy =" + pc);
        }
        codeSource = new CodeSource(new URL(RAR_TYPE_CODESOURCE), (Certificate[])null);
        pc = pf.getPermissions(codeSource);
        policyMap.put(CommponentType.rar, pc);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded rar policy =" + pc);
        }
        codeSource = new CodeSource(new URL(CLIENT_TYPE_CODESOURCE), (Certificate[])null);
        pc = pf.getPermissions(codeSource);
        policyMap.put(CommponentType.car, pc);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded car policy =" + pc);
        }
        codeSource = new CodeSource(new URL(EAR_TYPE_CODESOURCE), (Certificate[])null);
        pc = pf.getPermissions(codeSource);
        policyMap.put(CommponentType.ear, pc);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded ear policy =" + pc);
        }
    }

    private static void checkDomainRestrictionsForDefaultPermissions() throws SecurityException {
        GlobalPolicyUtil.checkEETypePermsAgainstServerRestiction(CommponentType.ejb);
        GlobalPolicyUtil.checkEETypePermsAgainstServerRestiction(CommponentType.war);
        GlobalPolicyUtil.checkEETypePermsAgainstServerRestiction(CommponentType.rar);
        GlobalPolicyUtil.checkEETypePermsAgainstServerRestiction(CommponentType.car);
        GlobalPolicyUtil.checkEETypePermsAgainstServerRestiction(CommponentType.ear);
    }

    private static void checkEETypePermsAgainstServerRestiction(CommponentType type) throws SecurityException {
        GlobalPolicyUtil.checkRestriction(compTypeToEEGarntsMap.get((Object)type), compTypeToEERestrictedMap.get((Object)type));
    }

    public static void checkRestriction(CommponentType type, PermissionCollection declaredPC) throws SecurityException {
        GlobalPolicyUtil.checkRestriction(declaredPC, GlobalPolicyUtil.getCompRestrictedPerms(type));
    }

    public static void checkRestriction(PermissionCollection declaredPC, PermissionCollection restrictedPC) throws SecurityException {
        if (restrictedPC == null || declaredPC == null) {
            return;
        }
        GlobalPolicyUtil.checkContains(declaredPC, restrictedPC);
        GlobalPolicyUtil.checkContains(restrictedPC, declaredPC);
    }

    private static void checkContains(PermissionCollection containPC, PermissionCollection toBeCheckedPC) throws SecurityException {
        if (containPC == null || toBeCheckedPC == null) {
            return;
        }
        Enumeration<Permission> checkEnum = toBeCheckedPC.elements();
        while (checkEnum.hasMoreElements()) {
            Permission permissions = checkEnum.nextElement();
            if (JDK_REQUIRED_PERMISSIONS.contains(permissions.getName()) || !containPC.implies(permissions)) continue;
            throw new SecurityException("Restricted permission " + permissions + " is declared or implied in the " + containPC);
        }
    }

    public static void checkRestrictionOfComponentType(PermissionCollection declaredPC, CommponentType type) throws SecurityException {
        if (CommponentType.ear == type) {
            GlobalPolicyUtil.checkRestrictionOfEar(declaredPC);
        }
        PermissionCollection restrictedPC = compTypeToEERestrictedMap.get((Object)type);
        GlobalPolicyUtil.checkRestriction(declaredPC, restrictedPC);
    }

    public static void checkRestrictionOfEar(PermissionCollection declaredPC) throws SecurityException {
        PermissionCollection permissionCollection = compTypeToEERestrictedMap.get((Object)CommponentType.ejb);
        if (permissionCollection != null) {
            GlobalPolicyUtil.checkRestriction(declaredPC, permissionCollection);
        }
        if ((permissionCollection = compTypeToEERestrictedMap.get((Object)CommponentType.war)) != null) {
            GlobalPolicyUtil.checkRestriction(declaredPC, permissionCollection);
        }
        if ((permissionCollection = compTypeToEERestrictedMap.get((Object)CommponentType.rar)) != null) {
            GlobalPolicyUtil.checkRestriction(declaredPC, permissionCollection);
        }
        if ((permissionCollection = compTypeToEERestrictedMap.get((Object)CommponentType.car)) != null) {
            GlobalPolicyUtil.checkRestriction(declaredPC, permissionCollection);
        }
    }

    static {
        CompTypeToCodeBaseMap.put(CommponentType.ejb, EJB_TYPE_CODESOURCE);
        CompTypeToCodeBaseMap.put(CommponentType.war, WEB_TYPE_CODESOURCE);
        CompTypeToCodeBaseMap.put(CommponentType.rar, RAR_TYPE_CODESOURCE);
        CompTypeToCodeBaseMap.put(CommponentType.car, CLIENT_TYPE_CODESOURCE);
        CompTypeToCodeBaseMap.put(CommponentType.ear, EAR_TYPE_CODESOURCE);
        compTypeToEEGarntsMap = new HashMap<CommponentType, PermissionCollection>();
        compTypeToEERestrictedMap = new HashMap<CommponentType, PermissionCollection>();
        compTypeToServAllowedMap = new HashMap<CommponentType, PermissionCollection>();
        eeGrantedPolicyInitDone = false;
        domainCfgFolder = GlobalPolicyUtil.getJavaPolicyFolder() + File.separator;
    }

    public static enum PolicyType {
        EEGranted,
        EERestricted,
        ServerAllowed;

    }
}

