/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AController;
import com.sun.messaging.jmq.admin.apps.console.AdminApp;
import com.sun.messaging.jmq.admin.apps.console.BrokerAddDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerDestAddDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerDestCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerDestListCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerDestPropsDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerListCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerPasswdDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerPropsDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerQueryDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerServiceCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerServiceListCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerServicePropsDialog;
import com.sun.messaging.jmq.admin.apps.console.ConsoleBrokerAdminManager;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.event.ConsoleActionEvent;
import com.sun.messaging.jmq.admin.apps.console.event.DialogEvent;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminConn;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminUtil;
import com.sun.messaging.jmq.admin.event.AdminEvent;
import com.sun.messaging.jmq.admin.event.AdminEventListener;
import com.sun.messaging.jmq.admin.event.BrokerAdminEvent;
import com.sun.messaging.jmq.admin.event.BrokerCmdStatusEvent;
import com.sun.messaging.jmq.admin.event.BrokerErrorEvent;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class BrokerAdminHandler
implements AdminEventListener {
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static AdminResources ar = Globals.getAdminResources();
    private static String[] close;
    private static String BROKERLIST_FILENAME;
    public static final boolean JMQ_RECONNECT = false;
    public static final int JMQ_RECONNECT_RETRIES = 5;
    public static final long JMQ_RECONNECT_DELAY = 5000L;
    private AdminApp app;
    private AController controller;
    private BrokerAddDialog brokerAddDialog = null;
    private BrokerDestAddDialog brokerDestAddDialog = null;
    private BrokerDestPropsDialog brokerDestPropsDialog = null;
    private BrokerServicePropsDialog brokerSvcPropsDialog = null;
    private BrokerPropsDialog brokerBkrPropsDialog = null;
    private BrokerQueryDialog brokerBkrQueryDialog = null;
    private BrokerPasswdDialog brokerPasswdDialog = null;

    public BrokerAdminHandler(AdminApp app, AController controller) {
        this.app = app;
        this.controller = controller;
    }

    public void init() {
        this.loadBrokerList();
    }

    @Override
    public void adminEventDispatched(AdminEvent e) {
        if (e instanceof DialogEvent) {
            this.handleDialogEvents((DialogEvent)e);
        } else if (e instanceof BrokerAdminEvent) {
            this.handleBrokerAdminEvents((BrokerAdminEvent)e);
        } else if (e instanceof BrokerErrorEvent) {
            this.handleBrokerErrorEvents((BrokerErrorEvent)e);
        } else if (e instanceof BrokerCmdStatusEvent) {
            this.handleBrokerCmdStatusEvent((BrokerCmdStatusEvent)e);
        }
    }

    public void handleDialogEvents(DialogEvent de) {
        ConsoleObj selObj = this.app.getSelectedObj();
        int dialogType = de.getDialogType();
        switch (dialogType) {
            case 0: {
                if (selObj instanceof BrokerListCObj) {
                    if (this.brokerAddDialog == null) {
                        this.brokerAddDialog = new BrokerAddDialog(this.app.getFrame(), (BrokerListCObj)selObj);
                        this.brokerAddDialog.addAdminEventListener(this);
                        this.brokerAddDialog.setLocationRelativeTo(this.app.getFrame());
                    }
                    this.brokerAddDialog.setVisible(true);
                    break;
                }
                if (!(selObj instanceof BrokerDestListCObj)) break;
                if (this.brokerDestAddDialog == null) {
                    this.brokerDestAddDialog = new BrokerDestAddDialog(this.app.getFrame());
                    this.brokerDestAddDialog.addAdminEventListener(this);
                    this.brokerDestAddDialog.setLocationRelativeTo(this.app.getFrame());
                }
                this.brokerDestAddDialog.setVisible(true);
                break;
            }
            case 1: {
                if (selObj instanceof BrokerCObj) {
                    this.doDeleteBroker((BrokerCObj)selObj);
                    break;
                }
                if (!(selObj instanceof BrokerDestCObj)) break;
                this.doDeleteDestination((BrokerDestCObj)selObj);
                break;
            }
            case 2: {
                if (!(selObj instanceof BrokerDestCObj)) break;
                this.doPurgeDestination((BrokerDestCObj)selObj);
                break;
            }
            case 3: {
                if (selObj instanceof BrokerDestCObj) {
                    BrokerDestCObj bDestCObj;
                    if (this.brokerDestPropsDialog == null) {
                        this.brokerDestPropsDialog = new BrokerDestPropsDialog(this.app.getFrame());
                        this.brokerDestPropsDialog.addAdminEventListener(this);
                        this.brokerDestPropsDialog.setLocationRelativeTo(this.app.getFrame());
                    }
                    if (!this.refreshBrokerDestCObj(bDestCObj = (BrokerDestCObj)selObj)) break;
                    this.app.getInspector().selectedObjectUpdated();
                    this.brokerDestPropsDialog.show(bDestCObj.getDestinationInfo(), bDestCObj.getDurables());
                    break;
                }
                if (selObj instanceof BrokerServiceCObj) {
                    BrokerServiceCObj bSvcCObj;
                    if (this.brokerSvcPropsDialog == null) {
                        this.brokerSvcPropsDialog = new BrokerServicePropsDialog(this.app.getFrame());
                        this.brokerSvcPropsDialog.addAdminEventListener(this);
                        this.brokerSvcPropsDialog.setLocationRelativeTo(this.app.getFrame());
                    }
                    if (!this.refreshBrokerServiceCObj(bSvcCObj = (BrokerServiceCObj)selObj)) break;
                    this.app.getInspector().selectedObjectUpdated();
                    this.brokerSvcPropsDialog.show(bSvcCObj.getServiceInfo());
                    break;
                }
                if (!(selObj instanceof BrokerCObj)) break;
                if (this.brokerBkrPropsDialog == null) {
                    this.brokerBkrPropsDialog = new BrokerPropsDialog(this.app.getFrame());
                    this.brokerBkrPropsDialog.addAdminEventListener(this);
                    this.brokerBkrPropsDialog.setLocationRelativeTo(this.app.getFrame());
                }
                BrokerCObj bCObj = (BrokerCObj)selObj;
                this.brokerBkrPropsDialog.setBrokerCObj(bCObj);
                this.brokerBkrPropsDialog.setVisible(true);
                break;
            }
            case 8: {
                if (!(selObj instanceof BrokerCObj)) break;
                this.doConnectToBroker((BrokerCObj)selObj);
                break;
            }
            case 9: {
                if (!(selObj instanceof BrokerCObj)) break;
                this.doDisconnectFromBroker((BrokerCObj)selObj);
                break;
            }
            case 4: {
                if (!(selObj instanceof BrokerCObj)) break;
                this.doShutdownBroker((BrokerCObj)selObj);
                break;
            }
            case 5: {
                if (!(selObj instanceof BrokerCObj)) break;
                this.doRestartBroker((BrokerCObj)selObj);
                break;
            }
            case 6: {
                if (selObj instanceof BrokerServiceCObj) {
                    this.doPauseService((BrokerServiceCObj)selObj);
                    break;
                }
                if (selObj instanceof BrokerCObj) {
                    this.doPauseBroker((BrokerCObj)selObj);
                    break;
                }
                if (selObj instanceof BrokerDestCObj) {
                    this.doPauseDest((BrokerDestCObj)selObj);
                    break;
                }
                if (!(selObj instanceof BrokerDestListCObj)) break;
                this.doPauseAllDests((BrokerDestListCObj)selObj);
                break;
            }
            case 7: {
                if (selObj instanceof BrokerServiceCObj) {
                    this.doResumeService((BrokerServiceCObj)selObj);
                    break;
                }
                if (selObj instanceof BrokerCObj) {
                    this.doResumeBroker((BrokerCObj)selObj);
                    break;
                }
                if (selObj instanceof BrokerDestCObj) {
                    this.doResumeDest((BrokerDestCObj)selObj);
                    break;
                }
                if (!(selObj instanceof BrokerDestListCObj)) break;
                this.doResumeAllDests((BrokerDestListCObj)selObj);
                break;
            }
            case 10: {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A1222"), acr.getString("A1223"), 0, 1, null, close, close[0]);
            }
        }
    }

    public void handleBrokerAdminEvents(BrokerAdminEvent bae) {
        int type = bae.getType();
        ConsoleBrokerAdminManager baMgr = this.app.getBrokerListCObj().getBrokerAdminManager();
        ConsoleObj selObj = this.app.getSelectedObj();
        switch (type) {
            case 1: {
                BrokerAdmin ba;
                if (!(selObj instanceof BrokerListCObj)) break;
                try {
                    ba = new BrokerAdmin(bae.getHost(), bae.getPort(), bae.getUsername(), bae.getPassword(), -1L, false, 5, 5000L);
                    ba.setKey(bae.getBrokerName());
                }
                catch (BrokerAdminException baex) {
                    JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3051", bae.getBrokerName()) + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1131") + ": " + acr.getString("A1218", "A3051"), 0, 0, null, close, close[0]);
                    return;
                }
                catch (Exception e) {
                    JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3051", bae.getBrokerName()) + e, acr.getString("A1131") + ": " + acr.getString("A1218", "A3051"), 0, 0, null, close, close[0]);
                    return;
                }
                if (baMgr.exist(ba.getKey())) {
                    JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3025", ba.getKey()), acr.getString("A1131") + ": " + acr.getString("A1218", "A3025"), 0, 0, null, close, close[0]);
                    return;
                }
                BrokerCObj bCObj = new BrokerCObj(ba);
                baMgr.addBrokerAdmin(ba);
                this.app.getExplorer().addBroker(bCObj);
                this.app.getInspector().refresh();
                this.saveBrokerList();
                if (!bae.isOKAction()) break;
                this.brokerAddDialog.setVisible(false);
                break;
            }
            case 2: {
                if (!(selObj instanceof BrokerDestListCObj)) break;
                BrokerDestCObj bDestCObj = null;
                BrokerCObj bCObj = ((BrokerDestListCObj)selObj).getBrokerCObj();
                bDestCObj = this.addDestination(bCObj, bae);
                if (bDestCObj == null) {
                    return;
                }
                this.app.getExplorer().addToParent(selObj, bDestCObj);
                this.app.getInspector().refresh();
                if (!bae.isOKAction()) break;
                this.brokerDestAddDialog.setVisible(false);
                break;
            }
            case 3: {
                this.doUpdateLogin(bae, selObj);
                break;
            }
            case 4: {
                this.doUpdateBroker(bae, selObj);
                break;
            }
            case 5: {
                this.doDeleteDurable(bae, selObj);
                break;
            }
            case 10: {
                this.doPurgeDurable(bae, selObj);
                break;
            }
            case 6: {
                this.doUpdateService(bae, selObj);
                break;
            }
            case 7: {
                this.doUpdateDestination(bae, selObj);
                break;
            }
            case 8: {
                this.doQueryBroker(selObj);
                break;
            }
            case 9: {
                this.doUpdateBrokerEntry(bae, selObj);
            }
        }
    }

    private void handleBrokerErrorEvents(BrokerErrorEvent bee) {
        int type = bee.getType();
        BrokerListCObj blCObj = this.app.getBrokerListCObj();
        String brokerHost = bee.getBrokerHost();
        String brokerPort = bee.getBrokerPort();
        String brokerName = bee.getBrokerName();
        Object[] args = new String[]{brokerHost, brokerPort, brokerName};
        switch (type) {
            case 0: 
            case 1: {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3047", args), acr.getString("A1094") + ": " + acr.getString("A1218", "A3047"), 0, 0, null, close, close[0]);
                break;
            }
            case 2: {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3048", args), acr.getString("A1094") + ": " + acr.getString("A1218", "A3048"), 0, 0, null, close, close[0]);
            }
        }
        Enumeration<TreeNode> e = blCObj.children();
        while (e.hasMoreElements()) {
            ConsoleObj node = (ConsoleObj)e.nextElement();
            if (!(node instanceof BrokerCObj)) continue;
            BrokerCObj bCObj = (BrokerCObj)node;
            if (brokerName == null || !brokerName.equals(bCObj.getExplorerLabel())) continue;
            bCObj.setBrokerProps(null);
            this.clearBroker(bCObj);
            this.app.getExplorer().nodeChanged(bCObj);
            this.controller.setActions(bCObj);
        }
        this.app.getInspector().refresh();
    }

    private void handleBrokerCmdStatusEvent(BrokerCmdStatusEvent cse) {
        Object msg;
        int type = cse.getType();
        BrokerAdmin ba = cse.getBrokerAdmin();
        boolean success = cse.getSuccess();
        Exception ex = cse.getLinkedException();
        String dstName = cse.getDestinationName();
        String svcName = cse.getServiceName();
        String clientID = cse.getClientID();
        String durName = cse.getDurableName();
        String bkrName = ba.getKey();
        DestinationInfo dstInfo = cse.getDestinationInfo();
        ServiceInfo svcInfo = cse.getServiceInfo();
        Object refreshObj = ba.getAssociatedObj();
        if (type == 10000) {
            int numRetriesAttempted = cse.getNumRetriesAttempted();
            int maxNumRetries = cse.getMaxNumRetries();
            long retryTimeount = cse.getRetryTimeount();
            Object[] args = new Object[]{Integer.toString(numRetriesAttempted), Integer.toString(maxNumRetries), Long.toString(retryTimeount)};
            String s = ar.getString("A1350", args);
            this.app.getStatusArea().appendText(s + "\n");
            return;
        }
        if (type == 1 || type == 7 || type == 17 || type == 11) {
            if (refreshObj instanceof BrokerCObj) {
                this.app.getExplorer().nodeChanged((DefaultMutableTreeNode)refreshObj);
                this.controller.setActions((BrokerCObj)refreshObj);
            }
            return;
        }
        int msgType = success ? 1 : 0;
        String title = acr.getString("A1511");
        switch (type) {
            case 22: {
                if (success) {
                    msg = acr.getString("A6022", bkrName);
                    if (!(refreshObj instanceof BrokerCObj)) break;
                    BrokerCObj bCObj = (BrokerCObj)refreshObj;
                    ba.setIsConnected(true);
                    if (!this.refreshBrokerServiceListCObj(bCObj.getBrokerServiceListCObj()) || !this.refreshBrokerDestListCObj(bCObj.getBrokerDestListCObj())) break;
                    this.app.getExplorer().nodeChanged(bCObj);
                    this.app.getInspector().refresh();
                    this.controller.setActions(bCObj);
                    break;
                }
                msg = acr.getString("A3063", bkrName);
                break;
            }
            case 9: {
                if (success) {
                    msg = acr.getString("A6019", dstInfo.name, bkrName);
                    if (!(refreshObj instanceof BrokerCObj)) break;
                    BrokerCObj bCObj = (BrokerCObj)refreshObj;
                    BrokerDestListCObj bDestlCObj = bCObj.getBrokerDestListCObj();
                    BrokerDestCObj bDestCObj = new BrokerDestCObj(bCObj, dstInfo);
                    this.app.getExplorer().addToParent(bDestlCObj, bDestCObj);
                    this.app.getInspector().refresh();
                    break;
                }
                msg = acr.getString("A3069", dstInfo.name, bkrName);
                break;
            }
            case 0: {
                if (success) {
                    msg = acr.getString("A6020", dstName, bkrName);
                    if (!(refreshObj instanceof BrokerDestCObj)) break;
                    this.app.getExplorer().removeFromParent((BrokerDestCObj)refreshObj);
                    this.app.getInspector().refresh();
                    break;
                }
                msg = acr.getString("A3058", dstName, bkrName);
                break;
            }
            case 13: {
                if (success) {
                    msg = acr.getString("A6027", dstInfo.name);
                    break;
                }
                msg = acr.getString("A3072", dstInfo.name);
                break;
            }
            case 10: {
                if (success) {
                    msg = acr.getString("A6021", dstName, bkrName);
                    break;
                }
                msg = acr.getString("A3060", dstName, bkrName);
                break;
            }
            case 18: {
                if (success) {
                    msg = acr.getString("A6025", BrokerAdminUtil.getDSubLogString(clientID, durName));
                    if (!(refreshObj instanceof BrokerDestCObj)) break;
                    BrokerDestCObj bDestCObj = (BrokerDestCObj)refreshObj;
                    this.refreshBrokerDestCObj(bDestCObj, 5);
                    Vector durables = bDestCObj.getDurables();
                    if (durables == null) break;
                    this.brokerDestPropsDialog.refresh(durables);
                    break;
                }
                msg = acr.getString("A3061", BrokerAdminUtil.getDSubLogString(clientID, durName));
                break;
            }
            case 8: {
                if (success) {
                    BrokerDestListCObj bDestlCObj;
                    msg = acr.getString("A6012", bkrName);
                    Object obj = cse.getReturnedObject();
                    if (!(obj instanceof Vector)) break;
                    Vector dests = (Vector)obj;
                    if (refreshObj instanceof BrokerDestListCObj) {
                        bDestlCObj = (BrokerDestListCObj)refreshObj;
                    } else if (refreshObj instanceof BrokerCObj) {
                        BrokerCObj bCObj = (BrokerCObj)refreshObj;
                        bDestlCObj = bCObj.getBrokerDestListCObj();
                    } else {
                        return;
                    }
                    this.refreshBrokerDestList(dests, bDestlCObj);
                    this.app.getInspector().refresh();
                    break;
                }
                msg = acr.getString("A3033");
                break;
            }
            case 3: {
                if (success) {
                    BrokerServiceCObj bSvcCObj;
                    msg = acr.getString("A6013", svcName, bkrName);
                    if (!(refreshObj instanceof BrokerServiceCObj) || !this.refreshBrokerServiceCObj(bSvcCObj = (BrokerServiceCObj)refreshObj)) break;
                    this.app.getInspector().refresh();
                    this.controller.setActions(bSvcCObj);
                    break;
                }
                msg = acr.getString("A3027", svcName);
                break;
            }
            case 5: {
                if (success) {
                    BrokerServiceCObj bSvcCObj;
                    msg = acr.getString("A6014", svcName, bkrName);
                    if (!(refreshObj instanceof BrokerServiceCObj) || !this.refreshBrokerServiceCObj(bSvcCObj = (BrokerServiceCObj)refreshObj)) break;
                    this.app.getInspector().refresh();
                    this.controller.setActions(bSvcCObj);
                    break;
                }
                msg = acr.getString("A3028", svcName);
                break;
            }
            case 14: {
                if (success) {
                    msg = acr.getString("A6026", svcInfo.name);
                    if (!(refreshObj instanceof BrokerServiceCObj) || !this.refreshBrokerServiceCObj((BrokerServiceCObj)refreshObj)) break;
                    this.app.getInspector().refresh();
                    break;
                }
                msg = acr.getString("A3065", svcInfo.name);
                break;
            }
            case 2: {
                if (success) {
                    BrokerServiceListCObj bSvclCObj;
                    msg = acr.getString("A6011", bkrName);
                    Object obj = cse.getReturnedObject();
                    if (!(obj instanceof Vector)) break;
                    Vector svcs = (Vector)obj;
                    if (refreshObj instanceof BrokerServiceListCObj) {
                        bSvclCObj = (BrokerServiceListCObj)refreshObj;
                    } else if (refreshObj instanceof BrokerCObj) {
                        BrokerCObj bCObj = (BrokerCObj)refreshObj;
                        bSvclCObj = bCObj.getBrokerServiceListCObj();
                    } else {
                        return;
                    }
                    this.refreshBrokerServiceList(svcs, bSvclCObj);
                    this.app.getInspector().refresh();
                    break;
                }
                msg = acr.getString("A3032");
                break;
            }
            case 4: {
                if (success) {
                    BrokerCObj bCObj;
                    msg = acr.getString("A6015", bkrName);
                    if (!(refreshObj instanceof BrokerCObj) || !this.refreshBrokerServiceListCObj((bCObj = (BrokerCObj)refreshObj).getBrokerServiceListCObj())) break;
                    this.app.getInspector().refresh();
                    this.controller.setActions(bCObj);
                    break;
                }
                msg = acr.getString("A3029", bkrName);
                break;
            }
            case 6: {
                if (success) {
                    BrokerCObj bCObj;
                    msg = acr.getString("A6016", bkrName);
                    if (!(refreshObj instanceof BrokerCObj) || !this.refreshBrokerServiceListCObj((bCObj = (BrokerCObj)refreshObj).getBrokerServiceListCObj())) break;
                    this.app.getInspector().refresh();
                    this.controller.setActions(bCObj);
                    break;
                }
                msg = acr.getString("A3030", bkrName);
                break;
            }
            case 12: {
                if (success) {
                    msg = acr.getString("A6024", bkrName);
                    break;
                }
                msg = acr.getString("A3064", bkrName);
                break;
            }
            default: {
                msg = acr.getString("A1512", bkrName);
            }
        }
        if (!success) {
            msg = ex instanceof BrokerAdminException ? (String)msg + "\n" + this.printBrokerAdminExceptionDetails((BrokerAdminException)ex) : (String)msg + "\n" + ex;
        }
        JOptionPane.showOptionDialog(this.app.getFrame(), msg, title, 0, msgType, null, close, close[0]);
    }

    private void doConnectToBroker(BrokerCObj bCObj) {
        BrokerAdmin ba = bCObj.getBrokerAdmin();
        ba.setReconnect(false);
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bCObj);
        }
        boolean authenticationNeeded = false;
        if (ba.getUserName().length() == 0) {
            authenticationNeeded = true;
        }
        if (ba.getPassword().length() == 0) {
            authenticationNeeded = true;
        }
        if (authenticationNeeded) {
            if (this.brokerPasswdDialog == null) {
                this.brokerPasswdDialog = new BrokerPasswdDialog(this.app.getFrame());
                this.brokerPasswdDialog.addAdminEventListener(this);
                this.brokerPasswdDialog.setLocationRelativeTo(this.app.getFrame());
            }
            this.brokerPasswdDialog.show(ba);
        } else if (this.connectToBroker(ba)) {
            if (!this.refreshBrokerCObj(bCObj)) {
                return;
            }
            if (!this.populateBrokerServices(bCObj)) {
                return;
            }
            if (!this.populateBrokerDestinations(bCObj)) {
                return;
            }
            this.app.getExplorer().nodeChanged(bCObj);
            this.app.getInspector().refresh();
            this.controller.setActions(bCObj);
        } else {
            return;
        }
    }

    private boolean connectToBroker(BrokerAdmin ba) {
        return this.connectToBroker(ba, null, null, false);
    }

    private boolean connectToBroker(BrokerAdmin ba, String tempUsername, String tempPassword, boolean useTempValues) {
        try {
            if (useTempValues) {
                ba.connect(tempUsername, tempPassword);
            } else {
                ba.connect();
            }
            ba.addAdminEventListener(this);
            ba.setInitiator(false);
            ba.sendHelloMessage();
            ba.receiveHelloReplyMessage();
            if (ba.isReconnect()) {
                this.app.getStatusArea().appendText(acr.getString("A6018", ba.getKey()));
            } else {
                this.app.getStatusArea().appendText(acr.getString("A6022", ba.getKey()));
            }
        }
        catch (BrokerAdminException baex) {
            if (11 == baex.getType()) {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3040"), acr.getString("A1141") + ": " + acr.getString("A1218", "A3040"), 0, 0, null, close, close[0]);
            } else if (12 == baex.getType()) {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3041"), acr.getString("A1141") + ": " + acr.getString("A1218", "A3041"), 0, 0, null, close, close[0]);
            } else {
                Object[] args = new Object[]{ba.getKey(), ba.getBrokerHost(), ba.getBrokerPort(), this.printBrokerAdminExceptionDetails(baex)};
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3045", args), acr.getString("A1141") + ": " + acr.getString("A1218", "A3045"), 0, 0, null, close, close[0]);
                if (this.brokerPasswdDialog != null) {
                    this.brokerPasswdDialog.setVisible(false);
                }
            }
            return false;
        }
        catch (Exception baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3063", ba.getKey()) + baex, acr.getString("A1141") + ": " + acr.getString("A1218", "A3063"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doUpdateLogin(BrokerAdminEvent bae, ConsoleObj selObj) {
        if (selObj instanceof BrokerCObj) {
            String tempPasswd;
            String tempUsername;
            BrokerCObj bCObj = (BrokerCObj)selObj;
            BrokerAdmin ba = bCObj.getBrokerAdmin();
            if (this.connectToBroker(ba, tempUsername = bae.getUsername(), tempPasswd = bae.getPassword(), true)) {
                if (!this.refreshBrokerCObj(bCObj)) {
                    return;
                }
                if (!this.populateBrokerServices(bCObj)) {
                    return;
                }
                if (!this.populateBrokerDestinations(bCObj)) {
                    return;
                }
            } else {
                return;
            }
            this.app.getExplorer().nodeChanged(bCObj);
            this.app.getInspector().refresh();
            this.brokerPasswdDialog.setVisible(false);
            this.controller.setActions(bCObj);
        }
    }

    private void doUpdateBroker(BrokerAdminEvent bae, ConsoleObj selObj) {
        Properties bkrProps = bae.getBrokerProps();
        if (!(selObj instanceof BrokerCObj)) {
            return;
        }
        BrokerCObj bCObj = (BrokerCObj)selObj;
        BrokerAdmin ba = bCObj.getBrokerAdmin();
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bCObj);
        }
        try {
            ba.sendUpdateBrokerPropsMessage(bkrProps);
            ba.receiveUpdateBrokerPropsReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6024", ba.getKey()));
            if (bae.isOKAction()) {
                this.brokerBkrQueryDialog.setVisible(false);
            }
        }
        catch (BrokerAdminException bae2) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3064", ba.getKey()) + this.printBrokerAdminExceptionDetails(bae2), acr.getString("A1159") + ": " + acr.getString("A1218", "A3064"), 0, 0, null, close, close[0]);
        }
    }

    private void doDeleteDurable(BrokerAdminEvent bae, ConsoleObj selObj) {
        String durableName = null;
        String clientID = null;
        if (!(selObj instanceof BrokerDestCObj)) {
            return;
        }
        BrokerDestCObj bDestCObj = (BrokerDestCObj)selObj;
        BrokerAdmin ba = bDestCObj.getBrokerAdmin();
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bDestCObj);
        }
        durableName = bae.getDurableName();
        clientID = bae.getClientID();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5013", durableName, clientID), acr.getString("A1514"), 0);
        if (result == 1) {
            return;
        }
        try {
            ba.sendDestroyDurableMessage(durableName, clientID);
            ba.receiveDestroyDurableReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6025", BrokerAdminUtil.getDSubLogString(clientID, durableName)));
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3061", BrokerAdminUtil.getDSubLogString(clientID, durableName)) + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1514") + ": " + acr.getString("A1218", "A3061"), 0, 0, null, close, close[0]);
            return;
        }
        this.refreshBrokerDestCObj(bDestCObj, bae.getType());
        Vector durables = bDestCObj.getDurables();
        if (durables != null) {
            this.brokerDestPropsDialog.refresh(durables);
        }
    }

    private void doPurgeDurable(BrokerAdminEvent bae, ConsoleObj selObj) {
        String durableName = null;
        String clientID = null;
        if (!(selObj instanceof BrokerDestCObj)) {
            return;
        }
        BrokerDestCObj bDestCObj = (BrokerDestCObj)selObj;
        BrokerAdmin ba = bDestCObj.getBrokerAdmin();
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bDestCObj);
        }
        durableName = bae.getDurableName();
        clientID = bae.getClientID();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5015", durableName, clientID), acr.getString("A1515"), 0);
        if (result == 1) {
            return;
        }
        try {
            ba.sendPurgeDurableMessage(durableName, clientID);
            ba.receivePurgeDurableReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6035", BrokerAdminUtil.getDSubLogString(clientID, durableName)));
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3074", BrokerAdminUtil.getDSubLogString(clientID, durableName)) + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1514") + ": " + acr.getString("A1218", "A3074"), 0, 0, null, close, close[0]);
            return;
        }
        this.refreshBrokerDestCObj(bDestCObj, bae.getType());
        Vector durables = bDestCObj.getDurables();
        if (durables != null) {
            this.brokerDestPropsDialog.refresh(durables);
        }
    }

    private void doUpdateService(BrokerAdminEvent bae, ConsoleObj selObj) {
        String serviceName = null;
        int portValue = -1;
        int minThreadsValue = -1;
        int maxThreadsValue = -1;
        if (!(selObj instanceof BrokerServiceCObj)) {
            return;
        }
        BrokerServiceCObj bSvcCObj = (BrokerServiceCObj)selObj;
        BrokerAdmin ba = bSvcCObj.getBrokerAdmin();
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bSvcCObj);
        }
        serviceName = bSvcCObj.getServiceInfo().name;
        portValue = bae.getPort();
        minThreadsValue = bae.getMinThreads();
        maxThreadsValue = bae.getMaxThreads();
        ServiceInfo svcInfo = new ServiceInfo();
        svcInfo.setName(serviceName);
        svcInfo.setPort(portValue);
        svcInfo.setMinThreads(minThreadsValue);
        svcInfo.setMaxThreads(maxThreadsValue);
        try {
            ba.sendUpdateServiceMessage(svcInfo);
            ba.receiveUpdateServiceReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6026", serviceName));
            if (bae.isOKAction()) {
                this.brokerSvcPropsDialog.setVisible(false);
            }
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3065", serviceName) + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1409") + ": " + acr.getString("A1218", "A3065"), 0, 0, null, close, close[0]);
            return;
        }
        if (this.refreshBrokerServiceCObj(bSvcCObj)) {
            this.app.getInspector().selectedObjectUpdated();
            this.controller.setActions(bSvcCObj);
        }
    }

    private void doUpdateDestination(BrokerAdminEvent bae, ConsoleObj selObj) {
        String destName = null;
        int destTypeMask = -1;
        if (!(selObj instanceof BrokerDestCObj)) {
            return;
        }
        BrokerDestCObj bDestCObj = (BrokerDestCObj)selObj;
        BrokerAdmin ba = bDestCObj.getBrokerAdmin();
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bDestCObj);
        }
        destName = bDestCObj.getDestinationInfo().name;
        destTypeMask = bDestCObj.getDestinationInfo().type;
        DestinationInfo destInfo = bae.getDestinationInfo();
        destInfo.setName(destName);
        destInfo.setType(destTypeMask);
        try {
            ba.sendUpdateDestinationMessage(destInfo);
            ba.receiveUpdateDestinationReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6027", destName));
            if (bae.isOKAction()) {
                this.brokerDestPropsDialog.setVisible(false);
            }
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3072", destName) + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1408") + ": " + acr.getString("A1218", "A3072"), 0, 0, null, close, close[0]);
            return;
        }
        if (this.refreshBrokerDestCObj(bDestCObj, bae.getType())) {
            this.app.getInspector().selectedObjectUpdated();
            this.controller.setActions(bDestCObj);
        }
    }

    private void doQueryBroker(ConsoleObj selObj) {
        BrokerCObj bCObj;
        if (!(selObj instanceof BrokerCObj)) {
            return;
        }
        if (this.brokerBkrQueryDialog == null) {
            this.brokerBkrQueryDialog = new BrokerQueryDialog(this.app.getFrame());
            this.brokerBkrQueryDialog.addAdminEventListener(this);
            this.brokerBkrQueryDialog.setLocationRelativeTo(this.app.getFrame());
        }
        if (this.refreshBrokerCObj(bCObj = (BrokerCObj)selObj)) {
            this.brokerBkrQueryDialog.show(bCObj);
        }
    }

    private void doUpdateBrokerEntry(BrokerAdminEvent bae, ConsoleObj selObj) {
        ConsoleBrokerAdminManager baMgr = this.app.getBrokerListCObj().getBrokerAdminManager();
        String newName = bae.getBrokerName();
        if (!(selObj instanceof BrokerCObj)) {
            return;
        }
        BrokerCObj bCObj = (BrokerCObj)selObj;
        BrokerAdmin ba = bCObj.getBrokerAdmin();
        String oldName = ba.getKey();
        String oldHost = ba.getBrokerHost();
        String oldPort = ba.getBrokerPort();
        String oldUserName = ba.getUserName();
        String oldPasswd = ba.getPassword();
        if (!oldName.equals(newName) && baMgr.exist(newName)) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3025", newName), acr.getString("A1410") + ": " + acr.getString("A1218", "A3025"), 0, 0, null, close, close[0]);
            return;
        }
        try {
            ba.setKey(bae.getBrokerName());
            ba.setBrokerHost(bae.getHost());
            ba.setBrokerPort(Integer.toString(bae.getPort()));
            ba.setUserName(bae.getUsername());
            ba.setPassword(bae.getPassword());
        }
        catch (BrokerAdminException baex) {
            int type = baex.getType();
            String badVal = baex.getBadValue();
            String errorStrId = "A3038";
            try {
                ba.setKey(oldName);
                ba.setBrokerHost(oldHost);
                ba.setBrokerPort(oldPort);
                ba.setUserName(oldUserName);
                ba.setPassword(oldPasswd);
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (type) {
                case 9: {
                    errorStrId = "A3039";
                    break;
                }
                case 10: {
                    errorStrId = "A3038";
                }
            }
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString(errorStrId, badVal), acr.getString("A1410") + ": " + acr.getString("A1218", errorStrId), 0, 0, null, close, close[0]);
            return;
        }
        this.app.getExplorer().nodeChanged(selObj);
        this.app.getStatusArea().appendText(acr.getString("A6033", selObj.toString()));
        this.app.getInspector().selectedObjectUpdated();
        this.saveBrokerList();
        if (bae.isOKAction()) {
            this.brokerBkrPropsDialog.setVisible(false);
        }
    }

    private boolean reconnectToBroker(BrokerCObj bCObj) throws BrokerAdminException {
        BrokerAdmin ba = bCObj.getBrokerAdmin();
        boolean connected = false;
        int count = 0;
        while (!connected && count < 5) {
            try {
                ++count;
                ba.connect();
                ba.sendHelloMessage();
                ba.receiveHelloReplyMessage();
                connected = true;
                ba.addAdminEventListener(this);
                ba.setInitiator(false);
            }
            catch (BrokerAdminException baex) {
                if (baex.getType() == 0) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3066", ba.getKey()) + ie, acr.getString("A1094") + ": " + acr.getString("A1218", "A3066"), 0, 0, null, close, close[0]);
                        this.app.getExplorer().nodeChanged(bCObj);
                        this.controller.setActions(bCObj);
                    }
                } else {
                    JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3066", ba.getKey()) + baex, acr.getString("A1094") + ": " + acr.getString("A1218", "A3066"), 0, 0, null, close, close[0]);
                    this.app.getExplorer().nodeChanged(bCObj);
                    this.controller.setActions(bCObj);
                }
            }
            catch (Exception ex) {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3066", ba.getKey()) + ex, acr.getString("A1094") + ": " + acr.getString("A1218", "A3066"), 0, 0, null, close, close[0]);
                this.app.getExplorer().nodeChanged(bCObj);
                this.controller.setActions(bCObj);
            }
            if (count < 5) continue;
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3026"), acr.getString("A1141") + ": " + acr.getString("A1218", "A3026"), 0, 0, null, close, close[0]);
            this.app.getExplorer().nodeChanged(bCObj);
            this.controller.setActions(bCObj);
        }
        return connected;
    }

    private void doDisconnectFromBroker(BrokerCObj bCObj) {
        BrokerAdmin ba = bCObj.getBrokerAdmin();
        if (ba == null) {
            return;
        }
        if (ba.isBusy()) {
            Object[] args = new Object[]{ba.getKey(), ba.getBrokerHost(), ba.getBrokerPort()};
            String busyMsg = acr.getString("A1513", args);
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3070") + busyMsg, acr.getString("A1144"), 0, 0, null, close, close[0]);
            return;
        }
        ba.removeAdminEventListener(this);
        ba.setReconnect(false);
        if (!this.disconnectFromBroker(ba)) {
            return;
        }
        bCObj.setBrokerProps(null);
        this.clearBroker(bCObj);
        this.app.getExplorer().nodeChanged(bCObj);
        this.app.getInspector().refresh();
        this.controller.setActions(bCObj);
    }

    private boolean disconnectFromBroker(BrokerAdmin ba) {
        ba.close();
        this.app.getStatusArea().appendText(acr.getString("A6023", ba.getKey()));
        return true;
    }

    private boolean populateBrokerServices(BrokerCObj bCObj) {
        BrokerServiceListCObj bSvclCObj = null;
        bSvclCObj = bCObj.getBrokerServiceListCObj();
        return this.refreshBrokerServiceListCObj(bSvclCObj);
    }

    private boolean refreshBrokerServiceListCObj(BrokerServiceListCObj bSvclCObj) {
        Vector svcs = null;
        BrokerCObj bCObj = bSvclCObj.getBrokerCObj();
        BrokerAdmin ba = bCObj.getBrokerAdmin();
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bSvclCObj);
        }
        try {
            ba.sendGetServicesMessage(null);
            svcs = ba.receiveGetServicesReplyMessage();
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3032") + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1500") + ": " + acr.getString("A1218", "A3032"), 0, 0, null, close, close[0]);
            return false;
        }
        this.refreshBrokerServiceList(svcs, bSvclCObj);
        return true;
    }

    private void refreshBrokerServiceList(Vector svcs, BrokerServiceListCObj bSvclCObj) {
        BrokerCObj bCObj = bSvclCObj.getBrokerCObj();
        if (svcs != null) {
            bSvclCObj.removeAllChildren();
            int i = 0;
            Enumeration e = svcs.elements();
            while (e.hasMoreElements()) {
                ServiceInfo sInfo = (ServiceInfo)e.nextElement();
                BrokerServiceCObj bSvcCObj = new BrokerServiceCObj(bCObj, sInfo);
                bSvclCObj.insert(bSvcCObj, i++);
            }
        }
    }

    private boolean refreshBrokerServiceCObj(BrokerServiceCObj bSvcCObj) {
        ServiceInfo oldSvcInfo = bSvcCObj.getServiceInfo();
        BrokerAdmin ba = bSvcCObj.getBrokerAdmin();
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bSvcCObj);
        }
        Vector svc = null;
        try {
            ba.sendGetServicesMessage(oldSvcInfo.name);
            svc = ba.receiveGetServicesReplyMessage(false);
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3034", oldSvcInfo.name) + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1409") + ": " + acr.getString("A1218", "A3034"), 0, 0, null, close, close[0]);
            return false;
        }
        if (svc != null && svc.size() == 1) {
            Enumeration e = svc.elements();
            ServiceInfo sInfo = (ServiceInfo)e.nextElement();
            bSvcCObj.setServiceInfo(sInfo);
            return true;
        }
        return false;
    }

    private boolean populateBrokerDestinations(BrokerCObj bCObj) {
        BrokerDestListCObj bDestlCObj = null;
        bDestlCObj = bCObj.getBrokerDestListCObj();
        return this.refreshBrokerDestListCObj(bDestlCObj);
    }

    private boolean refreshBrokerDestListCObj(BrokerDestListCObj bDestlCObj) {
        Vector dests = null;
        BrokerAdmin ba = bDestlCObj.getBrokerAdmin();
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bDestlCObj);
        }
        try {
            ba.sendGetDestinationsMessage(null, -1);
            dests = ba.receiveGetDestinationsReplyMessage();
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3033") + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1501") + ": " + acr.getString("A1218", "A3033"), 0, 0, null, close, close[0]);
            return false;
        }
        this.refreshBrokerDestList(dests, bDestlCObj);
        return true;
    }

    private void refreshBrokerDestList(Vector dests, BrokerDestListCObj bDestlCObj) {
        BrokerCObj bCObj = bDestlCObj.getBrokerCObj();
        if (dests != null) {
            bDestlCObj.removeAllChildren();
            int i = 0;
            Enumeration e = dests.elements();
            while (e.hasMoreElements()) {
                DestinationInfo dInfo = (DestinationInfo)e.nextElement();
                if (DestType.isTemporary(dInfo.type) || "__JMQAdmin".equals(dInfo.name) || "__JMQBridgeAdmin".equals(dInfo.name) || DestType.isInternal(dInfo.fulltype)) continue;
                BrokerDestCObj bDestCObj = new BrokerDestCObj(bCObj, dInfo);
                bDestlCObj.insert(bDestCObj, i++);
            }
        }
    }

    private boolean refreshBrokerDestCObj(BrokerDestCObj bDestCObj) {
        return this.refreshBrokerDestCObj(bDestCObj, -1);
    }

    private boolean refreshBrokerDestCObj(BrokerDestCObj bDestCObj, int eventType) {
        DestinationInfo oldDestInfo = bDestCObj.getDestinationInfo();
        BrokerAdmin ba = bDestCObj.getBrokerAdmin();
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bDestCObj);
        }
        Vector dests = null;
        Vector durables = null;
        boolean succeed = false;
        try {
            ba.sendGetDurablesMessage(oldDestInfo.name, null);
            durables = ba.receiveGetDurablesReplyMessage(false);
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3036", oldDestInfo.name) + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1408") + ": " + acr.getString("A1218", "A3036"), 0, 0, null, close, close[0]);
            return false;
        }
        bDestCObj.setDurables(durables);
        succeed = true;
        try {
            ba.sendGetDestinationsMessage(oldDestInfo.name, oldDestInfo.type);
            dests = ba.receiveGetDestinationsReplyMessage(false);
        }
        catch (BrokerAdminException baex) {
            if (eventType == 5 || eventType == 7) {
                return false;
            }
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3035", oldDestInfo.name) + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1408") + ": " + acr.getString("A1218", "A3035"), 0, 0, null, close, close[0]);
            return false;
        }
        if (dests != null && dests.size() == 1) {
            Enumeration e = dests.elements();
            DestinationInfo dInfo = (DestinationInfo)e.nextElement();
            if (!(DestType.isTemporary(dInfo.type) || DestType.isInternal(dInfo.fulltype) || "__JMQBridgeAdmin".equals(dInfo.name) || "__JMQAdmin".equals(dInfo.name))) {
                bDestCObj.setDestinationInfo(dInfo);
            }
            succeed = true;
        }
        return succeed;
    }

    private void clearBroker(BrokerCObj bCObj) {
        DefaultMutableTreeNode bDestlCObj = null;
        DefaultMutableTreeNode bSvclCObj = null;
        Enumeration<TreeNode> e = bCObj.children();
        while (e.hasMoreElements()) {
            ConsoleObj node = (ConsoleObj)e.nextElement();
            if (node instanceof BrokerDestListCObj) {
                bDestlCObj = (BrokerDestListCObj)node;
                continue;
            }
            if (!(node instanceof BrokerServiceListCObj)) continue;
            bSvclCObj = (BrokerServiceListCObj)node;
        }
        if (bDestlCObj != null) {
            bDestlCObj.removeAllChildren();
        }
        if (bSvclCObj != null) {
            bSvclCObj.removeAllChildren();
        }
    }

    private void doDeleteBroker(BrokerCObj bCObj) {
        ConsoleBrokerAdminManager baMgr = this.app.getBrokerListCObj().getBrokerAdminManager();
        BrokerAdmin ba = bCObj.getBrokerAdmin();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5004", ba.getKey()), acr.getString("A1137"), 0);
        if (result == 1) {
            return;
        }
        baMgr.deleteBrokerAdmin(ba);
        this.saveBrokerList();
        ba.close();
        this.app.getExplorer().removeFromParent(bCObj);
        this.controller.clearSelection();
    }

    private void doPauseService(BrokerServiceCObj bSvcCObj) {
        BrokerAdmin ba = bSvcCObj.getBrokerAdmin();
        ServiceInfo svcInfo = bSvcCObj.getServiceInfo();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5005", svcInfo.name, ba.getKey()), acr.getString("A1147"), 0);
        if (result == 1) {
            return;
        }
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bSvcCObj);
        }
        if (this.pauseService(ba, svcInfo.name)) {
            svcInfo = this.queryServiceInfo(ba, svcInfo.name);
            if (svcInfo != null) {
                bSvcCObj.setServiceInfo(svcInfo);
                this.app.getInspector().selectedObjectUpdated();
            }
            this.controller.setActions(bSvcCObj);
        }
    }

    private boolean pauseService(BrokerAdmin ba, String svcName) {
        try {
            ba.sendPauseMessage(svcName);
            ba.receivePauseReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6013", svcName, ba.getKey()));
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3027", svcName) + "\n" + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1146") + ": " + acr.getString("A1218", "A3027"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doResumeService(BrokerServiceCObj bSvcCObj) {
        BrokerAdmin ba = bSvcCObj.getBrokerAdmin();
        ServiceInfo svcInfo = bSvcCObj.getServiceInfo();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5006", svcInfo.name, ba.getKey()), acr.getString("A1150"), 0);
        if (result == 1) {
            return;
        }
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bSvcCObj);
        }
        if (this.resumeService(ba, svcInfo.name)) {
            svcInfo = this.queryServiceInfo(ba, svcInfo.name);
            if (svcInfo != null) {
                bSvcCObj.setServiceInfo(svcInfo);
                this.app.getInspector().selectedObjectUpdated();
            }
            this.controller.setActions(bSvcCObj);
        }
    }

    private boolean resumeService(BrokerAdmin ba, String svcName) {
        try {
            ba.sendResumeMessage(svcName);
            ba.receiveResumeReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6014", svcName, ba.getKey()));
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3028", svcName) + "\n" + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1150") + ": " + acr.getString("A1218", "A3028"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doPauseDest(BrokerDestCObj bDestCObj) {
        BrokerAdmin ba = bDestCObj.getBrokerAdmin();
        DestinationInfo destInfo = bDestCObj.getDestinationInfo();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5016", destInfo.name, ba.getKey()), acr.getString("A1155"), 0);
        if (result == 1) {
            return;
        }
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bDestCObj);
        }
        if (this.pauseDest(ba, destInfo.name, destInfo.type, 3)) {
            destInfo = this.queryDestinationInfo(ba, destInfo.name, destInfo.type);
            if (destInfo != null) {
                bDestCObj.setDestinationInfo(destInfo);
                this.app.getInspector().selectedObjectUpdated();
            }
            this.controller.setActions(bDestCObj);
        }
    }

    private void doPauseAllDests(BrokerDestListCObj bDestListCObj) {
        BrokerAdmin ba = bDestListCObj.getBrokerAdmin();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5018", ba.getKey()), acr.getString("A1157"), 0);
        if (result == 1) {
            return;
        }
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bDestListCObj);
        }
        if (this.pauseAllDests(ba, 1, 3)) {
            if (!this.populateBrokerDestinations((BrokerCObj)bDestListCObj.getParent())) {
                return;
            }
            this.controller.setActions(bDestListCObj);
            this.app.getInspector().refresh();
        }
    }

    private boolean pauseDest(BrokerAdmin ba, String destName, int destTypeMask, int pauseType) {
        try {
            ba.sendPauseMessage(destName, destTypeMask, pauseType);
            ba.receivePauseReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6036", destName, ba.getKey()));
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3076", destName) + "\n" + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1155") + ": " + acr.getString("A1218", "A3076"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private boolean pauseAllDests(BrokerAdmin ba, int destTypeMask, int pauseType) {
        try {
            ba.sendPauseMessage(null, destTypeMask, pauseType);
            ba.receivePauseReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6038", ba.getKey()));
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3078") + "\n" + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1157") + ": " + acr.getString("A1218", "A3078"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doPauseBroker(BrokerCObj bCObj) {
        BrokerAdmin ba = bCObj.getBrokerAdmin();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5011", ba.getKey()), acr.getString("A1146"), 0);
        if (result == 1) {
            return;
        }
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bCObj);
        }
        if (this.pauseBroker(ba)) {
            Enumeration<TreeNode> e = bCObj.children();
            BrokerServiceListCObj bSvclCObj = null;
            while (e.hasMoreElements()) {
                ConsoleObj cObj = (ConsoleObj)e.nextElement();
                if (!(cObj instanceof BrokerServiceListCObj)) continue;
                bSvclCObj = (BrokerServiceListCObj)cObj;
            }
            Vector svcs = this.queryAllServiceInfo(ba);
            if (svcs != null) {
                this.updateAllServiceInfo(bSvclCObj, svcs);
                this.controller.setActions(bCObj);
                this.app.getInspector().refresh();
            }
        }
    }

    private boolean pauseBroker(BrokerAdmin ba) {
        try {
            ba.sendPauseMessage(null);
            ba.receivePauseReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6015", ba.getKey()));
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3029", ba.getKey()) + "\n" + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1146") + ": " + acr.getString("A1218", "A3029"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doResumeBroker(BrokerCObj bCObj) {
        BrokerAdmin ba = bCObj.getBrokerAdmin();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5007", ba.getKey()), acr.getString("A1149"), 0);
        if (result == 1) {
            return;
        }
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bCObj);
        }
        if (this.resumeBroker(ba)) {
            Enumeration<TreeNode> e = bCObj.children();
            BrokerServiceListCObj bSvclCObj = null;
            while (e.hasMoreElements()) {
                ConsoleObj cObj = (ConsoleObj)e.nextElement();
                if (!(cObj instanceof BrokerServiceListCObj)) continue;
                bSvclCObj = (BrokerServiceListCObj)cObj;
            }
            Vector svcs = this.queryAllServiceInfo(ba);
            if (svcs != null) {
                this.updateAllServiceInfo(bSvclCObj, svcs);
                this.controller.setActions(bCObj);
                this.app.getInspector().refresh();
            }
        }
    }

    private boolean resumeBroker(BrokerAdmin ba) {
        try {
            ba.sendResumeMessage(null);
            ba.receiveResumeReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6016", ba.getKey()));
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3030", ba.getKey()) + ".\n" + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1149") + ": " + acr.getString("A1218", "A3030"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doResumeAllDests(BrokerDestListCObj bDestListCObj) {
        BrokerAdmin ba = bDestListCObj.getBrokerAdmin();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5019", ba.getKey()), acr.getString("A1158"), 0);
        if (result == 1) {
            return;
        }
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bDestListCObj);
        }
        if (this.resumeAllDests(ba, 1)) {
            if (!this.populateBrokerDestinations((BrokerCObj)bDestListCObj.getParent())) {
                return;
            }
            this.controller.setActions(bDestListCObj);
            this.app.getInspector().refresh();
        }
    }

    private void doResumeDest(BrokerDestCObj bDestCObj) {
        BrokerAdmin ba = bDestCObj.getBrokerAdmin();
        DestinationInfo destInfo = bDestCObj.getDestinationInfo();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5017", destInfo.name, ba.getKey()), acr.getString("A1156"), 0);
        if (result == 1) {
            return;
        }
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bDestCObj);
        }
        if (this.resumeDest(ba, destInfo.name, destInfo.type)) {
            destInfo = this.queryDestinationInfo(ba, destInfo.name, destInfo.type);
            if (destInfo != null) {
                bDestCObj.setDestinationInfo(destInfo);
                this.app.getInspector().selectedObjectUpdated();
            }
            this.controller.setActions(bDestCObj);
        }
    }

    private boolean resumeAllDests(BrokerAdmin ba, int destTypeMask) {
        try {
            ba.sendResumeMessage(null, destTypeMask);
            ba.receiveResumeReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6039", ba.getKey()));
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3079") + "\n" + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1158") + ": " + acr.getString("A1218", "A3079"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private boolean resumeDest(BrokerAdmin ba, String destName, int destTypeMask) {
        try {
            ba.sendResumeMessage(destName, destTypeMask);
            ba.receiveResumeReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6037", destName, ba.getKey()));
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3077", destName) + "\n" + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1156") + ": " + acr.getString("A1218", "A3077"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private boolean refreshBrokerCObj(BrokerCObj bCObj) {
        BrokerAdmin ba = bCObj.getBrokerAdmin();
        Properties bkrProps = this.queryBrokerProps(ba);
        if (bkrProps != null) {
            bCObj.setBrokerProps(bkrProps);
            return true;
        }
        return false;
    }

    private Properties queryBrokerProps(BrokerAdmin ba) {
        Properties bkrProps = null;
        try {
            ba.sendGetBrokerPropsMessage();
            bkrProps = ba.receiveGetBrokerPropsReplyMessage(false);
        }
        catch (BrokerAdminException bae) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3052", ba.getKey()) + this.printBrokerAdminExceptionDetails(bae), acr.getString("A1094") + ": " + acr.getString("A1218", "A3052"), 0, 0, null, close, close[0]);
        }
        return bkrProps;
    }

    private ServiceInfo queryServiceInfo(BrokerAdmin ba, String svcName) {
        ServiceInfo svcInfo = null;
        try {
            ba.sendGetServicesMessage(svcName);
            Vector svc = ba.receiveGetServicesReplyMessage(false);
            if (svc != null && svc.size() == 1) {
                Enumeration e = svc.elements();
                svcInfo = (ServiceInfo)e.nextElement();
            }
        }
        catch (BrokerAdminException bae) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3053", svcName) + this.printBrokerAdminExceptionDetails(bae), acr.getString("A1094") + ": " + acr.getString("A1218", "A3053"), 0, 0, null, close, close[0]);
        }
        return svcInfo;
    }

    private Vector queryAllServiceInfo(BrokerAdmin ba) {
        Vector svcs = null;
        try {
            ba.sendGetServicesMessage(null);
            svcs = ba.receiveGetServicesReplyMessage();
        }
        catch (BrokerAdminException bae) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3054") + this.printBrokerAdminExceptionDetails(bae), acr.getString("A1094") + ": " + acr.getString("A1218", "A3054"), 0, 0, null, close, close[0]);
        }
        return svcs;
    }

    private void updateAllServiceInfo(BrokerServiceListCObj bSvclCObj, Vector svcs) {
        if (bSvclCObj == null || svcs == null) {
            return;
        }
        Enumeration<TreeNode> e = bSvclCObj.children();
        while (e.hasMoreElements()) {
            BrokerServiceCObj bSvcCObj = (BrokerServiceCObj)e.nextElement();
            for (int i = 0; i < svcs.size(); ++i) {
                ServiceInfo svc = (ServiceInfo)svcs.elementAt(i);
                if (!bSvcCObj.getServiceInfo().name.equals(svc.name)) continue;
                bSvcCObj.setServiceInfo((ServiceInfo)svcs.elementAt(i));
            }
        }
    }

    private DestinationInfo queryDestinationInfo(BrokerAdmin ba, String name, int type) {
        DestinationInfo destInfo = null;
        try {
            ba.sendGetDestinationsMessage(name, type);
            Vector dest = ba.receiveGetDestinationsReplyMessage(false);
            if (dest != null && dest.size() == 1) {
                Enumeration e = dest.elements();
                destInfo = (DestinationInfo)e.nextElement();
            }
        }
        catch (BrokerAdminException bae) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3055", name) + this.printBrokerAdminExceptionDetails(bae), acr.getString("A1094") + ": " + acr.getString("A1218", "A3055"), 0, 0, null, close, close[0]);
        }
        return destInfo;
    }

    private void doShutdownBroker(BrokerCObj bCObj) {
        BrokerAdmin ba = bCObj.getBrokerAdmin();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5008", ba.getKey()), acr.getString("A1151"), 0);
        if (result == 1) {
            return;
        }
        ba.setInitiator(true);
        ba.setReconnect(false);
        if (this.shutdownBroker(ba)) {
            this.clearBroker(bCObj);
            this.app.getExplorer().nodeChanged(bCObj);
            this.app.getInspector().refresh();
            this.controller.setActions(bCObj);
        }
    }

    private boolean shutdownBroker(BrokerAdmin ba) {
        try {
            ba.sendShutdownMessage(false);
            ba.receiveShutdownReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6017", ba.getKey()));
        }
        catch (BrokerAdminException bae) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3067", ba.getKey()) + this.printBrokerAdminExceptionDetails(bae), acr.getString("A1151") + ": " + acr.getString("A1218", "A3067"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doRestartBroker(BrokerCObj bCObj) {
        BrokerAdmin ba = bCObj.getBrokerAdmin();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5009", ba.getKey()), acr.getString("A1152"), 0);
        if (result == 1) {
            return;
        }
        ba.setInitiator(true);
        ba.setReconnect(true);
        this.restartBroker(ba, bCObj);
    }

    private boolean restartBroker(BrokerAdmin ba, BrokerCObj bCObj) {
        try {
            ba.sendShutdownMessage(true);
            ba.receiveShutdownReplyMessage();
            this.clearBroker(bCObj);
            boolean authenticationNeeded = false;
            if (ba.getUserName().length() == 0) {
                authenticationNeeded = true;
            }
            if (ba.getPassword().length() == 0) {
                authenticationNeeded = true;
            }
            if (authenticationNeeded) {
                if (this.brokerPasswdDialog == null) {
                    this.brokerPasswdDialog = new BrokerPasswdDialog(this.app.getFrame());
                    this.brokerPasswdDialog.addAdminEventListener(this);
                    this.brokerPasswdDialog.setLocationRelativeTo(this.app.getFrame());
                }
                this.brokerPasswdDialog.show(ba);
            } else {
                if (this.reconnectToBroker(bCObj)) {
                    if (!this.refreshBrokerCObj(bCObj)) {
                        return false;
                    }
                    if (!this.populateBrokerServices(bCObj)) {
                        return false;
                    }
                    if (!this.populateBrokerDestinations(bCObj)) {
                        return false;
                    }
                } else {
                    return false;
                }
                this.app.getExplorer().nodeChanged(bCObj);
                this.app.getInspector().refresh();
                this.app.getStatusArea().appendText(acr.getString("A6018", ba.getKey()));
                this.controller.setActions(bCObj);
            }
        }
        catch (BrokerAdminException bae) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3068", ba.getKey()) + this.printBrokerAdminExceptionDetails(bae), acr.getString("A1152") + ": " + acr.getString("A1218", "A3068"), 0, 0, null, close, close[0]);
            this.app.getExplorer().nodeChanged(bCObj);
            this.controller.setActions(bCObj);
            return false;
        }
        return true;
    }

    private BrokerDestCObj addDestination(BrokerCObj bCObj, BrokerAdminEvent bae) {
        BrokerDestCObj bDestCObj;
        DestinationInfo destInfo = this.createDestination(bae);
        BrokerAdmin ba = bCObj.getBrokerAdmin();
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bCObj);
        }
        String destName = destInfo.name;
        try {
            ba.sendCreateDestinationMessage(destInfo);
            ba.receiveCreateDestinationReplyMessage();
            bDestCObj = new BrokerDestCObj(bCObj, destInfo);
            this.app.getStatusArea().appendText(acr.getString("A6019", destInfo.name, ba.getKey()));
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3069", destName, ba.getKey()) + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1132") + ": " + acr.getString("A1218", "A3069"), 0, 0, null, close, close[0]);
            return null;
        }
        return bDestCObj;
    }

    private DestinationInfo createDestination(BrokerAdminEvent bae) {
        DestinationInfo destInfo = new DestinationInfo();
        destInfo.setName(bae.getDestinationName());
        destInfo.setType(bae.getDestinationTypeMask());
        if (DestType.isQueue(bae.getDestinationTypeMask())) {
            destInfo.setMaxActiveConsumers(bae.getActiveConsumers());
            destInfo.setMaxFailoverConsumers(bae.getFailoverConsumers());
        }
        destInfo.setMaxProducers(bae.getMaxProducers());
        destInfo.setMaxMessageBytes(bae.getMaxMesgBytes());
        destInfo.setMaxMessages(bae.getMaxMesg());
        destInfo.setMaxMessageSize(bae.getMaxPerMesgSize());
        return destInfo;
    }

    private void doDeleteDestination(BrokerDestCObj bDestCObj) {
        BrokerAdmin ba = bDestCObj.getBrokerAdmin();
        if (!ba.isBusy()) {
            ba.setAssociatedObj(bDestCObj);
        }
        DestinationInfo destInfo = bDestCObj.getDestinationInfo();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5010", destInfo.name, ba.getKey()), acr.getString("A1138"), 0);
        if (result == 1) {
            return;
        }
        if (!this.deleteDestination(ba, destInfo.name, destInfo.type)) {
            return;
        }
        BrokerDestListCObj destList = (BrokerDestListCObj)bDestCObj.getParent();
        this.app.getExplorer().removeFromParent(bDestCObj);
        this.app.getExplorer().select(destList);
        this.app.getInspector().refresh();
    }

    private boolean deleteDestination(BrokerAdmin ba, String name, int type) {
        try {
            ba.sendDestroyDestinationMessage(name, type);
            ba.receiveDestroyDestinationReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6020", name, ba.getKey()));
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3058", name, ba.getKey()) + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1138") + ": " + acr.getString("A1218", "A3058"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private void doPurgeDestination(BrokerDestCObj bDestCObj) {
        BrokerAdmin ba = bDestCObj.getBrokerAdmin();
        DestinationInfo destInfo = bDestCObj.getDestinationInfo();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5012", destInfo.name, ba.getKey()), acr.getString("A1101"), 0);
        if (result == 1) {
            return;
        }
        if (!this.purgeDestination(ba, destInfo.name, destInfo.type)) {
            return;
        }
        destInfo = this.queryDestinationInfo(ba, destInfo.name, destInfo.type);
        if (destInfo != null) {
            bDestCObj.setDestinationInfo(destInfo);
            this.app.getInspector().selectedObjectUpdated();
        }
    }

    private boolean purgeDestination(BrokerAdmin ba, String name, int type) {
        try {
            ba.sendPurgeDestinationMessage(name, type);
            ba.receivePurgeDestinationReplyMessage();
            this.app.getStatusArea().appendText(acr.getString("A6021", name, ba.getKey()));
        }
        catch (BrokerAdminException baex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3060", name, ba.getKey()) + this.printBrokerAdminExceptionDetails(baex), acr.getString("A1101") + ": " + acr.getString("A1218", "A3060"), 0, 0, null, close, close[0]);
            return false;
        }
        return true;
    }

    private String printBrokerAdminExceptionDetails(BrokerAdminException bae) {
        Object fullMsg = null;
        String basicMsg = this.getBrokerAdminExceptionBasicMsg(bae);
        String detailMsg = this.getBrokerAdminExceptionMsgDetail(bae);
        if (basicMsg == null && detailMsg == null) {
            return acr.getString("A3050");
        }
        if (basicMsg != null) {
            fullMsg = basicMsg;
        }
        if (detailMsg != null) {
            fullMsg = fullMsg == null ? detailMsg : (String)fullMsg + "\n" + detailMsg;
        }
        return fullMsg;
    }

    private String getBrokerAdminExceptionMsgDetail(BrokerAdminException bae) {
        Exception e = bae.getLinkedException();
        String s = bae.getBrokerErrorStr();
        Object errorMessage = null;
        if (s != null) {
            errorMessage = s;
        }
        if (e != null) {
            errorMessage = errorMessage != null ? (String)errorMessage + e.getMessage() : e.getMessage();
        }
        return errorMessage;
    }

    private String getBrokerAdminExceptionBasicMsg(BrokerAdminException bae) {
        String ret;
        int type = bae.getType();
        BrokerAdminConn ba = bae.getBrokerAdminConn();
        switch (type) {
            case 1: {
                ret = ar.getString("A3121");
                break;
            }
            case 2: {
                ret = ar.getString("A3122");
                break;
            }
            case 3: {
                ret = ar.getString("A3123");
                break;
            }
            case 4: {
                ret = ar.getString("A3124");
                break;
            }
            case 5: {
                ret = ar.getString("A3125");
                break;
            }
            case 6: {
                ret = acr.getString("A3059");
                break;
            }
            case 7: {
                ret = ar.getString("A3127");
                break;
            }
            case 14: {
                ret = acr.getString("A3073");
                break;
            }
            case 13: {
                Object[] args = new Object[3];
                String brokerName = ba.getKey();
                String host = ba.getBrokerHost();
                String port = ba.getBrokerPort();
                args[0] = brokerName;
                args[1] = host;
                args[2] = port;
                ret = acr.getString("A1513", args);
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    private void loadBrokerList() {
        ConsoleBrokerAdminManager baMgr = this.app.getBrokerListCObj().getBrokerAdminManager();
        try {
            baMgr.setFileName(BROKERLIST_FILENAME);
            baMgr.readBrokerAdminsFromFile();
        }
        catch (Exception ex) {
            String errStr = acr.getString("A3056") + ex.getMessage();
            JOptionPane.showOptionDialog(this.app.getFrame(), errStr, acr.getString("A1520") + ": " + acr.getString("A1218", "A3056"), 0, 0, null, close, close[0]);
        }
        Vector v = baMgr.getBrokerAdmins();
        for (int i = 0; i < v.size(); ++i) {
            BrokerAdmin ba = (BrokerAdmin)v.get(i);
            BrokerCObj brokerCObj = new BrokerCObj(ba);
            this.app.getExplorer().addBroker(brokerCObj);
        }
        this.app.getInspector().refresh();
    }

    private void saveBrokerList() {
        ConsoleBrokerAdminManager baMgr = this.app.getBrokerListCObj().getBrokerAdminManager();
        try {
            baMgr.setFileName(BROKERLIST_FILENAME);
            baMgr.writeBrokerAdminsToFile();
        }
        catch (Exception ex) {
            String errStr = acr.getString("A3057") + ex.getMessage();
            JOptionPane.showOptionDialog(this.app.getFrame(), errStr, acr.getString("A1094") + ": " + acr.getString("A1218", "A3057"), 0, 0, null, close, close[0]);
        }
    }

    public void handleConsoleActionEvents(ConsoleActionEvent cae) {
        int type = cae.getType();
        switch (type) {
            case 5: {
                this.doRefresh();
                this.app.getInspector().refresh();
            }
        }
    }

    private void doRefresh() {
        BrokerDestCObj bDestCObj;
        BrokerCObj bCObj;
        BrokerDestListCObj bDestlCObj;
        ConsoleObj selObj = this.app.getSelectedObj();
        if (selObj instanceof BrokerCObj) {
            BrokerCObj bCObj2 = (BrokerCObj)selObj;
            if (this.refreshBrokerServiceListCObj(bCObj2.getBrokerServiceListCObj()) && this.refreshBrokerDestListCObj(bCObj2.getBrokerDestListCObj())) {
                this.app.getStatusArea().appendText(acr.getString("A6034", bCObj2.toString()));
            }
        } else if (selObj instanceof BrokerServiceListCObj) {
            BrokerServiceListCObj bSvclCObj = (BrokerServiceListCObj)selObj;
            BrokerCObj bCObj3 = bSvclCObj.getBrokerCObj();
            if (this.refreshBrokerServiceListCObj(bSvclCObj)) {
                this.app.getStatusArea().appendText(acr.getString("A6011", bCObj3.toString()));
            }
        } else if (selObj instanceof BrokerServiceCObj) {
            BrokerServiceCObj bSvcCObj = (BrokerServiceCObj)selObj;
            BrokerCObj bCObj4 = bSvcCObj.getBrokerCObj();
            BrokerServiceListCObj bSvclCObj = bCObj4.getBrokerServiceListCObj();
            if (this.refreshBrokerServiceListCObj(bSvclCObj)) {
                this.app.getStatusArea().appendText(acr.getString("A6011", bCObj4.toString()));
            }
        } else if (selObj instanceof BrokerDestListCObj) {
            BrokerDestListCObj bDestlCObj2 = (BrokerDestListCObj)selObj;
            BrokerCObj bCObj5 = bDestlCObj2.getBrokerCObj();
            if (this.refreshBrokerDestListCObj(bDestlCObj2)) {
                this.app.getStatusArea().appendText(acr.getString("A6012", bCObj5.toString()));
            }
        } else if (selObj instanceof BrokerDestCObj && this.refreshBrokerDestListCObj(bDestlCObj = (bCObj = (bDestCObj = (BrokerDestCObj)selObj).getBrokerCObj()).getBrokerDestListCObj())) {
            this.app.getStatusArea().appendText(acr.getString("A6012", bCObj.toString()));
        }
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
        BROKERLIST_FILENAME = "brokerlist.properties";
    }
}

