/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.batch;

import com.sun.enterprise.config.serverbeans.Domain;
import jakarta.validation.constraints.Min;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.batch.AbstractListCommandProxy;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-batch-jobs")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.batch.jobs")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-batch-jobs", description="List Batch Jobs")})
public class ListBatchJobsProxy
extends AbstractListCommandProxy {
    @Param(primary=true, optional=true)
    String jobName;
    @Min(value=0L, message="Offset value needs to be greater than 0")
    @Param(name="offset", optional=true, defaultValue="0")
    @Min(value=0L, message="Offset value needs to be greater than 0") String offSetValue;
    @Min(value=0L, message="Limit value needs to be greater than 0")
    @Param(name="limit", optional=true, defaultValue="2000")
    @Min(value=0L, message="Limit value needs to be greater than 0") String limitValue;

    @Override
    protected String getCommandName() {
        return "_ListBatchJobs";
    }

    @Override
    protected void fillParameterMap(ParameterMap parameterMap) {
        super.fillParameterMap(parameterMap);
        if (this.jobName != null) {
            parameterMap.add((Object)"DEFAULT", (Object)this.jobName);
        }
        parameterMap.add((Object)"offset", (Object)this.offSetValue);
        parameterMap.add((Object)"limit", (Object)this.limitValue);
    }

    @Override
    protected void postInvoke(AdminCommandContext context, ActionReport subReport) {
        Properties subProperties = subReport.getExtraProperties();
        Properties extraProps = context.getActionReport().getExtraProperties();
        if (subProperties.get("simpleMode") != null) {
            extraProps.put("simpleMode", subProperties.get("simpleMode"));
        }
        if (subProperties.get("listBatchJobs") != null) {
            extraProps.put("listBatchJobs", subProperties.get("listBatchJobs"));
        }
        if (subProperties.get("listJobsCount") != null) {
            extraProps.put("listJobsCount", subProperties.get("listJobsCount"));
        }
    }
}

